/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cron;

import com.cronutils.model.definition.CronDefinition;
import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.microservices.jvm.cron.JvmCronExpressionProvider;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.cron.SpringCronDocumentationTarget;
import com.intellij.spring.boot.cron.SpringCronExpressionProviderKt;
import com.intellij.spring.boot.cron.SpringCronUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/spring/boot/cron/SpringCronExpressionProvider;", "Lcom/intellij/microservices/jvm/cron/JvmCronExpressionProvider;", "<init>", "()V", "isSuitableElement", "", "element", "Lcom/intellij/psi/PsiElement;", "getCronDefinition", "Lcom/cronutils/model/definition/CronDefinition;", "cronExpr", "", "cronCompletionExamples", "", "isCronLanguageInjection", "getCronExpression", "createDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "getCronExplanation", "intellij.spring.boot.cron"})
final class SpringCronExpressionProvider
implements JvmCronExpressionProvider {
    public boolean isSuitableElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SpringCronUtilsKt.isSpringScheduledCronValue(element);
    }

    @NotNull
    public CronDefinition getCronDefinition(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        return SpringCronUtilsKt.springCronDefinition(element);
    }

    @NotNull
    public List<String> cronCompletionExamples(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SpringCronExpressionProviderKt.getSPRING_CRON_EXAMPLES();
    }

    public boolean isCronLanguageInjection(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return SpringCronUtilsKt.isSimpleValue(super.getCronExpression(element));
    }

    @Nullable
    public String getCronExpression(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = super.getCronExpression(element);
        if (string == null) {
            return null;
        }
        String value = string;
        if (SpringCronUtilsKt.isSimpleValue(value)) {
            return value;
        }
        return SpringCronUtilsKt.springPropertyReferenceValue(element);
    }

    @NotNull
    public DocumentationTarget createDocumentationTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return (DocumentationTarget)new SpringCronDocumentationTarget(element, (CronExpressionProvider)this);
    }

    @Nullable
    public String getCronExplanation(@NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        return SpringCronUtilsKt.getSpringCronExpression((CronDefinitionExpressionProvider)this, cronExpr, element);
    }
}

