/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.qodana.sarif;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.jetbrains.qodana.sarif.IsoInstantTypeAdapter;
import com.jetbrains.qodana.sarif.model.PropertyBag;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.SarifReport;
import com.jetbrains.qodana.sarif.model.Tool;
import com.jetbrains.qodana.sarif.model.ToolComponent;
import com.jetbrains.qodana.sarif.model.streaming.IndexedResult;
import com.jetbrains.qodana.sarif.model.streaming.IndexedResultIterator;
import com.jetbrains.qodana.sarif.model.streaming.ResultIterator;
import com.jetbrains.qodana.sarif.model.streaming.ResultLocation;
import com.jetbrains.qodana.sarif.model.streaming.StreamJsonRunsListTypeAdapter;
import com.jetbrains.qodana.sarif.model.streaming.StreamingFieldsExclusionStrategy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SarifUtil {
    private SarifUtil() {
    }

    public static SarifReport readReport(Reader reader) {
        return SarifUtil.readReport(reader, true);
    }

    public static SarifReport readReport(Reader reader, boolean readResults) {
        return SarifUtil.readReport(reader, readResults, Collections.emptyList());
    }

    public static SarifReport readReport(Reader reader, boolean readResults, Iterable<String> skippedProperties) {
        GsonBuilder gsonBuilder = SarifUtil.createGsonBuilder(skippedProperties);
        Iterator<String> skippedPropertiesIterator = skippedProperties.iterator();
        if (!readResults || skippedPropertiesIterator.hasNext()) {
            gsonBuilder.registerTypeAdapterFactory(StreamJsonRunsListTypeAdapter.makeFactory());
        }
        if (!readResults) {
            gsonBuilder.addDeserializationExclusionStrategy((ExclusionStrategy)StreamingFieldsExclusionStrategy.results());
        }
        return (SarifReport)gsonBuilder.create().fromJson(reader, SarifReport.class);
    }

    public static SarifReport readReport(Path path) throws IOException {
        return SarifUtil.readReport(path, true);
    }

    public static SarifReport readReport(Path path, boolean readResults) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            SarifReport sarifReport = SarifUtil.readReport(reader, readResults);
            return sarifReport;
        }
    }

    public static List<Result> readResultsFromObject(Object o) {
        Gson gson = SarifUtil.createGson();
        String json = gson.toJson(o);
        return (List)gson.fromJson(json, new TypeToken<List<Result>>(){}.getType());
    }

    public static Iterator<Result> lazyReadResultsFromLocation(Reader reader, ResultLocation resultLocation) {
        return new ResultIterator(reader, resultLocation);
    }

    public static SarifReport emptyReport(String toolName) {
        Run run = new Run(new Tool(new ToolComponent(toolName))).withResults(new ArrayList<Result>());
        return new SarifReport().withRuns(Collections.singletonList(run));
    }

    public static void writeReport(Writer writer, SarifReport report) {
        Gson gson = SarifUtil.createGson();
        gson.toJson((Object)report, (Appendable)writer);
    }

    public static void writeReport(Path path, SarifReport report) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            SarifUtil.writeReport(writer, report);
        }
    }

    public static Gson createGson() {
        return SarifUtil.createGsonBuilder().create();
    }

    public static GsonBuilder createGsonBuilder() {
        return SarifUtil.createGsonBuilder(Collections.emptyList());
    }

    public static Iterator<Result> lazyReadResults(Reader reader, int runIndexInReport) {
        return SarifUtil.lazyReadResultsFromLocation(reader, new ResultLocation.InRun(runIndexInReport));
    }

    public static Iterator<IndexedResult> lazyReadIndexedResults(Reader reader) {
        return new IndexedResultIterator(reader);
    }

    private static GsonBuilder createGsonBuilder(Iterable<String> ignoreKeys) {
        ArrayList<String> ignoreKeysArray = new ArrayList<String>();
        ignoreKeys.iterator().forEachRemaining(ignoreKeysArray::add);
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapterFactory((TypeAdapterFactory)new PropertyBag.PropertyBagTypeAdapterFactory(ignoreKeysArray)).registerTypeAdapter(Instant.class, (Object)new IsoInstantTypeAdapter().nullSafe());
    }
}

