/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.make;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.javaee.appServers.run.configuration.CommonStrategy;
import com.intellij.javaee.appServers.run.execution.J2EEProcess;
import com.intellij.javaee.appServers.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.appServers.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class J2EECompilerManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(J2EECompilerManager.class);
    private final Project myProject;

    public static J2EECompilerManager getInstance(Project project) {
        return (J2EECompilerManager)project.getService(J2EECompilerManager.class);
    }

    public J2EECompilerManager(final @NotNull Project project) {
        if (project == null) {
            J2EECompilerManager.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                List<J2EEProcess> processes;
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompilerManager compilerManager = CompilerManager.getInstance((Project)J2EECompilerManager.this.myProject);
                if (!(project.isDisposed() || !project.isInitialized() || compilerManager.isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator() || (processes = J2EECompilerManager.getActiveJavaeeProcesses(J2EECompilerManager.this.myProject)).isEmpty())) {
                    J2EECompilerManager.this.makeJavaeeModules(processes);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/javaee/appServers/make/J2EECompilerManager$1", "applicationDeactivated"));
            }
        });
    }

    private static List<J2EEProcess> getActiveJavaeeProcesses(@Nullable Project project) {
        ProcessHandler[] processes;
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList<J2EEProcess> activeProcesses = new ArrayList<J2EEProcess>();
        for (ProcessHandler process : processes = ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (!(process instanceof J2EEProcess) || process.isProcessTerminated() || process.isProcessTerminating() || !process.isStartNotified()) continue;
            activeProcesses.add((J2EEProcess)process);
        }
        return activeProcesses;
    }

    private void makeJavaeeModules(List<J2EEProcess> processes) {
        try {
            for (J2EEProcess process : processes) {
                CommonStrategy strategy = process.getCommonStrategy();
                UpdatingPolicy policy = strategy.getUpdateOnFrameDeactivationPolicy();
                Executor executor = UpdatingRunningApplicationUtil.getExecutor(process);
                if (policy == null || !policy.isAvailableForConfiguration(strategy) || !policy.isAvailableForExecutor(executor) || !policy.isAvailableOnFrameDeactivation()) continue;
                policy.runUpdate(this.myProject, null, process.getServerInstance(), (ProcessHandler)process, true);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/appServers/make/J2EECompilerManager", "<init>"));
    }
}

