/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public final class PsiClassUtil {
    private PsiClassUtil() {
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic) {
        return PsiClassUtil.isRunnableClass(aClass, mustBePublic, true);
    }

    public static boolean isRunnableClass(PsiClass aClass, boolean mustBePublic, boolean mustNotBeAbstract) {
        if (aClass instanceof PsiAnonymousClass) {
            return false;
        }
        if (mustBePublic && !aClass.hasModifierProperty("public") && (mustNotBeAbstract || !aClass.hasModifierProperty("abstract"))) {
            return false;
        }
        if (aClass.hasModifierProperty("private")) {
            return false;
        }
        if (mustNotBeAbstract && aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return aClass.getContainingClass() == null || aClass.hasModifierProperty("static") || aClass.hasModifierProperty("abstract");
    }

    @NotNull
    public static Comparator<PsiClass> createScopeComparator(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiClassUtil.$$$reportNull$$$0(0);
        }
        Comparator<PsiClass> comparator = Comparator.comparing(c -> PsiUtilCore.getVirtualFile((PsiElement)c), Comparator.nullsFirst((file1, file2) -> scope.compare(file2, file1)));
        if (comparator == null) {
            PsiClassUtil.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    public static boolean isThrowable(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiClassUtil.$$$reportNull$$$0(2);
        }
        if (psiClass.isInterface()) {
            return false;
        }
        if (psiClass.getTypeParameters().length > 0) {
            return false;
        }
        if ("java.lang.Throwable".equals(psiClass.getQualifiedName())) {
            return true;
        }
        PsiClass throwableClass = JavaPsiFacade.getInstance(psiClass.getProject()).findClass("java.lang.Throwable", psiClass.getResolveScope());
        if (throwableClass == null) {
            return false;
        }
        return psiClass.isInheritor(throwableClass, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiClassUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScopeComparator";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isThrowable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

