/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.telemetry.rt.context;

import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContextGetter;
import com.intellij.platform.diagnostic.telemetry.rt.context.TelemetryContextSetter;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TelemetryContext
extends HashMap<String, String>
implements Serializable {
    public static final String TRACE_CONTEXT_JVM_PROPERTY_NAME = "otel.trace.context";

    @NotNull
    public String asString() {
        StringJoiner joiner = new StringJoiner(", ");
        for (Map.Entry entry : this.entrySet()) {
            joiner.add((String)entry.getKey() + "=" + (String)entry.getValue());
        }
        String string = joiner.toString();
        if (string == null) {
            TelemetryContext.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Context extract(@NotNull TextMapPropagator propagator) {
        if (propagator == null) {
            TelemetryContext.$$$reportNull$$$0(1);
        }
        Context context = propagator.extract(Context.current(), (Object)this, (TextMapGetter)new TelemetryContextGetter());
        if (context == null) {
            TelemetryContext.$$$reportNull$$$0(2);
        }
        return context;
    }

    @NotNull
    public Context extract() {
        Context context = this.extract(GlobalOpenTelemetry.getPropagators().getTextMapPropagator());
        if (context == null) {
            TelemetryContext.$$$reportNull$$$0(3);
        }
        return context;
    }

    @NotNull
    public static TelemetryContext from(@NotNull Context context, @NotNull TextMapPropagator propagator) {
        if (context == null) {
            TelemetryContext.$$$reportNull$$$0(4);
        }
        if (propagator == null) {
            TelemetryContext.$$$reportNull$$$0(5);
        }
        TelemetryContext holder = new TelemetryContext();
        propagator.inject(context, (Object)holder, (TextMapSetter)new TelemetryContextSetter());
        TelemetryContext telemetryContext = holder;
        if (telemetryContext == null) {
            TelemetryContext.$$$reportNull$$$0(6);
        }
        return telemetryContext;
    }

    @NotNull
    public static TelemetryContext current() {
        return TelemetryContext.from(Context.current(), GlobalOpenTelemetry.getPropagators().getTextMapPropagator());
    }

    @NotNull
    public static TelemetryContext fromString(@NotNull String string) {
        if (string == null) {
            TelemetryContext.$$$reportNull$$$0(7);
        }
        TelemetryContext context = new TelemetryContext();
        try {
            String[] particles;
            for (String tuple : particles = string.split(", ")) {
                String[] pairs = tuple.split("=");
                if (pairs.length != 2) continue;
                context.put(pairs[0], pairs[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TelemetryContext telemetryContext = context;
        if (telemetryContext == null) {
            TelemetryContext.$$$reportNull$$$0(8);
        }
        return telemetryContext;
    }

    @NotNull
    public static TelemetryContext fromJvmProperties() {
        String value = System.getProperty(TRACE_CONTEXT_JVM_PROPERTY_NAME);
        if (value == null) {
            return new TelemetryContext();
        }
        return TelemetryContext.fromString(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propagator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/diagnostic/telemetry/rt/context/TelemetryContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "from";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

