/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat.tags;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterListenersKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadata;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.metadata.JupyterTag;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsEventListener;
import com.intellij.jupyter.core.remote.RemoteMetadataUpdater;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J$\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u001e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J \u0010\u0014\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService;", "", "<init>", "()V", "getAllTagsForNotebook", "", "Lcom/intellij/jupyter/core/jupyter/nbformat/metadata/JupyterTag;", "editor", "Lcom/intellij/openapi/editor/Editor;", "addTagToCell", "", "cellIndex", "", "tag", "addTagsToCell", "tags", "", "removeTagFromCell", "getTagsForCell", "updateRemoteRemove", "updateRemoteAdd", "getJupyterCellForEditor", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "notifyTagsChanged", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterTagsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterTagsService.kt\ncom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1374#2:86\n1460#2,5:87\n1869#2,2:92\n1869#2,2:94\n1869#2,2:96\n1869#2,2:98\n*S KotlinDebug\n*F\n+ 1 JupyterTagsService.kt\ncom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService\n*L\n21#1:86\n21#1:87,5\n33#1:92,2\n34#1:94,2\n61#1:96,2\n69#1:98,2\n*E\n"})
public final class JupyterTagsService {
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Set<JupyterTag> getAllTagsForNotebook(@NotNull Editor editor) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (object == null || (object = object.getNotebook()) == null || (object = object.computeCells()) == null) {
            return null;
        }
        List<JupyterCell> cells = object;
        Iterable $this$flatMap$iv = cells;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JupyterCell cell = (JupyterCell)element$iv$iv;
            boolean bl = false;
            List list = cell.getMetadata().getTags$intellij_jupyter_core();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final void addTagToCell(@NotNull Editor editor, int cellIndex, @NotNull JupyterTag tag) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.addTagsToCell(editor, cellIndex, CollectionsKt.listOfNotNull((Object)tag));
    }

    public final void addTagsToCell(@NotNull Editor editor, int cellIndex, @NotNull List<JupyterTag> tags) {
        JupyterTag tag;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        if (object == null || (object = object.getNotebook()) == null) {
            return;
        }
        Object notebook = object;
        JupyterCell jupyterCell = notebook.getCellOrNull(cellIndex);
        if (jupyterCell == null) {
            return;
        }
        JupyterCell cell = jupyterCell;
        Iterable $this$forEach$iv = tags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            tag = (JupyterTag)element$iv;
            boolean bl = false;
            cell.getMetadata().addTag$intellij_jupyter_core(tag);
        }
        $this$forEach$iv = tags;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            tag = (JupyterTag)element$iv;
            boolean bl = false;
            this.updateRemoteAdd(editor, cellIndex, tag);
        }
        NotebookIntervalPointerFactory intervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = intervalPointerFactory;
        if (notebookIntervalPointerFactory == null || (notebookIntervalPointerFactory = notebookIntervalPointerFactory.getForOrdinalIfExists(cellIndex)) == null) {
            return;
        }
        NotebookIntervalPointerFactory intervalPointer = notebookIntervalPointerFactory;
        this.notifyTagsChanged((JupyterNotebook)notebook, (NotebookIntervalPointer)intervalPointer);
    }

    public final void removeTagFromCell(@NotNull Editor editor, int cellIndex, @NotNull JupyterTag tag) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        JupyterNotebook notebook = backedNotebookVirtualFile != null ? backedNotebookVirtualFile.getNotebook() : null;
        JupyterMetadataAware<JsonNode> jupyterMetadataAware = notebook;
        if (jupyterMetadataAware == null || (jupyterMetadataAware = jupyterMetadataAware.getCellOrNull(cellIndex)) == null) {
            return;
        }
        JupyterMetadataAware<JsonNode> cell = jupyterMetadataAware;
        cell.getMetadata().removeTag$intellij_jupyter_core(tag);
        this.updateRemoteRemove(editor, cellIndex, tag);
        JupyterFeaturesCollector.Companion.onCellTagRemoved();
        NotebookIntervalPointerFactory intervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = intervalPointerFactory;
        if (notebookIntervalPointerFactory == null || (notebookIntervalPointerFactory = notebookIntervalPointerFactory.getForOrdinalIfExists(cellIndex)) == null) {
            return;
        }
        NotebookIntervalPointerFactory intervalPointer = notebookIntervalPointerFactory;
        this.notifyTagsChanged(notebook, (NotebookIntervalPointer)intervalPointer);
    }

    @Nullable
    public final List<JupyterTag> getTagsForCell(@NotNull Editor editor, int cellIndex) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = this.getJupyterCellForEditor(editor, cellIndex);
        return object != null && (object = object.getMetadata()) != null ? ((JupyterMetadata)object).getTags$intellij_jupyter_core() : null;
    }

    private final void updateRemoteRemove(Editor editor, int cellIndex, JupyterTag tag) {
        Iterable $this$forEach$iv = RemoteMetadataUpdater.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteMetadataUpdater it = (RemoteMetadataUpdater)element$iv;
            boolean bl = false;
            it.tagRemoved(editor, cellIndex, tag);
        }
    }

    private final void updateRemoteAdd(Editor editor, int cellIndex, JupyterTag tag) {
        Iterable $this$forEach$iv = RemoteMetadataUpdater.Companion.getEP_NAME().getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RemoteMetadataUpdater it = (RemoteMetadataUpdater)element$iv;
            boolean bl = false;
            it.tagAdded(editor, cellIndex, tag);
        }
    }

    private final JupyterCell getJupyterCellForEditor(Editor editor, int cellIndex) {
        Object object = JupyterEditorExtensionsKt.getNotebookFileOrNull(editor);
        return object != null && (object = object.getNotebook()) != null ? object.getCellOrNull(cellIndex) : null;
    }

    private final void notifyTagsChanged(JupyterNotebook notebook, NotebookIntervalPointer intervalPointer) {
        ActionsKt.runInEdt$default(null, () -> JupyterTagsService.notifyTagsChanged$lambda$0(notebook, intervalPointer), (int)1, null);
    }

    private static final Unit notifyTagsChanged$lambda$0(JupyterNotebook $notebook, NotebookIntervalPointer $intervalPointer) {
        ((JupyterTagsEventListener)$notebook.getListeners().getTagsListeners().getMulticaster()).tagsUpdated($intervalPointer);
        JupyterListenersKt.notifyNotebookChanged($notebook);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterTagsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterTagsService.kt\ncom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,85:1\n42#2,3:86\n*S KotlinDebug\n*F\n+ 1 JupyterTagsService.kt\ncom/intellij/jupyter/core/jupyter/nbformat/tags/JupyterTagsService$Companion\n*L\n83#1:86,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterTagsService getInstance() {
            boolean $i$f$service = false;
            Class<JupyterTagsService> serviceClass$iv = JupyterTagsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JupyterTagsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

