/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.trust;

import com.intellij.codeWithMe.ClientId;
import com.intellij.jupyter.core.jupyter.nbformat.DisplayDataContainer;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterDisplayDataOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutput;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputs;
import com.intellij.jupyter.core.jupyter.nbformat.MimeType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.util.xmlb.annotations.XCollection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@State(name="JupyterTrustHash", storages={@Storage(value="jupyterHashTrust.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Trust;", "<init>", "()V", "trust", "getState", "loadState", "", "state", "trustOutputs", "outputs", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputs;", "isOutputTrusted", "", "output", "getUnsafeOutputs", "", "", "getHashForString", "str", "addHash", "hash", "Trust", "Companion", "intellij.jupyter.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJupyterHashTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1740#2,3:86\n1617#2,9:89\n1869#2:98\n1870#2:100\n1626#2:101\n1374#2:102\n1460#2,2:103\n1617#2,9:105\n1869#2:114\n1870#2:116\n1626#2:117\n1462#2,3:118\n1#3:99\n1#3:115\n*S KotlinDebug\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager\n*L\n47#1:86,3\n54#1:89,9\n54#1:98\n54#1:100\n54#1:101\n55#1:102\n55#1:103,2\n57#1:105,9\n57#1:114\n57#1:116\n57#1:117\n55#1:118,3\n54#1:99\n57#1:115\n*E\n"})
public final class JupyterHashTrustManager
implements PersistentStateComponent<Trust> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Trust trust = new Trust(null, 1, null);
    private static final int CACHE_MAX_SIZE = 65535;

    @NotNull
    public Trust getState() {
        return this.trust;
    }

    public void loadState(@NotNull Trust state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Set newHashed = state.getHashed();
        if (newHashed.size() > 65535) {
            newHashed = CollectionsKt.toMutableSet((Iterable)CollectionsKt.take((Iterable)newHashed, (int)16383));
        }
        this.trust.setHashed(newHashed);
    }

    public final void trustOutputs(@NotNull JupyterOutputs outputs) {
        Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
        List<String> unsafeOutputs = this.getUnsafeOutputs(outputs);
        for (String unsafeOutput : unsafeOutputs) {
            String hash = this.getHashForString(unsafeOutput);
            this.addHash(hash);
        }
    }

    public final boolean isOutputTrusted(@NotNull JupyterOutputs output) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            List<String> unsafeOutputs = this.getUnsafeOutputs(output);
            if (unsafeOutputs.isEmpty()) {
                return true;
            }
            Iterable $this$all$iv = unsafeOutputs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String hash = this.getHashForString(it);
                    if (this.trust.getHashed().contains(hash)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getUnsafeOutputs(JupyterOutputs outputs) {
        void $this$flatMapTo$iv$iv;
        Object it$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = outputs.getOutputs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<JupyterDisplayDataOutput> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            JupyterOutput it = (JupyterOutput)element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof JupyterDisplayDataOutput ? (JupyterDisplayDataOutput)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List displayOutputs = (List)destination$iv$iv;
        Iterable $this$flatMap$iv = displayOutputs;
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv2;
            JupyterDisplayDataOutput dataOutput = (JupyterDisplayDataOutput)element$iv$iv;
            boolean bl = false;
            DisplayDataContainer data = dataOutput.getData();
            Iterable $this$mapNotNull$iv2 = MimeType.Companion.getUNSAFE_OUTPUTS();
            boolean $i$f$mapNotNull2 = false;
            it$iv$iv = $this$mapNotNull$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv2;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                MimeType it = (MimeType)((Object)element$iv$iv2);
                boolean bl5 = false;
                if (data.getAsString(it.getMimeType()) == null) continue;
                boolean bl6 = false;
                destination$iv$iv3.add(it$iv$iv2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List untrustedOutputs = (List)destination$iv$iv2;
        return untrustedOutputs;
    }

    private final String getHashForString(String str) {
        byte[] byArray = str.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNull((Object)digest);
        return ArraysKt.joinToString$default((byte[])digest, (CharSequence)"", null, null, (int)0, null, JupyterHashTrustManager::getHashForString$lambda$0, (int)30, null);
    }

    private final void addHash(String hash) {
        Trust trust = this.trust;
        trust.setHashed(SetsKt.plus(trust.getHashed(), (Object)hash));
    }

    private static final CharSequence getHashForString$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion;", "", "<init>", "()V", "CACHE_MAX_SIZE", "", "getInstance", "Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager;", "intellij.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nJupyterHashTrustManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,85:1\n42#2,3:86\n*S KotlinDebug\n*F\n+ 1 JupyterHashTrustManager.kt\ncom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Companion\n*L\n82#1:86,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JupyterHashTrustManager getInstance() {
            boolean $i$f$service = false;
            Class<JupyterHashTrustManager> serviceClass$iv = JupyterHashTrustManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JupyterHashTrustManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R$\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jupyter/core/jupyter/trust/JupyterHashTrustManager$Trust;", "", "hashed", "", "", "<init>", "(Ljava/util/Set;)V", "getHashed", "()Ljava/util/Set;", "setHashed", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.jupyter.core"})
    public static final class Trust {
        @XCollection
        @NotNull
        private Set<String> hashed;

        public Trust(@NotNull Set<String> hashed) {
            Intrinsics.checkNotNullParameter(hashed, (String)"hashed");
            this.hashed = hashed;
        }

        public /* synthetic */ Trust(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = new LinkedHashSet();
            }
            this(set);
        }

        @NotNull
        public final Set<String> getHashed() {
            return this.hashed;
        }

        public final void setHashed(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.hashed = set;
        }

        @NotNull
        public final Set<String> component1() {
            return this.hashed;
        }

        @NotNull
        public final Trust copy(@NotNull Set<String> hashed) {
            Intrinsics.checkNotNullParameter(hashed, (String)"hashed");
            return new Trust(hashed);
        }

        public static /* synthetic */ Trust copy$default(Trust trust, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = trust.hashed;
            }
            return trust.copy(set);
        }

        @NotNull
        public String toString() {
            return "Trust(hashed=" + this.hashed + ")";
        }

        public int hashCode() {
            return ((Object)this.hashed).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Trust)) {
                return false;
            }
            Trust trust = (Trust)other;
            return Intrinsics.areEqual(this.hashed, trust.hashed);
        }

        public Trust() {
            this(null, 1, null);
        }
    }
}

