/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfiguration;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunConfigurationEditor;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntTaskListingSettingsDialog
extends DialogWrapper {
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myGruntCliPackageField;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final JPanel myPanel;
    private final Project myProject;

    protected GruntTaskListingSettingsDialog(@NotNull Project project, @Nullable VirtualFile contextGruntfile) {
        if (project == null) {
            GruntTaskListingSettingsDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.setTitle(JavaScriptBundle.message((String)"dialog.title.grunt.settings", (Object[])new Object[0]));
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = GruntRunConfigurationEditor.createNodeOptionsEditor();
        this.myGruntCliPackageField = new NodePackageField(this.myNodeInterpreterField, GruntUtil.GRUNT, () -> contextGruntfile);
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myPanel = FormBuilder.createFormBuilder().setAlignLabelOnRight(false).setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.nodeOptions.label", (Object[])new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.gruntCliPackage.label", (Object[])new Object[0]), (JComponent)((Object)this.myGruntCliPackageField)).addLabeledComponent(JavaScriptBundle.message((String)"grunt.rc.environmentVariables.label", (Object[])new Object[0]), (JComponent)this.myEnvVarsComponent).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(project);
        this.myNodeInterpreterField.setInterpreterRef(templateRunSettings.getInterpreterRef());
        NodeJsInterpreter interpreter2 = templateRunSettings.getInterpreterRef().resolve(project);
        GruntNonSharedSettings settings = GruntUtil.getGruntPackage(project, interpreter2, contextGruntfile);
        this.myGruntCliPackageField.setSelected(settings.getGruntCliPackage());
        this.myNodeOptionsEditor.setText(templateRunSettings.getNodeOptions());
        this.myEnvVarsComponent.setData(templateRunSettings.getEnvData());
        this.configurePreferredWidth();
        this.init();
    }

    private void configurePreferredWidth() {
        this.myNodeInterpreterField.setPreferredWidthToFitText();
        this.myGruntCliPackageField.setPreferredWidthToFitText();
        int prefWidth = Math.max(this.myNodeInterpreterField.getPreferredSize().width, this.myGruntCliPackageField.getPreferredSize().width);
        int minWidth = JBUIScale.scale((int)300);
        if (prefWidth < minWidth) {
            SwingHelper.setPreferredWidth((Component)((Object)this.myNodeInterpreterField), (int)minWidth);
        }
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNodeInterpreterField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String interpreterError = NodeInterpreterUtil.validateAndGetErrorMessage(this.myNodeInterpreterField.getInterpreter());
        if (interpreterError != null) {
            return new ValidationInfo(interpreterError, (JComponent)((Object)this.myNodeInterpreterField));
        }
        String gruntCliPackageError = this.myGruntCliPackageField.getSelected().getErrorMessage(GruntUtil.GRUNT.getPackageNames().get(0));
        if (gruntCliPackageError != null) {
            return new ValidationInfo(gruntCliPackageError, this.myGruntCliPackageField.getEditorComponent());
        }
        return null;
    }

    protected void doOKAction() {
        this.apply();
        super.doOKAction();
    }

    private void apply() {
        GruntUtil.setGruntPackage(this.myProject, this.myGruntCliPackageField.getSelected());
        GruntRunSettings templateRunSettings = GruntRunConfiguration.getTemplateRunSettings(this.myProject);
        GruntRunSettings.Builder builder2 = GruntRunSettings.builder(templateRunSettings);
        builder2.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder2.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder2.setEnvData(this.myEnvVarsComponent.getData());
        GruntRunConfiguration.setTemplateRunSettings(this.myProject, builder2.build());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/grunt/GruntTaskListingSettingsDialog", "<init>"));
    }
}

