/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.CreateJSFieldFromParameterAction;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignParameterToFieldAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final String VAR_NAME = "__var_name";
    private final String myFieldNameToCreate;
    private final String myFieldName;
    private final String myParameterName;
    private final String myClassName;

    public AssignParameterToFieldAction(@Nullable PsiElement element2, @Nullable String fieldNameToCreate, String fieldName, String parameterName, String className) {
        super(element2);
        this.myFieldNameToCreate = fieldNameToCreate;
        this.myFieldName = fieldName;
        this.myParameterName = parameterName;
        this.myClassName = className;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFieldNameToCreate != null ? CreateJSFieldFromParameterAction.getCreateFieldMessage(this.myFieldNameToCreate) : JavaScriptBundle.message((String)"javascript.assign.parameter.to.field.intention.name", (Object[])new Object[]{this.myParameterName});
        if (string == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(final @NotNull Project project, final @NotNull PsiFile psiFile, final @Nullable Editor editor, final @NotNull PsiElement psiElement, @NotNull PsiElement endElement) {
        int ourParameterIndex;
        JSFunction fun;
        if (project == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(3);
        }
        if (psiElement == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(4);
        }
        if (endElement == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(5);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class)) == null) {
            return;
        }
        JSBlockStatement functionBlockStatement = fun.getBlock();
        if (functionBlockStatement == null) {
            return;
        }
        boolean isES6ClassImpl = JSClassUtils.isES6ClassImplementation((PsiElement)fun);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        PsiElement insertBefore = functionBlockStatement.getFirstChild();
        List<JSParameter> parameters2 = Arrays.asList(fun.getParameterVariables());
        if ((insertBefore = JSChangeUtil.findInsertionPlaceStartingFrom((PsiElement)insertBefore, (boolean)true, arg_0 -> AssignParameterToFieldAction.lambda$invoke$0(parameters2, ourParameterIndex = parameters2.indexOf(psiElement.getParent()), arg_0))) == null) {
            insertBefore = functionBlockStatement.getLastChild();
        }
        boolean staticContext = JSResolveUtil.calculateStaticFromContext((PsiElement)psiElement);
        if (!ArrayUtil.isEmpty((Object[])functionBlockStatement.getStatementListItems())) {
            template.addTextSegment("\n");
        }
        if (isES6ClassImpl || this.myFieldName.equals(this.myParameterName) || staticContext) {
            Object res = staticContext ? this.myClassName + "." : "this.";
            template.addTextSegment((String)res);
            ConstantNode expression = new ConstantNode(this.myFieldName);
            template.addVariable(VAR_NAME, (Expression)expression, (Expression)expression, true);
        } else {
            template.addTextSegment(this.myFieldName);
        }
        template.addTextSegment(" = " + this.myParameterName + JSCodeStyleSettings.getSemicolon((PsiElement)fun));
        template.addEndVariable();
        editor.getCaretModel().moveToOffset(insertBefore.getTextRange().getStartOffset());
        template.setToReformat(true);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
            String newFieldName;
            {
                this.newFieldName = AssignParameterToFieldAction.this.myFieldName;
            }

            public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                TextResult variableValue;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((variableValue = state.getVariableValue(AssignParameterToFieldAction.VAR_NAME)) == null) {
                    return;
                }
                String fieldName = variableValue.getText();
                if (!LanguageNamesValidation.isIdentifier((Language)FlexSupportLoader.ECMA_SCRIPT_L4, (String)fieldName, (Project)project)) {
                    return;
                }
                this.newFieldName = fieldName;
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (AssignParameterToFieldAction.this.myFieldNameToCreate != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        CreateJSFieldFromParameterAction createFieldFromParameterAction = new CreateJSFieldFromParameterAction(psiElement, this.newFieldName);
                        createFieldFromParameterAction.invoke(project, editor, psiFile);
                    }, project.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTemplateFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "templateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ Boolean lambda$invoke$0(List parameters2, int ourParameterIndex, PsiElement psiElement1) {
        if (psiElement1 instanceof JSExpressionStatement) {
            int i;
            PsiElement resolve2;
            JSExpression rOperand;
            JSExpression expression = ((JSExpressionStatement)psiElement1).getExpression();
            if (expression instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression) {
                return Boolean.TRUE;
            }
            if (expression instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSReferenceExpression && (resolve2 = ((JSReferenceExpression)rOperand).resolve()) instanceof JSParameter && (i = parameters2.indexOf((JSParameter)resolve2)) != -1 && i < ourParameterIndex) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

