/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.evaluation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSConditionOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processors;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSParameterTypeInferrer {
    private static final Key<SoftlyCachedValue<SoftlyCachedValue.FinalRef<JSType>>> PARAMETER_TYPE_FROM_CALLS = Key.create((String)"js.parameter.type.from.calls");

    @NotNull
    public static Map<JSParameterListElement, JSInferredParameterType> inferTypes(@NotNull JSFunction signature) {
        if (signature == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(0);
        }
        JSParameterListElement[] parameters2 = signature.getParameters();
        List[] types2 = new List[parameters2.length + 1];
        JSParameterTypeInferrer.inferTypesFromCalls(signature, -1, types2, x -> true);
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)signature);
        boolean hasNonConditionalUsages = false;
        for (int i = 0; i < parameters2.length; ++i) {
            JSParameterListElement parameter = parameters2[i];
            for (PsiReference search : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).asIterable()) {
                if (!(search instanceof JSExpression)) continue;
                PsiElement parent = ((JSExpression)search).getParent();
                if (JSParameterTypeInferrer.isInCondition((PsiElement)search, parent)) {
                    if (parameter.isOptional() || !isTypeScript) continue;
                    JSParameterTypeInferrer.addTypeAtIndex(types2, i, (JSType)JSNamedTypeFactory.createVoidType((JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)parent, (boolean)true)));
                    continue;
                }
                hasNonConditionalUsages = true;
                JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSExpression)search));
                if (expectedType == null) continue;
                JSParameterTypeInferrer.addTypeAtIndex(types2, i, expectedType);
            }
        }
        HashMap<JSParameterListElement, JSInferredParameterType> result2 = new HashMap<JSParameterListElement, JSInferredParameterType>(parameters2.length);
        for (int i = 0; i < parameters2.length; ++i) {
            JSInferredParameterType mergedInferredType = JSParameterTypeInferrer.mergeInferredTypes(signature, parameters2[i], types2[i], types2[parameters2.length], hasNonConditionalUsages);
            result2.put(parameters2[i], mergedInferredType);
        }
        HashMap<JSParameterListElement, JSInferredParameterType> hashMap = result2;
        if (hashMap == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    @Nullable
    public static JSType inferTypeFromCalls(@NotNull JSParameter parameter, int timeoutMs) {
        if (parameter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(2);
        }
        if (timeoutMs == 200) {
            SoftlyCachedValue.FinalRef value;
            SoftlyCachedValue data2 = (SoftlyCachedValue)parameter.getUserData(PARAMETER_TYPE_FROM_CALLS);
            if (data2 != null && (value = (SoftlyCachedValue.FinalRef)data2.getUpToDateOrNull()) != null) {
                return (JSType)value.getValue();
            }
            JSType type2 = JSParameterTypeInferrer.doInferTypeFromCalls(parameter, timeoutMs);
            PsiModificationTracker modificationTracker = PsiModificationTracker.getInstance((Project)parameter.getProject());
            parameter.putUserData(PARAMETER_TYPE_FROM_CALLS, (Object)new SoftlyCachedValue((Object)new SoftlyCachedValue.FinalRef((Object)type2), (ModificationTracker)modificationTracker));
            return type2;
        }
        return JSParameterTypeInferrer.doInferTypeFromCalls(parameter, timeoutMs);
    }

    @Nullable
    private static JSType doInferTypeFromCalls(@NotNull JSParameter parameter, int timeoutMs) {
        JSFunction signature;
        if (parameter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(3);
        }
        if ((signature = parameter.getDeclaringFunction()) == null) {
            return null;
        }
        Object[] parameters2 = signature.getParameters();
        int indexOfParameter = ArrayUtil.indexOf((Object[])parameters2, (Object)parameter);
        if (indexOfParameter == -1) {
            return null;
        }
        List[] types2 = new List[parameters2.length + 1];
        JSParameterTypeInferrer.inferTypesFromCalls(signature, timeoutMs, types2, x -> x == indexOfParameter);
        JSInferredParameterType inferredType = JSParameterTypeInferrer.mergeInferredTypes(signature, (JSParameterListElement)parameter, types2[indexOfParameter], types2[parameters2.length], false);
        return inferredType != null ? inferredType.type : null;
    }

    private static void inferTypesFromCalls(@NotNull JSFunction signature, int timeoutMs, List<JSType> @NotNull [] outTypes, @NotNull Predicate<? super Integer> indexFilter) {
        if (signature == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(4);
        }
        if (indexFilter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(5);
        }
        if (outTypes == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(6);
        }
        for (PsiReference reference : JSParameterTypeInferrer.findFunctionReferences(signature, timeoutMs)) {
            if (!(reference instanceof JSExpression)) continue;
            JSParameterTypeInferrer.addTypesFromCall(signature, reference, outTypes, indexFilter);
        }
    }

    @NotNull
    private static Collection<PsiReference> findFunctionReferences(@NotNull JSFunction signature, int timeoutMs) {
        if (signature == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(7);
        }
        if (timeoutMs > 0) {
            ConcurrentHashMap.KeySetView result2 = ConcurrentHashMap.newKeySet();
            ProgressIndicatorUtils.withTimeout((long)timeoutMs, () -> {
                for (PsiElement e : JSParameterTypeInferrer.getElementsToSearchRefs(signature)) {
                    Query query = ReferencesSearch.search((PsiElement)e, (SearchScope)e.getUseScope()).allowParallelProcessing();
                    query.forEach(Processors.cancelableCollectProcessor((Collection)result2));
                }
                return null;
            });
            ConcurrentHashMap.KeySetView keySetView = result2;
            if (keySetView == null) {
                JSParameterTypeInferrer.$$$reportNull$$$0(8);
            }
            return keySetView;
        }
        ArrayList<PsiReference> result3 = new ArrayList<PsiReference>();
        for (PsiElement e : JSParameterTypeInferrer.getElementsToSearchRefs(signature)) {
            result3.addAll(ReferencesSearch.search((PsiElement)e, (SearchScope)e.getUseScope()).findAll());
        }
        ArrayList<PsiReference> arrayList = result3;
        if (arrayList == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void addTypesFromCall(@NotNull JSFunction signature, @NotNull PsiReference reference, List<JSType> @NotNull [] outTypes, @NotNull Predicate<? super Integer> indexFilter) {
        PsiElement parent;
        if (signature == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(10);
        }
        if (reference == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(11);
        }
        if (indexFilter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(12);
        }
        if (outTypes == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(13);
        }
        if (!(reference instanceof JSExpression)) {
            return;
        }
        if (reference instanceof JSReferenceExpression && (parent = ((JSReferenceExpression)reference).getParent()) instanceof JSCallLikeExpression) {
            JSParameterTypeInferrer.doInferFromCallLike((JSCallLikeExpression)parent, outTypes, indexFilter);
        }
        JSType type2 = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSExpression)reference.getElement()));
        JSTypeUtils.getFunctionType((JSType)type2, (boolean)false, (PsiElement)signature).forEach(t -> {
            if (t instanceof JSFunctionType) {
                List decorators = ((JSFunctionType)t).getParameters();
                for (int i = 0; i < decorators.size() && i < outTypes.length; ++i) {
                    JSParameterTypeDecorator parameter;
                    JSType inferredType;
                    if (i < outTypes.length - 1 && !indexFilter.test(i) || (inferredType = (parameter = (JSParameterTypeDecorator)decorators.get(i)).getInferredType()) == null) continue;
                    JSParameterTypeInferrer.addTypeAtIndex(outTypes, i, inferredType);
                }
            }
        });
    }

    private static boolean isInCondition(@NotNull PsiElement search, @Nullable PsiElement parent) {
        if (search == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(14);
        }
        while (parent instanceof JSPrefixExpression || parent instanceof JSParenthesizedExpression || parent instanceof JSBinaryExpression) {
            IElementType sign;
            if (parent instanceof JSBinaryExpression && (sign = ((JSBinaryExpression)parent).getOperationSign()) != JSTokenTypes.ANDAND && sign != JSTokenTypes.OROR) {
                return false;
            }
            if (parent instanceof JSPrefixExpression && ((JSPrefixExpression)parent).getOperationSign() != JSTokenTypes.EXCL) {
                return false;
            }
            search = parent;
            parent = parent.getParent();
        }
        return parent instanceof JSConditionOwner && ((JSConditionOwner)parent).getCondition() == search;
    }

    @Nullable
    private static JSInferredParameterType mergeInferredTypes(@NotNull JSFunction signature, @NotNull JSParameterListElement parameter, @Nullable List<JSType> inferredTypesForParam, @Nullable List<JSType> inferredRestTypes, boolean hasNonConditionalUsages) {
        JSType commonType;
        if (signature == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(15);
        }
        if (parameter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(16);
        }
        if (inferredTypesForParam == null || inferredTypesForParam.isEmpty()) {
            return null;
        }
        if (JSParameterTypeInferrer.hasTypeElement(parameter)) {
            return null;
        }
        if (parameter.isRest() && inferredRestTypes != null) {
            inferredTypesForParam.addAll(inferredRestTypes);
        }
        ArrayList<JSType> reduced = new ArrayList<JSType>(inferredTypesForParam.size());
        for (JSType type2 : inferredTypesForParam) {
            reduced.add(type2.transformTypeHierarchy(t -> JSTypeUtils.widenLiteralTypes((JSType)t)));
        }
        boolean isSingle = reduced.size() == 1 || hasNonConditionalUsages;
        reduced = new ArrayList(ContainerUtil.map(reduced, t -> t instanceof JSVoidType ? (isSingle ? JSNamedTypeFactory.createBooleanPrimitiveType((JSTypeSource)t.getSource()) : JSNamedTypeFactory.createUndefinedType((JSTypeSource)t.getSource())) : t));
        TypeScriptTypeRelations.reduceBySubtyping((PsiElement)signature, inferredTypesForParam, reduced);
        JSType jSType = commonType = reduced.size() == 1 ? (JSType)reduced.get(0) : JSTypeUtils.getCommonType((Collection)ContainerUtil.map(reduced, t -> () -> t), (PsiElement)signature, (boolean)true);
        if (commonType == null) {
            return null;
        }
        commonType = TypeScriptTypeRelations.subtypeReduction((JSType)commonType, (PsiElement)signature);
        if (parameter.isRest()) {
            commonType = new JSArrayTypeImpl(commonType, commonType.getSource());
        } else if (parameter.isOptional() && commonType instanceof JSUnionType && ((JSUnionType)commonType).getTypes().stream().anyMatch(t -> t instanceof JSUndefinedType)) {
            commonType = JSCompositeTypeFactory.createUnionType((JSTypeSource)commonType.getSource(), (Collection)ContainerUtil.filter((Collection)((JSUnionType)commonType).getTypes(), t -> !(t instanceof JSUndefinedType)));
        }
        boolean proposeGenerics = commonType instanceof JSUnionType && ((JSUnionType)commonType).getTypes().size() > 2 && reduced.size() > 2;
        return new JSInferredParameterType(commonType, proposeGenerics);
    }

    public static boolean hasTypeElement(@NotNull JSParameterListElement parameter) {
        if (parameter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(17);
        }
        if (parameter.getTypeElement() != null) {
            return true;
        }
        if (DialectDetector.isTypeScript((PsiElement)parameter)) {
            return false;
        }
        return parameter.getTypeDecorator().getSimpleType() != null;
    }

    private static void doInferFromCallLike(@NotNull JSCallLikeExpression parent, List<JSType> @NotNull [] outTypes, @NotNull Predicate<? super Integer> indexFilter) {
        if (parent == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(18);
        }
        if (indexFilter == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(19);
        }
        if (outTypes == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(20);
        }
        if (parent instanceof ES6TaggedTemplateExpression) {
            JSType type2 = JSNamedTypeFactory.createType((String)"TemplateStringsArray", (JSTypeSource)JSTypeSourceFactory.createTypeSource((PsiElement)parent, (boolean)true), (JSTypeContext)JSTypeContext.INSTANCE);
            JSParameterTypeInferrer.addTypeAtIndex(outTypes, 0, type2);
        }
        int firstArgumentIndex = parent.getFirstArgumentIndex();
        JSExpression[] arguments = parent.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            JSType type3;
            int index;
            int n = index = i + firstArgumentIndex < outTypes.length ? i + firstArgumentIndex : outTypes.length - 1;
            if (index < outTypes.length - 1 && !indexFilter.test((Integer)i) || (type3 = JSResolveUtil.getExpressionJSType((JSExpression)arguments[i])) == null) continue;
            JSParameterTypeInferrer.addTypeAtIndex(outTypes, index, type3);
        }
    }

    private static void addTypeAtIndex(List<JSType>[] types2, int index, JSType type2) {
        if (types2[index] == null) {
            types2[index] = new SmartList();
        }
        types2[index].add(type2);
    }

    private static List<PsiElement> getElementsToSearchRefs(@NotNull JSFunction function) {
        JSQualifiedNamedElement parent;
        if (function == null) {
            JSParameterTypeInferrer.$$$reportNull$$$0(21);
        }
        SmartList items = new SmartList((Object)function);
        if (function instanceof JSFunctionExpression && (parent = JSPsiImplUtils.getInitializedElement((JSExpression)((JSFunctionExpression)function))) instanceof JSInitializerOwner && ((JSInitializerOwner)parent).getInitializer() == function && !Objects.equals(parent.getName(), function.getName())) {
            items.add(parent);
        }
        return items;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/evaluation/JSParameterTypeInferrer";
                break;
            }
            case 2: 
            case 3: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 5: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFilter";
                break;
            }
            case 6: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outTypes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "search";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/evaluation/JSParameterTypeInferrer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypes";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeFromCalls";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInferTypeFromCalls";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inferTypesFromCalls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionReferences";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTypesFromCall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInCondition";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mergeInferredTypes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasTypeElement";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doInferFromCallLike";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToSearchRefs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 8, 9 -> new IllegalStateException(string);
        };
    }

    public static final class JSInferredParameterType {
        @NotNull
        public final JSType type;
        public final boolean tooManyOptions;

        public JSInferredParameterType(@NotNull JSType type2, boolean tooManyOptions) {
            if (type2 == null) {
                JSInferredParameterType.$$$reportNull$$$0(0);
            }
            this.type = type2;
            this.tooManyOptions = tooManyOptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/evaluation/JSParameterTypeInferrer$JSInferredParameterType", "<init>"));
        }
    }
}

