/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.model.JavaeeModelElement;
import com.intellij.javaee.ui.JavaeeCodeStyleSettings;
import com.intellij.javaee.ui.NewAbstractDataHolder;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Servlet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CreateClassUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class ServletDataHolder
extends NewAbstractDataHolder {
    private String myJspFileName;
    private final boolean myShouldCreateClasses;

    public ServletDataHolder(Servlet source) {
        super(source.getModule(), WebUtil.getWebFacet((JavaeeModelElement)source).getRoot().getServlets(), (String)source.getServletName().getValue());
        this.setName((String)source.getServletName().getValue());
        this.setClassName(source.getServletClass().getStringValue());
        this.setJspFileName((String)source.getJspFile().getValue());
        this.myShouldCreateClasses = false;
    }

    public ServletDataHolder(WebFacet webFacet) {
        super(webFacet.getModule(), webFacet.getWebModel().getServlets(), null);
        this.setName(this.getUniqueName());
        this.setClassName(this.myCodeStyleSettings.SERVLET_CLASS_PREFIX + this.getName() + this.myCodeStyleSettings.SERVLET_CLASS_SUFFIX);
        this.setJspFileName(null);
        this.myShouldCreateClasses = true;
    }

    public String getJspFileName() {
        return this.myJspFileName;
    }

    public void setJspFileName(String jspFileName) {
        this.myJspFileName = jspFileName;
    }

    public boolean shouldCreateClasses() {
        return this.myShouldCreateClasses;
    }

    protected String getDefaultName() {
        return "Servlet";
    }

    protected String getObjectName(Object o) {
        return (String)((CommonServlet)o).getServletName().getValue();
    }

    public String getNamePrefix(JavaeeCodeStyleSettings settings) {
        return settings.SERVLET_DD_PREFIX;
    }

    public String getNameSuffix(JavaeeCodeStyleSettings settings) {
        return settings.SERVLET_DD_SUFFIX;
    }

    public final void installTo(Servlet servlet) {
        servlet.getServletName().setValue((Object)this.getName());
        servlet.getJspFile().setValue((Object)this.myJspFileName);
        servlet.getServletClass().setStringValue(this.getClassName());
        if (this.shouldCreateClasses()) {
            ServletDataHolder.createClass(this, "Servlet Class.java");
        }
    }

    @Nullable
    public static PsiClass createClass(NewAbstractDataHolder dataHolder, String template) {
        PsiClass existing = JavaPsiFacade.getInstance((Project)dataHolder.getModule().getProject()).findClass(dataHolder.getClassName(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)dataHolder.getModule()));
        if (existing != null) {
            return existing;
        }
        PsiDirectory classDirectory = dataHolder.getClassDirectory();
        Module module = dataHolder.getModule();
        if (classDirectory == null && module != null) {
            try {
                classDirectory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)"", null, (boolean)false);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        if (classDirectory == null) {
            return null;
        }
        Properties properties = new Properties();
        properties.setProperty("JAVAEE_TYPE", JavaeeType.discover((Module)module, (JavaeeClass)WebCommonClassNames.SERVLET).pkg);
        return CreateClassUtil.createClassWithDefaultProperties((String)dataHolder.getClassName(), (Properties)properties, (String)template, (PsiDirectory)classDirectory);
    }
}

