/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class BufferedValueModel
extends AbstractValueModel {
    public static final String PROPERTY_BUFFERING = "buffering";
    public static final String PROPERTY_SUBJECT = "subject";
    public static final String PROPERTY_TRIGGER_CHANNEL = "triggerChannel";
    private ValueModel subject;
    private ValueModel triggerChannel;
    private Object bufferedValue;
    private boolean valueAssigned;
    private final ValueChangeHandler valueChangeHandler = new ValueChangeHandler();
    private final TriggerChangeHandler triggerChangeHandler = new TriggerChangeHandler();

    public BufferedValueModel(ValueModel subject, ValueModel triggerChannel) {
        this.setSubject(subject);
        this.setTriggerChannel(triggerChannel);
        this.setBuffering(false);
    }

    public ValueModel getSubject() {
        return this.subject;
    }

    public void setSubject(ValueModel newSubject) {
        ValueModel oldSubject = this.getSubject();
        Object oldValue = null;
        if (oldSubject != null) {
            ReadAccessResult oldReadValue = this.readBufferedOrSubjectValue();
            oldValue = oldReadValue.value;
            oldSubject.removeValueChangeListener(this.valueChangeHandler);
        }
        this.subject = newSubject;
        if (newSubject != null) {
            newSubject.addValueChangeListener(this.valueChangeHandler);
        }
        this.firePropertyChange(PROPERTY_SUBJECT, oldSubject, newSubject);
        if (this.isBuffering()) {
            return;
        }
        ReadAccessResult newReadValue = this.readBufferedOrSubjectValue();
        Object newValue = newReadValue.value;
        if (oldValue != null || newValue != null) {
            this.fireValueChange(oldValue, newValue, true);
        }
    }

    public ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public void setTriggerChannel(ValueModel newTriggerChannel) {
        Preconditions.checkNotNull((Object)newTriggerChannel, (String)"The trigger channel must not be null.");
        ValueModel oldTriggerChannel = this.getTriggerChannel();
        if (oldTriggerChannel != null) {
            oldTriggerChannel.removeValueChangeListener(this.triggerChangeHandler);
        }
        this.triggerChannel = newTriggerChannel;
        newTriggerChannel.addValueChangeListener(this.triggerChangeHandler);
        this.firePropertyChange(PROPERTY_TRIGGER_CHANNEL, oldTriggerChannel, newTriggerChannel);
    }

    @Override
    public Object getValue() {
        Preconditions.checkNotNull((Object)this.subject, (String)"The subject must not be null when reading a value from a BufferedValueModel.");
        return this.isBuffering() ? this.bufferedValue : this.subject.getValue();
    }

    @Override
    public void setValue(Object newBufferedValue) {
        Preconditions.checkNotNull((Object)this.subject, (String)"The subject must not be null when setting a value to a BufferedValueModel.");
        ReadAccessResult oldReadValue = this.readBufferedOrSubjectValue();
        Object oldValue = oldReadValue.value;
        this.bufferedValue = newBufferedValue;
        this.setBuffering(true);
        if (oldReadValue.readable && oldValue == newBufferedValue) {
            return;
        }
        this.fireValueChange(oldValue, newBufferedValue, true);
    }

    private ReadAccessResult readBufferedOrSubjectValue() {
        try {
            Object value = this.getValue();
            return new ReadAccessResult(value, true);
        }
        catch (Exception e) {
            return new ReadAccessResult(null, false);
        }
    }

    public void release() {
        ValueModel aTriggerChannel;
        ValueModel aSubject = this.getSubject();
        if (aSubject != null) {
            aSubject.removeValueChangeListener(this.valueChangeHandler);
        }
        if ((aTriggerChannel = this.getTriggerChannel()) != null) {
            aTriggerChannel.removeValueChangeListener(this.triggerChangeHandler);
        }
    }

    public boolean isBuffering() {
        return this.valueAssigned;
    }

    private void setBuffering(boolean newValue) {
        boolean oldValue = this.isBuffering();
        this.valueAssigned = newValue;
        this.firePropertyChange(PROPERTY_BUFFERING, oldValue, newValue);
    }

    private void commit() {
        if (this.isBuffering()) {
            this.setBuffering(false);
            this.valueChangeHandler.oldValue = this.bufferedValue;
            this.subject.setValue(this.bufferedValue);
            this.valueChangeHandler.oldValue = null;
        } else {
            Preconditions.checkNotNull((Object)this.subject, (String)"The subject must not be null while committing a value in a BufferedValueModel.");
        }
    }

    private void flush() {
        Object oldValue = this.getValue();
        this.setBuffering(false);
        Object newValue = this.getValue();
        this.fireValueChange(oldValue, newValue, true);
    }

    @Override
    protected String paramString() {
        return "value=" + this.valueString() + "; buffering" + this.isBuffering();
    }

    private final class TriggerChangeHandler
    implements PropertyChangeListener {
        private TriggerChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (Boolean.TRUE.equals(evt.getNewValue())) {
                BufferedValueModel.this.commit();
            } else if (Boolean.FALSE.equals(evt.getNewValue())) {
                BufferedValueModel.this.flush();
            }
        }
    }

    private final class ValueChangeHandler
    implements PropertyChangeListener {
        Object oldValue;

        private ValueChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!BufferedValueModel.this.isBuffering()) {
                BufferedValueModel.this.fireValueChange(this.oldValue != null ? this.oldValue : evt.getOldValue(), evt.getNewValue(), true);
            }
        }
    }

    private static final class ReadAccessResult {
        final Object value;
        final boolean readable;

        private ReadAccessResult(Object value, boolean readable) {
            this.value = value;
            this.readable = readable;
        }
    }
}

