/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.common.browser;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.common.browser.BrowserExecutableNotFoundException;
import com.intellij.javascript.debugger.common.browser.ChromeQuality;
import com.intellij.javascript.debugger.common.browser.DetectedBrowser;
import com.intellij.javascript.debugger.common.browser.EdgeQuality;
import com.intellij.util.system.OS;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aQ\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007\u00a2\u0006\u0002\u0010\r\u001a@\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0002\u001a2\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00122\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00122\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u001a<\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00122\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0019"}, d2={"detectBrowserBinary", "Lkotlin/Result;", "Ljava/nio/file/Path;", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "userHome", "env", "", "", "fs", "Ljava/nio/file/FileSystem;", "os", "Lcom/intellij/util/system/OS;", "(Lcom/intellij/ide/browsers/WebBrowser;Ljava/nio/file/Path;Ljava/util/Map;Ljava/nio/file/FileSystem;Lcom/intellij/util/system/OS;)Ljava/lang/Object;", "findBrowserBinary", "Lcom/intellij/javascript/debugger/common/browser/DetectedBrowser;", "windowsCandidates", "Lkotlin/sequences/Sequence;", "Lcom/intellij/javascript/debugger/common/browser/DetectedBrowser$BrowserWithQuality;", "linuxCandidates", "macosCandidates", "findInNameAndPath", "", "what", "detectBrowserType", "intellij.javascript.debugger.common"})
@SourceDebugExtension(value={"SMAP\nBrowserDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserDetection.kt\ncom/intellij/javascript/debugger/common/browser/BrowserDetectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public final class BrowserDetectionKt {
    @ApiStatus.Internal
    @NotNull
    public static final Object detectBrowserBinary(@NotNull WebBrowser browser, @Nullable Path userHome, @NotNull Map<String, String> env, @NotNull FileSystem fs, @NotNull OS os) {
        Path browserPath;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String string = browser.getPath();
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            v1 = fs.getPath(p0, new String[0]);
        } else {
            v1 = browserPath = null;
        }
        if (browserPath != null && Files.isExecutable(browserPath)) {
            return Result.constructor-impl((Object)browserPath);
        }
        DetectedBrowser detectedBrowser = BrowserDetectionKt.detectBrowserType(browser);
        if (detectedBrowser == null) {
            return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new BrowserExecutableNotFoundException(browser)));
        }
        DetectedBrowser detectedBrowser2 = detectedBrowser;
        Path pathToBinary = BrowserDetectionKt.findBrowserBinary(detectedBrowser2, os, env, fs, userHome);
        if (pathToBinary != null) {
            return Result.constructor-impl((Object)pathToBinary);
        }
        return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new BrowserExecutableNotFoundException(browser)));
    }

    public static /* synthetic */ Object detectBrowserBinary$default(WebBrowser webBrowser, Path path, Map map, FileSystem fileSystem, OS oS, int n, Object object) {
        if ((n & 2) != 0) {
            path = null;
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            FileSystem fileSystem2 = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getDefault(...)");
            fileSystem = fileSystem2;
        }
        if ((n & 0x10) != 0) {
            OS oS2 = OS.CURRENT;
            Intrinsics.checkNotNullExpressionValue((Object)oS2, (String)"CURRENT");
            oS = oS2;
        }
        return BrowserDetectionKt.detectBrowserBinary(webBrowser, path, map, fileSystem, oS);
    }

    private static final Path findBrowserBinary(DetectedBrowser browser, OS os, Map<String, String> env, FileSystem fs, Path userHome) {
        DetectedBrowser.BrowserWithQuality browserWithQuality = browser instanceof DetectedBrowser.BrowserWithQuality ? (DetectedBrowser.BrowserWithQuality)browser : null;
        if (browserWithQuality == null) {
            return null;
        }
        DetectedBrowser.BrowserWithQuality browser2 = browserWithQuality;
        Sequence<Path> candidates = switch (WhenMappings.$EnumSwitchMapping$0[os.ordinal()]) {
            case 1 -> BrowserDetectionKt.windowsCandidates(browser2, env, fs);
            case 2 -> BrowserDetectionKt.macosCandidates(browser2, env, fs, userHome);
            case 3, 4 -> BrowserDetectionKt.linuxCandidates(browser2, env, fs);
            case 5 -> SequencesKt.emptySequence();
            default -> throw new NoWhenBranchMatchedException();
        };
        return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.filter(candidates, BrowserDetectionKt::findBrowserBinary$lambda$0));
    }

    private static final Sequence<Path> windowsCandidates(DetectedBrowser.BrowserWithQuality browser, Map<String, String> env, FileSystem fs) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Path>, Continuation<? super Unit>, Object>(env, fs, browser, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Map<String, String> $env;
            final /* synthetic */ FileSystem $fs;
            final /* synthetic */ DetectedBrowser.BrowserWithQuality $browser;
            {
                this.$env = $env;
                this.$fs = $fs;
                this.$browser = $browser;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var12_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_4 = new String[]{"LOCALAPPDATA", "ProgramFiles", "ProgramFiles(x86)"};
                        var3_6 = var4_4;
                        var4_5 = 0;
                        var5_7 = var3_6.length;
lbl10:
                        // 2 sources

                        while (var4_5 < var5_7) {
                            envVar = var3_6[var4_5];
                            v0 = this.$env.get(envVar);
                            if (v0 != null) {
                                var8_10 = v0;
                                var9_11 = this.$fs;
                                p0 = var8_10;
                                $i$a$-let-BrowserDetectionKt$windowsCandidates$1$path$1 = false;
                                v1 = var9_11.getPath(p0, new String[0]);
                                v0 = v1;
                                if (v1 == null) {
                                } else {
                                    path = v0;
                                    v2 = path.resolve(this.$browser.getQuality().getWindowsFolder());
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolve(...)");
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_6;
                                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)envVar);
                                    this.L$3 = SpillingKt.nullOutSpilledVariable((Object)path);
                                    this.I$0 = var4_5;
                                    this.I$1 = var5_7;
                                    this.label = 1;
                                    v3 = $this$sequence.yield((Object)v2, (Continuation)this);
                                    if (v3 == var12_3) {
                                        return var12_3;
                                    }
                                }
                            }
                            ** GOTO lbl46
                        }
                        break;
                    }
                    case 1: {
                        var5_7 = this.I$1;
                        var4_5 = this.I$0;
                        path = (Path)this.L$3;
                        envVar = (String)this.L$2;
                        var3_6 = (String[])this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl46:
                        // 3 sources

                        ++var4_5;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Path> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Sequence<Path> linuxCandidates(DetectedBrowser.BrowserWithQuality browser, Map<String, String> env, FileSystem fs) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Path>, Continuation<? super Unit>, Object>(browser, fs, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int I$0;
            int I$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DetectedBrowser.BrowserWithQuality $browser;
            final /* synthetic */ FileSystem $fs;
            {
                this.$browser = $browser;
                this.$fs = $fs;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                block8: {
                    var2_2 = (SequenceScope)this.L$0;
                    var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    block0 : switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            var4_4 = new String[]{"/usr/local/bin", "/opt/local/bin", "/usr/bin", "/opt/bin"};
                            var3_7 /* !! */  = var4_4;
                            var4_5 = 0;
                            var5_8 = var3_7 /* !! */ .length;
lbl10:
                            // 2 sources

                            while (var4_5 < var5_8) {
                                installationDir = var3_7 /* !! */ [var4_5];
                                var7_10 = this.$browser.getQuality().getLinuxExecutables().iterator();
lbl13:
                                // 3 sources

                                while (var7_10.hasNext()) {
                                    executableName = (String)var7_10.next();
                                    var9_12 = new String[]{executableName};
                                    v0 = this.$fs.getPath(installationDir, var9_12);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getPath(...)");
                                    this.L$0 = $this$sequence;
                                    this.L$1 = var3_7 /* !! */ ;
                                    this.L$2 = installationDir;
                                    this.L$3 = var7_10;
                                    this.L$4 = SpillingKt.nullOutSpilledVariable((Object)executableName);
                                    this.I$0 = var4_5;
                                    this.I$1 = var5_8;
                                    this.label = 1;
                                    v1 = $this$sequence.yield((Object)v0, (Continuation)this);
                                    if (v1 != var10_3) continue;
                                    return var10_3;
                                }
                                break block0;
                            }
                            break block8;
                        }
                        case 1: {
                            var5_8 = this.I$1;
                            var4_5 = this.I$0;
                            executableName = (String)this.L$4;
                            var7_10 = (Iterator<String>)this.L$3;
                            installationDir = (String)this.L$2;
                            var3_7 /* !! */  = (String[])this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl13
                        }
                    }
                    ++var4_5;
                    ** GOTO lbl10
                }
                var3_7 /* !! */  = this.$browser.getQuality().getLinuxExecutables().iterator();
lbl45:
                // 3 sources

                while (var3_7 /* !! */ .hasNext()) {
                    executableName = (String)var3_7 /* !! */ .next();
                    var6_9 = new String[]{executableName, "bin", executableName};
                    v2 = this.$fs.getPath("/usr/local", var6_9);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getPath(...)");
                    this.L$0 = $this$sequence;
                    this.L$1 = var3_7 /* !! */ ;
                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)executableName);
                    this.L$3 = null;
                    this.L$4 = null;
                    this.label = 2;
                    v3 = $this$sequence.yield((Object)v2, (Continuation)this);
                    if (v3 != var10_3) continue;
                    return var10_3;
                }
                {
                    break;
                    case 2: {
                        executableName = (String)this.L$2;
                        var3_7 /* !! */  = (String[])this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
                        ** GOTO lbl45
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super Path> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final Sequence<Path> macosCandidates(DetectedBrowser.BrowserWithQuality browser, Map<String, String> env, FileSystem fs, Path userHome) {
        String appName = browser.getQuality().getMacAppName();
        Object[] objectArray = new Path[2];
        objectArray[0] = fs.getPath("/Applications", new String[0]);
        Path path = userHome;
        objectArray[1] = path != null ? path.resolve("Applications") : null;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray)), arg_0 -> BrowserDetectionKt.macosCandidates$lambda$0(appName, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean findInNameAndPath(String what, WebBrowser browser) {
        String string = browser.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.contains((CharSequence)string, (CharSequence)what, (boolean)true)) return true;
        String string2 = browser.getPath();
        if (string2 == null) return false;
        if (!StringsKt.contains((CharSequence)string2, (CharSequence)what, (boolean)true)) return false;
        return true;
    }

    @ApiStatus.Internal
    @Nullable
    public static final DetectedBrowser detectBrowserType(@NotNull WebBrowser browser) {
        DetectedBrowser detectedBrowser;
        String string;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                String string2 = browser.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String string3 = string2.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                String name = string3;
                string = browser.getPath();
                if (string == null) break block9;
                String string4 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string = string4;
                if (string4 != null) break block10;
            }
            string = "";
        }
        String path = string;
        if (BrowserDetectionKt.findInNameAndPath("chromium", browser)) {
            detectedBrowser = DetectedBrowser.Chromium.INSTANCE;
        } else if (BrowserDetectionKt.findInNameAndPath("chrome", browser)) {
            ChromeQuality quality = BrowserDetectionKt.findInNameAndPath("canary", browser) || BrowserDetectionKt.findInNameAndPath("sxs", browser) ? (ChromeQuality)ChromeQuality.Canary.INSTANCE : (BrowserDetectionKt.findInNameAndPath("dev", browser) || BrowserDetectionKt.findInNameAndPath("unstable", browser) ? (ChromeQuality)ChromeQuality.Dev.INSTANCE : (BrowserDetectionKt.findInNameAndPath("beta", browser) ? (ChromeQuality)ChromeQuality.Beta.INSTANCE : (ChromeQuality)ChromeQuality.Stable.INSTANCE));
            detectedBrowser = new DetectedBrowser.Chrome(quality);
        } else if (BrowserDetectionKt.findInNameAndPath("edge", browser)) {
            EdgeQuality quality = BrowserDetectionKt.findInNameAndPath("canary", browser) || BrowserDetectionKt.findInNameAndPath("sxs", browser) ? (EdgeQuality)EdgeQuality.Canary.INSTANCE : (BrowserDetectionKt.findInNameAndPath("dev", browser) ? (EdgeQuality)EdgeQuality.Dev.INSTANCE : (BrowserDetectionKt.findInNameAndPath("beta", browser) ? (EdgeQuality)EdgeQuality.Beta.INSTANCE : (EdgeQuality)EdgeQuality.Stable.INSTANCE));
            detectedBrowser = new DetectedBrowser.Edge(quality);
        } else {
            detectedBrowser = BrowserDetectionKt.findInNameAndPath("opera", browser) ? (DetectedBrowser)DetectedBrowser.Opera.INSTANCE : (BrowserDetectionKt.findInNameAndPath("brave", browser) ? (DetectedBrowser)DetectedBrowser.Brave.INSTANCE : (BrowserDetectionKt.findInNameAndPath("vivaldi", browser) ? (DetectedBrowser)DetectedBrowser.Vivaldi.INSTANCE : null));
        }
        return detectedBrowser;
    }

    private static final boolean findBrowserBinary$lambda$0(Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Files.isExecutable(it);
    }

    private static final Path macosCandidates$lambda$0(String $appName, Path it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.resolve($appName + ".app").resolve("Contents").resolve("MacOS").resolve($appName);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.FreeBSD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Linux.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Other.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

