/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.common.property.folding;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.configurations.common.property.KtorCommonProperty;
import com.intellij.ktor.configurations.common.property.reference.KtorPropertyReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u00020\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00152\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/ktor/configurations/common/property/folding/KtorPropertyFoldingBuilder;", "Lcom/intellij/lang/folding/FoldingBuilderEx;", "<init>", "()V", "buildFoldRegions", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Document;Z)[Lcom/intellij/lang/folding/FoldingDescriptor;", "isAvailable", "psiElement", "foldingDescriptor", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "foldingRange", "Lcom/intellij/openapi/util/TextRange;", "placeholderText", "", "value", "ktElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "getPlaceholderTextMaxLength", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFoldingDependencies", "", "", "project", "Lcom/intellij/openapi/project/Project;", "isCollapsedByDefault", "node", "Lcom/intellij/lang/ASTNode;", "getPlaceholderText", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorPropertyFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorPropertyFoldingBuilder.kt\ncom/intellij/ktor/configurations/common/property/folding/KtorPropertyFoldingBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,81:1\n37#2,2:82\n4225#3,11:84\n1#4:95\n58#5,2:96\n28#5,12:98\n*S KotlinDebug\n*F\n+ 1 KtorPropertyFoldingBuilder.kt\ncom/intellij/ktor/configurations/common/property/folding/KtorPropertyFoldingBuilder\n*L\n38#1:82,2\n50#1:84,11\n58#1:96,2\n58#1:98,12\n*E\n"})
public final class KtorPropertyFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (this.isAvailable(quick, root)) {
            return new FoldingDescriptor[0];
        }
        List descriptors = new ArrayList();
        root.accept((PsiElementVisitor)new KtTreeVisitorVoid(descriptors, this){
            final /* synthetic */ List<FoldingDescriptor> $descriptors;
            final /* synthetic */ KtorPropertyFoldingBuilder this$0;
            {
                this.$descriptors = $descriptors;
                this.this$0 = $receiver;
            }

            public void visitStringTemplateExpression(KtStringTemplateExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                UtilKt.addIfNotNull(this.$descriptors, (Object)KtorPropertyFoldingBuilder.access$foldingDescriptor(this.this$0, expression));
            }
        });
        Collection $this$toTypedArray$iv = descriptors;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FoldingDescriptor[0]);
    }

    private final boolean isAvailable(boolean quick, PsiElement psiElement) {
        Module module = GenericPsiUtils.getModule((PsiElement)psiElement);
        if (module == null) {
            return false;
        }
        Module module2 = module;
        return quick || !(psiElement instanceof KtElement) || !JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages() || !KtorLibraryUtilKt.hasKtorConfiguration(module2);
    }

    /*
     * WARNING - void declaration
     */
    private final FoldingDescriptor foldingDescriptor(KtStringTemplateExpression $this$foldingDescriptor) {
        FoldingDescriptor descriptor;
        FoldingDescriptor foldingDescriptor;
        void $this$filterIsInstanceTo$iv$iv;
        PsiReference[] psiReferenceArray = $this$foldingDescriptor.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        Object[] $this$filterIsInstance$iv = psiReferenceArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtorPropertyReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KtorPropertyReference ktorPropertyReference = (KtorPropertyReference)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
        if (ktorPropertyReference == null) {
            return null;
        }
        KtorPropertyReference reference = ktorPropertyReference;
        KtorCommonProperty<?> ktorCommonProperty = reference.resolveToKtorProperty();
        if (ktorCommonProperty == null || (ktorCommonProperty = ktorCommonProperty.getValue()) == null) {
            return null;
        }
        KtorCommonProperty<?> value = ktorCommonProperty;
        ASTNode aSTNode = $this$foldingDescriptor.getNode();
        TextRange textRange = this.foldingRange($this$foldingDescriptor);
        Project project = $this$foldingDescriptor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        FoldingDescriptor $this$foldingDescriptor_u24lambda_u240 = foldingDescriptor = (descriptor = new FoldingDescriptor(aSTNode, textRange, null, this.getFoldingDependencies(project)));
        boolean bl = false;
        $this$foldingDescriptor_u24lambda_u240.setPlaceholderText(this.placeholderText((String)((Object)value), (KtElement)$this$foldingDescriptor));
        return foldingDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange foldingRange(KtStringTemplateExpression $this$foldingRange) {
        KtCallExpression ktCallExpression;
        PsiElement psiElement;
        PsiElement psiElement2;
        block6: {
            void $this$findParentInFile$iv$iv;
            PsiElement $this$findParentOfType_u24default$iv = (PsiElement)$this$foldingRange;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof KtCallExpression) {
                        psiElement2 = current$iv$iv;
                        break block6;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement = null;
        }
        if ((ktCallExpression = (KtCallExpression)((PsiElement)((KtCallExpression)psiElement))) == null || (ktCallExpression = ktCallExpression.getTextRange()) == null) {
            TextRange textRange = $this$foldingRange.getTextRange();
            ktCallExpression = textRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        }
        return ktCallExpression;
    }

    private final String placeholderText(String value, KtElement ktElement) {
        if (StringsKt.isBlank((CharSequence)value)) {
            return KtorStarterBundle.INSTANCE.message("ktor.config.property.folding.empty.value", new Object[0]);
        }
        PsiFile psiFile = ktElement.getContainingFile();
        if (psiFile == null) {
            return value;
        }
        PsiFile psiFile2 = psiFile;
        int maxLength = this.getPlaceholderTextMaxLength(psiFile2);
        String string = StringUtil.shortenTextWithEllipsis((String)value, (int)maxLength, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        return string;
    }

    private final int getPlaceholderTextMaxLength(PsiFile psiFile) {
        int maxLength = CodeStyle.getSettings((PsiFile)psiFile).getRightMargin(psiFile.getLanguage()) / 2;
        return RangesKt.coerceAtLeast((int)maxLength, (int)3);
    }

    private final Set<Object> getFoldingDependencies(Project project) {
        return SetsKt.setOf((Object)PsiModificationTracker.getInstance((Project)project).forLanguages(arg_0 -> KtorPropertyFoldingBuilder.getFoldingDependencies$lambda$1(KtorPropertyFoldingBuilder::getFoldingDependencies$lambda$0, arg_0)));
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return true;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return null;
    }

    private static final boolean getFoldingDependencies$lambda$0(Language it) {
        return Intrinsics.areEqual((Object)it.getID(), (Object)"yaml");
    }

    private static final boolean getFoldingDependencies$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ FoldingDescriptor access$foldingDescriptor(KtorPropertyFoldingBuilder $this, KtStringTemplateExpression $receiver) {
        return $this.foldingDescriptor($receiver);
    }
}

