/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.ktor.KtorLibraryUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"KTOR_CONFIG_FILE_TYPE", "Lorg/jetbrains/yaml/YAMLFileType;", "isInsideKtorYamlFile", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isKtorYamlConfigFile", "yamlFile", "Lorg/jetbrains/yaml/psi/YAMLFile;", "intellij.ktor"})
public final class YamlConfigUtilsKt {
    @NotNull
    private static final YAMLFileType KTOR_CONFIG_FILE_TYPE;

    public static final boolean isInsideKtorYamlFile(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        PsiFile psiFile2 = containingFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile2;
        return originalFile instanceof YAMLFile && YamlConfigUtilsKt.isKtorYamlConfigFile((YAMLFile)originalFile);
    }

    public static final boolean isKtorYamlConfigFile(@NotNull YAMLFile yamlFile) {
        Intrinsics.checkNotNullParameter((Object)yamlFile, (String)"yamlFile");
        if (!KtorLibraryUtilKt.hasKtorYamlLibrary(GenericPsiUtils.getModule((PsiElement)((PsiElement)yamlFile)))) {
            return false;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)yamlFile), () -> YamlConfigUtilsKt.isKtorYamlConfigFile$lambda$0(yamlFile));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    private static final CachedValueProvider.Result isKtorYamlConfigFile$lambda$0(YAMLFile $yamlFile) {
        VirtualFile virtualFile = $yamlFile.getVirtualFile();
        boolean isKtorYaml = Intrinsics.areEqual((Object)virtualFile.getNameWithoutExtension(), (Object)"application") && Intrinsics.areEqual((Object)virtualFile.getFileType(), (Object)KTOR_CONFIG_FILE_TYPE) && KtorLibraryUtilKt.hasKtorServerLibrary(GenericPsiUtils.getModule((PsiElement)((PsiElement)$yamlFile)));
        Object[] objectArray = new Object[]{JavaLibraryModificationTracker.getInstance((Project)$yamlFile.getProject())};
        return CachedValueProvider.Result.create((Object)isKtorYaml, (Object[])objectArray);
    }

    static {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
        KTOR_CONFIG_FILE_TYPE = yAMLFileType;
    }
}

