/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.kotlin.completions;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependencyRepository;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.ktor.KtorStarterBundle;
import com.intellij.ktor.kotlin.completions.EngineDescriptor;
import com.intellij.ktor.kotlin.completions.KtorCompletionBaseLookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ktor/kotlin/completions/KtorEngineLookupElement;", "Lcom/intellij/ktor/kotlin/completions/KtorCompletionBaseLookupElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "engine", "Lcom/intellij/ktor/kotlin/completions/EngineDescriptor;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/ktor/kotlin/completions/EngineDescriptor;)V", "getEngine", "()Lcom/intellij/ktor/kotlin/completions/EngineDescriptor;", "imports", "", "", "getImports", "()Ljava/util/List;", "dependencies", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "getDependencies", "dependencies$delegate", "Lkotlin/Lazy;", "repositories", "Lcom/intellij/buildsystem/model/unified/UnifiedDependencyRepository;", "getRepositories", "codeToAdd", "getCodeToAdd", "()Ljava/lang/String;", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "intellij.ktor"})
public final class KtorEngineLookupElement
extends KtorCompletionBaseLookupElement {
    @NotNull
    private final EngineDescriptor engine;
    @NotNull
    private final List<String> imports;
    @NotNull
    private final Lazy dependencies$delegate;
    @NotNull
    private final List<UnifiedDependencyRepository> repositories;
    @NotNull
    private final String codeToAdd;

    public KtorEngineLookupElement(@NotNull KtFile file, @NotNull EngineDescriptor engine) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        super(file, engine.getName(), KtorStarterBundle.INSTANCE.message("ktor.engine.description", new Object[0]));
        this.engine = engine;
        this.imports = this.engine.getImports();
        this.dependencies$delegate = LazyKt.lazy(() -> KtorEngineLookupElement.dependencies_delegate$lambda$0(file, this));
        this.repositories = CollectionsKt.emptyList();
        this.codeToAdd = this.engine.getName();
    }

    @NotNull
    public final EngineDescriptor getEngine() {
        return this.engine;
    }

    @Override
    @NotNull
    public List<String> getImports() {
        return this.imports;
    }

    @Override
    @NotNull
    public List<UnifiedDependency> getDependencies() {
        Lazy lazy = this.dependencies$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public List<UnifiedDependencyRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    @NotNull
    public String getCodeToAdd() {
        return this.codeToAdd;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        Object textToInsert;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.handleInsert(context);
        if (((CharSequence)this.engine.getConfiguration()).length() == 0) {
            return;
        }
        Editor editor2 = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        PsiDocumentManager.getInstance((Project)this.getFile().getProject()).doPostponedOperationsAndUnblockDocument(editor3.getDocument());
        int currentOffset = editor3.getCaretModel().getOffset();
        int eolOffset = editor3.getCaretModel().getVisualLineEnd();
        String string = editor3.getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string.substring(currentOffset, eolOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String currentSuffix = string2;
        boolean blockAlreadyExists = StringsKt.contains$default((CharSequence)currentSuffix, (char)'{', (boolean)false, (int)2, null);
        Object object = textToInsert = blockAlreadyExists ? this.engine.getConfiguration() : "{\n" + this.engine.getConfiguration() + "\n}";
        if (blockAlreadyExists) {
            GenerateUtilsKt.moveCaret$default((Editor)editor3, (int)eolOffset, null, (int)2, null);
        } else {
            GenerateUtilsKt.moveCaret$default((Editor)editor3, (int)(eolOffset - 1), null, (int)2, null);
        }
        editor3.getDocument().insertString(editor3.getCaretModel().getOffset(), (CharSequence)textToInsert);
        if (!blockAlreadyExists) {
            editor3.getCaretModel().moveCaretRelatively(0, 1, false, false, true);
            editor3.getCaretModel().moveToOffset(editor3.getCaretModel().getVisualLineEnd());
        }
        context.commitDocument();
        Project project = this.getFile().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)this.getFile()));
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(...)");
        this.reformatAfterInsertion(project, (SmartPsiElementPointer<KtFile>)smartPsiElementPointer);
    }

    private static final List dependencies_delegate$lambda$0(KtFile $file, KtorEngineLookupElement this$0) {
        Module module = GenericPsiUtils.getModule((PsiElement)((PsiElement)$file));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        return CollectionsKt.listOf((Object)this$0.engine.unifiedDependency(module2));
    }
}

