/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LazyKt;
import kotlin.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSIntention
extends JavaScriptIntention {
    @FileModifier.SafeFieldForPreview
    private final Lazy<JSElementPredicate> predicate = LazyKt.lazyPub(this::getElementPredicate);

    protected JSIntention() {
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement matchingElement;
        if (project == null) {
            JSIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSIntention.$$$reportNull$$$0(1);
        }
        if ((matchingElement = this.findMatchingElement(editor, element)) != null) {
            this.processIntention(project, editor, matchingElement);
        }
    }

    protected abstract void processIntention(@NotNull Project var1, @Nullable Editor var2, @NotNull PsiElement var3) throws IncorrectOperationException;

    @NotNull
    protected abstract JSElementPredicate getElementPredicate();

    @Nullable
    protected PsiElement findMatchingElement(Editor editor, @Nullable PsiElement element) {
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        Language language = element.getLanguage();
        if (language != Language.ANY && !(language instanceof JSLanguageDialect)) {
            return null;
        }
        while (element != null) {
            if (((JSElementPredicate)this.predicate.getValue()).satisfiedBy(element) && this.isSelectionSatisfies(editor, element)) {
                return element;
            }
            if (!this.stopTraversingUp(element = element.getParent())) continue;
            break;
        }
        return null;
    }

    private boolean isSelectionSatisfies(Editor editor, @NotNull PsiElement element) {
        if (element == null) {
            JSIntention.$$$reportNull$$$0(2);
        }
        if (this.getSelectionRequirement() == SelectionRequirement.ELEMENT_COVERS_SELECTION) {
            SelectionModel selection = editor.getSelectionModel();
            if (!selection.hasSelection()) {
                return true;
            }
            TextRange textRange = element.getTextRange();
            return textRange != null && textRange.getStartOffset() <= selection.getSelectionStart() && selection.getSelectionEnd() <= textRange.getEndOffset();
        }
        return true;
    }

    protected SelectionRequirement getSelectionRequirement() {
        return SelectionRequirement.NONE;
    }

    protected boolean stopTraversingUp(@Nullable PsiElement element) {
        return element instanceof PsiFile || element instanceof XmlElement;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            JSIntention.$$$reportNull$$$0(4);
        }
        return super.isAvailable(project, editor, element) && this.findMatchingElement(editor, element) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/intellij/idea/lang/javascript/intention/JSIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isSelectionSatisfies";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum SelectionRequirement {
        NONE,
        ELEMENT_COVERS_SELECTION;

    }
}

