/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnit4Framework
extends JUnitTestFramework {
    public boolean isDumbAware() {
        return ((Object)((Object)this)).getClass().isAssignableFrom(JUnit4Framework.class);
    }

    @NotNull
    public String getName() {
        return "JUnit4";
    }

    protected String getMarkerClassFQName() {
        return "org.junit.Test";
    }

    @Nullable
    public ExternalLibraryDescriptor getFrameworkLibraryDescriptor() {
        return JUnitExternalLibraryDescriptor.JUNIT4;
    }

    @Nullable
    public String getDefaultSuperClass() {
        return null;
    }

    public boolean isTestClass(PsiClass clazz, boolean canBePotential) {
        if (clazz == null) {
            return false;
        }
        return (Boolean)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            if (canBePotential) {
                return this.isUnderTestSources(clazz);
            }
            if (!this.isFrameworkAvailable((PsiElement)clazz)) {
                return false;
            }
            return JUnitUtil.isJUnit4TestClass((PsiClass)clazz, (boolean)false);
        }, (Object)false);
    }

    @Nullable
    protected PsiMethod findSetUpMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit4Framework.$$$reportNull$$$0(0);
        }
        return (PsiMethod)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.Before", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findBeforeClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit4Framework.$$$reportNull$$$0(1);
        }
        return (PsiMethod)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!each.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.Before", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findTearDownMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit4Framework.$$$reportNull$$$0(2);
        }
        return (PsiMethod)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.After", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findAfterClassMethod(@NotNull PsiClass clazz) {
        if (clazz == null) {
            JUnit4Framework.$$$reportNull$$$0(3);
        }
        return (PsiMethod)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            for (PsiMethod each : clazz.getMethods()) {
                if (!each.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)each, (String)"org.junit.AfterClass", (int)0)) continue;
                return each;
            }
            return null;
        }, null);
    }

    @Nullable
    protected PsiMethod findOrCreateSetUpMethod(PsiClass clazz) throws IncorrectOperationException {
        String beforeClassAnnotationName = "org.junit.BeforeClass";
        String beforeAnnotationName = "org.junit.Before";
        return this.findOrCreateSetUpMethod(clazz, beforeClassAnnotationName, beforeAnnotationName);
    }

    private PsiMethod findOrCreateSetUpMethod(PsiClass clazz, String beforeClassAnnotationName, String beforeAnnotationName) {
        PsiMethod testMethod;
        PsiMethod method = this.findSetUpMethod(clazz);
        if (method != null) {
            return method;
        }
        PsiManager manager = clazz.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        method = this.createSetUpPatternMethod((JVMElementFactory)factory);
        PsiMethod existingMethod = clazz.findMethodBySignature(method, false);
        if (existingMethod != null) {
            int exit;
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)existingMethod, (String)beforeClassAnnotationName, (int)0)) {
                return existingMethod;
            }
            int n = exit = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showOkCancelDialog((String)JUnitBundle.message("create.setup.dialog.message", "@Before"), (String)JUnitBundle.message("create.setup.dialog.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (exit == 0) {
                AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)beforeAnnotationName, (PsiNameValuePair[])PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)existingMethod.getModifierList());
                return existingMethod;
            }
        }
        method = (testMethod = JUnitUtil.findFirstTestMethod((PsiClass)clazz)) != null ? (PsiMethod)clazz.addBefore((PsiElement)method, (PsiElement)testMethod) : (PsiMethod)clazz.add((PsiElement)method);
        JavaCodeStyleManager.getInstance((Project)manager.getProject()).shortenClassReferences((PsiElement)method);
        return method;
    }

    public boolean isIgnoredMethod(PsiElement element) {
        if (element == null) {
            return false;
        }
        return (Boolean)JUnit4Framework.callWithAlternateResolver((Project)element.getProject(), () -> {
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                PsiMethod ignoredTestMethod = AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Ignore", (int)0) ? JUnitUtil.getTestMethod((PsiElement)element) : null;
                return ignoredTestMethod != null;
            }
            return false;
        }, (Object)true);
    }

    public FileTemplateDescriptor getSetUpMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 SetUp Method.java");
    }

    public FileTemplateDescriptor getBeforeClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 BeforeClass Method.java");
    }

    public FileTemplateDescriptor getTearDownMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 TearDown Method.java");
    }

    public FileTemplateDescriptor getAfterClassMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 AfterClass Method.java");
    }

    @NotNull
    public FileTemplateDescriptor getTestMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Method.java");
    }

    public FileTemplateDescriptor getParametersMethodFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Parameters Method.java");
    }

    public FileTemplateDescriptor getTestClassFileTemplateDescriptor() {
        return new FileTemplateDescriptor("JUnit4 Test Class.java");
    }

    public boolean isSuiteClass(PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        return (Boolean)JUnit4Framework.callWithAlternateResolver((Project)psiClass.getProject(), () -> {
            PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)psiClass);
            return annotation != null && JUnitUtil.isOneOf((PsiAnnotation)annotation, (String[])new String[]{"org.junit.runners.Suite"});
        }, (Object)false);
    }

    public boolean isParameterized(PsiClass clazz) {
        if (clazz == null) {
            return false;
        }
        return (Boolean)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            PsiAnnotation annotation = JUnitUtil.getRunWithAnnotation((PsiClass)clazz);
            return annotation != null && JUnitUtil.isParameterized((PsiAnnotation)annotation);
        }, (Object)false);
    }

    public PsiMethod findParametersMethod(PsiClass clazz) {
        if (clazz == null) {
            return null;
        }
        return (PsiMethod)JUnit4Framework.callWithAlternateResolver((Project)clazz.getProject(), () -> {
            PsiMethod[] methods;
            for (PsiMethod method : methods = clazz.getAllMethods()) {
                if (!method.hasModifierProperty("public") || !method.hasModifierProperty("static") || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.runners.Parameterized.Parameters", (int)0)) continue;
                return method;
            }
            return null;
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "clazz";
        objectArray2[1] = "com/intellij/execution/junit/JUnit4Framework";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSetUpMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findBeforeClassMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findTearDownMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findAfterClassMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

