/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.collections.visualizer.core;

import com.intellij.debugger.collections.visualizer.core.CollectionElement;
import com.intellij.debugger.collections.visualizer.core.XCollectionAccessorId;
import com.intellij.debugger.collections.visualizer.core.XCollectionMetadata;
import com.intellij.debugger.collections.visualizer.core.XCollectionViewerApi;
import com.intellij.platform.debugger.impl.rpc.XValueDto;
import com.intellij.xdebugger.impl.rpc.XValueId;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=3, xi=48)
@ApiStatus.Internal
public final class XCollectionViewerApiClientStub
implements XCollectionViewerApi {
    @NotNull
    private Function3<String, Object[], Continuation<Object>, Object> invocationHandler;

    public XCollectionViewerApiClientStub(@NotNull Function3<? super String, ? super Object[], ? super Continuation<Object>, ? extends Object> invocationHandler) {
        Intrinsics.checkNotNullParameter(invocationHandler, (String)"invocationHandler");
        this.invocationHandler = invocationHandler;
    }

    @NotNull
    public final Function3<String, Object[], Continuation<Object>, Object> getInvocationHandler() {
        return this.invocationHandler;
    }

    @Override
    @Nullable
    public final Object findCollectionAccessor(@NotNull XValueId valueId, @NotNull Continuation<? super Deferred<XCollectionAccessorId>> $completion) {
        Object[] objectArray = new Object[]{valueId};
        return this.invocationHandler.invoke((Object)"findCollectionAccessor", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object loadMetadata(@NotNull XCollectionAccessorId accessorId, @NotNull Continuation<? super XCollectionMetadata> $completion) {
        Object[] objectArray = new Object[]{accessorId};
        return this.invocationHandler.invoke((Object)"loadMetadata", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object subCollection(@NotNull XCollectionAccessorId accessorId, int start, int amount, @NotNull Continuation<? super Flow<CollectionElement>> $completion) {
        Object[] objectArray = new Object[]{accessorId, Boxing.boxInt((int)start), Boxing.boxInt((int)amount)};
        return this.invocationHandler.invoke((Object)"subCollection", (Object)objectArray, $completion);
    }

    @Override
    @Nullable
    public final Object getValue(@NotNull XCollectionAccessorId accessorId, int row, @NotNull String columnName, @NotNull Continuation<? super XValueDto> $completion) {
        Object[] objectArray = new Object[]{accessorId, Boxing.boxInt((int)row), columnName};
        return this.invocationHandler.invoke((Object)"getValue", (Object)objectArray, $completion);
    }
}

