/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 124490217111073L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(590077140 - (char)-30017, -590077140 - -((char)-15941), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(590077140 - (char)-30016, -590077140 - -27017, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 127434990431532L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.C();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-984204630 - -1648, -984204630 - -5929, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-984204630 - -1649, -984204630 - -12184, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-984204630 - -1650, -984204630 - -11699, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 25195843427021L;
                Object object = this.lock;
                int[] nArray = SshAgentIpcService.C();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11192, 1565237940 + 31015, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11189, 1565237940 + 23932, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11190, -1565237940 + -((char)-14462), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11203, -1565237940 + -((char)-31620), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11204, -1565237940 + -((char)-29627), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11201, 1565237940 + (char)-13430, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11203, -1565237940 + -((char)-31620), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1565237940 + (char)-11202, 1565237940 + (char)-19163, (int)l2));
            if (ActionTimestamp.C() != null) {
                SshAgentIpcService.C(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 87374357236893L;
                    nArray = SshAgentIpcService.C();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 126591537058622L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = SshAgentIpcService.C();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1671011430 - 7520, -1671011430 - -26311, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7519, -1671011430 - -((char)-30083), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7522, -1671011430 - -12775, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1671011430 - 7520, -1671011430 - -26311, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7521, -1671011430 - -((char)-28622), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n = Kernel32.INSTANCE.GetLastError();
                if (n == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1671011430 - 7520, -1671011430 - -26311, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7500, -1671011430 - -16730, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7499, -1671011430 - -26709, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7522, -1671011430 - -12775, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1671011430 - 7520, -1671011430 - -26311, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1671011430 - 7524, -1671011430 - -28041, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1671011430 - 7502, -1671011430 - -25081, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 67265251205244L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1768396440 - 32285, 1768396440 - (char)-32091, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 88821059851535L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1136245830 - (char)-12483, 1136114760 + (char)-11319, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "!6\u00e6\u0002J\u00fc\u00e91\u00f7\u00be\u00f1)\u00cf\u00f78R\u0012\u00cb\u00e1\u0014dtNLD\u00f7U\u00d5\u00e2$\u0096\u00ae\u00e1\u00fe<\u00f8\u007fXKe";
                        var4_3 = "!6\u00e6\u0002J\u00fc\u00e91\u00f7\u00be\u00f1)\u00cf\u00f78R\u0012\u00cb\u00e1\u0014dtNLD\u00f7U\u00d5\u00e2$\u0096\u00ae\u00e1\u00fe<\u00f8\u007fXKe".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 12;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 44;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 12;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 30;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 72;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 47;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 40;
                                        break;
                                    }
                                    default: {
                                        v11 = 30;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n, int n2, int n3) {
                    int n4 = (n ^ n3 ^ 0x7807) & 0xFFFF;
                    if (b[n4] == null) {
                        int n5;
                        char[] cArray = a[n4].toCharArray();
                        int n6 = switch (cArray[0] & 0xFF) {
                            case 0 -> 14;
                            case 1 -> 32;
                            case 2 -> 159;
                            case 3 -> 156;
                            case 4 -> 139;
                            case 5 -> 20;
                            case 6 -> 176;
                            case 7 -> 28;
                            case 8 -> 98;
                            case 9 -> 67;
                            case 10 -> 110;
                            case 11 -> 79;
                            case 12 -> 116;
                            case 13 -> 24;
                            case 14 -> 122;
                            case 15 -> 59;
                            case 16 -> 222;
                            case 17 -> 5;
                            case 18 -> 167;
                            case 19 -> 105;
                            case 20 -> 53;
                            case 21 -> 201;
                            case 22 -> 76;
                            case 23 -> 226;
                            case 24 -> 12;
                            case 25 -> 190;
                            case 26 -> 37;
                            case 27 -> 234;
                            case 28 -> 75;
                            case 29 -> 183;
                            case 30 -> 54;
                            case 31 -> 88;
                            case 32 -> 133;
                            case 33 -> 131;
                            case 34 -> 179;
                            case 35 -> 213;
                            case 36 -> 97;
                            case 37 -> 146;
                            case 38 -> 215;
                            case 39 -> 173;
                            case 40 -> 106;
                            case 41 -> 236;
                            case 42 -> 52;
                            case 43 -> 10;
                            case 44 -> 8;
                            case 45 -> 119;
                            case 46 -> 33;
                            case 47 -> 211;
                            case 48 -> 47;
                            case 49 -> 94;
                            case 50 -> 208;
                            case 51 -> 9;
                            case 52 -> 178;
                            case 53 -> 216;
                            case 54 -> 89;
                            case 55 -> 115;
                            case 56 -> 41;
                            case 57 -> 26;
                            case 58 -> 229;
                            case 59 -> 120;
                            case 60 -> 189;
                            case 61 -> 228;
                            case 62 -> 232;
                            case 63 -> 230;
                            case 64 -> 140;
                            case 65 -> 35;
                            case 66 -> 109;
                            case 67 -> 69;
                            case 68 -> 244;
                            case 69 -> 4;
                            case 70 -> 19;
                            case 71 -> 83;
                            case 72 -> 217;
                            case 73 -> 145;
                            case 74 -> 154;
                            case 75 -> 246;
                            case 76 -> 136;
                            case 77 -> 148;
                            case 78 -> 34;
                            case 79 -> 126;
                            case 80 -> 31;
                            case 81 -> 223;
                            case 82 -> 227;
                            case 83 -> 157;
                            case 84 -> 200;
                            case 85 -> 242;
                            case 86 -> 158;
                            case 87 -> 161;
                            case 88 -> 63;
                            case 89 -> 195;
                            case 90 -> 137;
                            case 91 -> 209;
                            case 92 -> 38;
                            case 93 -> 7;
                            case 94 -> 143;
                            case 95 -> 0;
                            case 96 -> 135;
                            case 97 -> 66;
                            case 98 -> 249;
                            case 99 -> 199;
                            case 100 -> 74;
                            case 101 -> 42;
                            case 102 -> 193;
                            case 103 -> 117;
                            case 104 -> 196;
                            case 105 -> 16;
                            case 106 -> 162;
                            case 107 -> 243;
                            case 108 -> 197;
                            case 109 -> 78;
                            case 110 -> 147;
                            case 111 -> 62;
                            case 112 -> 58;
                            case 113 -> 149;
                            case 114 -> 71;
                            case 115 -> 252;
                            case 116 -> 219;
                            case 117 -> 68;
                            case 118 -> 56;
                            case 119 -> 55;
                            case 120 -> 30;
                            case 121 -> 132;
                            case 122 -> 114;
                            case 123 -> 102;
                            case 124 -> 127;
                            case 125 -> 239;
                            case 126 -> 175;
                            case 127 -> 84;
                            case 128 -> 188;
                            case 129 -> 73;
                            case 130 -> 92;
                            case 131 -> 191;
                            case 132 -> 185;
                            case 133 -> 81;
                            case 134 -> 235;
                            case 135 -> 107;
                            case 136 -> 155;
                            case 137 -> 100;
                            case 138 -> 212;
                            case 139 -> 65;
                            case 140 -> 251;
                            case 141 -> 96;
                            case 142 -> 218;
                            case 143 -> 108;
                            case 144 -> 221;
                            case 145 -> 40;
                            case 146 -> 181;
                            case 147 -> 177;
                            case 148 -> 93;
                            case 149 -> 23;
                            case 150 -> 86;
                            case 151 -> 224;
                            case 152 -> 165;
                            case 153 -> 237;
                            case 154 -> 87;
                            case 155 -> 25;
                            case 156 -> 207;
                            case 157 -> 27;
                            case 158 -> 141;
                            case 159 -> 46;
                            case 160 -> 245;
                            case 161 -> 95;
                            case 162 -> 11;
                            case 163 -> 124;
                            case 164 -> 118;
                            case 165 -> 172;
                            case 166 -> 18;
                            case 167 -> 123;
                            case 168 -> 186;
                            case 169 -> 170;
                            case 170 -> 254;
                            case 171 -> 202;
                            case 172 -> 160;
                            case 173 -> 184;
                            case 174 -> 152;
                            case 175 -> 150;
                            case 176 -> 247;
                            case 177 -> 187;
                            case 178 -> 99;
                            case 179 -> 104;
                            case 180 -> 44;
                            case 181 -> 253;
                            case 182 -> 198;
                            case 183 -> 130;
                            case 184 -> 2;
                            case 185 -> 151;
                            case 186 -> 36;
                            case 187 -> 13;
                            case 188 -> 51;
                            case 189 -> 205;
                            case 190 -> 169;
                            case 191 -> 43;
                            case 192 -> 214;
                            case 193 -> 60;
                            case 194 -> 128;
                            case 195 -> 129;
                            case 196 -> 240;
                            case 197 -> 180;
                            case 198 -> 17;
                            case 199 -> 220;
                            case 200 -> 82;
                            case 201 -> 182;
                            case 202 -> 85;
                            case 203 -> 39;
                            case 204 -> 29;
                            case 205 -> 250;
                            case 206 -> 80;
                            case 207 -> 72;
                            case 208 -> 50;
                            case 209 -> 164;
                            case 210 -> 112;
                            case 211 -> 77;
                            case 212 -> 225;
                            case 213 -> 144;
                            case 214 -> 210;
                            case 215 -> 206;
                            case 216 -> 134;
                            case 217 -> 203;
                            case 218 -> 125;
                            case 219 -> 121;
                            case 220 -> 192;
                            case 221 -> 101;
                            case 222 -> 61;
                            case 223 -> 70;
                            case 224 -> 113;
                            case 225 -> 166;
                            case 226 -> 163;
                            case 227 -> 57;
                            case 228 -> 174;
                            case 229 -> 138;
                            case 230 -> 171;
                            case 231 -> 233;
                            case 232 -> 21;
                            case 233 -> 22;
                            case 234 -> 255;
                            case 235 -> 45;
                            case 236 -> 3;
                            case 237 -> 103;
                            case 238 -> 49;
                            case 239 -> 142;
                            case 240 -> 6;
                            case 241 -> 153;
                            case 242 -> 15;
                            case 243 -> 64;
                            case 244 -> 238;
                            case 245 -> 248;
                            case 246 -> 204;
                            case 247 -> 1;
                            case 248 -> 91;
                            case 249 -> 48;
                            case 250 -> 231;
                            case 251 -> 90;
                            case 252 -> 241;
                            case 253 -> 111;
                            case 254 -> 168;
                            default -> 194;
                        };
                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                        if (n7 < 0) {
                            n7 += 256;
                        }
                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                            n5 += 256;
                        }
                        int n8 = 0;
                        while (n8 < cArray.length) {
                            int n9 = n8 % 2;
                            int n10 = n8;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n10];
                            if (n9 == 0) {
                                cArray2[n10] = (char)(c2 ^ n7);
                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                            } else {
                                cArray2[n10] = (char)(c2 ^ n5);
                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                            }
                            ++n8;
                        }
                        accept.3.b[n4] = new String(cArray).intern();
                    }
                    return b[n4];
                }
            };
            if (nArray == null) {
                ActionTimestamp.C(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 62585439588767L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.C();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19597), 823774950 + (char)-1574, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19593), 823906020 - (char)-1182, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19614), 823906020 - (char)-9750, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19597), 823774950 + (char)-1574, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19593), 823906020 - (char)-1182, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-823774950 + -((char)-19621), -823774950 + -((char)-5920), (int)l3) + ErrorToolsKt.prettyHRESULT((int)n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 115433293670502L;
                        int[] nArray2 = SshAgentIpcService.C();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1752536970 + (char)-4931, -1752668040 - -((char)-25216), (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1752536970 + (char)-4934, -1752668040 - -((char)-24655), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 5576087211738L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                nArray = SshAgentIpcService.C();
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11158, -1219606350 + -((char)-3795), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11162, -1219606350 + -((char)-1045), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11181, -1219606350 + -((char)-13381), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11162, -1219606350 + -((char)-1045), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11156, -1219737420 - -((char)-16463), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11158, -1219606350 + -((char)-3795), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11162, -1219606350 + -((char)-1045), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11178, -1219737420 - -((char)-165), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11158, -1219606350 + -((char)-3795), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11162, -1219606350 + -((char)-1045), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11179, -1219737420 - -((char)-7759), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11158, -1219606350 + -((char)-3795), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11162, -1219606350 + -((char)-1045), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1219737420 - (char)-11176, 1219606350 + (char)-12608, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 61646168206359L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.C();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24101, -502653450 - -((char)-10414), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(502653450 - (char)-24097, -502653450 - -((char)-12268), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24110, -502653450 - -((char)-13108), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24117, -502653450 - -((char)-17618), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24101, -502653450 - -((char)-10414), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(502653450 - (char)-24097, -502653450 - -((char)-12268), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24116, 502653450 - (char)-10751, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24101, -502653450 - -((char)-10414), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(502653450 - (char)-24097, -502653450 - -((char)-12268), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24115, 502653450 - (char)-10569, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24101, -502653450 - -((char)-10414), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(502653450 - (char)-24097, -502653450 - -((char)-12268), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24114, -502653450 - -26240, (int)l2));
                    if (nArray == null) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24101, -502653450 - -((char)-10414), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(502653450 - (char)-24097, -502653450 - -((char)-12268), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(502653450 - (char)-24057, 502653450 - (char)-14376, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(502653450 - (char)-24056, 502653450 - (char)-12789, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "$)\u00a3#\u00b4\u00e0}\u008e\u0014]0\u00b4\u00e7\u00a8\u00f0Q\u00961\u000e\u000e\u0002&\f\u00e9\u00a5\u00e1C\u00ee\u00c4\u0006\u00c1\u00ad\u001f\u00b3I\u00b3\u0018?I\u0098\u00f8\u00af\u00d6\u00b3\u0092\u00a5\u00f3\u0093\u00cd\u00f3\n\u0001\u00e7UbV}\u00b2rW\u0093\t\u00d3\u00bb\u009b\u0017\u00a4\u00b4\u00ca\u0096\u00b6\u0005\u0001\u007f\u0007\u00e9P\b\u008f\u00b8\u00d6`H\u00ae\u00e4\u00a5\u0014\u00a8)r_\u001d\u00ef\u00d2\u00e2/]f\u00dcat\u00baG\u0099\u00cc\u0018w\u0005\u0093'U\u00e2\u001a\u001e\u0088\u0099#QI'\u00cd\u00d6\u00cfo\u0095\u00d9\u007f\u00a82\u00d7\u00d2\u00f5t{Z\u009dF\u00a3\u00b7\u0012E\u00d4Q\u00ba\u0010l\u00e7[[\u0011T0A\r/@,\u00c3C\n5\t\u008d\u00a6\u0086\u00a5T\u00c5\u00f2'_\u0010K\u00c7\u00bf_\u008d\u00d4\u00a3Q\u007f-\u000el\nK34?\u00e8\u00ae'\u00b7\u00c4\u00f2\u00f9\u00008d.C\u00b7\r\u0016Z\u0093!!$~$\u00b9\u00f2X\u00d0\u00b58xq\u00a1_x\u0098\u0082\u00c4]Z\u00ff\u0086\\\u00be\u00f6\r\u0096\u00a5\u00f0Oy\u00c5\u00f7\u00bf\u00b3f\u00e7Y\u0091,K\u00de\t\u00df#\b\u00e9\u00bc\u001a\u00e0\u00d1\u00be\u00d7\u00a7\f\u00c4\u00a0\u00afxz\u00cfL\u008e\u00ab\u009e\u00c6\u001eF\u00f6\u00f7\u00e9\u0092\u00b2\u0092U%\u0088\u00e7\u00a8\u00f5\u00f1\u00d3\u00c1\u00a7\u0095\u00f9\u00e1\u0090t\u00e0\u00fbX&\u00ae\u0089\u00fc@\u00c0\u009cU\u00e3o3\u001b\u00b1\u00ec\u00c9\u0094\t\u00e9\u00d7\u001cl\u0002\u00fb\u00c6\u00ff\fA,\u008a\u0082\u00d6\u00de(\u00a8\u00ea\u00f2\u000e3\u009f;D\u00ea62\u00c0\u00a2\u001f-0\u0097d\u00df\u0081\u001f\u0002\u0095\u00f5\u00de\u008a\u0016\u00df\u0014\u0088m\u00f6\u00fe\u00d1\u00c0H\u00c2\u00b2F\u00e0lFi\u0019\u00bb\u000bn\u008b\u00fa\u001d\u00d0c\u0019\u001b\u0001 \u0099\u00152\u00a0q{\u00a6\u00c7;\u00f2{\u00fd\u001e@\u00b0*\u00dd`\u00af\u007f{\u0099F)\u0017\u00c9\u00d0[7f\u0002\u00fe6j\u00aay\u009c\u00ab\u00db\u0003\u00cb\u000f\u00f1I\u00d1#&\u00c7\u00b5\u0007\u00c5\u00c2s}z\u00dc\u00c1\u00fb\u0011\u0004\u00eb\u0012\t\u00e2\u00b2\u0007Q(\u0012}K\u00ff\u0016\u0007\u00fe\u0007\u0083\u00f4\u009e!\u00ba(m\u0011\u00d3a\u00e7K\u00ee|\u00db\u00ed=\u00bfM\u00f2\u00a3\u00ab\u00c3\u00b7^\u001dE\u0097\u00db\u009a\u009a\u0010\u0096[..\n\u00af4\u00fe1\tU\u00ceM\u008a\u000f\u00fa\u00ffo\u0095\u0098\u00b9\u00a4\u00e1\u00e7\u00d3\u001b))t\u00b1\"\u001c\u00e1\u00b1^\u001b\u00c6\u0087\u00ea\u0086\u00e8\u00bc)]\u00ad\u0087\r\u00ab\u00e7w\u0016\u00eb\u00c8\u00c1\u00ea\u00da\u00f6\u00e5\"SS\u00dc\u001e;P\u000e\u00c3\u00e5H\u00d6|\u00d18\u00ectri\u001dk\u00f8\u001b\u00fa\u00ffh\u0090\u0083\u00acR\u001fn\u008b\u00a7#\u00e2\tV\u008f9\u001d\u0098\u00d5-\u0084j\u00c5\u00e4~w\n\u00d1\u008b\u00c9\u0019\u00a3y\u0085\u008f?\u00fb\u0018\u00dd\u00cd\u008c\u00db\u001ey\u00c0\u00fb\"\u00de\u00ec\u00162\u00fc\u00b0\u0010\u0092\u00ef:\u00f2\u0001+\u00b4c)h_?\u0089\u00ca<\u00bd\u00b5\u00c1\u0003TTG\u0007?\u00ed)\u00a7r\u0099\u009b)&\u008a\u00c0<\u00f6IFPg\u00e8G\u00a3\u0014\u009b\u0095\u00c5\u00c6\u0018K\t\u0094\u00ff\u00a5\u0090:\u00aciQ\u0091";
                var4_3 = "$)\u00a3#\u00b4\u00e0}\u008e\u0014]0\u00b4\u00e7\u00a8\u00f0Q\u00961\u000e\u000e\u0002&\f\u00e9\u00a5\u00e1C\u00ee\u00c4\u0006\u00c1\u00ad\u001f\u00b3I\u00b3\u0018?I\u0098\u00f8\u00af\u00d6\u00b3\u0092\u00a5\u00f3\u0093\u00cd\u00f3\n\u0001\u00e7UbV}\u00b2rW\u0093\t\u00d3\u00bb\u009b\u0017\u00a4\u00b4\u00ca\u0096\u00b6\u0005\u0001\u007f\u0007\u00e9P\b\u008f\u00b8\u00d6`H\u00ae\u00e4\u00a5\u0014\u00a8)r_\u001d\u00ef\u00d2\u00e2/]f\u00dcat\u00baG\u0099\u00cc\u0018w\u0005\u0093'U\u00e2\u001a\u001e\u0088\u0099#QI'\u00cd\u00d6\u00cfo\u0095\u00d9\u007f\u00a82\u00d7\u00d2\u00f5t{Z\u009dF\u00a3\u00b7\u0012E\u00d4Q\u00ba\u0010l\u00e7[[\u0011T0A\r/@,\u00c3C\n5\t\u008d\u00a6\u0086\u00a5T\u00c5\u00f2'_\u0010K\u00c7\u00bf_\u008d\u00d4\u00a3Q\u007f-\u000el\nK34?\u00e8\u00ae'\u00b7\u00c4\u00f2\u00f9\u00008d.C\u00b7\r\u0016Z\u0093!!$~$\u00b9\u00f2X\u00d0\u00b58xq\u00a1_x\u0098\u0082\u00c4]Z\u00ff\u0086\\\u00be\u00f6\r\u0096\u00a5\u00f0Oy\u00c5\u00f7\u00bf\u00b3f\u00e7Y\u0091,K\u00de\t\u00df#\b\u00e9\u00bc\u001a\u00e0\u00d1\u00be\u00d7\u00a7\f\u00c4\u00a0\u00afxz\u00cfL\u008e\u00ab\u009e\u00c6\u001eF\u00f6\u00f7\u00e9\u0092\u00b2\u0092U%\u0088\u00e7\u00a8\u00f5\u00f1\u00d3\u00c1\u00a7\u0095\u00f9\u00e1\u0090t\u00e0\u00fbX&\u00ae\u0089\u00fc@\u00c0\u009cU\u00e3o3\u001b\u00b1\u00ec\u00c9\u0094\t\u00e9\u00d7\u001cl\u0002\u00fb\u00c6\u00ff\fA,\u008a\u0082\u00d6\u00de(\u00a8\u00ea\u00f2\u000e3\u009f;D\u00ea62\u00c0\u00a2\u001f-0\u0097d\u00df\u0081\u001f\u0002\u0095\u00f5\u00de\u008a\u0016\u00df\u0014\u0088m\u00f6\u00fe\u00d1\u00c0H\u00c2\u00b2F\u00e0lFi\u0019\u00bb\u000bn\u008b\u00fa\u001d\u00d0c\u0019\u001b\u0001 \u0099\u00152\u00a0q{\u00a6\u00c7;\u00f2{\u00fd\u001e@\u00b0*\u00dd`\u00af\u007f{\u0099F)\u0017\u00c9\u00d0[7f\u0002\u00fe6j\u00aay\u009c\u00ab\u00db\u0003\u00cb\u000f\u00f1I\u00d1#&\u00c7\u00b5\u0007\u00c5\u00c2s}z\u00dc\u00c1\u00fb\u0011\u0004\u00eb\u0012\t\u00e2\u00b2\u0007Q(\u0012}K\u00ff\u0016\u0007\u00fe\u0007\u0083\u00f4\u009e!\u00ba(m\u0011\u00d3a\u00e7K\u00ee|\u00db\u00ed=\u00bfM\u00f2\u00a3\u00ab\u00c3\u00b7^\u001dE\u0097\u00db\u009a\u009a\u0010\u0096[..\n\u00af4\u00fe1\tU\u00ceM\u008a\u000f\u00fa\u00ffo\u0095\u0098\u00b9\u00a4\u00e1\u00e7\u00d3\u001b))t\u00b1\"\u001c\u00e1\u00b1^\u001b\u00c6\u0087\u00ea\u0086\u00e8\u00bc)]\u00ad\u0087\r\u00ab\u00e7w\u0016\u00eb\u00c8\u00c1\u00ea\u00da\u00f6\u00e5\"SS\u00dc\u001e;P\u000e\u00c3\u00e5H\u00d6|\u00d18\u00ectri\u001dk\u00f8\u001b\u00fa\u00ffh\u0090\u0083\u00acR\u001fn\u008b\u00a7#\u00e2\tV\u008f9\u001d\u0098\u00d5-\u0084j\u00c5\u00e4~w\n\u00d1\u008b\u00c9\u0019\u00a3y\u0085\u008f?\u00fb\u0018\u00dd\u00cd\u008c\u00db\u001ey\u00c0\u00fb\"\u00de\u00ec\u00162\u00fc\u00b0\u0010\u0092\u00ef:\u00f2\u0001+\u00b4c)h_?\u0089\u00ca<\u00bd\u00b5\u00c1\u0003TTG\u0007?\u00ed)\u00a7r\u0099\u009b)&\u008a\u00c0<\u00f6IFPg\u00e8G\u00a3\u0014\u009b\u0095\u00c5\u00c6\u0018K\t\u0094\u00ff\u00a5\u0090:\u00aciQ\u0091".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 43;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u000b*\u00ee\u009aM\u00e3\u00f0\u00f3\u00d5vkG\u001d\u00d8\u00c9\u00abJ\u00de\u00f3\u008fCis\u00e1|\u00f0M(\u001c\u0014\u00c5\u001d\u001a\u00ff\u00c0N\u00e1\u00fc\u009a\u00fe\u00c6\u00a1\u0082\u00c5\u00c0!yn@\u00dc";
                    var4_3 = "\u000b*\u00ee\u009aM\u00e3\u00f0\u00f3\u00d5vkG\u001d\u00d8\u00c9\u00abJ\u00de\u00f3\u008fCis\u00e1|\u00f0M(\u001c\u0014\u00c5\u001d\u001a\u00ff\u00c0N\u00e1\u00fc\u009a\u00fe\u00c6\u00a1\u0082\u00c5\u00c0!yn@\u00dc".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 124;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 24;
                            break;
                        }
                        case 1: {
                            v15 = 16;
                            break;
                        }
                        case 2: {
                            v15 = 100;
                            break;
                        }
                        case 3: {
                            v15 = 107;
                            break;
                        }
                        case 4: {
                            v15 = 44;
                            break;
                        }
                        case 5: {
                            v15 = 15;
                            break;
                        }
                        default: {
                            v15 = 14;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0x6C34) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 44;
                case 1 -> 42;
                case 2 -> 56;
                case 3 -> 81;
                case 4 -> 241;
                case 5 -> 148;
                case 6 -> 131;
                case 7 -> 61;
                case 8 -> 201;
                case 9 -> 93;
                case 10 -> 132;
                case 11 -> 209;
                case 12 -> 66;
                case 13 -> 252;
                case 14 -> 189;
                case 15 -> 220;
                case 16 -> 46;
                case 17 -> 186;
                case 18 -> 18;
                case 19 -> 251;
                case 20 -> 98;
                case 21 -> 202;
                case 22 -> 94;
                case 23 -> 95;
                case 24 -> 48;
                case 25 -> 30;
                case 26 -> 7;
                case 27 -> 22;
                case 28 -> 107;
                case 29 -> 115;
                case 30 -> 173;
                case 31 -> 39;
                case 32 -> 89;
                case 33 -> 25;
                case 34 -> 143;
                case 35 -> 79;
                case 36 -> 135;
                case 37 -> 15;
                case 38 -> 177;
                case 39 -> 45;
                case 40 -> 20;
                case 41 -> 222;
                case 42 -> 130;
                case 43 -> 60;
                case 44 -> 219;
                case 45 -> 244;
                case 46 -> 147;
                case 47 -> 170;
                case 48 -> 21;
                case 49 -> 207;
                case 50 -> 212;
                case 51 -> 163;
                case 52 -> 231;
                case 53 -> 106;
                case 54 -> 111;
                case 55 -> 54;
                case 56 -> 197;
                case 57 -> 199;
                case 58 -> 138;
                case 59 -> 1;
                case 60 -> 82;
                case 61 -> 228;
                case 62 -> 152;
                case 63 -> 120;
                case 64 -> 36;
                case 65 -> 11;
                case 66 -> 240;
                case 67 -> 16;
                case 68 -> 167;
                case 69 -> 156;
                case 70 -> 78;
                case 71 -> 121;
                case 72 -> 155;
                case 73 -> 38;
                case 74 -> 136;
                case 75 -> 235;
                case 76 -> 192;
                case 77 -> 224;
                case 78 -> 23;
                case 79 -> 176;
                case 80 -> 29;
                case 81 -> 205;
                case 82 -> 229;
                case 83 -> 6;
                case 84 -> 159;
                case 85 -> 242;
                case 86 -> 194;
                case 87 -> 248;
                case 88 -> 114;
                case 89 -> 68;
                case 90 -> 32;
                case 91 -> 227;
                case 92 -> 141;
                case 93 -> 70;
                case 94 -> 175;
                case 95 -> 187;
                case 96 -> 134;
                case 97 -> 232;
                case 98 -> 140;
                case 99 -> 230;
                case 100 -> 41;
                case 101 -> 86;
                case 102 -> 254;
                case 103 -> 169;
                case 104 -> 218;
                case 105 -> 239;
                case 106 -> 246;
                case 107 -> 172;
                case 108 -> 225;
                case 109 -> 123;
                case 110 -> 109;
                case 111 -> 208;
                case 112 -> 124;
                case 113 -> 31;
                case 114 -> 238;
                case 115 -> 204;
                case 116 -> 40;
                case 117 -> 12;
                case 118 -> 103;
                case 119 -> 75;
                case 120 -> 64;
                case 121 -> 59;
                case 122 -> 253;
                case 123 -> 193;
                case 124 -> 118;
                case 125 -> 234;
                case 126 -> 63;
                case 127 -> 245;
                case 128 -> 49;
                case 129 -> 92;
                case 130 -> 8;
                case 131 -> 97;
                case 132 -> 185;
                case 133 -> 255;
                case 134 -> 99;
                case 135 -> 4;
                case 136 -> 151;
                case 137 -> 217;
                case 138 -> 183;
                case 139 -> 243;
                case 140 -> 52;
                case 141 -> 69;
                case 142 -> 161;
                case 143 -> 174;
                case 144 -> 90;
                case 145 -> 55;
                case 146 -> 216;
                case 147 -> 237;
                case 148 -> 100;
                case 149 -> 146;
                case 150 -> 139;
                case 151 -> 14;
                case 152 -> 76;
                case 153 -> 35;
                case 154 -> 200;
                case 155 -> 47;
                case 156 -> 27;
                case 157 -> 188;
                case 158 -> 116;
                case 159 -> 113;
                case 160 -> 77;
                case 161 -> 0;
                case 162 -> 247;
                case 163 -> 57;
                case 164 -> 62;
                case 165 -> 5;
                case 166 -> 191;
                case 167 -> 196;
                case 168 -> 105;
                case 169 -> 26;
                case 170 -> 117;
                case 171 -> 250;
                case 172 -> 83;
                case 173 -> 87;
                case 174 -> 71;
                case 175 -> 206;
                case 176 -> 221;
                case 177 -> 19;
                case 178 -> 178;
                case 179 -> 142;
                case 180 -> 108;
                case 181 -> 2;
                case 182 -> 67;
                case 183 -> 158;
                case 184 -> 150;
                case 185 -> 122;
                case 186 -> 236;
                case 187 -> 73;
                case 188 -> 119;
                case 189 -> 13;
                case 190 -> 144;
                case 191 -> 210;
                case 192 -> 129;
                case 193 -> 213;
                case 194 -> 17;
                case 195 -> 9;
                case 196 -> 184;
                case 197 -> 203;
                case 198 -> 137;
                case 199 -> 51;
                case 200 -> 171;
                case 201 -> 226;
                case 202 -> 190;
                case 203 -> 102;
                case 204 -> 182;
                case 205 -> 145;
                case 206 -> 162;
                case 207 -> 88;
                case 208 -> 154;
                case 209 -> 160;
                case 210 -> 34;
                case 211 -> 133;
                case 212 -> 233;
                case 213 -> 164;
                case 214 -> 166;
                case 215 -> 215;
                case 216 -> 157;
                case 217 -> 91;
                case 218 -> 223;
                case 219 -> 72;
                case 220 -> 96;
                case 221 -> 179;
                case 222 -> 84;
                case 223 -> 43;
                case 224 -> 165;
                case 225 -> 211;
                case 226 -> 101;
                case 227 -> 65;
                case 228 -> 214;
                case 229 -> 28;
                case 230 -> 33;
                case 231 -> 168;
                case 232 -> 249;
                case 233 -> 126;
                case 234 -> 104;
                case 235 -> 58;
                case 236 -> 181;
                case 237 -> 110;
                case 238 -> 74;
                case 239 -> 195;
                case 240 -> 10;
                case 241 -> 24;
                case 242 -> 125;
                case 243 -> 153;
                case 244 -> 53;
                case 245 -> 127;
                case 246 -> 198;
                case 247 -> 37;
                case 248 -> 50;
                case 249 -> 80;
                case 250 -> 149;
                case 251 -> 128;
                case 252 -> 180;
                case 253 -> 85;
                case 254 -> 3;
                default -> 112;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 110346596544783L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(296742480 + 10461, 296742480 + 15007, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 23087389577791L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.C();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1940360280 + 26564, 1940360280 + 26525, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1940360280 + 26567, 1940360280 + 19246, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1940360280 + 26566, 1940360280 + 13645, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "^\u00a3\u0002\r\u00f8\u0087\u008d\u00a9\u0010\u0085\u0011\u0088\u00fa\u0013\u00c2\tX\u007f\u00e2q\u00edG\u0002QH";
                    var4_3 = "^\u00a3\u0002\r\u00f8\u0087\u008d\u00a9\u0010\u0085\u0011\u0088\u00fa\u0013\u00c2\tX\u007f\u00e2q\u00edG\u0002QH".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 100;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e0\b>\u0093\u00e459\u0005\u0012^\u00b3\u0084\u00ee\u00d0\u001f\u00a3\u0004\u00ee\u00f5c\u00e9\u0005w\u0097\u00b9*\u00e3@\u0018/\u0099W\u00dbp\u0005\u00f6\u00da|x\t\u0014\u0097\u00f4\u001f\u001a\u00d6\u0019\t\u00e9\u00ad%\u00ce\u00e7\u00f9\u00bd\u00c5\u00c2\u009f\u00c4";
                        var4_3 = "\u00e0\b>\u0093\u00e459\u0005\u0012^\u00b3\u0084\u00ee\u00d0\u001f\u00a3\u0004\u00ee\u00f5c\u00e9\u0005w\u0097\u00b9*\u00e3@\u0018/\u0099W\u00dbp\u0005\u00f6\u00da|x\t\u0014\u0097\u00f4\u001f\u001a\u00d6\u0019\t\u00e9\u00ad%\u00ce\u00e7\u00f9\u00bd\u00c5\u00c2\u009f\u00c4".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 74;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 56;
                                break;
                            }
                            case 1: {
                                v15 = 69;
                                break;
                            }
                            case 2: {
                                v15 = 40;
                                break;
                            }
                            case 3: {
                                v15 = 24;
                                break;
                            }
                            case 4: {
                                v15 = 123;
                                break;
                            }
                            case 5: {
                                v15 = 101;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x6622) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 163;
                    case 1 -> 240;
                    case 2 -> 110;
                    case 3 -> 123;
                    case 4 -> 188;
                    case 5 -> 243;
                    case 6 -> 13;
                    case 7 -> 60;
                    case 8 -> 255;
                    case 9 -> 125;
                    case 10 -> 142;
                    case 11 -> 100;
                    case 12 -> 133;
                    case 13 -> 69;
                    case 14 -> 68;
                    case 15 -> 31;
                    case 16 -> 7;
                    case 17 -> 117;
                    case 18 -> 144;
                    case 19 -> 193;
                    case 20 -> 33;
                    case 21 -> 58;
                    case 22 -> 233;
                    case 23 -> 141;
                    case 24 -> 39;
                    case 25 -> 166;
                    case 26 -> 192;
                    case 27 -> 18;
                    case 28 -> 101;
                    case 29 -> 203;
                    case 30 -> 196;
                    case 31 -> 36;
                    case 32 -> 63;
                    case 33 -> 185;
                    case 34 -> 167;
                    case 35 -> 52;
                    case 36 -> 175;
                    case 37 -> 204;
                    case 38 -> 3;
                    case 39 -> 103;
                    case 40 -> 168;
                    case 41 -> 194;
                    case 42 -> 112;
                    case 43 -> 227;
                    case 44 -> 28;
                    case 45 -> 42;
                    case 46 -> 197;
                    case 47 -> 50;
                    case 48 -> 191;
                    case 49 -> 254;
                    case 50 -> 122;
                    case 51 -> 96;
                    case 52 -> 210;
                    case 53 -> 152;
                    case 54 -> 43;
                    case 55 -> 14;
                    case 56 -> 5;
                    case 57 -> 45;
                    case 58 -> 132;
                    case 59 -> 92;
                    case 60 -> 209;
                    case 61 -> 164;
                    case 62 -> 129;
                    case 63 -> 155;
                    case 64 -> 220;
                    case 65 -> 202;
                    case 66 -> 253;
                    case 67 -> 91;
                    case 68 -> 236;
                    case 69 -> 214;
                    case 70 -> 169;
                    case 71 -> 19;
                    case 72 -> 120;
                    case 73 -> 71;
                    case 74 -> 27;
                    case 75 -> 41;
                    case 76 -> 147;
                    case 77 -> 76;
                    case 78 -> 54;
                    case 79 -> 157;
                    case 80 -> 90;
                    case 81 -> 134;
                    case 82 -> 245;
                    case 83 -> 235;
                    case 84 -> 64;
                    case 85 -> 95;
                    case 86 -> 228;
                    case 87 -> 34;
                    case 88 -> 174;
                    case 89 -> 239;
                    case 90 -> 138;
                    case 91 -> 102;
                    case 92 -> 165;
                    case 93 -> 159;
                    case 94 -> 84;
                    case 95 -> 195;
                    case 96 -> 251;
                    case 97 -> 11;
                    case 98 -> 139;
                    case 99 -> 85;
                    case 100 -> 108;
                    case 101 -> 208;
                    case 102 -> 97;
                    case 103 -> 170;
                    case 104 -> 25;
                    case 105 -> 213;
                    case 106 -> 40;
                    case 107 -> 149;
                    case 108 -> 107;
                    case 109 -> 35;
                    case 110 -> 80;
                    case 111 -> 9;
                    case 112 -> 113;
                    case 113 -> 189;
                    case 114 -> 137;
                    case 115 -> 226;
                    case 116 -> 17;
                    case 117 -> 156;
                    case 118 -> 172;
                    case 119 -> 146;
                    case 120 -> 223;
                    case 121 -> 231;
                    case 122 -> 135;
                    case 123 -> 78;
                    case 124 -> 47;
                    case 125 -> 93;
                    case 126 -> 57;
                    case 127 -> 99;
                    case 128 -> 187;
                    case 129 -> 229;
                    case 130 -> 199;
                    case 131 -> 238;
                    case 132 -> 221;
                    case 133 -> 244;
                    case 134 -> 207;
                    case 135 -> 143;
                    case 136 -> 182;
                    case 137 -> 111;
                    case 138 -> 86;
                    case 139 -> 38;
                    case 140 -> 2;
                    case 141 -> 234;
                    case 142 -> 62;
                    case 143 -> 249;
                    case 144 -> 104;
                    case 145 -> 205;
                    case 146 -> 215;
                    case 147 -> 88;
                    case 148 -> 179;
                    case 149 -> 75;
                    case 150 -> 10;
                    case 151 -> 114;
                    case 152 -> 73;
                    case 153 -> 186;
                    case 154 -> 242;
                    case 155 -> 206;
                    case 156 -> 145;
                    case 157 -> 180;
                    case 158 -> 55;
                    case 159 -> 148;
                    case 160 -> 51;
                    case 161 -> 160;
                    case 162 -> 82;
                    case 163 -> 248;
                    case 164 -> 116;
                    case 165 -> 161;
                    case 166 -> 94;
                    case 167 -> 124;
                    case 168 -> 252;
                    case 169 -> 65;
                    case 170 -> 22;
                    case 171 -> 30;
                    case 172 -> 1;
                    case 173 -> 53;
                    case 174 -> 8;
                    case 175 -> 250;
                    case 176 -> 66;
                    case 177 -> 162;
                    case 178 -> 128;
                    case 179 -> 48;
                    case 180 -> 56;
                    case 181 -> 79;
                    case 182 -> 98;
                    case 183 -> 181;
                    case 184 -> 131;
                    case 185 -> 171;
                    case 186 -> 72;
                    case 187 -> 105;
                    case 188 -> 219;
                    case 189 -> 46;
                    case 190 -> 44;
                    case 191 -> 118;
                    case 192 -> 26;
                    case 193 -> 6;
                    case 194 -> 4;
                    case 195 -> 59;
                    case 196 -> 67;
                    case 197 -> 29;
                    case 198 -> 83;
                    case 199 -> 87;
                    case 200 -> 70;
                    case 201 -> 109;
                    case 202 -> 15;
                    case 203 -> 127;
                    case 204 -> 32;
                    case 205 -> 154;
                    case 206 -> 211;
                    case 207 -> 77;
                    case 208 -> 173;
                    case 209 -> 153;
                    case 210 -> 150;
                    case 211 -> 0;
                    case 212 -> 201;
                    case 213 -> 230;
                    case 214 -> 184;
                    case 215 -> 136;
                    case 216 -> 89;
                    case 217 -> 12;
                    case 218 -> 21;
                    case 219 -> 49;
                    case 220 -> 130;
                    case 221 -> 74;
                    case 222 -> 225;
                    case 223 -> 241;
                    case 224 -> 106;
                    case 225 -> 151;
                    case 226 -> 61;
                    case 227 -> 121;
                    case 228 -> 224;
                    case 229 -> 126;
                    case 230 -> 212;
                    case 231 -> 16;
                    case 232 -> 119;
                    case 233 -> 247;
                    case 234 -> 115;
                    case 235 -> 81;
                    case 236 -> 190;
                    case 237 -> 232;
                    case 238 -> 218;
                    case 239 -> 216;
                    case 240 -> 176;
                    case 241 -> 237;
                    case 242 -> 217;
                    case 243 -> 246;
                    case 244 -> 24;
                    case 245 -> 20;
                    case 246 -> 23;
                    case 247 -> 158;
                    case 248 -> 222;
                    case 249 -> 177;
                    case 250 -> 183;
                    case 251 -> 140;
                    case 252 -> 178;
                    case 253 -> 198;
                    case 254 -> 200;
                    default -> 37;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 84228092514920L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "e\bYPP,\u0011<\tb\u0002JZ\u001dn\f D";
                    var5_4 = "e\bYPP,\u0011<\tb\u0002JZ\u001dn\f D".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 29;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 19;
                                    break;
                                }
                                case 1: {
                                    v11 = 112;
                                    break;
                                }
                                case 2: {
                                    v11 = 54;
                                    break;
                                }
                                case 3: {
                                    v11 = 35;
                                    break;
                                }
                                case 4: {
                                    v11 = 40;
                                    break;
                                }
                                case 5: {
                                    v11 = 93;
                                    break;
                                }
                                default: {
                                    v11 = 63;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 61639000595503L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "ZJxpE\u0001^\u0004\\Ttj\nPK\u007fjI\u0003FzJv\tPK\u007fjI\u0003Fv@\rWMbgC\u000e\\vGemB\u0007";
                    var5_4 = "ZJxpE\u0001^\u0004\\Ttj\nPK\u007fjI\u0003FzJv\tPK\u007fjI\u0003Fv@\rWMbgC\u000e\\vGemB\u0007".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 82;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "0(\u001e\u0017%n5\u00060(\u001e\u0017)d";
                        var5_4 = "0(\u001e\u0017%n5\u00060(\u001e\u0017)d".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 50;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 65;
                                break;
                            }
                            case 1: {
                                v15 = 118;
                                break;
                            }
                            case 2: {
                                v15 = 67;
                                break;
                            }
                            case 3: {
                                v15 = 86;
                                break;
                            }
                            case 4: {
                                v15 = 126;
                                break;
                            }
                            case 5: {
                                v15 = 50;
                                break;
                            }
                            default: {
                                v15 = 96;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 22587638197809L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-405137370 + -((char)-9533), -405137370 + -((char)-17226), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 71529554263461L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0083C\u001d\u00b5\u0093\u0003\u009a\u0012\u008a\u0005\u0001\u00ebkd\u00be\r\f\u00da\u00fc\b\u00b9\u00c7\u0098\u00a2\u00c4\u00bb\u0085\u0090\u00f1\u0010\u00be5m\u001e\u00b4\u0090\u0012u\\\u00c5u\u0012\t\u0012\u00ff\n\u0005q\re\u00b8\u007f3\u00a8\u00efO\u0093%e\u0010\u00dfamY.J\u00c4\u00bb\u00cfd^\\6\u00fcI6\u00ef\u001c \u00a7\u00cc\u00b8~;\u00bburQ\u001f\r%\u001ek!\u00e0s\tn\u00a3\u0010[\u00ce-\u00f7";
                    var4_3 = "\u0083C\u001d\u00b5\u0093\u0003\u009a\u0012\u008a\u0005\u0001\u00ebkd\u00be\r\f\u00da\u00fc\b\u00b9\u00c7\u0098\u00a2\u00c4\u00bb\u0085\u0090\u00f1\u0010\u00be5m\u001e\u00b4\u0090\u0012u\\\u00c5u\u0012\t\u0012\u00ff\n\u0005q\re\u00b8\u007f3\u00a8\u00efO\u0093%e\u0010\u00dfamY.J\u00c4\u00bb\u00cfd^\\6\u00fcI6\u00ef\u001c \u00a7\u00cc\u00b8~;\u00bburQ\u001f\r%\u001ek!\u00e0s\tn\u00a3\u0010[\u00ce-\u00f7".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 10;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0088]p\u00c8\u00cc\u0091\u00c6\u008e\u001da\u0086]\u00ac \u0090\u0097L3\u0097\u00f0[\u00f6+\u00ef\u00b7\u00b1\u00d5\u00bfr\u0085K&\u0083\t\u00dd\u00d5k~]\u0097\u0014\u00d0o\u00c08ur\u00b6\u008e\u000f\u00e1\u00b4\u00aaX\u0096U\u00a0\u00a5\u00bf\u00f7D0\u000f\u00cb-\u009c\f\u008e\u0080w\u00e076\u00f8\u00db\u001e\u00dd/p\u0002QL\u0010\t\u00b49h\u00e77\u00det\"\u00c9";
                        var4_3 = "\u0088]p\u00c8\u00cc\u0091\u00c6\u008e\u001da\u0086]\u00ac \u0090\u0097L3\u0097\u00f0[\u00f6+\u00ef\u00b7\u00b1\u00d5\u00bfr\u0085K&\u0083\t\u00dd\u00d5k~]\u0097\u0014\u00d0o\u00c08ur\u00b6\u008e\u000f\u00e1\u00b4\u00aaX\u0096U\u00a0\u00a5\u00bf\u00f7D0\u000f\u00cb-\u009c\f\u008e\u0080w\u00e076\u00f8\u00db\u001e\u00dd/p\u0002QL\u0010\t\u00b49h\u00e77\u00det\"\u00c9".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 127;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 89;
                                break;
                            }
                            case 1: {
                                v15 = 75;
                                break;
                            }
                            case 2: {
                                v15 = 37;
                                break;
                            }
                            case 3: {
                                v15 = 26;
                                break;
                            }
                            case 4: {
                                v15 = 98;
                                break;
                            }
                            case 5: {
                                v15 = 72;
                                break;
                            }
                            default: {
                                v15 = 84;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0xFFFF9352) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 102;
                    case 1 -> 199;
                    case 2 -> 232;
                    case 3 -> 79;
                    case 4 -> 138;
                    case 5 -> 88;
                    case 6 -> 205;
                    case 7 -> 173;
                    case 8 -> 240;
                    case 9 -> 208;
                    case 10 -> 118;
                    case 11 -> 176;
                    case 12 -> 101;
                    case 13 -> 107;
                    case 14 -> 211;
                    case 15 -> 20;
                    case 16 -> 238;
                    case 17 -> 71;
                    case 18 -> 46;
                    case 19 -> 103;
                    case 20 -> 64;
                    case 21 -> 250;
                    case 22 -> 73;
                    case 23 -> 209;
                    case 24 -> 216;
                    case 25 -> 96;
                    case 26 -> 42;
                    case 27 -> 159;
                    case 28 -> 139;
                    case 29 -> 97;
                    case 30 -> 23;
                    case 31 -> 247;
                    case 32 -> 121;
                    case 33 -> 15;
                    case 34 -> 146;
                    case 35 -> 32;
                    case 36 -> 239;
                    case 37 -> 16;
                    case 38 -> 245;
                    case 39 -> 255;
                    case 40 -> 55;
                    case 41 -> 68;
                    case 42 -> 85;
                    case 43 -> 226;
                    case 44 -> 11;
                    case 45 -> 134;
                    case 46 -> 76;
                    case 47 -> 235;
                    case 48 -> 225;
                    case 49 -> 92;
                    case 50 -> 124;
                    case 51 -> 40;
                    case 52 -> 49;
                    case 53 -> 12;
                    case 54 -> 108;
                    case 55 -> 34;
                    case 56 -> 4;
                    case 57 -> 182;
                    case 58 -> 141;
                    case 59 -> 119;
                    case 60 -> 70;
                    case 61 -> 116;
                    case 62 -> 155;
                    case 63 -> 52;
                    case 64 -> 62;
                    case 65 -> 157;
                    case 66 -> 123;
                    case 67 -> 104;
                    case 68 -> 201;
                    case 69 -> 66;
                    case 70 -> 227;
                    case 71 -> 111;
                    case 72 -> 83;
                    case 73 -> 249;
                    case 74 -> 80;
                    case 75 -> 63;
                    case 76 -> 0;
                    case 77 -> 28;
                    case 78 -> 151;
                    case 79 -> 188;
                    case 80 -> 61;
                    case 81 -> 24;
                    case 82 -> 95;
                    case 83 -> 206;
                    case 84 -> 163;
                    case 85 -> 8;
                    case 86 -> 166;
                    case 87 -> 196;
                    case 88 -> 127;
                    case 89 -> 3;
                    case 90 -> 190;
                    case 91 -> 43;
                    case 92 -> 18;
                    case 93 -> 178;
                    case 94 -> 143;
                    case 95 -> 161;
                    case 96 -> 5;
                    case 97 -> 220;
                    case 98 -> 158;
                    case 99 -> 197;
                    case 100 -> 136;
                    case 101 -> 164;
                    case 102 -> 177;
                    case 103 -> 57;
                    case 104 -> 252;
                    case 105 -> 189;
                    case 106 -> 193;
                    case 107 -> 10;
                    case 108 -> 25;
                    case 109 -> 114;
                    case 110 -> 234;
                    case 111 -> 145;
                    case 112 -> 221;
                    case 113 -> 172;
                    case 114 -> 162;
                    case 115 -> 254;
                    case 116 -> 91;
                    case 117 -> 72;
                    case 118 -> 156;
                    case 119 -> 94;
                    case 120 -> 99;
                    case 121 -> 194;
                    case 122 -> 86;
                    case 123 -> 132;
                    case 124 -> 36;
                    case 125 -> 105;
                    case 126 -> 198;
                    case 127 -> 181;
                    case 128 -> 185;
                    case 129 -> 100;
                    case 130 -> 58;
                    case 131 -> 90;
                    case 132 -> 149;
                    case 133 -> 128;
                    case 134 -> 186;
                    case 135 -> 165;
                    case 136 -> 47;
                    case 137 -> 27;
                    case 138 -> 22;
                    case 139 -> 133;
                    case 140 -> 244;
                    case 141 -> 35;
                    case 142 -> 184;
                    case 143 -> 126;
                    case 144 -> 231;
                    case 145 -> 137;
                    case 146 -> 212;
                    case 147 -> 75;
                    case 148 -> 195;
                    case 149 -> 150;
                    case 150 -> 243;
                    case 151 -> 210;
                    case 152 -> 65;
                    case 153 -> 21;
                    case 154 -> 229;
                    case 155 -> 84;
                    case 156 -> 183;
                    case 157 -> 233;
                    case 158 -> 153;
                    case 159 -> 53;
                    case 160 -> 54;
                    case 161 -> 17;
                    case 162 -> 237;
                    case 163 -> 33;
                    case 164 -> 213;
                    case 165 -> 131;
                    case 166 -> 148;
                    case 167 -> 241;
                    case 168 -> 152;
                    case 169 -> 142;
                    case 170 -> 170;
                    case 171 -> 171;
                    case 172 -> 29;
                    case 173 -> 122;
                    case 174 -> 19;
                    case 175 -> 31;
                    case 176 -> 140;
                    case 177 -> 56;
                    case 178 -> 228;
                    case 179 -> 223;
                    case 180 -> 202;
                    case 181 -> 147;
                    case 182 -> 219;
                    case 183 -> 169;
                    case 184 -> 48;
                    case 185 -> 168;
                    case 186 -> 7;
                    case 187 -> 74;
                    case 188 -> 191;
                    case 189 -> 13;
                    case 190 -> 215;
                    case 191 -> 248;
                    case 192 -> 77;
                    case 193 -> 30;
                    case 194 -> 106;
                    case 195 -> 113;
                    case 196 -> 251;
                    case 197 -> 135;
                    case 198 -> 9;
                    case 199 -> 179;
                    case 200 -> 218;
                    case 201 -> 224;
                    case 202 -> 81;
                    case 203 -> 204;
                    case 204 -> 117;
                    case 205 -> 38;
                    case 206 -> 200;
                    case 207 -> 203;
                    case 208 -> 144;
                    case 209 -> 1;
                    case 210 -> 41;
                    case 211 -> 6;
                    case 212 -> 230;
                    case 213 -> 125;
                    case 214 -> 39;
                    case 215 -> 187;
                    case 216 -> 112;
                    case 217 -> 192;
                    case 218 -> 222;
                    case 219 -> 130;
                    case 220 -> 78;
                    case 221 -> 207;
                    case 222 -> 154;
                    case 223 -> 44;
                    case 224 -> 115;
                    case 225 -> 246;
                    case 226 -> 2;
                    case 227 -> 174;
                    case 228 -> 93;
                    case 229 -> 98;
                    case 230 -> 236;
                    case 231 -> 160;
                    case 232 -> 26;
                    case 233 -> 242;
                    case 234 -> 120;
                    case 235 -> 89;
                    case 236 -> 14;
                    case 237 -> 59;
                    case 238 -> 129;
                    case 239 -> 110;
                    case 240 -> 109;
                    case 241 -> 45;
                    case 242 -> 253;
                    case 243 -> 175;
                    case 244 -> 82;
                    case 245 -> 67;
                    case 246 -> 87;
                    case 247 -> 51;
                    case 248 -> 60;
                    case 249 -> 69;
                    case 250 -> 50;
                    case 251 -> 167;
                    case 252 -> 214;
                    case 253 -> 37;
                    case 254 -> 180;
                    default -> 217;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 92965923570810L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1356443430 + 1635, 1356443430 + 1499, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 3265402586791L;
                    int[] nArray = SshAgentIpcService.C();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1227470550 - 32641, 1227470550 - 28742, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 27248014888592L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "Gr\u00ad\u00f4\u00dc\u0003\u00ed\u009c\u00ae";
                var4_3 = "Gr\u00ad\u00f4\u00dc\u0003\u00ed\u009c\u00ae".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 44;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 108;
                                break;
                            }
                            case 1: {
                                v11 = 101;
                                break;
                            }
                            case 2: {
                                v11 = 73;
                                break;
                            }
                            case 3: {
                                v11 = 90;
                                break;
                            }
                            case 4: {
                                v11 = 84;
                                break;
                            }
                            case 5: {
                                v11 = 76;
                                break;
                            }
                            default: {
                                v11 = 102;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x71F3) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 226;
                    case 1 -> 122;
                    case 2 -> 96;
                    case 3 -> 65;
                    case 4 -> 105;
                    case 5 -> 214;
                    case 6 -> 185;
                    case 7 -> 21;
                    case 8 -> 67;
                    case 9 -> 14;
                    case 10 -> 228;
                    case 11 -> 117;
                    case 12 -> 59;
                    case 13 -> 37;
                    case 14 -> 183;
                    case 15 -> 196;
                    case 16 -> 234;
                    case 17 -> 33;
                    case 18 -> 118;
                    case 19 -> 7;
                    case 20 -> 212;
                    case 21 -> 20;
                    case 22 -> 133;
                    case 23 -> 153;
                    case 24 -> 55;
                    case 25 -> 23;
                    case 26 -> 164;
                    case 27 -> 87;
                    case 28 -> 216;
                    case 29 -> 171;
                    case 30 -> 56;
                    case 31 -> 76;
                    case 32 -> 238;
                    case 33 -> 40;
                    case 34 -> 240;
                    case 35 -> 35;
                    case 36 -> 3;
                    case 37 -> 193;
                    case 38 -> 99;
                    case 39 -> 81;
                    case 40 -> 224;
                    case 41 -> 166;
                    case 42 -> 202;
                    case 43 -> 161;
                    case 44 -> 174;
                    case 45 -> 209;
                    case 46 -> 69;
                    case 47 -> 93;
                    case 48 -> 231;
                    case 49 -> 62;
                    case 50 -> 159;
                    case 51 -> 141;
                    case 52 -> 221;
                    case 53 -> 110;
                    case 54 -> 248;
                    case 55 -> 175;
                    case 56 -> 38;
                    case 57 -> 45;
                    case 58 -> 97;
                    case 59 -> 104;
                    case 60 -> 79;
                    case 61 -> 31;
                    case 62 -> 36;
                    case 63 -> 136;
                    case 64 -> 111;
                    case 65 -> 169;
                    case 66 -> 86;
                    case 67 -> 184;
                    case 68 -> 95;
                    case 69 -> 155;
                    case 70 -> 63;
                    case 71 -> 102;
                    case 72 -> 9;
                    case 73 -> 16;
                    case 74 -> 77;
                    case 75 -> 186;
                    case 76 -> 18;
                    case 77 -> 108;
                    case 78 -> 151;
                    case 79 -> 253;
                    case 80 -> 83;
                    case 81 -> 188;
                    case 82 -> 195;
                    case 83 -> 27;
                    case 84 -> 113;
                    case 85 -> 106;
                    case 86 -> 125;
                    case 87 -> 129;
                    case 88 -> 220;
                    case 89 -> 179;
                    case 90 -> 22;
                    case 91 -> 223;
                    case 92 -> 143;
                    case 93 -> 46;
                    case 94 -> 187;
                    case 95 -> 211;
                    case 96 -> 34;
                    case 97 -> 64;
                    case 98 -> 101;
                    case 99 -> 8;
                    case 100 -> 58;
                    case 101 -> 178;
                    case 102 -> 90;
                    case 103 -> 1;
                    case 104 -> 52;
                    case 105 -> 43;
                    case 106 -> 173;
                    case 107 -> 207;
                    case 108 -> 189;
                    case 109 -> 206;
                    case 110 -> 235;
                    case 111 -> 205;
                    case 112 -> 247;
                    case 113 -> 42;
                    case 114 -> 237;
                    case 115 -> 210;
                    case 116 -> 71;
                    case 117 -> 244;
                    case 118 -> 163;
                    case 119 -> 32;
                    case 120 -> 25;
                    case 121 -> 213;
                    case 122 -> 124;
                    case 123 -> 100;
                    case 124 -> 252;
                    case 125 -> 19;
                    case 126 -> 167;
                    case 127 -> 245;
                    case 128 -> 17;
                    case 129 -> 80;
                    case 130 -> 29;
                    case 131 -> 152;
                    case 132 -> 13;
                    case 133 -> 148;
                    case 134 -> 241;
                    case 135 -> 134;
                    case 136 -> 120;
                    case 137 -> 130;
                    case 138 -> 158;
                    case 139 -> 68;
                    case 140 -> 246;
                    case 141 -> 119;
                    case 142 -> 157;
                    case 143 -> 139;
                    case 144 -> 177;
                    case 145 -> 61;
                    case 146 -> 181;
                    case 147 -> 94;
                    case 148 -> 39;
                    case 149 -> 116;
                    case 150 -> 28;
                    case 151 -> 219;
                    case 152 -> 44;
                    case 153 -> 11;
                    case 154 -> 92;
                    case 155 -> 72;
                    case 156 -> 218;
                    case 157 -> 194;
                    case 158 -> 172;
                    case 159 -> 200;
                    case 160 -> 144;
                    case 161 -> 251;
                    case 162 -> 249;
                    case 163 -> 132;
                    case 164 -> 50;
                    case 165 -> 75;
                    case 166 -> 109;
                    case 167 -> 199;
                    case 168 -> 41;
                    case 169 -> 123;
                    case 170 -> 191;
                    case 171 -> 60;
                    case 172 -> 242;
                    case 173 -> 89;
                    case 174 -> 103;
                    case 175 -> 135;
                    case 176 -> 70;
                    case 177 -> 10;
                    case 178 -> 2;
                    case 179 -> 74;
                    case 180 -> 149;
                    case 181 -> 49;
                    case 182 -> 227;
                    case 183 -> 128;
                    case 184 -> 82;
                    case 185 -> 250;
                    case 186 -> 215;
                    case 187 -> 12;
                    case 188 -> 4;
                    case 189 -> 232;
                    case 190 -> 48;
                    case 191 -> 255;
                    case 192 -> 146;
                    case 193 -> 160;
                    case 194 -> 5;
                    case 195 -> 24;
                    case 196 -> 51;
                    case 197 -> 201;
                    case 198 -> 115;
                    case 199 -> 162;
                    case 200 -> 165;
                    case 201 -> 6;
                    case 202 -> 150;
                    case 203 -> 203;
                    case 204 -> 114;
                    case 205 -> 176;
                    case 206 -> 112;
                    case 207 -> 197;
                    case 208 -> 91;
                    case 209 -> 229;
                    case 210 -> 15;
                    case 211 -> 192;
                    case 212 -> 236;
                    case 213 -> 243;
                    case 214 -> 0;
                    case 215 -> 88;
                    case 216 -> 230;
                    case 217 -> 140;
                    case 218 -> 131;
                    case 219 -> 57;
                    case 220 -> 254;
                    case 221 -> 78;
                    case 222 -> 233;
                    case 223 -> 54;
                    case 224 -> 30;
                    case 225 -> 198;
                    case 226 -> 222;
                    case 227 -> 127;
                    case 228 -> 98;
                    case 229 -> 147;
                    case 230 -> 154;
                    case 231 -> 73;
                    case 232 -> 47;
                    case 233 -> 121;
                    case 234 -> 208;
                    case 235 -> 145;
                    case 236 -> 66;
                    case 237 -> 217;
                    case 238 -> 239;
                    case 239 -> 225;
                    case 240 -> 126;
                    case 241 -> 138;
                    case 242 -> 142;
                    case 243 -> 204;
                    case 244 -> 182;
                    case 245 -> 84;
                    case 246 -> 180;
                    case 247 -> 53;
                    case 248 -> 170;
                    case 249 -> 26;
                    case 250 -> 107;
                    case 251 -> 190;
                    case 252 -> 137;
                    case 253 -> 85;
                    case 254 -> 156;
                    default -> 168;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

