/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.mongoDB;

import com.intellij.database.dialects.mongo.MongoDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.jam.JamService;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.jpb.model.repository.RepositorySearch;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.data.commons.model.jam.SpringDataDocumentId;
import com.intellij.spring.data.mongoDB.jam.SpringDataMongoDbDocumentField;
import com.intellij.spring.data.mongoDB.jam.SpringDataMongodbDocument;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringDataMongoDbUtils {
    private static final String SPRING_DATA_MONGODB_MAVEN = "org.springframework.data:spring-data-mongodb";

    public static boolean hasSpringDataMongoDbSupport(Project project) {
        return JavaLibraryUtil.hasLibraryJar((Project)project, (String)SPRING_DATA_MONGODB_MAVEN);
    }

    public static boolean hasSpringDataMongoDbSupport(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_DATA_MONGODB_MAVEN);
    }

    @Nullable
    public static SpringDataMongodbDocument getMongoDbDocument(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(0);
        }
        return (SpringDataMongodbDocument)JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringDataMongodbDocument.META.getJamKey(), (PsiElement)psiClass);
    }

    @Nullable
    public static SpringDataMongoDbDocumentField<?> getMongoDbDocumentField(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        return (SpringDataMongoDbDocumentField)SemService.getSemService((Project)psiElement.getProject()).getSemElement(SpringDataMongoDbDocumentField.SEM_KEY, psiElement);
    }

    @Nullable
    public static SpringDataDocumentId getMongoDbDocumentId(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        return (SpringDataDocumentId)SemService.getSemService((Project)psiElement.getProject()).getSemElement(SpringDataDocumentId.SEM_KEY, psiElement);
    }

    @NotNull
    public static Collection<DbDataSource> getMongoDbDataSources(@NotNull Project project) {
        if (project == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(1);
        }
        Collection collection = DbPsiFacade.getInstance((Project)project).getDataSources().stream().filter(source -> source.getDatabaseDialect() instanceof MongoDialect).collect(Collectors.toSet());
        if (collection == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public static String getDocumentName(@NotNull UClass uClass) {
        if (uClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(3);
        }
        return SpringDataMongoDbUtils.getDocumentName(uClass.getJavaPsi());
    }

    @Nullable
    public static String getDocumentName(@NotNull PsiClass psiClass) {
        SpringDataMongodbDocument document;
        if (psiClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(4);
        }
        if ((document = SpringDataMongoDbUtils.getMongoDbDocument(psiClass)) != null && !StringUtil.isEmptyOrSpaces((String)document.getDocumentName())) {
            return document.getDocumentName();
        }
        if (!StringUtil.isEmptyOrSpaces((String)psiClass.getName())) {
            return psiClass.getName().toLowerCase(Locale.ENGLISH);
        }
        return null;
    }

    @Nullable
    public static DbTable findDocument(@NotNull UClass uClass) {
        String documentName;
        if (uClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(documentName = SpringDataMongoDbUtils.getDocumentName(uClass)))) {
            return null;
        }
        return SpringDataMongoDbUtils.findDocument(uClass.getJavaPsi().getProject(), documentName);
    }

    @Nullable
    public static DbTable findDocument(@NotNull Project project, @NotNull String documentName) {
        if (project == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(6);
        }
        if (documentName == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(7);
        }
        for (DbDataSource dataSource : SpringDataMongoDbUtils.getMongoDbDataSources(project)) {
            for (DasTable dasTable : DasUtil.getTables((DasDataSource)dataSource)) {
                DbElement element;
                if (!documentName.equals(dasTable.getName()) || !((element = DbImplUtilCore.findElement((DbDataSource)dataSource, (DasObject)dasTable)) instanceof DbTable)) continue;
                return (DbTable)element;
            }
        }
        return null;
    }

    @Nullable
    public static DbElement findField(@NotNull PsiElement psiElement, @NotNull String fieldName) {
        UElement uElement;
        if (psiElement == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(8);
        }
        if (fieldName == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(9);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)psiElement)) == null) {
            return null;
        }
        return SpringDataMongoDbUtils.getMongoDbDocumentField(uElement, fieldName);
    }

    @Nullable
    public static DbElement getMongoDbDocumentField(@NotNull String documentName, @NotNull String fieldName, @NotNull Project project) {
        DbTable document;
        if (documentName == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(10);
        }
        if (fieldName == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(11);
        }
        if (project == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(12);
        }
        if ((document = SpringDataMongoDbUtils.findDocument(project, documentName)) != null) {
            for (DasColumn column : DasUtil.getColumns((DasObject)document)) {
                if (!fieldName.equals(column.getName())) continue;
                return DbImplUtilCore.findElement((DbDataSource)document.getDataSource(), (DasObject)column);
            }
        }
        return null;
    }

    @Nullable
    public static DbElement getMongoDbDocumentField(@NotNull UElement uElement, @NotNull String fieldName) {
        DbTable document;
        UClass uClass;
        if (uElement == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(13);
        }
        if (fieldName == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(14);
        }
        if ((uClass = (UClass)UastUtils.getParentOfType((UElement)uElement, UClass.class)) != null && (document = SpringDataMongoDbUtils.findDocument(uClass)) != null) {
            for (DasColumn column : DasUtil.getColumns((DasObject)document)) {
                if (!fieldName.equals(column.getName())) continue;
                return DbImplUtilCore.findElement((DbDataSource)document.getDataSource(), (DasObject)column);
            }
        }
        return null;
    }

    @Nullable
    public static DbElement getMongoDbField(@NotNull PsiMember psiMember) {
        PsiClass psiClass;
        if (psiMember == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(15);
        }
        if ((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiMember, PsiClass.class)) == null) {
            return null;
        }
        String documentName = SpringDataMongoDbUtils.getDocumentName(psiClass);
        if (StringUtil.isEmptyOrSpaces((String)documentName)) {
            return null;
        }
        String fieldName = SpringDataMongoDbUtils.getFieldName(psiMember);
        if (StringUtil.isEmptyOrSpaces((String)fieldName)) {
            return null;
        }
        return SpringDataMongoDbUtils.getMongoDbDocumentField(documentName, fieldName, psiMember.getProject());
    }

    @NotNull
    public static Set<DbElement> getAllFields(@NotNull PsiElement psiElement) {
        UElement uElement;
        if (psiElement == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(16);
        }
        if ((uElement = UastContextKt.toUElement((PsiElement)psiElement)) == null) {
            Set<DbElement> set = Collections.emptySet();
            if (set == null) {
                SpringDataMongoDbUtils.$$$reportNull$$$0(17);
            }
            return set;
        }
        return SpringDataMongoDbUtils.getAllFields((UClass)UastUtils.getParentOfType((UElement)uElement, UClass.class));
    }

    @NotNull
    public static Set<DbElement> getAllFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(18);
        }
        return SpringDataMongoDbUtils.getAllFields((UClass)UastContextKt.toUElement((PsiElement)psiClass, UClass.class));
    }

    @NotNull
    public static Set<DbElement> getAllFields(@Nullable UClass uClass) {
        if (uClass == null) {
            Set<DbElement> set = Collections.emptySet();
            if (set == null) {
                SpringDataMongoDbUtils.$$$reportNull$$$0(19);
            }
            return set;
        }
        HashSet<DbElement> fields = new HashSet<DbElement>();
        DbTable document = SpringDataMongoDbUtils.findDocument(uClass);
        if (document != null) {
            for (DasColumn column : DasUtil.getColumns((DasObject)document)) {
                if ("_id".equals(column.getName())) continue;
                ContainerUtil.addIfNotNull(fields, (Object)DbImplUtilCore.findElement((DbDataSource)document.getDataSource(), (DasObject)column));
            }
        }
        HashSet<DbElement> hashSet = fields;
        if (hashSet == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    @NotNull
    public static Set<DbTable> getAllDocuments(@NotNull Project project) {
        if (project == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(21);
        }
        HashSet<DbTable> documents = new HashSet<DbTable>();
        for (DbDataSource dataSource : SpringDataMongoDbUtils.getMongoDbDataSources(project)) {
            for (DasTable dasTable : DasUtil.getTables((DasDataSource)dataSource)) {
                DbElement element = DbImplUtilCore.findElement((DbDataSource)dataSource, (DasObject)dasTable);
                if (!(element instanceof DbTable)) continue;
                documents.add((DbTable)element);
            }
        }
        HashSet<DbTable> hashSet = documents;
        if (hashSet == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    @NotNull
    public static String getFieldName(@NotNull PsiMember psiMember) {
        SpringDataDocumentId documentId;
        if (psiMember == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(23);
        }
        if ((documentId = SpringDataMongoDbUtils.getMongoDbDocumentId((PsiElement)psiMember)) != null) {
            return "_id";
        }
        SpringDataMongoDbDocumentField<?> mongoDbField = SpringDataMongoDbUtils.getMongoDbDocumentField((PsiElement)psiMember);
        if (mongoDbField != null && !StringUtil.isEmptyOrSpaces((String)mongoDbField.getName())) {
            String string = mongoDbField.getName();
            if (string == null) {
                SpringDataMongoDbUtils.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = psiMember.getName();
        if (string == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Nullable
    public static PsiMember findFieldDeclaration(@NotNull UClass documentClass, @NotNull String fieldPath) {
        SemService semService;
        PsiClass documentPsiClass;
        String[] fieldNames;
        String firstFieldName;
        Pair<PsiMember, PsiType> declarationAndType;
        if (documentClass == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(26);
        }
        if (fieldPath == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(27);
        }
        if ((declarationAndType = SpringDataMongoDbUtils.findFieldDeclaration(firstFieldName = (fieldNames = fieldPath.split("\\.", 2)).length > 1 ? fieldNames[0] : fieldPath, documentPsiClass = documentClass.getJavaPsi(), semService = SemService.getSemService((Project)documentPsiClass.getProject()))) == null) {
            return null;
        }
        if (fieldNames.length == 1) {
            return (PsiMember)declarationAndType.first;
        }
        PsiType psiType = (PsiType)declarationAndType.second;
        if (!(psiType instanceof PsiClassType)) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)psiType).resolve();
        if (psiClass == null) {
            return null;
        }
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)psiClass, UClass.class);
        if (uClass == null) {
            return null;
        }
        return SpringDataMongoDbUtils.findFieldDeclaration(uClass, fieldNames[1]);
    }

    public static boolean isReadonlyProperty(@NotNull UDeclaration uDeclaration) {
        if (uDeclaration == null) {
            SpringDataMongoDbUtils.$$$reportNull$$$0(28);
        }
        return ContainerUtil.exists((Iterable)uDeclaration.getUAnnotations(), uAnno -> "org.springframework.data.annotation.ReadOnlyProperty".equals(uAnno.getQualifiedName()));
    }

    public static boolean isIdFieldName(@Nullable String fieldName) {
        return "id".equals(fieldName) || "_id".equals(fieldName);
    }

    @Nullable
    private static Pair<PsiMember, PsiType> findFieldDeclaration(String fieldName, PsiClass psiClass, SemService semService) {
        PsiMember psiField = SpringDataMongoDbUtils.findFieldDeclaration(fieldName, (PsiMember[])psiClass.getAllFields(), semService);
        if (psiField instanceof PsiField) {
            return new Pair((Object)psiField, (Object)((PsiField)psiField).getType());
        }
        PsiMember psiMethod = SpringDataMongoDbUtils.findFieldDeclaration(fieldName, (PsiMember[])psiClass.getAllMethods(), semService);
        if (psiMethod instanceof PsiMethod) {
            return new Pair((Object)psiMethod, (Object)((PsiMethod)psiMethod).getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMember findFieldDeclaration(String fieldName, PsiMember[] psiMembers, SemService semService) {
        return (PsiMember)ContainerUtil.find((Object[])psiMembers, psiMember -> {
            if (SpringDataMongoDbUtils.isIdFieldName(fieldName) && SpringDataMongoDbUtils.isIdFieldName(psiMember.getName()) || fieldName.equals(psiMember.getName())) {
                return true;
            }
            SpringDataMongoDbDocumentField documentField = (SpringDataMongoDbDocumentField)semService.getSemElement(SpringDataMongoDbDocumentField.SEM_KEY, (PsiElement)psiMember);
            return documentField != null && fieldName.equals(documentField.getName());
        });
    }

    public static Set<PsiClass> getRepositoriesDomainClasses(Project project) {
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            RepositorySearch repositorySearch = RepositorySearch.getInstance((Project)project);
            Set result = repositorySearch.getRepositoriesByParent(GlobalSearchScope.projectScope((Project)project), "org.springframework.data.mongodb.repository.MongoRepository", false).stream().map(arg_0 -> ((RepositorySearch)repositorySearch).getDomainClass(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{SpringModificationTrackersManager.getInstance((Project)project).getOuterModelsModificationTracker()});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 17, 19, 20, 22, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/mongoDB/SpringDataMongoDbUtils";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentName";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uElement";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentClass";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldPath";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/mongoDB/SpringDataMongoDbUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMongoDbDataSources";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDocuments";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMongoDbDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMongoDbDataSources";
                break;
            }
            case 2: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDocument";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findField";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getMongoDbDocumentField";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMongoDbField";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllFields";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAllDocuments";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFieldName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findFieldDeclaration";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isReadonlyProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 17, 19, 20, 22, 24, 25 -> new IllegalStateException(string);
        };
    }
}

