/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.util.DataProviderFactory;
import com.intellij.openapi.graph.impl.builder.BasicPopupMode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.services.GraphGroupingService;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.PopupMode;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphEditModeFactoryImpl
extends GraphEditModeFactory {
    @NotNull
    public <N, E> EditMode createEditMode(final @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.C(0);
        }
        final GraphPresentationModel graphPresentationModel = builder.getGraphPresentationModel();
        return new EditMode(){

            @Nullable
            public String getNodeTip(@Nullable Node node) {
                return (String)builder.getActionExecutor().tryComputeReadAction(null, () -> {
                    Object object = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node));
                    return object == null ? null : graphPresentationModel.getNodeTooltip(object);
                });
            }

            @Nullable
            public String getEdgeTip(@Nullable Edge edge) {
                return (String)builder.getActionExecutor().tryComputeReadAction(null, () -> {
                    Object object = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getEdgeObject(edge));
                    return object == null ? null : graphPresentationModel.getEdgeTooltip(object);
                });
            }

            public void mouseClicked(@NotNull MouseEvent mouseEvent) {
                if (mouseEvent == null) {
                    1.C(0);
                }
                if (mouseEvent.getClickCount() == 2) {
                    if (!(builder instanceof GraphBuilderImpl) || !((GraphBuilderImpl)builder).isUpdating()) {
                        HitInfo hitInfo = this.getHitInfo(mouseEvent);
                        Node node = hitInfo.getHitNode();
                        Edge edge = hitInfo.getHitEdge();
                        if (node != null) {
                            if (GraphGroupingService.getInstance().isGroupOrFolderNode(builder, node)) {
                                builder.getActionExecutor().runGraphActionAsync(() -> {
                                    GraphGroupingService.getInstance().toggleGroup(builder, node, graphPresentationModel.getSettings().isCollapseEdgesOnGrouping());
                                    GraphEditModeFactoryImpl.this.update(builder);
                                });
                            }
                            super.mouseClicked(mouseEvent);
                        } else if (edge != null) {
                            graphPresentationModel.editEdge(builder.getEdgeObject(edge));
                        }
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            public boolean editNode(@Nullable Node node, @Nullable EventObject eventObject) {
                Object object = builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node));
                return graphPresentationModel.editNode(object);
            }

            private static /* synthetic */ void C(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mouseEvent", "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl$1", "mouseClicked"));
            }
        };
    }

    @NotNull
    public <N, E> PopupMode createPopupMode(final @NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.C(1);
        }
        final GraphPresentationModel graphPresentationModel = builder.getGraphPresentationModel();
        return new BasicPopupMode(this, graphPresentationModel){

            @Override
            @NotNull
            protected DefaultActionGroup getNodeActions(@Nullable Node node) {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getNodeActionGroup(builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getNodeObject(node)));
                if (defaultActionGroup == null) {
                    2.C(0);
                }
                return defaultActionGroup;
            }

            @Override
            @NotNull
            protected DefaultActionGroup getEdgeActions(@Nullable Edge edge) {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getEdgeActionGroup(builder.getActionExecutor().suppressComputableReadLockAssertion(() -> builder.getEdgeObject(edge)));
                if (defaultActionGroup == null) {
                    2.C(1);
                }
                return defaultActionGroup;
            }

            @Override
            @NotNull
            protected DefaultActionGroup getPaperPopupActions() {
                DefaultActionGroup defaultActionGroup = graphPresentationModel.getPaperActionGroup();
                if (defaultActionGroup == null) {
                    2.C(2);
                }
                return defaultActionGroup;
            }

            private static /* synthetic */ void C(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNodeActions";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getEdgeActions";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPaperPopupActions";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public <N, E> CellEditorMode createCellEditorMode(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.C(2);
        }
        return new CellEditorMode(this, GraphEditModeFactoryImpl.C(builder), NodeCellRendererPainter.USER_DATA_MAP){};
    }

    protected <N, E> void update(@NotNull GraphBuilder<N, E> builder) {
        if (builder == null) {
            GraphEditModeFactoryImpl.C(3);
        }
        builder.queryGraphUpdate().withDataReload().withRelayout().run();
    }

    @NotNull
    private static <N, E> DataProvider C(final @NotNull GraphBuilder<N, E> graphBuilder) {
        if (graphBuilder == null) {
            GraphEditModeFactoryImpl.C(4);
        }
        return new DataProviderFactory.ProviderAdapter(){

            @Nullable
            public Object get(@Nullable Object dataHolder) {
                return graphBuilder.getGraphPresentationModel().getCustomNodeCellEditor(graphBuilder.getNodeObject((Node)dataHolder));
            }
        };
    }

    private static /* synthetic */ void C(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "builder";
        objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphEditModeFactoryImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditMode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopupMode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCellEditorDataProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

