/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.GrammarRules;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeSupport;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class PluralsInCompounds {
    private static final NodePattern possessiveProhibitingHead = NodePattern.N.lemma("proliferation|enumeration|(de)?nominator|devastation|obesity|pregnancy|mortality|violence|shortage|improvement|development");
    private static final NodePattern gamesConsole = NodePattern.N.inFormSequence(0, "games", "consoles?");
    private static final NodePattern sgRequiringDet = NodePattern.or(AgreementSet.sgRequiringDet, NodePattern.N.form("this|that"));
    private static final NodePattern sgPossessiveOnly = NodePattern.or(NodePattern.N.form("todays|yesterdays|tomorrows"), NodePattern.N.lemma("master|bachelor|associate"));
    private static final NodePattern possessiveProhibitingNonHead = NodePattern.or(gamesConsole, NodePattern.N.inFormSequence(0, "profits", "warnings?"), NodePattern.N.form("humans|rights|computers"));
    private static final NodePattern possibleFiniteVerb = NodePattern.N.potentialPos("VBZ").andNot(EnglishValences.definitelyIntransitive).andOr(NodePattern.N.directlyAfter(NodePattern.N.potentialPos("NN.*").noForm("hide|get|make")), CommonPatterns.firstToken.withHead(NodePattern.ROOT)).andNot(NodePattern.N.form("masters|prompts").withHeadRelation("compound"));

    PluralsInCompounds() {
    }

    static NodePattern pattern() {
        return NodePattern.or(PluralsInCompounds.compoundNounChild(), PluralsInCompounds.compoundAware());
    }

    private static NodePattern compoundNounChild() {
        NodePattern ellipsisPart = NodePattern.N.withHead("conj", NodePattern.N.pos("NN.*").withHeadRelation("xcomp"));
        NodePattern head = NodePattern.or(NodePattern.N.pos("NN.*"), NodePattern.N.withHeadRelation("compound").potentialPos("NN.*")).noPos("IN").noDependents("amod|compound", NodePattern.N.before("Plural")).noDependents("compound|nummod", NodePattern.N.noLemma(".*").after("Plural")).noDependents("amod", NodePattern.N.noPos("JJ").after("Plural").beforeHead()).noDependents("det", NodePattern.N.after("Plural")).andNot(CommonPatterns.capitalizedMiddle.withDependent("conj", CommonPatterns.capitalizedMiddle)).andNot(Semantics.allowedCompoundPluralHead).andNot(EnglishTreePatterns.someAnyEveryNoThing).andNot(EnglishTreePatterns.someAnyEveryNoAnimate).noLabel("LOCATION").andNot(NodePattern.N.withHead("compound|amod", NodePattern.N.pos("NNS")).potentialPos("VBG")).andNot(Number.misparsedVsCompound).andNot(ellipsisPart).markAs("Head");
        NodePattern properName = NodePattern.or(NodePattern.or(CommonPatterns.capitalizedMiddle, CommonPatterns.capitalized.and(Semantics.needsCapitalization)).withHead(NodePattern.not(CommonPatterns.capitalizedMiddle)).noForm("presidents"), CommonPatterns.capitalizedMiddle.directlyBeforeHead().withHead(CommonPatterns.capitalized.pos("NNS|NNP").noForm("digest")), CommonPatterns.upperCase.directlyBefore(NodePattern.not(CommonPatterns.upperCase)), NodePattern.N.inFormSequence(0, "diners", "club"), NodePattern.N.inFormSequence(0, "extensions", "marketplace").and(CommonPatterns.capitalized));
        NodePattern misparsedIObj = NodePattern.N.withHead("obj", EnglishValences.mayHaveTwoObjects.noDependents("iobj"));
        return NodePattern.N.markAs("Plural").andOr(NodePattern.N.pos("NNS").andOr(NodePattern.N.beforeHead().withHead("compound|nmod:poss|nmod:tmod", head.andNot(NodePattern.N.potentialPos("VBG").withDependent(".*", NodePattern.N.afterHead())).andNot(NodePattern.ROOT.potentialPos("VBP").withDependent("nmod|obl").noDependents("det")).andNot(misparsedIObj).noDependents("nmod", NodePattern.N.potentialPos("VB[PZD]").withDependent("case").withDependent("compound")).andNot(NodePattern.N.withHeadRelation("parataxis").andNot(EnglishTreePatterns.clause)).noDependents("appos").andNot(NodePattern.N.withDependent("cc", NodePattern.N.markAs("CC")).withHead("conj", NodePattern.N.directlyBefore("CC").pos("NNS").noDependents("compound", NodePattern.N.withDependent("compound"))).noDependents("advmod|det|nmod:poss")).andNot(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation("i?obj|obl")).and(NodePattern.markedNodeMatches("Plural", NodePattern.N.potentialPos("VBZ")))).noDependents("cc", NodePattern.N.after("Plural"))).noDependents(NodePattern.N.noHeadRelation("conj").afterHead()).noDependents("conj", NodePattern.N.pos("NNS")), NodePattern.N.withHead("nmod:poss|nmod:tmod", NodePattern.N.withHead("amod", head))), NodePattern.N.withHead("nsubj|compound", head.withHead("xcomp|ccomp", NodePattern.N.directlyBefore("Plural"))).directlyBeforeHead(), NodePattern.N.withHeadRelation("obj").directlyBefore(head.withHeadRelation("obj").afterHead()).andNot(NodePattern.N.inPhrase(misparsedIObj)), NodePattern.N.withHeadRelation("iobj").withDependent("det", NodePattern.N.directlyBeforeHead()).directlyBefore(head.withHeadRelation("obj").noDependents().afterHead()), NodePattern.ROOT.withDependent("flat", NodePattern.N.directlyAfterHead().and(head)).noPotentialPos("VBZ"), NodePattern.N.potentialPos("NNS").andNot(EnglishTreePatterns.unlikelyToBeNoun).withHead("compound", NodePattern.ROOT.and(head).noLabel(".*").noDependents(NodePattern.N.afterHead())), CommonPatterns.nerPerson.withHead("nmod:poss", head)).noPos("NN|PRP.*").noLabel("LAW").noLemma("master|bachelor|associate").andNot(possibleFiniteVerb).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("[/'\u2019`\u2018]"), NodePattern.N.withHeadRelation("punct|case")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("_").noSpaceAfter())).andNot(Semantics.allowedCompoundPluralNonHead).andNot(Semantics.potentiallyNamedCompoundPlural.noForm("prompts")).noForm("ones").andNot(NodePattern.N.inFormSequence(0, "properties", "files?")).andNot(NodePattern.N.inFormSequence(0, "awards", "seasons?")).andNot(NodePattern.N.inFormSequence(0, "honou?rs", "program(me)?s?")).andNot(NodePattern.N.inFormSequence(0, "solutions", "engineers?")).andNot(NodePattern.N.inFormSequence(0, "champions", "league")).andNot(NodePattern.N.inFormSequence(0, "bees", "algorithm")).andNot(NodePattern.N.inFormSequence(0, "works", "council")).andNot(NodePattern.N.inFormSequence(1, "find", "usages")).andNot(NodePattern.N.inFormSequence(2, "call", "for", "papers|talks|submissions|proposals")).andNot(gamesConsole.andNot(EnglishParameters.VARIANT.withValue("US|CA"))).noDependents(NodePattern.N.beforeHead().noHeadRelation("det").andNot(NodePattern.N.withHeadRelation("advmod").directlyBefore(NodePattern.N.withHeadRelation("det")))).andNot(NodePattern.N.form("degrees").withHead(CommonPatterns.capitalized)).andNot(NodePattern.N.form("roles").withHead(NodePattern.N.lemma("matrix"))).andNot(NodePattern.N.form("workflows").withHead(NodePattern.N.form("community"))).andNot(NodePattern.N.form("rights").withHead(NodePattern.N.form("movement|activist|activism"))).andNot(NodePattern.N.inFormSequence(0, ".+wards", "conflation")).noDependents("conj", NodePattern.or(NodePattern.N.noPos("NNS"), NodePattern.N.sameWordAs("Plural"))).andNot(EnglishTreePatterns.inShortCapitalizedSentence).andNot(NodePattern.markedNodeMatches("Head", EnglishTreePatterns.argumentParsedAsAdvcl)).reportEverythingTouched().andOr(CommonPatterns.capitalized.and(GrammarRules.endsWithS).noDependents(".*", NodePattern.N.afterHead()).withHead("nmod:poss|compound", NodePattern.N.noPos("NNP")).and(Semantics.Animacy.humanLike.pattern).and(GrammarRules.removePluralInProperName).and(NodePattern.custom((node, match) -> match.withMessage("'" + node.form().substring(0, node.form().length() - 1) + "' should probably be possessive in a compound noun"))).andOptionally(NodePattern.N.withHead(NodePattern.N.pos("NNS")).correct(NodeCorrector.insertAfter("\u2019"))), NodePattern.N.potentialPos("NNS").noPos("NNP").andNot(properName).and((node, match) -> {
            String singular = PluralsInCompounds.toRegularSingular(node);
            if (singular == null) {
                return null;
            }
            Node det = node.findSingleDependent("det");
            if (det == null) {
                det = ((StreamEx)node.hierarchy().takeWhile(n -> n.hasHeadRelation("compound"))).map(n -> Objects.requireNonNull(n.head()).findSingleDependent("det")).findFirst(Objects::nonNull).orElse(null);
            }
            if (!PluralsInCompounds.isRegularPlural(singular, node.lowForm())) {
                return null;
            }
            Node compoundHead = match.getMarkedNode("Head");
            if (compoundHead.hasForm("number")) {
                String article = compoundHead.hasDependent("det") ? "" : "the ";
                match = match.withCorrector(NodeCorrector.removeNode(compoundHead).join(NodeCorrector.insertBefore(node.phraseStart(), article + "number of ")));
            }
            boolean suggestPossessive = !possessiveProhibitingNonHead.matches(node) && !possessiveProhibitingHead.matches(compoundHead);
            boolean suggestSingular = !suggestPossessive || singular.equalsIgnoreCase("other") || Semantics.animacy(node) != Semantics.Animacy.humanLike;
            String form = node.form();
            if (suggestSingular && !sgPossessiveOnly.matches(node)) {
                match = match.withCorrector(NodeCorrector.replace(node, TreeSupport.preserveCase(form, singular, node.language())));
            }
            if (suggestPossessive) {
                if ((det == null || suggestSingular && !sgRequiringDet.matches(det)) && !sgPossessiveOnly.matches(node)) {
                    match = match.withCorrector(NodeCorrector.replace(node, form + "\u2019"));
                }
                match = match.withCorrector(NodeCorrector.replace(node, TreeSupport.preserveCase(form, singular + "\u2019s", node.language())));
            }
            String expectedForm = suggestSingular && suggestPossessive ? "singular or possessive" : (suggestSingular ? "singular" : "possessive");
            return match.withMessage("'" + singular + "' should probably be " + expectedForm + " in a compound noun").concedingToOtherGrammarCheckers();
        }));
    }

    private static NodePattern compoundAware() {
        NodePattern plural = NodePattern.N.pos("NNS").markAs("Plural").noPos("NNP?").noLabel("LAW").andNot(possibleFiniteVerb).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("/"))).andNot(Semantics.allowedCompoundPluralNonHead).and((node, match) -> {
            String singular = PluralsInCompounds.toRegularSingular(node);
            if (singular == null) {
                return null;
            }
            Node next = Objects.requireNonNull(node.nextNode());
            NodeCorrector corrector = NodeCorrector.replace(node, singular);
            if (!next.hasForm("-")) {
                corrector = corrector.join(NodeCorrector.rawReplace(new TextRange(node.endOffset(), next.startOffset()), "-"));
            }
            return match.withCorrector(corrector).withMessage("'" + singular + "' should probably be singular in a compound noun");
        });
        return NodePattern.N.form("aware").and(CommonPatterns.afterSkipping(CommonPatterns.noSpaceHyphen, plural)).noHeadRelation("xcomp").noDependents("obl");
    }

    private static boolean isRegularPlural(String singular, String lowForm) {
        return lowForm.equals(singular + "s") || singular.endsWith("x") && lowForm.equals(singular + "es") || singular.endsWith("y") && lowForm.equals(singular.substring(0, singular.length() - 1) + "ies");
    }

    @Nullable
    static String toRegularSingular(Node node) {
        List<String> sg = node.tree().treeSupport().inflectNode(node, "NNS", "NN");
        return sg.isEmpty() || !PluralsInCompounds.isRegularPlural(sg.get(0), node.lowForm()) ? null : sg.get(0);
    }
}

