/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.syntax.element.SyntaxElementTypes;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.java.syntax.parser.JavaParserUtil;
import com.intellij.java.syntax.parser.StatementParser;
import com.intellij.javaee.el.ELSyntaxElementType;
import com.intellij.jsp.psi.BaseJspSyntaxElementType;
import com.intellij.jsp.psi.JspSyntaxTokenType;
import com.intellij.jsp.util.JspSyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementTypeSet;
import com.intellij.platform.syntax.SyntaxElementTypeSetKt;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.psi.util.SyntaxElementUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.syntax.XmlSyntaxTokenType;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspJavaParser {
    private static final SyntaxElementTypeSet TEMPLATE_DATA = SyntaxElementTypeSetKt.syntaxElementTypeSetOf((SyntaxElementType[])new SyntaxElementType[]{BaseJspSyntaxElementType.JSP_DIRECTIVE, ELSyntaxElementType.EL_HOLDER, JspSyntaxTokenType.JSP_TEMPLATE_DATA, JspSyntaxTokenType.JSP_COMMENT, XmlSyntaxTokenType.XML_TAG_NAME, XmlSyntaxTokenType.XML_NAME, XmlSyntaxTokenType.XML_END_TAG_START, XmlSyntaxTokenType.XML_EQ, XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlSyntaxTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlSyntaxTokenType.XML_TAG_END, XmlSyntaxTokenType.XML_EMPTY_ELEMENT_END});
    private static final SyntaxElementTypeSet TEMPLATE_TOKEN = SyntaxElementTypeSetKt.syntaxElementTypeSetOf((SyntaxElementType[])new SyntaxElementType[]{JspSyntaxTokenType.JSPX_ROOT_TAG_HEADER, JspSyntaxTokenType.JSPX_ROOT_TAG_FOOTER, JspSyntaxTokenType.JSP_SCRIPTLET_START, JspSyntaxTokenType.JSP_SCRIPTLET_END});
    private static final SyntaxElementTypeSet JSP_TOKENS = SyntaxElementTypeSetKt.asSyntaxElementTypeSet((Collection)ContainerUtil.concat((List[])new List[]{SyntaxElementUtil.getTokensInClass(JspSyntaxTokenType.class, (String[])new String[0]), SyntaxElementUtil.getTokensInClass(XmlSyntaxTokenType.class, (String[])new String[]{"COMMENTS", "WHITESPACES", "INSTANCE"}), SyntaxElementUtil.getTokensInClass(BaseJspSyntaxElementType.class, (String[])new String[0])}));
    private final JavaParser myJspJavaParser;
    private final JavaParser myJavaParser;
    private boolean isTerminated;

    public JspJavaParser(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            JspJavaParser.$$$reportNull$$$0(0);
        }
        this.isTerminated = false;
        this.myJspJavaParser = new MyJavaParser(languageLevel);
        this.myJavaParser = new JavaParser(this, languageLevel){
            private final StatementParser myStatementParser = new StatementParser((JavaParser)this, true);

            @NotNull
            public StatementParser getStatementParser() {
                StatementParser statementParser = this.myStatementParser;
                if (statementParser == null) {
                    1.$$$reportNull$$$0(0);
                }
                return statementParser;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsp/JspJavaParser$1", "getStatementParser"));
            }
        };
    }

    public void parse(SyntaxTreeBuilder builder) {
        builder.enforceCommentTokens(SyntaxElementTypes.INSTANCE.getJAVA_COMMENT_BIT_SET());
        builder.mark().done(JspSyntaxElementType.JSP_IMPORT_LIST_WRAPPER);
        this.parseJspClass(builder);
    }

    private void parseJspClass(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker jspClass = builder.mark();
        SyntaxTreeBuilder.Marker jspMethod = builder.mark();
        SyntaxTreeBuilder.Marker block = builder.mark();
        this.parseJspCodeBlock(builder);
        if (!builder.eof()) {
            builder.mark().error(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]));
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        block.done(JspSyntaxElementType.JSP_CODE_BLOCK);
        jspMethod.done(JspSyntaxElementType.HOLDER_METHOD);
        jspClass.done(JspSyntaxElementType.JSP_CLASS);
    }

    private void parseJspCodeBlock(SyntaxTreeBuilder builder) {
        while (this.myJspJavaParser.getStatementParser().parseStatement(builder) != null) {
        }
    }

    @NotNull
    private SyntaxTreeBuilder.Marker parseTemplateDataStatement(SyntaxTreeBuilder builder, boolean single) {
        SyntaxTreeBuilder.Marker templateStatement = builder.mark();
        if (single) {
            builder.remapCurrentToken(JspSyntaxElementType.JSP_TEMPLATE_DATA_WRAPPER);
            builder.advanceLexer();
        } else {
            SyntaxTreeBuilder.Marker templateData = builder.mark();
            SyntaxElementType lastToken = null;
            boolean endTagPassed = false;
            while (TEMPLATE_DATA.containsNullable(builder.getTokenType())) {
                lastToken = builder.getTokenType();
                if (lastToken == XmlSyntaxTokenType.XML_END_TAG_START) {
                    endTagPassed = true;
                }
                builder.advanceLexer();
                if (lastToken != XmlSyntaxTokenType.XML_TAG_END && lastToken != XmlSyntaxTokenType.XML_EMPTY_ELEMENT_END) continue;
            }
            templateData.collapse(JspSyntaxElementType.JSP_TEMPLATE_DATA_WRAPPER);
            this.setTerminated(endTagPassed && lastToken == XmlSyntaxTokenType.XML_TAG_END || lastToken == XmlSyntaxTokenType.XML_EMPTY_ELEMENT_END);
        }
        templateStatement.done(JspSyntaxElementType.JSP_TEMPLATE_STATEMENT);
        SyntaxTreeBuilder.Marker marker = templateStatement;
        if (marker == null) {
            JspJavaParser.$$$reportNull$$$0(1);
        }
        return marker;
    }

    @NotNull
    private SyntaxTreeBuilder.Marker parseJspClassLevelDeclarationStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        JspJavaParser.wrap(builder, JspSyntaxElementType.JSP_DECLARATION_START_WRAPPER);
        SyntaxTreeBuilder builderWrapper = JavaParserUtil.stoppingBuilder((SyntaxTreeBuilder)builder, (token, text) -> JspJavaParser.isJspToken(token));
        this.myJavaParser.getDeclarationParser().parseClassBodyDeclarations(builderWrapper, false);
        JspJavaParser.extraTokens(builder);
        if (builder.getTokenType() == JspSyntaxTokenType.JSP_DECLARATION_END) {
            JspJavaParser.wrap(builder, JspSyntaxElementType.JSP_DECLARATION_END_WRAPPER);
        }
        statement.done(JspSyntaxElementType.JSP_CLASS_LEVEL_DECLARATION_STATEMENT);
        SyntaxTreeBuilder.Marker marker = statement;
        if (marker == null) {
            JspJavaParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    @NotNull
    private SyntaxTreeBuilder.Marker parseJspExpressionStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        JspJavaParser.wrap(builder, JspSyntaxElementType.JSP_EXPRESSION_START_WRAPPER);
        SyntaxTreeBuilder.Marker call = builder.mark();
        SyntaxTreeBuilder.Marker exprList = builder.mark();
        if (this.myJavaParser.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error((SyntaxTreeBuilder)builder, (String)JavaErrorBundle.message((String)"expression.expected", (Object[])new Object[0]));
        }
        JspJavaParser.extraTokens(builder);
        exprList.done(JspSyntaxElementType.JSP_EXPRESSION_LIST);
        call.done(JspSyntaxElementType.JSP_METHOD_CALL);
        if (builder.getTokenType() == JspSyntaxTokenType.JSP_EXPRESSION_END) {
            JspJavaParser.wrap(builder, JspSyntaxElementType.JSP_EXPRESSION_END_WRAPPER);
        }
        statement.done(JspSyntaxElementType.JSP_EXPRESSION_STATEMENT);
        SyntaxTreeBuilder.Marker marker = statement;
        if (marker == null) {
            JspJavaParser.$$$reportNull$$$0(3);
        }
        return marker;
    }

    @NotNull
    private SyntaxTreeBuilder.Marker parseJspAction(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker whileStatement = builder.mark();
        SyntaxTreeBuilder.Marker blockStatement = builder.mark();
        SyntaxTreeBuilder.Marker block = builder.mark();
        if (this.skipTagDetails(builder)) {
            this.parseJspCodeBlock(builder);
            this.setTerminated(false);
        }
        block.done(JspSyntaxElementType.JSP_CODE_BLOCK);
        blockStatement.done(JspSyntaxElementType.JSP_BLOCK_STATEMENT);
        whileStatement.done(JspSyntaxElementType.JSP_WHILE_STATEMENT);
        SyntaxTreeBuilder.Marker marker = whileStatement;
        if (marker == null) {
            JspJavaParser.$$$reportNull$$$0(4);
        }
        return marker;
    }

    private boolean skipTagDetails(SyntaxTreeBuilder builder) {
        SyntaxElementType tt;
        SyntaxTreeBuilder.Marker marker = builder.mark();
        boolean advanced = false;
        while (true) {
            if ((tt = builder.getTokenType()) == JspSyntaxTokenType.JSP_EXPRESSION_START) {
                if (advanced) {
                    marker.collapse(JspSyntaxElementType.JSP_TEMPLATE_DATA_WRAPPER);
                    marker.precede().done(JspSyntaxElementType.JSP_TEMPLATE_STATEMENT);
                } else {
                    marker.drop();
                }
                this.parseJspExpressionStatement(builder);
                marker = builder.mark();
                advanced = false;
                continue;
            }
            builder.advanceLexer();
            advanced = true;
            if (tt == XmlSyntaxTokenType.XML_TAG_END || tt == XmlSyntaxTokenType.XML_EMPTY_ELEMENT_END || tt == null) break;
        }
        marker.collapse(JspSyntaxElementType.JSP_TEMPLATE_DATA_WRAPPER);
        marker.precede().done(JspSyntaxElementType.JSP_TEMPLATE_STATEMENT);
        return tt == XmlSyntaxTokenType.XML_TAG_END;
    }

    private static void wrap(SyntaxTreeBuilder builder, SyntaxElementType token) {
        SyntaxTreeBuilder.Marker expr = builder.mark();
        builder.remapCurrentToken(token);
        builder.advanceLexer();
        expr.done(JspSyntaxElementType.JSP_TEMPLATE_EXPRESSION);
    }

    private static void extraTokens(SyntaxTreeBuilder builder) {
        SyntaxElementType tt;
        SyntaxTreeBuilder.Marker error = null;
        while ((tt = builder.getTokenType()) != null && !JspJavaParser.isJspToken(tt)) {
            if (error == null) {
                error = builder.mark();
            }
            builder.advanceLexer();
        }
        if (error != null) {
            error.error(JavaPsiBundle.message((String)"unexpected.token", (Object[])new Object[0]));
        }
    }

    private static boolean isJspToken(@Nullable SyntaxElementType token) {
        return JSP_TOKENS.containsNullable(token);
    }

    private boolean isTerminated() {
        return this.isTerminated;
    }

    private void setTerminated(boolean value) {
        this.isTerminated = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/JspJavaParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/JspJavaParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTemplateDataStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJspClassLevelDeclarationStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJspExpressionStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseJspAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private class MyJavaParser
    extends JavaParser {
        private final StatementParser myStatementParser;

        MyJavaParser(LanguageLevel languageLevel) {
            if (languageLevel == null) {
                MyJavaParser.$$$reportNull$$$0(0);
            }
            super(languageLevel);
            this.myStatementParser = new StatementParser(this, true){

                public SyntaxTreeBuilder.Marker parseStatement(@NotNull SyntaxTreeBuilder builder) {
                    if (builder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!JspJavaParser.this.isTerminated()) {
                        SyntaxElementType tt = builder.getTokenType();
                        if (TEMPLATE_DATA.containsNullable(tt)) {
                            return JspJavaParser.this.parseTemplateDataStatement(builder, false);
                        }
                        if (TEMPLATE_TOKEN.containsNullable(tt)) {
                            return JspJavaParser.this.parseTemplateDataStatement(builder, true);
                        }
                        if (tt == JspSyntaxTokenType.JSP_DECLARATION_START) {
                            return JspJavaParser.this.parseJspClassLevelDeclarationStatement(builder);
                        }
                        if (tt == JspSyntaxTokenType.JSP_EXPRESSION_START) {
                            return JspJavaParser.this.parseJspExpressionStatement(builder);
                        }
                        if (tt == XmlSyntaxTokenType.XML_START_TAG_START) {
                            return JspJavaParser.this.parseJspAction(builder);
                        }
                    }
                    return super.parseStatement(builder);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/jsp/JspJavaParser$MyJavaParser$1", "parseStatement"));
                }
            };
        }

        @NotNull
        public StatementParser getStatementParser() {
            StatementParser statementParser = this.myStatementParser;
            if (statementParser == null) {
                MyJavaParser.$$$reportNull$$$0(1);
            }
            return statementParser;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/JspJavaParser$MyJavaParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/JspJavaParser$MyJavaParser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStatementParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

