/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.llmInstaller.InstallJunieActionManagerExt;
import com.intellij.llmInstaller.InstallJunieHubActionManagerKt;
import com.intellij.llmInstaller.InstallJunieHubActionManagerState;
import com.intellij.llmInstaller.InstallJunieHubActionManagerStateManager;
import com.intellij.llmInstaller.ui.promo2.AudienceKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@State(name="InstallJunieHubActionManager", storages={@Storage(value="InstallJunieHubActionManager.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\u0006\u0010\u001f\u001a\u00020\u0019J\u0006\u0010 \u001a\u00020\u0019J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/llmInstaller/InstallJunieHubActionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "appState", "Lcom/intellij/llmInstaller/InstallJunieHubActionManagerStateManager;", "getAppState", "()Lcom/intellij/llmInstaller/InstallJunieHubActionManagerStateManager;", "ourState", "Lcom/intellij/llmInstaller/InstallJunieHubActionManagerState;", "getOurState", "()Lcom/intellij/llmInstaller/InstallJunieHubActionManagerState;", "shouldShowBadge", "Lkotlinx/coroutines/flow/StateFlow;", "", "getShouldShowBadge", "()Lkotlinx/coroutines/flow/StateFlow;", "shouldShowNewLabel", "getShouldShowNewLabel", "isActionVisible", "startStateCalculation", "", "wasBadgeShown", "recalculateState", "isActionAllowed", "isActionAllowedExt", "startInstallation", "onHubOpen", "onHubClose", "isJunieInstalled", "isJunieBeingInstalled", "Companion", "intellij.llmInstaller"})
@SourceDebugExtension(value={"SMAP\nInstallJunieHubActionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallJunieHubActionManager.kt\ncom/intellij/llmInstaller/InstallJunieHubActionManager\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,267:1\n42#2,3:268\n*S KotlinDebug\n*F\n+ 1 InstallJunieHubActionManager.kt\ncom/intellij/llmInstaller/InstallJunieHubActionManager\n*L\n110#1:268,3\n*E\n"})
public final class InstallJunieHubActionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final StateFlow<Boolean> shouldShowBadge;
    @NotNull
    private final StateFlow<Boolean> shouldShowNewLabel;
    @NotNull
    private final StateFlow<Boolean> isActionVisible;
    private boolean wasBadgeShown;

    public InstallJunieHubActionManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.shouldShowBadge = FlowKt.asStateFlow(this.getAppState().getMutableShouldShowBadge$intellij_llmInstaller());
        this.shouldShowNewLabel = FlowKt.asStateFlow(this.getAppState().getMutableShouldShowNewLabel$intellij_llmInstaller());
        this.isActionVisible = FlowKt.asStateFlow(this.getAppState().getMutableIsActionVisible$intellij_llmInstaller());
        this.startStateCalculation();
    }

    private final InstallJunieHubActionManagerStateManager getAppState() {
        boolean $i$f$service = false;
        Class<InstallJunieHubActionManagerStateManager> serviceClass$iv = InstallJunieHubActionManagerStateManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (InstallJunieHubActionManagerStateManager)object;
    }

    private final InstallJunieHubActionManagerState getOurState() {
        return this.getAppState().getOurState();
    }

    @NotNull
    public final StateFlow<Boolean> getShouldShowBadge() {
        return this.shouldShowBadge;
    }

    @NotNull
    public final StateFlow<Boolean> getShouldShowNewLabel() {
        return this.shouldShowNewLabel;
    }

    @NotNull
    public final StateFlow<Boolean> isActionVisible() {
        return this.isActionVisible;
    }

    private final void startStateCalculation() {
        if (this.getOurState().getSkipForeverVersion() < 1) {
            InstallJunieHubActionManagerKt.access$getLog$p().info("Skipping state calculation, version " + this.getOurState().getSkipForeverVersion());
            return;
        }
        if (this.isJunieInstalled() || !AudienceKt.isJunieAvailable()) {
            InstallJunieHubActionManagerKt.access$getLog$p().info("Junie is already installed or not available");
            this.getOurState().setWasBadgeRead(true);
            this.getOurState().setSkipForeverVersion(1);
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ InstallJunieHubActionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Flow[] flowArray = new Flow[2];
                        flowArray[0] = InstallJunieHubActionManagerKt.access$tickerFlow-LRDsOJo(DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS));
                        flowArray[1] = InstallJunieHubActionManager.access$getOurState(this.this$0).getStateUpdated$intellij_llmInstaller();
                        this.label = 1;
                        Object object2 = FlowKt.collect((Flow)FlowKt.onEach((Flow)FlowKt.merge((Flow[])flowArray), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ InstallJunieHubActionManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        InstallJunieHubActionManager.access$recalculateState(this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        })), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void recalculateState() {
        boolean isAllowed = this.isActionAllowed();
        if (isAllowed && !this.getOurState().getWasBadgeRead() && !this.wasBadgeShown) {
            InstallJunieHubActionManagerKt.access$getLog$p().info("Will show badge for Junie installation");
            this.getAppState().getMutableShouldShowBadge$intellij_llmInstaller().setValue((Object)true);
            this.getAppState().getMutableShouldShowNewLabel$intellij_llmInstaller().setValue((Object)true);
            this.wasBadgeShown = true;
        }
        this.getAppState().getMutableIsActionVisible$intellij_llmInstaller().setValue((Object)isAllowed);
    }

    private final boolean isActionAllowed() {
        return AudienceKt.isJunieAvailable() && !this.isJunieBeingInstalled() && !this.isJunieInstalled() && this.isActionAllowedExt();
    }

    private final boolean isActionAllowedExt() {
        InstallJunieActionManagerExt installJunieActionManagerExt = InstallJunieActionManagerExt.Companion.getExtension();
        return installJunieActionManagerExt != null ? installJunieActionManagerExt.isAllowed(this.project) : true;
    }

    public final void startInstallation() {
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ InstallJunieHubActionManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        InstallJunieHubActionManager.access$getOurState(this.this$0).setInstallationInProgress(true);
                        this.label = 1;
                        v0 = InstallJunieHubActionManagerKt.access$installJunieAdvanced(InstallJunieHubActionManager.access$getProject$p(this.this$0), (Continuation)this);
                        ** if (v0 != var3_2) goto lbl12
lbl11:
                        // 1 sources

                        return var3_2;
lbl12:
                        // 1 sources

                        ** GOTO lbl18
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            ((Boolean)v0).booleanValue();
                        }
                        catch (Throwable var2_3) {
                            throw var2_3;
                        }
                        finally {
                            InstallJunieHubActionManager.access$getOurState(this.this$0).setInstallationInProgress(false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void onHubOpen() {
        if (this.isActionAllowed()) {
            this.getAppState().getMutableShouldShowBadge$intellij_llmInstaller().setValue((Object)false);
            this.getOurState().setWasBadgeRead(true);
        }
    }

    public final void onHubClose() {
        if (this.isActionAllowed()) {
            this.getAppState().getMutableShouldShowNewLabel$intellij_llmInstaller().setValue((Object)false);
        }
    }

    private final boolean isJunieInstalled() {
        return PluginManager.isPluginInstalled((PluginId)PluginId.Companion.getId("org.jetbrains.junie"));
    }

    private final boolean isJunieBeingInstalled() {
        return this.getOurState().isInstallationInProgress();
    }

    public static final /* synthetic */ InstallJunieHubActionManagerState access$getOurState(InstallJunieHubActionManager $this) {
        return $this.getOurState();
    }

    public static final /* synthetic */ void access$recalculateState(InstallJunieHubActionManager $this) {
        $this.recalculateState();
    }

    public static final /* synthetic */ Project access$getProject$p(InstallJunieHubActionManager $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/llmInstaller/InstallJunieHubActionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/llmInstaller/InstallJunieHubActionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.llmInstaller"})
    @SourceDebugExtension(value={"SMAP\nInstallJunieHubActionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallJunieHubActionManager.kt\ncom/intellij/llmInstaller/InstallJunieHubActionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,267:1\n30#2,2:268\n*S KotlinDebug\n*F\n+ 1 InstallJunieHubActionManager.kt\ncom/intellij/llmInstaller/InstallJunieHubActionManager$Companion\n*L\n107#1:268,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InstallJunieHubActionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<InstallJunieHubActionManager> serviceClass$iv = InstallJunieHubActionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InstallJunieHubActionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

