/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.inline.tracking;

import com.intellij.ml.inline.completion.impl.inline.tracking.MLCompletionUsageTracker;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionAcceptedFirstUserActionListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "tracker", "Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker;)V", "lastInsertedRange", "Lcom/intellij/openapi/util/TextRange;", "recordAcceptedSuggestion", "", "insertedRange", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Companion", "intellij.fullLine.core.completion"})
@ApiStatus.Internal
public final class MLCompletionAcceptedFirstUserActionListener
implements DocumentListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MLCompletionUsageTracker tracker;
    @Nullable
    private TextRange lastInsertedRange;
    @NotNull
    private static final Key<MLCompletionAcceptedFirstUserActionListener> KEY;

    public MLCompletionAcceptedFirstUserActionListener(@NotNull MLCompletionUsageTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.tracker = tracker;
    }

    @RequiresEdt
    public final void recordAcceptedSuggestion(@NotNull TextRange insertedRange) {
        Intrinsics.checkNotNullParameter((Object)insertedRange, (String)"insertedRange");
        ThreadingAssertions.assertEventDispatchThread();
        this.lastInsertedRange = insertedRange;
    }

    @RequiresEdt
    public void documentChanged(@NotNull DocumentEvent event) {
        boolean isSuggestionTrimmedFromEnd;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingAssertions.assertEventDispatchThread();
        TextRange textRange = this.lastInsertedRange;
        if (textRange == null) {
            return;
        }
        TextRange range = textRange;
        boolean isDeletion = event.getNewLength() - event.getOldLength() < 0;
        int changeStart = event.getOffset();
        int changeEnd = changeStart + event.getOldLength();
        boolean bl = isSuggestionTrimmedFromEnd = isDeletion && range.getStartOffset() <= changeStart && changeEnd == range.getEndOffset();
        if (isSuggestionTrimmedFromEnd) {
            this.tracker.onSuggestionImmediatelyTrimmedFromEnd();
        } else {
            this.tracker.onSuggestionImmediatelyUntouched();
        }
        this.lastInsertedRange = null;
    }

    static {
        Key key = Key.create((String)"ml.completion.accepted.first.user.action.listener");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionAcceptedFirstUserActionListener$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionAcceptedFirstUserActionListener;", "getOrCreate", "document", "Lcom/intellij/openapi/editor/Document;", "tracker", "Lcom/intellij/ml/inline/completion/impl/inline/tracking/MLCompletionUsageTracker;", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final MLCompletionAcceptedFirstUserActionListener getOrCreate(@NotNull Document document, @NotNull MLCompletionUsageTracker tracker) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            ThreadingAssertions.assertEventDispatchThread();
            MLCompletionAcceptedFirstUserActionListener existing = (MLCompletionAcceptedFirstUserActionListener)document.getUserData(KEY);
            if (existing != null) {
                return existing;
            }
            MLCompletionAcceptedFirstUserActionListener listener2 = new MLCompletionAcceptedFirstUserActionListener(tracker);
            document.addDocumentListener((DocumentListener)listener2);
            document.putUserData(KEY, (Object)listener2);
            return listener2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

