/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/completion/validation/NetworkDisruptionValidator;", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "<init>", "()V", "validate", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/terminal/completion/validation/RiskCategory;", "", "command", "Lcom/intellij/ml/llm/terminal/completion/ParsedCommand;", "intellij.ml.llm.terminal.completion"})
public final class NetworkDisruptionValidator
implements Validator {
    @Override
    @Nullable
    public Pair<RiskCategory, String> validate(@NotNull ParsedCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        switch (command.getBaseCommand()) {
            case "iptables": 
            case "ip6tables": {
                if (command.getArgs().contains("-F") || command.getArgs().contains("--flush")) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"flushing all firewall rules");
                }
                if (command.getArgs().contains("-P") && command.getArgs().contains("DROP")) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"setting default DROP policy");
                }
                if (!command.getArgs().contains("-X")) break;
                return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"deleting iptables chains");
            }
            case "ufw": {
                if (!command.getArgs().contains("disable") && (!command.getArgs().contains("default") || !command.getArgs().contains("reject"))) break;
                return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"disabling firewall");
            }
            case "tc": {
                if (!command.getArgs().contains("qdisc") || !command.getArgs().contains("del") || !command.getArgs().contains("root")) break;
                return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"removing root traffic control");
            }
        }
        return null;
    }
}

