/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringFeatures;
import com.intellij.spring.SpringLibraryUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J(\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spring/model/actions/generate/LiveTemplateGenerateAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "group", "", "templateName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getTemplateName", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "findTemplate", "Lcom/intellij/codeInsight/template/impl/TemplateImpl;", "isAccepted", "", "template", "context", "Lcom/intellij/codeInsight/template/TemplateActionContext;", "contextTypes", "", "Lcom/intellij/codeInsight/template/TemplateContextType;", "intellij.spring.core"})
public abstract class LiveTemplateGenerateAction
extends AnAction {
    @NotNull
    private final String group;
    @NotNull
    private final String templateName;

    public LiveTemplateGenerateAction(@NotNull String group, @NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        this.group = group;
        this.templateName = templateName;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getTemplateName() {
        return this.templateName;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!SpringFeatures.GenerateSpringComponentAction.INSTANCE.isAvailable()) {
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (DumbService.Companion.isDumb(project2)) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiFile2));
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!SpringLibraryUtil.hasSpringLibrary((Module)module2)) {
            return;
        }
        TemplateActionContext templateActionContext = TemplateActionContext.expanding((PsiFile)psiFile2, (Editor)editor2);
        Intrinsics.checkNotNullExpressionValue((Object)templateActionContext, (String)"expanding(...)");
        TemplateActionContext context = templateActionContext;
        Presentation presentation = e.getPresentation();
        TemplateImpl templateImpl = this.findTemplate();
        Set set = TemplateManagerImpl.getApplicableContextTypes((TemplateActionContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getApplicableContextTypes(...)");
        presentation.setEnabledAndVisible(this.isAccepted(templateImpl, context, set));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dataContext2 = dataContext;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext2);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext2);
        if (psiFile == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        TemplateImpl templateImpl = this.findTemplate();
        if (templateImpl == null) {
            return;
        }
        TemplateImpl template = templateImpl;
        TemplateManager templateManager = TemplateManager.getInstance((Project)project2);
        ApplicationManager.getApplication().invokeLater(() -> LiveTemplateGenerateAction.actionPerformed$lambda$0(project2, psiFile2, e, templateManager, editor2, template));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final TemplateImpl findTemplate() {
        return TemplateSettings.getInstance().getTemplate(this.templateName, this.group);
    }

    private final boolean isAccepted(TemplateImpl template, TemplateActionContext context, Set<? extends TemplateContextType> contextTypes) {
        return template != null && !template.isDeactivated() && (!context.isSurrounding() || template.isSelectionTemplate()) && TemplateManagerImpl.isApplicable((TemplateImpl)template, contextTypes);
    }

    private static final void actionPerformed$lambda$0(Project $project, PsiFile $psiFile, AnActionEvent $e, TemplateManager $templateManager, Editor $editor, TemplateImpl $template) {
        PsiFile[] psiFileArray = new PsiFile[]{$psiFile};
        WriteCommandAction.writeCommandAction((Project)$project, (PsiFile[])psiFileArray).withName($e.getPresentation().getText()).run(() -> LiveTemplateGenerateAction.actionPerformed$lambda$0$0($templateManager, $editor, $template));
    }

    private static final void actionPerformed$lambda$0$0(TemplateManager $templateManager, Editor $editor, TemplateImpl $template) {
        $templateManager.startTemplate($editor, (Template)$template);
    }
}

