/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.ChartPointingObject;
import com.intellij.kubernetes.helm.model.ChartPomTarget;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010'\u001a\u0004\u0018\u00010\u00002\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR!\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010 \u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000fR\u0014\u0010!\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\fR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/intellij/kubernetes/helm/model/ChartObject;", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "Lcom/intellij/kubernetes/helm/model/ChartPointingObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "<init>", "(Lcom/intellij/kubernetes/helm/chart/Chart;)V", "getChart", "()Lcom/intellij/kubernetes/helm/chart/Chart;", "name", "", "getName", "()Ljava/lang/String;", "isFunction", "", "()Z", "isDeprecated", "isOverridable", "isRequired", "mustHaveValueDefinition", "getMustHaveValueDefinition", "project", "Lcom/intellij/openapi/project/Project;", "declarationElements", "", "Lcom/intellij/psi/PsiElement;", "getDeclarationElements", "()Ljava/util/Collection;", "secondaryElements", "getSecondaryElements", "secondaryElements$delegate", "Lkotlin/Lazy;", "isRenameable", "description", "getDescription", "names", "", "getNames", "()Ljava/util/Set;", "findChildObject", "findChartNameKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nChartObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartObject.kt\ncom/intellij/kubernetes/helm/model/ChartObject\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n1#2:74\n295#3,2:62\n1617#3,9:64\n1869#3:73\n1870#3:75\n1626#3:76\n*S KotlinDebug\n*F\n+ 1 ChartObject.kt\ncom/intellij/kubernetes/helm/model/ChartObject\n*L\n36#1:74\n55#1:62,2\n36#1:64,9\n36#1:73\n36#1:75\n36#1:76\n*E\n"})
public final class ChartObject
implements HelmObject,
ChartPointingObject {
    @NotNull
    private final Chart chart;
    private final boolean isFunction;
    private final boolean isDeprecated;
    private final boolean isOverridable;
    private final boolean isRequired;
    private final boolean mustHaveValueDefinition;
    @NotNull
    private final Project project;
    @NotNull
    private final Collection<PsiElement> declarationElements;
    @NotNull
    private final Lazy secondaryElements$delegate;
    private final boolean isRenameable;
    @NotNull
    private final Set<String> names;

    public ChartObject(@NotNull Chart chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        this.chart = chart;
        this.project = this.getChart().getProject();
        this.declarationElements = CollectionsKt.listOf((Object)PomService.convertToPsi((Project)this.project, (PomTarget)((PomTarget)new ChartPomTarget(this.getChart().getName(), HelmResolveUtilKt.getRootPathInChart(this.getChart()), this.getChart()))));
        this.secondaryElements$delegate = LazyKt.lazy(() -> ChartObject.secondaryElements_delegate$lambda$0(this));
        this.isRenameable = !this.getChart().isDownloaded();
        this.names = this.getChart().getDependencies().keySet();
    }

    @Override
    @NotNull
    public Chart getChart() {
        return this.chart;
    }

    @Override
    @NotNull
    public String getName() {
        return this.getChart().getName();
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public boolean isOverridable() {
        return this.isOverridable;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean getMustHaveValueDefinition() {
        return this.mustHaveValueDefinition;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        return this.declarationElements;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getSecondaryElements() {
        Lazy lazy = this.secondaryElements$delegate;
        return (Collection)lazy.getValue();
    }

    @Override
    public boolean isRenameable() {
        return this.isRenameable;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Chart \"" + this.getName() + "\"";
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public ChartObject findChildObject(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    private final YAMLKeyValue findChartNameKeyValue(Project project, Chart chart) {
        Object v3;
        block4: {
            VirtualFile virtualFile;
            block6: {
                block5: {
                    virtualFile = chart.getChartFile();
                    if (virtualFile == null) break block5;
                    VirtualFile it = virtualFile;
                    boolean bl = false;
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it);
                    YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
                    virtualFile = yAMLFile;
                    if (yAMLFile != null) break block6;
                }
                return null;
            }
            VirtualFile chartYamlFile = virtualFile;
            Collection collection = YAMLUtil.getTopLevelKeys((YAMLFile)chartYamlFile);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getTopLevelKeys(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                YAMLKeyValue it = (YAMLKeyValue)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)YamlUtilKt.getEffectiveKeyText((YAMLKeyValue)it), (Object)"name")) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final List secondaryElements_delegate$lambda$0(ChartObject this$0) {
        Object object;
        List list;
        YAMLValue chartNameElement;
        block5: {
            Iterator iterator;
            Collection destination$iv$iv;
            block4: {
                block3: {
                    void $this$mapNotNullTo$iv$iv;
                    YAMLKeyValue yAMLKeyValue = this$0.findChartNameKeyValue(this$0.project, this$0.getChart());
                    chartNameElement = yAMLKeyValue != null ? yAMLKeyValue.getValue() : null;
                    Chart chart = this$0.getChart().getSuperChart();
                    if (chart == null) break block3;
                    Chart.Info info = this$0.getChart().getInfo();
                    Collection<Chart.Dependency> collection = chart.getDependenciesByChartNameAndVersion(this$0.getChart().getName(), info != null ? info.getVersion() : null);
                    if (collection == null) break block3;
                    Iterable iterable = collection;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable2 = iterable;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    iterator = $this$forEach$iv$iv$iv.iterator();
                    break block4;
                }
                list = CollectionsKt.emptyList();
                break block5;
            }
            while (iterator.hasNext()) {
                YAMLValue it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Chart.Dependency it = (Chart.Dependency)element$iv$iv;
                boolean bl2 = false;
                YAMLMapping yAMLMapping = it.getElement();
                if ((yAMLMapping != null ? YamlUtilKt.get((YAMLMapping)yAMLMapping, (String)"name") : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List dependencyNameElements = list;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this$0.project).findDirectory(this$0.getChart().getBaseDir());
        if (psiDirectory != null) {
            PsiDirectory psiDirectory2;
            PsiDirectory psiDirectory3 = psiDirectory2 = psiDirectory;
            boolean bl = false;
            object = Comparing.equal((CharSequence)this$0.getChart().getBaseDir().getNameSequence(), (CharSequence)this$0.getChart().getName()) ? psiDirectory2 : null;
        } else {
            object = null;
        }
        PsiDirectory chartDirectoryElement = object;
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)chartNameElement), (Iterable)dependencyNameElements), (Iterable)CollectionsKt.listOfNotNull(chartDirectoryElement));
    }
}

