/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.inlays;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.database.DatabaseCredentials;
import com.intellij.kubernetes.database.KubernetesCredentialExtractor;
import com.intellij.kubernetes.database.KubernetesDatabaseIntegration;
import com.intellij.kubernetes.database.KubernetesDatabaseTypes;
import com.intellij.kubernetes.database.KubernetesPortForwardingDataSourceConfig;
import com.intellij.kubernetes.database.KubernetesPortForwardingDatabaseType;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.inlays.ContainerPortInlayCollector;
import com.intellij.kubernetes.inlays.KubernetesInlayUiUtilsKt;
import com.intellij.kubernetes.inlays.KubernetesPortForwardingInlayProviderKt;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.view.execution.KubernetesObjectInfo;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingServiceKt;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.kubernetes.view.execution.PortForwardingUtils;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingDialog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1DaemonSet;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1Job;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1ReplicaSet;
import io.kubernetes.client.openapi.models.V1ReplicationController;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002JH\u0010!\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$0\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010'\u001a\u00020\bH\u0002JP\u0010+\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$0\"2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020*H\u0002J\u0018\u0010-\u001a\u00020&2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/H\u0002J0\u00100\u001a\u001a\u0012\u0004\u0012\u00020#\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$0\"2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001f\u00101\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002\u00a2\u0006\u0002\u00102J,\u00103\u001a\u0002042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00105\u001a\u00020#2\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020&0$H\u0002J\u0010\u00107\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0002J*\u00108\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020%H\u0002J,\u0010<\u001a\u00020&2\u0006\u0010;\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/kubernetes/inlays/ContainerPortInlayCollector;", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCachedKubernetesObject", "Lkotlinx/coroutines/Deferred;", "Lio/kubernetes/client/common/KubernetesObject;", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "collect", "", "element", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "isValidElement", "isUnderEphemeralContainers", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "findActivePortForwarding", "Lcom/intellij/kubernetes/view/execution/PortForwardingProcess;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "objectInfo", "Lcom/intellij/kubernetes/view/execution/KubernetesObjectInfo;", "portValue", "", "determineActiveForwardingHint", "Lkotlin/Pair;", "", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "kubernetesObject", "activeForwarding", "detectDatabaseImage", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDatabaseType;", "createDatabaseDataSourceHint", "detectedDbType", "createDatabaseDataSource", "dataSourceConfig", "Lcom/intellij/kubernetes/database/KubernetesPortForwardingDataSourceConfig;", "createOpenInBrowserHint", "findLocalPort", "(Lcom/intellij/kubernetes/view/execution/PortForwardingProcess;I)Ljava/lang/Integer;", "addInlayPresentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "hintText", "hintAction", "isSupportedMetatype", "createAndShowPopup", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "e", "showContextMenu", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingInlayProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/inlays/ContainerPortInlayCollector\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,481:1\n66#2,2:482\n66#2,2:490\n295#3,2:484\n2746#3,3:487\n774#3:492\n865#3,2:493\n295#3:495\n1761#3,3:496\n296#3:499\n19#4:486\n13#5:500\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingInlayProvider.kt\ncom/intellij/kubernetes/inlays/ContainerPortInlayCollector\n*L\n131#1:482,2\n201#1:490,2\n139#1:484,2\n199#1:487,3\n222#1:492\n222#1:493,2\n224#1:495\n225#1:496,3\n224#1:499\n198#1:486\n310#1:500\n*E\n"})
final class ContainerPortInlayCollector
implements InlayHintsCollector {
    @NotNull
    private final CoroutineScope coroutineScope;

    public ContainerPortInlayCollector(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
    }

    private final Deferred<KubernetesObject> getCachedKubernetesObject(YAMLDocument document, Project project, CoroutineScope scope2) {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)document, () -> ContainerPortInlayCollector.getCachedKubernetesObject$lambda$0(scope2, document, project));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Deferred)object;
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        PortForwardingProcess portForwardingProcess;
        KubernetesApiModelInterface apiModel2;
        Object v6;
        KubernetesObject kubernetesObjectFromCache;
        int portValue;
        Project project;
        YAMLScalar value;
        block10: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            if (!this.isValidElement(element)) {
                return true;
            }
            YAMLValue yAMLValue = ((YAMLKeyValue)element).getValue();
            Intrinsics.checkNotNull((Object)yAMLValue, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLScalar");
            value = (YAMLScalar)yAMLValue;
            Project project2 = editor.getProject();
            if (project2 == null) {
                return true;
            }
            project = project2;
            String string = value.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            if (n == null) {
                return true;
            }
            portValue = n;
            KubernetesApiProviderInterface kubernetesApi = KubernetesApiProvider.Companion.getInstance(project);
            PsiElement $this$parentOfType_u24default$iv = element;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            YAMLDocument yAMLDocument = (YAMLDocument)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLDocument.class, (boolean)true);
            if (yAMLDocument == null) {
                return true;
            }
            YAMLDocument document = yAMLDocument;
            Deferred<KubernetesObject> cacheData = this.getCachedKubernetesObject(document, project, this.coroutineScope);
            if (!cacheData.isCompleted()) {
                return true;
            }
            KubernetesObject kubernetesObject = (KubernetesObject)cacheData.getCompleted();
            if (kubernetesObject == null) {
                return true;
            }
            kubernetesObjectFromCache = kubernetesObject;
            Iterable $this$firstOrNull$iv = kubernetesApi.getApiModels();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KubernetesApiModelInterface it = (KubernetesApiModelInterface)element$iv;
                boolean bl = false;
                if (!it.isSelectedAsCurrentCluster()) continue;
                v6 = element$iv;
                break block10;
            }
            v6 = null;
        }
        KubernetesApiModelInterface kubernetesApiModelInterface = apiModel2 = (KubernetesApiModelInterface)v6;
        if (kubernetesApiModelInterface != null) {
            KubernetesApiModelInterface api = kubernetesApiModelInterface;
            boolean bl = false;
            String string = kubernetesObjectFromCache.getKind();
            Intrinsics.checkNotNull((Object)string);
            String kind = string;
            KubernetesEntity kubernetesEntity = KubernetesEntity.Companion.findByKind(kind);
            Intrinsics.checkNotNull((Object)kubernetesEntity);
            KubernetesEntity entity = kubernetesEntity;
            String string2 = kubernetesObjectFromCache.getMetadata().getName();
            Intrinsics.checkNotNull((Object)string2);
            String name = string2;
            Object object = kubernetesObjectFromCache.getMetadata();
            if (object == null || (object = object.getNamespace()) == null) {
                object = api.getNamespace();
            }
            Object namespace = object;
            portForwardingProcess = this.findActivePortForwarding(api, new KubernetesObjectInfo(entity, (String)namespace, name), portValue);
        } else {
            portForwardingProcess = null;
        }
        PortForwardingProcess activeForwarding = portForwardingProcess;
        Pair pair = apiModel2 == null ? TuplesKt.to((Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.title", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.collect$lambda$2(project, this, editor, arg_0)) : (activeForwarding != null ? this.determineActiveForwardingHint(editor, kubernetesObjectFromCache, apiModel2, activeForwarding, portValue) : TuplesKt.to((Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.title", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.collect$lambda$3(kubernetesObjectFromCache, apiModel2, arg_0)));
        String hintText = (String)pair.component1();
        Function1 hintAction = (Function1)pair.component2();
        InlayPresentation referencePresentation = this.addInlayPresentation(editor, hintText, (Function1<? super MouseEvent, Unit>)hintAction);
        PsiElement psiElement = ((YAMLKeyValue)element).getParent();
        YAMLMapping yAMLMapping = psiElement instanceof YAMLMapping ? (YAMLMapping)psiElement : null;
        Integer mappingEndOffset = yAMLMapping != null && (yAMLMapping = yAMLMapping.getTextRange()) != null ? Integer.valueOf(yAMLMapping.getEndOffset()) : null;
        KubernetesInlayUiUtilsKt.addInlineInlayWithMappingPlacement(editor, sink, value.getTextRange().getEndOffset(), mappingEndOffset, referencePresentation, (Function2<? super MouseEvent, ? super Point, Unit>)((Function2)(arg_0, arg_1) -> ContainerPortInlayCollector.collect$lambda$4(this, editor, apiModel2, activeForwarding, arg_0, arg_1)));
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isValidElement(PsiElement element) {
        block10: {
            if (!(element instanceof YAMLKeyValue)) {
                return false;
            }
            var4_2 = ((YAMLKeyValue)element).getValue();
            v0 = var4_2 instanceof YAMLScalar != false ? (YAMLScalar)var4_2 : null;
            if (v0 == null) {
                return false;
            }
            value = v0;
            if (!this.isSupportedMetatype((YAMLKeyValue)element)) {
                return false;
            }
            v1 = YamlUtilKt.getTopLevelMapping((PsiElement)element);
            if (v1 == null || (v1 = YamlUtilKt.get((YAMLMapping)v1, (String)"kind")) == null) ** GOTO lbl-1000
            $this$asSafely$iv = v1;
            $i$f$asSafely = false;
            v2 = $this$asSafely$iv;
            if (!(v2 instanceof YAMLScalar)) {
                v2 = null;
            }
            if ((v1 = (YAMLScalar)v2) != null) {
                v3 = v1.getTextValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            kind = v3;
            $this$none$iv = PortForwardingUtils.INSTANCE.getSupportedEntities();
            $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                v4 = true;
            } else {
                for (T element$iv : $this$none$iv) {
                    it = (KubernetesEntity)element$iv;
                    $i$a$-none-ContainerPortInlayCollector$isValidElement$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getKind(), (Object)kind)) continue;
                    v4 = false;
                    break block10;
                }
                v4 = true;
            }
        }
        if (v4) {
            return false;
        }
        $this$parentOfType_u24default$iv = (PsiElement)value;
        withSelf$iv = false;
        $i$f$parentOfType = false;
        v5 = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLMapping.class, (boolean)true);
        var6_10 = v5 != null ? YamlUtilKt.get((YAMLMapping)v5, (String)"protocol") : null;
        v6 = var6_10 instanceof YAMLScalar != false ? (YAMLScalar)var6_10 : null;
        v7 = protocol = v6 != null ? v6.getTextValue() : null;
        return (v7 != null ? !StringsKt.equals((String)v7, (String)"TCP", (boolean)true) : false) == false;
    }

    private final boolean isUnderEphemeralContainers(YAMLKeyValue element) {
        for (PsiElement current = element.getParent(); current != null; current = current.getParent()) {
            YAMLKeyValue kv;
            PsiElement psiElement = current;
            YAMLKeyValue yAMLKeyValue = kv = psiElement instanceof YAMLKeyValue ? (YAMLKeyValue)psiElement : null;
            if (kv == null || !Intrinsics.areEqual((Object)kv.getKeyText(), (Object)"ephemeralContainers")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final PortForwardingProcess findActivePortForwarding(KubernetesApiModelInterface apiModel2, KubernetesObjectInfo objectInfo, int portValue) {
        Object v3;
        block8: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            KubernetesPortForwardingService portForwardingService = KubernetesPortForwardingService.Companion.getInstance();
            Iterable iterable = portForwardingService.getPortForwardingProcesses(apiModel2);
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PortForwardingProcess it = (PortForwardingProcess)element$iv$iv;
                boolean bl = false;
                if (!(KubernetesPortForwardingServiceKt.isActive((PortForwardingProcess)it) && Intrinsics.areEqual((Object)it.getPortForwarding().getObjectInfo(), (Object)objectInfo))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List activeForwardings = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = activeForwardings;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block7: {
                    PortForwardingProcess forwarding = (PortForwardingProcess)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = forwarding.getPortForwarding().getMappings();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            boolean bl3;
                            String mapping = (String)element$iv2;
                            boolean bl4 = false;
                            String[] stringArray = new String[]{":"};
                            List parts = StringsKt.split$default((CharSequence)mapping, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                            if (parts.size() == 2 && !Intrinsics.areEqual(parts.get(0), (Object)"")) {
                                Integer remotePort;
                                Integer n = remotePort = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                                int n2 = portValue;
                                bl3 = n != null && n == n2;
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        return v3;
    }

    private final Pair<String, Function1<MouseEvent, Unit>> determineActiveForwardingHint(Editor editor, KubernetesObject kubernetesObject, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding, int portValue) {
        Pair<String, Function1<MouseEvent, Unit>> pair;
        KubernetesPortForwardingDatabaseType detectedDatabaseImage = this.detectDatabaseImage(kubernetesObject);
        if (detectedDatabaseImage != null) {
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            pair = this.createDatabaseDataSourceHint(project, kubernetesObject, apiModel2, activeForwarding, portValue, detectedDatabaseImage);
        } else {
            pair = this.createOpenInBrowserHint(activeForwarding, portValue);
        }
        return pair;
    }

    private final KubernetesPortForwardingDatabaseType detectDatabaseImage(KubernetesObject kubernetesObject) {
        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType;
        block30: {
            KubernetesObject kubernetesObject2 = kubernetesObject;
            if (kubernetesObject2 instanceof V1Pod) {
                Object object = ((V1Pod)kubernetesObject).getSpec();
                if (object != null && (object = object.getContainers()) != null) {
                    for (V1Container container : (Iterable)object) {
                        boolean bl = false;
                        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType2 = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage());
                        if (kubernetesPortForwardingDatabaseType2 == null) continue;
                        kubernetesPortForwardingDatabaseType = kubernetesPortForwardingDatabaseType2;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1Deployment) {
                Object object = ((V1Deployment)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1ReplicaSet) {
                Object object = ((V1ReplicaSet)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1Job) {
                Object object = ((V1Job)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1DaemonSet) {
                Object object = ((V1DaemonSet)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (Object container : (Iterable)object) {
                        boolean bl = false;
                        if ((container = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage())) == null) continue;
                        kubernetesPortForwardingDatabaseType = container;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else if (kubernetesObject2 instanceof V1ReplicationController) {
                Object object = ((V1ReplicationController)kubernetesObject).getSpec();
                if (object != null && (object = object.getTemplate()) != null && (object = object.getSpec()) != null && (object = object.getContainers()) != null) {
                    for (V1Container container : (Iterable)object) {
                        boolean bl = false;
                        KubernetesPortForwardingDatabaseType kubernetesPortForwardingDatabaseType3 = KubernetesDatabaseTypes.INSTANCE.getDatabaseType(container.getImage());
                        if (kubernetesPortForwardingDatabaseType3 == null) continue;
                        kubernetesPortForwardingDatabaseType = kubernetesPortForwardingDatabaseType3;
                        break block30;
                    }
                    kubernetesPortForwardingDatabaseType = null;
                } else {
                    kubernetesPortForwardingDatabaseType = null;
                }
            } else {
                kubernetesPortForwardingDatabaseType = null;
            }
        }
        return kubernetesPortForwardingDatabaseType;
    }

    private final Pair<String, Function1<MouseEvent, Unit>> createDatabaseDataSourceHint(Project project, KubernetesObject kubernetesObject, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding, int portValue, KubernetesPortForwardingDatabaseType detectedDbType) {
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.create.database", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TuplesKt.to((Object)string, arg_0 -> ContainerPortInlayCollector.createDatabaseDataSourceHint$lambda$0(this, activeForwarding, portValue, project, detectedDbType, kubernetesObject, apiModel2, arg_0));
    }

    private final void createDatabaseDataSource(Project project, KubernetesPortForwardingDataSourceConfig dataSourceConfig) {
        KubernetesDatabaseIntegration databaseIntegration = (KubernetesDatabaseIntegration)CollectionsKt.firstOrNull((List)KubernetesDatabaseIntegration.Companion.getEP_NAME().getExtensionList());
        if (databaseIntegration != null) {
            databaseIntegration.createDatabaseDataSource(project, dataSourceConfig);
            return;
        }
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.provider.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String title = string;
        String string2 = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.database.plugin.required", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        Notification notification = NotificationsKt.getKubernetesNotificationGroup().createNotification(title, message, NotificationType.WARNING);
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.install.database.plugin", (Object[])new Object[0]), () -> ContainerPortInlayCollector.createDatabaseDataSource$lambda$0(project)));
        notification.notify(project);
    }

    private final Pair<String, Function1<MouseEvent, Unit>> createOpenInBrowserHint(PortForwardingProcess activeForwarding, int portValue) {
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.open.browser", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return TuplesKt.to((Object)string, arg_0 -> ContainerPortInlayCollector.createOpenInBrowserHint$lambda$0(this, activeForwarding, portValue, arg_0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Integer findLocalPort(PortForwardingProcess activeForwarding, int portValue) {
        Integer n;
        Integer n2;
        Iterator iterator = ((Iterable)activeForwarding.getPortForwarding().getMappings()).iterator();
        do {
            if (!iterator.hasNext()) return null;
            String mapping = (String)iterator.next();
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            List parts = StringsKt.split$default((CharSequence)mapping, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts.size() == 2) {
                Integer n3 = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                int n4 = portValue;
                if (n3 != null && n3 == n4) {
                    n = StringsKt.toIntOrNull((String)((String)parts.get(0)));
                    continue;
                }
            }
            n = null;
        } while ((n2 = n) == null);
        Integer n5 = n2;
        return n5;
    }

    private final InlayPresentation addInlayPresentation(Editor editor, String hintText, Function1<? super MouseEvent, Unit> hintAction) {
        String string = hintText;
        Icon icon = Intrinsics.areEqual((Object)string, (Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.open.browser", (Object[])new Object[0])) ? KubernetesIcons.PpWeb : (Intrinsics.areEqual((Object)string, (Object)KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.hint.create.database", (Object[])new Object[0])) ? KubernetesIcons.Dbms : KubernetesIcons.ForwardPorts);
        Intrinsics.checkNotNull((Object)icon);
        Icon iconToUse = icon;
        return KubernetesInlayUiUtilsKt.buildHoverInlayButton(editor, iconToUse, hintText, null, (Function2<? super MouseEvent, ? super Point, Unit>)((Function2)(arg_0, arg_1) -> ContainerPortInlayCollector.addInlayPresentation$lambda$0(hintAction, arg_0, arg_1)));
    }

    private final boolean isSupportedMetatype(YAMLKeyValue element) {
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)element);
        String typeName = yamlMetaType != null ? yamlMetaType.getTypeName() : null;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy(element);
        String fieldName = metaTypeProxy != null && (metaTypeProxy = metaTypeProxy.getField()) != null ? metaTypeProxy.getName() : null;
        return Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.core.v1.ContainerPort") && Intrinsics.areEqual((Object)fieldName, (Object)"containerPort") && !this.isUnderEphemeralContainers(element) || Intrinsics.areEqual((Object)typeName, (Object)"io.k8s.api.core.v1.ServicePort") && Intrinsics.areEqual((Object)fieldName, (Object)"port");
    }

    private final void createAndShowPopup(Editor editor, Project project, DefaultActionGroup actionGroup, MouseEvent e) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor).add(CommonDataKeys.PROJECT, (Object)project).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        popup.showInScreenCoordinates((Component)editor.getContentComponent(), e.getLocationOnScreen());
    }

    private final void showContextMenu(MouseEvent e, Editor editor, KubernetesApiModelInterface apiModel2, PortForwardingProcess activeForwarding) {
        PortForwardingProcess portForwardingProcess = activeForwarding;
        List stopPortForwardingAction2 = (portForwardingProcess != null ? KubernetesPortForwardingServiceKt.isActive((PortForwardingProcess)portForwardingProcess) : false) && apiModel2 != null ? CollectionsKt.listOf((Object)DumbAwareAction.create((String)KubernetesBundle.message((String)"action.Kubernetes.StopPortForwarding.text", (Object[])new Object[0]), arg_0 -> ContainerPortInlayCollector.showContextMenu$lambda$1(arg_0 -> ContainerPortInlayCollector.showContextMenu$lambda$0(apiModel2, activeForwarding, arg_0), arg_0))) : CollectionsKt.emptyList();
        SettingsKey settingsKey = KubernetesPortForwardingInlayProviderKt.access$getKEY$p();
        String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.provider.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        KubernetesInlayUiUtilsKt.showStandardInlayPopup(editor, settingsKey, string, e, stopPortForwardingAction2);
    }

    private static final CachedValueProvider.Result getCachedKubernetesObject$lambda$0(CoroutineScope $scope, YAMLDocument $document, Project $project) {
        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super KubernetesObject>, Object>($scope, $document, $project, null){
            int label;
            final /* synthetic */ CoroutineScope $scope;
            final /* synthetic */ YAMLDocument $document;
            final /* synthetic */ Project $project;
            {
                this.$scope = $scope;
                this.$document = $document;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(org.jetbrains.yaml.psi.YAMLDocument ), ()Ljava/lang/String;)((YAMLDocument)this.$document), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        documentText = (String)v0;
                        Intrinsics.checkNotNull((Object)documentText);
                        result = KubernetesResourceMapperKt.yamlToKubernetesObject((String)documentText);
                        BuildersKt.launch$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                            int label;
                            final /* synthetic */ Project $project;
                            {
                                this.$project = $project;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, null){
                                            int label;
                                            final /* synthetic */ Project $project;
                                            {
                                                this.$project = $project;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        InlayHintsPassFactoryInternal.Companion.restartDaemonUpdatingHints(this.$project, "KubernetesPortForwardingInlayProvider.kubernetesObjectComputed");
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        return result;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super KubernetesObject> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(YAMLDocument $document) {
                return $document.getText();
            }
        }), (int)3, null);
        Object[] objectArray = new Object[]{$document};
        return CachedValueProvider.Result.create((Object)deferred2, (Object[])objectArray);
    }

    private static final Unit collect$lambda$2(Project $project, ContainerPortInlayCollector this$0, Editor $editor, MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ActionManager actionManager = ActionManager.getInstance();
        KubernetesApiProviderInterface apiProvider = KubernetesApiProvider.Companion.getInstance($project);
        AnAction actionForPopup = !((Collection)apiProvider.getExistingContexts()).isEmpty() ? actionManager.getAction("Kubernetes.SetCurrentContext") : actionManager.getAction("Kubernetes.AddContexts");
        AnAction[] anActionArray = new AnAction[]{actionForPopup};
        this$0.createAndShowPopup($editor, $project, new DefaultActionGroup(anActionArray), e);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit collect$lambda$3(KubernetesObject $kubernetesObjectFromCache, KubernetesApiModelInterface $apiModel, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        V1ObjectMeta v1ObjectMeta = $kubernetesObjectFromCache.getMetadata();
        String originalNamespace = v1ObjectMeta != null ? v1ObjectMeta.getNamespace() : null;
        V1ObjectMeta v1ObjectMeta2 = $kubernetesObjectFromCache.getMetadata();
        if (v1ObjectMeta2 != null) {
            String string = originalNamespace;
            if (string == null) {
                string = $apiModel.getNamespace();
            }
            v1ObjectMeta2.setNamespace(string);
        }
        try {
            KubernetesPortForwardingDialog.Companion.show$default((KubernetesPortForwardingDialog.Companion)KubernetesPortForwardingDialog.Companion, (KubernetesApiModelInterface)$apiModel, (KubernetesObject)$kubernetesObjectFromCache, null, (boolean)true, (boolean)false, (int)16, null);
        }
        finally {
            V1ObjectMeta v1ObjectMeta3 = $kubernetesObjectFromCache.getMetadata();
            if (v1ObjectMeta3 != null) {
                v1ObjectMeta3.setNamespace(originalNamespace);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit collect$lambda$4(ContainerPortInlayCollector this$0, Editor $editor, KubernetesApiModelInterface $apiModel, PortForwardingProcess $activeForwarding, MouseEvent e, Point point) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        this$0.showContextMenu(e, $editor, $apiModel, $activeForwarding);
        return Unit.INSTANCE;
    }

    private static final Unit createDatabaseDataSourceHint$lambda$0(ContainerPortInlayCollector this$0, PortForwardingProcess $activeForwarding, int $portValue, Project $project, KubernetesPortForwardingDatabaseType $detectedDbType, KubernetesObject $kubernetesObject, KubernetesApiModelInterface $apiModel, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Integer localPort = this$0.findLocalPort($activeForwarding, $portValue);
        if (localPort != null) {
            DatabaseCredentials databaseCredentials;
            try {
                ModalTaskOwner modalTaskOwner = ModalTaskOwner.project((Project)$project);
                Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"project(...)");
                String string = KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.extracting.database.credentials", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                TaskCancellation.Cancellable cancellable = TaskCancellation.Companion.cancellable();
                String string2 = KubernetesBundle.message((String)"modal.progress.title.skip", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                databaseCredentials = (DatabaseCredentials)TasksKt.runWithModalProgressBlocking((ModalTaskOwner)modalTaskOwner, (String)string, (TaskCancellation)((TaskCancellation)cancellable.withButtonText(string2)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super DatabaseCredentials>, Object>($kubernetesObject, $apiModel, $detectedDbType, null){
                    int label;
                    final /* synthetic */ KubernetesObject $kubernetesObject;
                    final /* synthetic */ KubernetesApiModelInterface $apiModel;
                    final /* synthetic */ KubernetesPortForwardingDatabaseType $detectedDbType;
                    {
                        this.$kubernetesObject = $kubernetesObject;
                        this.$apiModel = $apiModel;
                        this.$detectedDbType = $detectedDbType;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = KubernetesCredentialExtractor.INSTANCE.extractCredentials(this.$kubernetesObject, this.$apiModel, this.$detectedDbType, (Continuation<? super DatabaseCredentials>)((Continuation)this));
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super DatabaseCredentials> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }));
            }
            catch (Exception e) {
                if (!(e instanceof CancellationException)) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(ContainerPortInlayCollector.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error((Throwable)e);
                }
                databaseCredentials = null;
            }
            DatabaseCredentials credentials2 = databaseCredentials;
            String string = (String)CollectionsKt.firstOrNull((List)$activeForwarding.getPortForwarding().getAddresses());
            if (string == null) {
                string = "localhost";
            }
            int n = localPort;
            String string3 = $kubernetesObject.getMetadata().getName();
            if (string3 == null) {
                string3 = "unknown";
            }
            KubernetesPortForwardingDataSourceConfig dataSourceConfig = new KubernetesPortForwardingDataSourceConfig(string, n, $portValue, $detectedDbType, string3, $activeForwarding.getPortForwarding().getObjectInfo().getEntity().getKind(), $activeForwarding.getPortForwarding().getObjectInfo().getNamespace(), $apiModel.getCurrentContextObject().getName(), credentials2);
            this$0.createDatabaseDataSource($project, dataSourceConfig);
        }
        return Unit.INSTANCE;
    }

    private static final void createDatabaseDataSource$lambda$0(Project $project) {
        String pluginSearch = "Database Tools and SQL";
        try {
            ShowSettingsUtilImpl.Companion.showSettingsDialog($project, "preferences.pluginManager", pluginSearch);
        }
        catch (Throwable throwable) {
            ShowSettingsUtil.getInstance().showSettingsDialog($project, KubernetesBundle.message((String)"KubernetesPortForwardingInlayProvider.install.database.all.plugins.page", (Object[])new Object[0]));
        }
    }

    private static final Unit createOpenInBrowserHint$lambda$0(ContainerPortInlayCollector this$0, PortForwardingProcess $activeForwarding, int $portValue, MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"<unused var>");
        Integer localPort = this$0.findLocalPort($activeForwarding, $portValue);
        if (localPort != null) {
            String string = (String)CollectionsKt.firstOrNull((List)$activeForwarding.getPortForwarding().getAddresses());
            if (string == null) {
                string = "localhost";
            }
            String address = string;
            BrowserUtil.browse((String)("http://" + address + ":" + localPort));
        }
        return Unit.INSTANCE;
    }

    private static final Unit addInlayPresentation$lambda$0(Function1 $hintAction, MouseEvent e, Point point) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
        $hintAction.invoke((Object)e);
        return Unit.INSTANCE;
    }

    private static final Unit showContextMenu$lambda$0(KubernetesApiModelInterface $apiModel, PortForwardingProcess $activeForwarding, AnActionEvent it) {
        BuildersKt.launch$default((CoroutineScope)$apiModel.getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($apiModel, $activeForwarding, null){
            int label;
            final /* synthetic */ KubernetesApiModelInterface $apiModel;
            final /* synthetic */ PortForwardingProcess $activeForwarding;
            {
                this.$apiModel = $apiModel;
                this.$activeForwarding = $activeForwarding;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutinesKt.backgroundWriteAction(() -> showContextMenu.stopPortForwardingAction.1.1.invokeSuspend$lambda$0(this.$apiModel, this.$activeForwarding), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(KubernetesApiModelInterface $apiModel, PortForwardingProcess $activeForwarding) {
                KubernetesPortForwardingService.Companion.getInstance().stopPortForwarding($apiModel.getCurrentContextObject(), $activeForwarding.getPortForwarding(), false);
                return Unit.INSTANCE;
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void showContextMenu$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

