/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.view.ui.FileTypeCellRenderer;
import com.intellij.kubernetes.view.ui.KubernetesKeyFileTypeService;
import com.intellij.kubernetes.view.ui.KubernetesKeyValueViewerPanel$special$;
import com.intellij.kubernetes.view.ui.KubernetesUIUtilitiesKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00028\u0000\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesKeyValueViewerPanel;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "key", "", "value", "resource", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lio/kubernetes/client/common/KubernetesObject;)V", "Lio/kubernetes/client/common/KubernetesObject;", "associatedFileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "kotlin.jvm.PlatformType", "currentFileType", "editor", "Lcom/intellij/ui/EditorTextField;", "fileTypeComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "createEditorTextField", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesKeyValueViewerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesKeyValueViewerPanel.kt\ncom/intellij/kubernetes/view/ui/KubernetesKeyValueViewerPanel\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,146:1\n477#2:147\n1#3:148\n*S KotlinDebug\n*F\n+ 1 KubernetesKeyValueViewerPanel.kt\ncom/intellij/kubernetes/view/ui/KubernetesKeyValueViewerPanel\n*L\n42#1:147\n*E\n"})
public final class KubernetesKeyValueViewerPanel<T extends KubernetesObject>
extends JPanel {
    @NotNull
    private final Project project;
    @Nullable
    private final String value;
    @NotNull
    private final T resource;
    private final LanguageFileType associatedFileType;
    private LanguageFileType currentFileType;
    @NotNull
    private EditorTextField editor;
    @NotNull
    private final ComboBox<LanguageFileType> fileTypeComboBox;

    /*
     * WARNING - void declaration
     */
    public KubernetesKeyValueViewerPanel(@NotNull Project project, @NotNull String key, @Nullable String value2, @NotNull T resource) {
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        super(new BorderLayout());
        this.project = project;
        this.value = value2;
        this.resource = resource;
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(key);
        LanguageFileType languageFileType = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType == null) {
            languageFileType = (LanguageFileType)PlainTextFileType.INSTANCE;
        }
        this.associatedFileType = languageFileType;
        KubernetesKeyFileTypeService kubernetesKeyFileTypeService = KubernetesKeyFileTypeService.Companion.getInstance(this.project);
        String string = this.resource.getMetadata().getUid();
        Intrinsics.checkNotNull((Object)string);
        fileType = kubernetesKeyFileTypeService.get(string);
        LanguageFileType languageFileType2 = fileType instanceof LanguageFileType ? (LanguageFileType)fileType : null;
        if (languageFileType2 == null) {
            languageFileType2 = this.associatedFileType;
        }
        this.currentFileType = languageFileType2;
        this.editor = this.createEditorTextField();
        FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
        fileType = ArraysKt.asSequence((Object[])fileTypeArray);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)special$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List fileTypes = SequencesKt.toList((Sequence)SequencesKt.filterNot((Sequence)sequence, KubernetesKeyValueViewerPanel::_init_$lambda$0));
        SortedComboBoxModel model = new SortedComboBoxModel((Collection)fileTypes, new Comparator(){

            public final int compare(T a, T b) {
                LanguageFileType it = (LanguageFileType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (LanguageFileType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        this.fileTypeComboBox = new ComboBox((ComboBoxModel)model);
        this.fileTypeComboBox.setSelectedItem((Object)this.currentFileType);
        this.fileTypeComboBox.setSwingPopup(false);
        this.fileTypeComboBox.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        this.fileTypeComboBox.setRenderer((ListCellRenderer)((Object)new FileTypeCellRenderer()));
        this.fileTypeComboBox.addItemListener(arg_0 -> KubernetesKeyValueViewerPanel._init_$lambda$2(this, arg_0));
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.setBorder(IdeBorderFactory.createBorder((int)8));
        panel2.add((Component)this.fileTypeComboBox);
        AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.ViewYAML");
        AnActionWrapper viewYamlAction2 = new AnActionWrapper(anAction){
            {
                Intrinsics.checkNotNull((Object)$super_call_param$1);
                super($super_call_param$1);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.update(e);
            }
        };
        ActionButtonWithText viewYamlButton = new ActionButtonWithText((AnAction)viewYamlAction2, null, "unknown", new Dimension(this.getMinimumSize().width, this.fileTypeComboBox.getMinimumSize().height));
        panel2.add((Component)viewYamlButton);
        this.add((Component)panel2, "North");
        this.add((Component)this.editor, "Center");
    }

    private final EditorTextField createEditorTextField() {
        EditorTextField editorTextField;
        Language language = this.currentFileType.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        EditorTextField it = editorTextField = KubernetesUIUtilitiesKt.createEditorTextField$default(this.project, language, null, 4, null);
        boolean bl = false;
        it.setViewer(true);
        if (this.value != null) {
            it.setText(this.value);
        }
        return editorTextField;
    }

    private static final boolean _init_$lambda$0(LanguageFileType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getLanguage(), (Object)Language.ANY);
    }

    /*
     * WARNING - void declaration
     */
    private static final void _init_$lambda$2(KubernetesKeyValueViewerPanel this$0, ItemEvent event2) {
        void it;
        LanguageFileType languageFileType;
        Object object = event2.getSource();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.JComboBox<*>");
        JComboBox comboBox = (JComboBox)object;
        Object object2 = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.openapi.fileTypes.LanguageFileType");
        this$0.currentFileType = (LanguageFileType)object2;
        KubernetesKeyFileTypeService kubernetesKeyFileTypeService = KubernetesKeyFileTypeService.Companion.getInstance(this$0.project);
        String string = this$0.resource.getMetadata().getUid();
        Intrinsics.checkNotNull((Object)string);
        LanguageFileType languageFileType2 = languageFileType = this$0.currentFileType;
        String string2 = string;
        KubernetesKeyFileTypeService kubernetesKeyFileTypeService2 = kubernetesKeyFileTypeService;
        boolean bl = false;
        boolean bl2 = Intrinsics.areEqual((Object)it, (Object)this$0.associatedFileType);
        kubernetesKeyFileTypeService2.set(string2, (FileType)(!bl2 ? languageFileType : null));
        this$0.remove((Component)this$0.editor);
        this$0.editor = this$0.createEditorTextField();
        this$0.add((Component)this$0.editor, "Center");
    }
}

