/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlKeyReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "YamlKeyMetaConfigKeyReference", "intellij.micronaut.config.yaml"})
public final class MnYamlKeyReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
        if (yamlKeyValue.getKey() == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String qualifiedConfigKeyName = string;
        PsiReference[] psiReferenceArray = new PsiReference[]{new YamlKeyMetaConfigKeyReference(yamlKeyValue, qualifiedConfigKeyName)};
        return psiReferenceArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlKeyReferenceProvider$YamlKeyMetaConfigKeyReference;", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyReference;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "yamlKeyValue", "keyText", "", "<init>", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;Ljava/lang/String;)V", "getReferenceDisplayText", "intellij.micronaut.config.yaml"})
    private static final class YamlKeyMetaConfigKeyReference
    extends MetaConfigKeyReference<YAMLKeyValue> {
        public YamlKeyMetaConfigKeyReference(@NotNull YAMLKeyValue yamlKeyValue, @NotNull String keyText) {
            Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
            Intrinsics.checkNotNullParameter((Object)keyText, (String)"keyText");
            super((MetaConfigKeyManager)MnMetaConfigKeyManager.Companion.getInstance(), (PsiElement)yamlKeyValue, keyText);
            this.setRangeInElement(TextRange.allOf((String)yamlKeyValue.getKeyText()).shiftRight(ElementManipulators.getOffsetInElement((PsiElement)((PsiElement)yamlKeyValue))));
        }

        @NotNull
        public String getReferenceDisplayText() {
            String string = ConfigYamlUtils.getReferenceDisplayText((YAMLKeyValue)((YAMLKeyValue)this.getElement()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReferenceDisplayText(...)");
            return string;
        }
    }
}

