/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el.highlighting;

import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.micronaut.el.lexer.MnELLexer;
import com.intellij.micronaut.el.lexer.MnLexerElementTypes;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class MnELHighlighter
extends SyntaxHighlighterBase {
    public static final TextAttributesKey MN_EL_BACKGROUND = TextAttributesKey.createTextAttributesKey((String)"MN_EL.BACKGROUND", (TextAttributesKey)DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
    public static final TextAttributesKey MN_EL_IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"MN_EL.IDENTIFIER", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey MN_EL_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"MN_EL.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey MN_EL_OPERATIONS = TextAttributesKey.createTextAttributesKey((String)"MN_EL.OPERATIONS", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
    public static final TextAttributesKey MN_EL_STRING = TextAttributesKey.createTextAttributesKey((String)"MN_EL.STRING", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey MN_EL_NUMBER = TextAttributesKey.createTextAttributesKey((String)"MN_EL.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey MN_EL_PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"MN_EL.PARENTHESES", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
    public static final TextAttributesKey MN_EL_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"MN_EL.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
    public static final TextAttributesKey MN_EL_BRACES = TextAttributesKey.createTextAttributesKey((String)"MN_EL.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
    public static final TextAttributesKey MN_EL_COMMA = TextAttributesKey.createTextAttributesKey((String)"MN_EL.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey MN_EL_DOT = TextAttributesKey.createTextAttributesKey((String)"MN_EL.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
    public static final TextAttributesKey MN_EL_COLON = TextAttributesKey.createTextAttributesKey((String)"MN_EL.COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
    public static final TextAttributesKey MN_EL_BOUNDS = TextAttributesKey.createTextAttributesKey((String)"MN_EL.BOUNDS", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey MN_EL_BEAN_PREFIX = TextAttributesKey.createTextAttributesKey((String)"MN_EL.BEAN_PREFIX", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
    public static final TextAttributesKey MN_EL_QUALIFIED_TYPE = TextAttributesKey.createTextAttributesKey((String)"MN_EL.QUALIFIED_TYPE", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_REFERENCE);
    public static final TextAttributesKey MN_EL_PROPERTY_KEY = TextAttributesKey.createTextAttributesKey((String)"MN_EL.PROPERTY_KEY", (TextAttributesKey)PropertiesHighlighter.PropertiesComponent.PROPERTY_KEY.getTextAttributesKey());
    public static final TextAttributesKey MN_EL_METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"MN_EL.METHOD_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_METHOD);
    public static final TextAttributesKey MN_EL_STATIC_FIELD = TextAttributesKey.createTextAttributesKey((String)"MN_EL.STATIC_FIELD", (TextAttributesKey)DefaultLanguageHighlighterColors.STATIC_FIELD);
    private static final Map<IElementType, TextAttributesKey> keys = new HashMap<IElementType, TextAttributesKey>();

    MnELHighlighter() {
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new MnELLexer(this){

            public IElementType getTokenType() {
                IElementType tokenType = super.getTokenType();
                if (tokenType == MnLexerElementTypes.MN_EL_ESCAPED_STRING_LITERAL) {
                    tokenType = MnLexerElementTypes.MN_EL_STRING_LITERAL;
                }
                return tokenType;
            }
        };
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = MnELHighlighter.pack((TextAttributesKey)MN_EL_BACKGROUND, (TextAttributesKey)keys.get(tokenType));
        if (textAttributesKeyArray == null) {
            MnELHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_IDENTIFIER, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_IDENTIFIER});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_KEYWORD, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_AND, MnLexerElementTypes.MN_EL_OR, MnLexerElementTypes.MN_EL_NOT_KEYWORD, MnLexerElementTypes.MN_EL_EQ, MnLexerElementTypes.MN_EL_NE, MnLexerElementTypes.MN_EL_LT, MnLexerElementTypes.MN_EL_GT, MnLexerElementTypes.MN_EL_LE, MnLexerElementTypes.MN_EL_GE});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_KEYWORD, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_TRUE, MnLexerElementTypes.MN_EL_FALSE, MnLexerElementTypes.MN_EL_NULL, MnLexerElementTypes.MN_EL_DIV, MnLexerElementTypes.MN_EL_MOD, MnLexerElementTypes.MN_EL_MATCHES, MnLexerElementTypes.MN_EL_INSTANCEOF, MnLexerElementTypes.MN_EL_NEW, MnLexerElementTypes.MN_EL_TYPE, MnLexerElementTypes.MN_EL_BETWEEN, MnLexerElementTypes.MN_EL_VARIABLE_PREFIX, MnLexerElementTypes.MN_EL_TYPE});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_OPERATIONS, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_PLUS, MnLexerElementTypes.MN_EL_MINUS, MnLexerElementTypes.MN_EL_NOT, MnLexerElementTypes.MN_EL_DIVISION, MnLexerElementTypes.MN_EL_MODULO, MnLexerElementTypes.MN_EL_MULTIPLY, MnLexerElementTypes.MN_EL_NOT_EQUAL, MnLexerElementTypes.MN_EL_EQUAL, MnLexerElementTypes.MN_EL_AND_AND, MnLexerElementTypes.MN_EL_OR_OR, MnLexerElementTypes.MN_EL_ASSIGNMENT, MnLexerElementTypes.MN_EL_QUEST, MnLexerElementTypes.MN_EL_LESS, MnLexerElementTypes.MN_EL_GREATER, MnLexerElementTypes.MN_EL_LESS_OR_EQUAL, MnLexerElementTypes.MN_EL_GREATER_OR_EQUAL});
        MnELHighlighter.fillMap(keys, (TokenSet)MnLexerElementTypes.OPERATIONS, (TextAttributesKey)MN_EL_OPERATIONS);
        MnELHighlighter.fillMap(keys, (TokenSet)MnLexerElementTypes.SELECTIONS, (TextAttributesKey)MN_EL_OPERATIONS);
        MnELHighlighter.fillMap(keys, (TokenSet)MnLexerElementTypes.MN_EL_STRING_LITERALS, (TextAttributesKey)MN_EL_STRING);
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_NUMBER, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_INTEGER_LITERAL, MnLexerElementTypes.MN_EL_FLOATING_POINT_LITERAL});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_PARENTHESES, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_LPARENTH, MnLexerElementTypes.MN_EL_RPARENTH});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_BRACKETS, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_LBRACKET, MnLexerElementTypes.MN_EL_RBRACKET});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_BRACES, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_L_CURLY, MnLexerElementTypes.MN_EL_R_CURLY});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_COMMA, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_COMMA});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_DOT, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_DOT});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_COLON, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_COLON});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_BOUNDS, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_START, MnLexerElementTypes.MN_EL_SHEBANG_START, MnLexerElementTypes.MN_EL_END});
        MnELHighlighter.fillMap(keys, (TextAttributesKey)MN_EL_BEAN_PREFIX, (IElementType[])new IElementType[]{MnLexerElementTypes.MN_EL_BEAN_PREFIX});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/micronaut/el/highlighting/MnELHighlighter", "getTokenHighlights"));
    }
}

