/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSEvaluateContext {
    @Nullable
    public final PsiFile targetFile;
    private final boolean myContextualOverloadEvaluation;
    @Nullable
    private final PsiElement source;
    @Nullable
    private final JSReferenceExpression myProcessedExpression;
    private final boolean myStrict;
    private final boolean myAstAccessAllowed;
    @Nullable
    private final JSType myThisContext;

    public JSEvaluateContext(@Nullable PsiFile targetFile) {
        this(targetFile, false);
    }

    public JSEvaluateContext(@Nullable PsiFile targetFile, boolean contextualOverloadEvaluation) {
        this(targetFile, contextualOverloadEvaluation, null, null, true, true, null);
    }

    private JSEvaluateContext(@Nullable PsiFile targetFile, boolean contextualOverloadEvaluation, @Nullable PsiElement source, @Nullable JSReferenceExpression processedExpression, boolean isEvaluationStrict, boolean isAstAccessAllowed, @Nullable JSType thisContext) {
        this.targetFile = targetFile;
        this.myContextualOverloadEvaluation = contextualOverloadEvaluation;
        this.source = source;
        this.myProcessedExpression = processedExpression;
        this.myStrict = isEvaluationStrict;
        this.myAstAccessAllowed = isAstAccessAllowed;
        this.myThisContext = thisContext;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    @NotNull
    public JSEvaluateContext withProcessedExpression(@Nullable JSReferenceExpression expression) {
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, expression, this.myStrict, this.myAstAccessAllowed, this.myThisContext);
    }

    @Nullable
    public PsiElement getSource() {
        return this.source;
    }

    @NotNull
    public JSEvaluateContext withSource(@Nullable PsiElement source) {
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed, this.myThisContext);
    }

    public boolean isStrict() {
        return this.myStrict;
    }

    @NotNull
    public JSEvaluateContext withThisContext(@Nullable JSType thisContext) {
        if (thisContext == this.myThisContext) {
            JSEvaluateContext jSEvaluateContext = this;
            if (jSEvaluateContext == null) {
                JSEvaluateContext.$$$reportNull$$$0(0);
            }
            return jSEvaluateContext;
        }
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed, thisContext);
    }

    @Nullable
    public JSType getThisContext() {
        return this.myThisContext;
    }

    @NotNull
    public JSEvaluateContext withCombinedStrictness(boolean isStrict) {
        JSEvaluateContext jSEvaluateContext = this.myStrict && !isStrict ? new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, false, this.myAstAccessAllowed, this.myThisContext) : this;
        if (jSEvaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(1);
        }
        return jSEvaluateContext;
    }

    @NotNull
    public JSEvaluateContext combineWith(@NotNull JSEvaluateContext subContext) {
        if (subContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(2);
        }
        return new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, (PsiElement)ObjectUtils.chooseNotNull((Object)subContext.source, (Object)this.source), (JSReferenceExpression)ObjectUtils.chooseNotNull((Object)subContext.myProcessedExpression, (Object)this.myProcessedExpression), this.myStrict && subContext.myStrict, this.myAstAccessAllowed, (JSType)ObjectUtils.chooseNotNull((Object)subContext.myThisContext, (Object)this.myThisContext));
    }

    public boolean isAstAccessAllowedInCurrentFile() {
        return this.myAstAccessAllowed;
    }

    public boolean isAstAccessAllowed(@NotNull PsiElement context) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(3);
        }
        return this.isAstAccessAllowed(context, false);
    }

    @Deprecated
    public boolean isAstAccessAllowed(@NotNull PsiElement context, boolean allowAccessInNonTargetFile) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(4);
        }
        return this.isAstAccessAllowedInCurrentFile() && (allowAccessInNonTargetFile || this.isFromCurrentFile(context));
    }

    public boolean isFromCurrentFile(@NotNull PsiElement element) {
        Object context;
        if (element == null) {
            JSEvaluateContext.$$$reportNull$$$0(5);
        }
        if ((context = this.targetFile) == null) {
            context = this.getProcessedExpression();
        }
        if (context == null) {
            return false;
        }
        PsiFile contextOriginalFile = context.getContainingFile().getOriginalFile();
        PsiFile elementFile = element.getContainingFile();
        if (elementFile == null) {
            return false;
        }
        return contextOriginalFile.isEquivalentTo((PsiElement)elementFile.getOriginalFile());
    }

    @NotNull
    public JSEvaluateContext withAstAccessForbidden() {
        JSEvaluateContext jSEvaluateContext = this.myAstAccessAllowed ? new JSEvaluateContext(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, false, this.myThisContext) : this;
        if (jSEvaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(6);
        }
        return jSEvaluateContext;
    }

    public boolean isContextualOverloadEvaluation() {
        return this.myContextualOverloadEvaluation;
    }

    @NotNull
    public JSEvaluateContext withContextualOverloadEvaluation(boolean contextualOverloadEvaluation) {
        if (contextualOverloadEvaluation == this.myContextualOverloadEvaluation) {
            JSEvaluateContext jSEvaluateContext = this;
            if (jSEvaluateContext == null) {
                JSEvaluateContext.$$$reportNull$$$0(7);
            }
            return jSEvaluateContext;
        }
        return new JSEvaluateContext(this.targetFile, contextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed, this.myThisContext);
    }

    @NotNull
    public JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.isContextualOverloadEvaluation() ? JSExpectedTypeKind.CONTEXTUAL_WITH_OVERLOADS : JSExpectedTypeKind.CONTEXTUAL;
        if (jSExpectedTypeKind == null) {
            JSEvaluateContext.$$$reportNull$$$0(8);
        }
        return jSExpectedTypeKind;
    }

    @NotNull
    public JSEvaluateContext withTargetFile(@Nullable PsiFile file) {
        return new JSEvaluateContext(file, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed, this.myThisContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSEvaluateContext context = (JSEvaluateContext)o;
        return this.myContextualOverloadEvaluation == context.myContextualOverloadEvaluation && this.myStrict == context.myStrict && this.myAstAccessAllowed == context.myAstAccessAllowed && Objects.equals(this.targetFile, context.targetFile) && Objects.equals(this.source, context.source) && Objects.equals(this.myProcessedExpression, context.myProcessedExpression) && Objects.equals(this.myThisContext, context.myThisContext);
    }

    public int hashCode() {
        return Objects.hash(this.targetFile, this.myContextualOverloadEvaluation, this.source, this.myProcessedExpression, this.myStrict, this.myAstAccessAllowed, this.myThisContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "withThisContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "withCombinedStrictness";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withAstAccessForbidden";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withContextualOverloadEvaluation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "combineWith";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAstAccessAllowed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFromCurrentFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    public static final class JSThisContext {
        private final JSType myThisType;
        private final JSThisContext myOuterContext;

        public JSThisContext(@NotNull JSType thisType, @Nullable JSThisContext outerContext) {
            if (thisType == null) {
                JSThisContext.$$$reportNull$$$0(0);
            }
            this.myThisType = thisType;
            this.myOuterContext = outerContext;
        }

        @NotNull
        public JSType getThisType() {
            JSType jSType = this.myThisType;
            if (jSType == null) {
                JSThisContext.$$$reportNull$$$0(1);
            }
            return jSType;
        }

        @Nullable
        public JSThisContext getOuterContext() {
            return this.myOuterContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSThisContext context = (JSThisContext)o;
            return Objects.equals(this.myThisType, context.myThisType) && Objects.equals(this.myOuterContext, context.myOuterContext);
        }

        public int hashCode() {
            return Objects.hash(this.myThisType, this.myOuterContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext$JSThisContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext$JSThisContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getThisType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

