/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssNamedElement;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssValueDeclaration;
import com.intellij.psi.css.CssValueImportedAlias;
import com.intellij.psi.css.CssValueRule;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssValueReference
extends PsiReferenceBase<PsiElement>
implements CssReference {
    private static final ResolveCache.AbstractResolver<CssValueReference, CssNamedElement> RESOLVER = (reference, incompleteCode) -> {
        String text = reference.getValue();
        if (text.isEmpty()) {
            return null;
        }
        Ref result = Ref.create();
        CssValueReference.processValueRules(reference.getElement(), (Processor<? super CssNamedElement>)((Processor)element -> {
            if (text.equals(element.getName())) {
                result.set(element);
                return false;
            }
            return true;
        }));
        return (CssNamedElement)result.get();
    };

    public CssValueReference(@NotNull PsiElement element) {
        if (element == null) {
            CssValueReference.$$$reportNull$$$0(0);
        }
        super(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            CssValueReference.$$$reportNull$$$0(1);
        }
        return element.getContainingFile() == this.myElement.getContainingFile() && super.isReferenceTo(element);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"message.pattern.value.0.not.found", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            CssValueReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, RESOLVER, false, false);
    }

    public Object @NotNull [] getVariants() {
        SmartList result = new SmartList();
        CssValueReference.processValueRules(this.myElement, (Processor<? super CssNamedElement>)((Processor)element -> {
            String name = element.getName();
            if (name != null) {
                ItemPresentation presentation;
                LookupElementBuilder lookup = LookupElementBuilder.create((PsiNamedElement)element).withIcon(CssValueRule.ICON).withTypeText("@value");
                if (element instanceof CssValueDeclaration) {
                    lookup = lookup.withTailText(" " + ((CssValueDeclaration)element).getValueValueText(), true);
                } else if (element instanceof CssValueImportedAlias && (presentation = element.getPresentation()) != null && presentation.getLocationString() != null) {
                    String text = name.equals(presentation.getPresentableText()) ? " from " + presentation.getLocationString() : " " + presentation.getPresentableText() + " from " + presentation.getLocationString();
                    lookup = lookup.withTailText(text, true);
                }
                result.add((Object)lookup);
            }
            return true;
        }));
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            CssValueReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static void processValueRules(@NotNull PsiElement element, @NotNull Processor<? super CssNamedElement> processor) {
        CssRulesetList rulesetList;
        if (element == null) {
            CssValueReference.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            CssValueReference.$$$reportNull$$$0(5);
        }
        if ((rulesetList = (CssRulesetList)PsiTreeUtil.getParentOfType((PsiElement)element, CssRulesetList.class)) == null) {
            return;
        }
        for (PsiElement child = rulesetList.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (!(child instanceof CssValueRule) || ((CssValueRule)child).processValueDeclaringElements(processor)) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/resolve/CssValueReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/resolve/CssValueReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processValueRules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

