/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.spring.security.model.jam.roles.SpringJakartaDeclareRoles;
import com.intellij.spring.security.model.jam.roles.SpringJamRolesHolder;
import com.intellij.spring.security.model.jam.roles.SpringJavaxDeclareRoles;
import com.intellij.spring.security.model.jam.roles.SpringRolesJakartaAllowed;
import com.intellij.spring.security.model.jam.roles.SpringRolesJavaxAllowed;
import com.intellij.spring.security.model.jam.roles.SpringSecuredRole;
import com.intellij.spring.security.model.jam.roles.SpringSecurityWithMockUser;
import com.intellij.spring.security.model.jam.testing.SpringSecurityJamWithUserDetailsForClass;
import com.intellij.spring.security.model.jam.testing.SpringSecurityJamWithUserDetailsForMethod;
import com.intellij.spring.security.model.xml.SpringSecurityDomElement;
import com.intellij.spring.security.model.xml.SpringSecurityRolesHolderMarkup;
import com.intellij.spring.security.model.xml.converters.SpringSecurityRolesConverter;
import com.intellij.spring.security.references.extensions.SpringSecurityRolesProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SpringSecurityRoleUtils {
    private SpringSecurityRoleUtils() {
    }

    @NotNull
    public static Set<String> collectRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(0);
        }
        HashSet<String> roles = new HashSet<String>();
        for (SpringJamRolesHolder<?> holder : SpringSecurityRoleUtils.collectJamRoles(module)) {
            ContainerUtil.addAllNotNull(roles, holder.getRoles());
        }
        ContainerUtil.addAllNotNull(roles, SpringSecurityRoleUtils.collectDomRoles(module));
        for (SpringSecurityRolesProvider provider : SpringSecurityRolesProvider.EP_NAME.getExtensionList()) {
            ProgressManager.checkCanceled();
            ContainerUtil.addAllNotNull(roles, provider.getRoles(module));
        }
        HashSet<String> hashSet = roles;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringJamRolesHolder<?>> collectJamRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(2);
        }
        HashSet elements = new HashSet();
        GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module);
        JamService jamService = JamService.getJamService((Project)module.getProject());
        elements.addAll(jamService.getJamClassElements(SpringSecuredRole.CLASS.CLASS_JAM_KEY, "org.springframework.security.access.annotation.Secured", scope));
        elements.addAll(jamService.getJamMethodElements(SpringSecuredRole.METHOD.M_JAM_KEY, "org.springframework.security.access.annotation.Secured", scope));
        elements.addAll(jamService.getJamClassElements(SpringJakartaDeclareRoles.CLASS.CLASS_JAM_KEY, "jakarta.annotation.security.DeclareRoles", scope));
        elements.addAll(jamService.getJamMethodElements(SpringJakartaDeclareRoles.METHOD.M_JAM_KEY, "jakarta.annotation.security.DeclareRoles", scope));
        elements.addAll(jamService.getJamClassElements(SpringJavaxDeclareRoles.CLASS.CLASS_JAM_KEY, "javax.annotation.security.DeclareRoles", scope));
        elements.addAll(jamService.getJamMethodElements(SpringJavaxDeclareRoles.METHOD.M_JAM_KEY, "javax.annotation.security.DeclareRoles", scope));
        elements.addAll(jamService.getJamClassElements(SpringRolesJakartaAllowed.JAKARTA_CLASS.CLASS_JAM_KEY, "jakarta.annotation.security.RolesAllowed", scope));
        elements.addAll(jamService.getJamMethodElements(SpringRolesJakartaAllowed.METHOD.M_JAM_KEY, "jakarta.annotation.security.RolesAllowed", scope));
        elements.addAll(jamService.getJamClassElements(SpringRolesJavaxAllowed.JAVAX_CLASS.CLASS_JAM_KEY, "javax.annotation.security.RolesAllowed", scope));
        elements.addAll(jamService.getJamMethodElements(SpringRolesJavaxAllowed.METHOD.M_JAM_KEY, "javax.annotation.security.RolesAllowed", scope));
        elements.addAll(jamService.getJamClassElements(SpringSecurityJamWithUserDetailsForClass.JAM_KEY, "org.springframework.security.test.context.support.WithUserDetails", scope));
        elements.addAll(jamService.getJamMethodElements(SpringSecurityJamWithUserDetailsForMethod.JAM_KEY, "org.springframework.security.test.context.support.WithUserDetails", scope));
        elements.addAll(jamService.getJamMethodElements(SpringSecurityWithMockUser.M_JAM_KEY, "org.springframework.security.test.context.support.WithMockUser", scope));
        HashSet hashSet = elements;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public static Set<String> collectDomRoles(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(4);
        }
        HashSet<String> roles = new HashSet<String>();
        for (SpringSecurityRolesHolderMarkup securityRolesMarkup : SpringSecurityRoleUtils.getDomSecurityRolesMarkups(module)) {
            for (DomElement domElement : DomUtil.getDefinedChildren((DomElement)securityRolesMarkup, (boolean)false, (boolean)true)) {
                Object domRoles;
                String stringValue;
                if (!(domElement instanceof GenericAttributeValue)) continue;
                GenericAttributeValue attributeValue = (GenericAttributeValue)domElement;
                Converter converter = attributeValue.getConverter();
                if (converter instanceof WrappingConverter) {
                    converter = WrappingConverter.getDeepestConverter((Converter)converter, (GenericDomValue)attributeValue);
                }
                if (!(converter instanceof SpringSecurityRolesConverter) || !StringUtil.isNotEmpty((String)(stringValue = attributeValue.getStringValue())) || (domRoles = ((SpringSecurityRolesConverter)converter).fromString(stringValue, ConvertContextFactory.createConvertContext((DomElement)attributeValue))) == null) continue;
                ContainerUtil.addAllNotNull(roles, (Iterable)domRoles);
            }
        }
        HashSet<String> hashSet = roles;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static Set<SpringSecurityRolesHolderMarkup> getDomSecurityRolesMarkups(@NotNull Module module) {
        if (module == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(6);
        }
        final HashSet<SpringSecurityRolesHolderMarkup> markups = new HashSet<SpringSecurityRolesHolderMarkup>();
        Project project = module.getProject();
        Collection springXmlCandidates = DomService.getInstance().getDomFileCandidates(Beans.class, SpringGlobalSearchScopes.moduleWithDependencies((Module)module));
        for (VirtualFile candidate : springXmlCandidates) {
            DomFileElement fileElement;
            PsiFile file = PsiManager.getInstance((Project)project).findFile(candidate);
            if (!(file instanceof XmlFile) || (fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)file))) == null) continue;
            for (SpringSecurityDomElement securityDomElement : DomUtil.getChildrenOf((DomElement)fileElement.getRootElement(), SpringSecurityDomElement.class)) {
                DomUtil.acceptAvailableChildren((DomElement)securityDomElement, (DomElementVisitor)new DomElementVisitor(){

                    public void visitDomElement(DomElement element) {
                        if (element instanceof SpringSecurityRolesHolderMarkup) {
                            markups.add((SpringSecurityRolesHolderMarkup)element);
                        }
                        element.acceptChildren((DomElementVisitor)this);
                    }
                });
            }
        }
        HashSet<SpringSecurityRolesHolderMarkup> hashSet = markups;
        if (hashSet == null) {
            SpringSecurityRoleUtils.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRoleUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRoleUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRoles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectJamRoles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDomRoles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomSecurityRolesMarkups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectRoles";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectJamRoles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDomRoles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDomSecurityRolesMarkups";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

