/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.util;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringSecurityUtil {
    private static final String SPRING_SECURITY_MAVEN = "org.springframework.security:spring-security-core";

    public static boolean hasSpringLibrary(@NotNull PsiFile file) {
        if (file == null) {
            SpringSecurityUtil.$$$reportNull$$$0(0);
        }
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        return SpringSecurityUtil.hasSpringLibrary(module);
    }

    public static boolean hasSpringLibrary(@Nullable Module module) {
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)SPRING_SECURITY_MAVEN);
    }

    public static boolean isSpringSecurityUsed(DomFileElement<Beans> domFileElement) {
        return SpringSecurityUtil.isSpringSecurityNamespaceUsed(domFileElement) || SpringSecurityUtil.isFilterChainProxyDefined(domFileElement);
    }

    public static boolean isSpringSecurityNamespaceUsed(DomFileElement<Beans> domFileElement) {
        return SpringDomUtils.hasNamespace(domFileElement, (String)"Spring Security namespace key");
    }

    private static boolean isFilterChainProxyDefined(DomFileElement<Beans> domFileElement) {
        Module module = domFileElement.getModule();
        if (module == null) {
            return false;
        }
        PsiClass filterChainProxy = DomJavaUtil.findClass((String)"org.springframework.security.web.FilterChainProxy", domFileElement);
        if (filterChainProxy == null) {
            return false;
        }
        Set springModels = SpringManager.getInstance((Project)module.getProject()).getSpringModelsByFile((PsiFile)domFileElement.getFile());
        for (CommonSpringModel model : springModels) {
            if (!SpringModelSearchers.doesBeanExist((CommonSpringModel)model, (PsiClass)filterChainProxy)) continue;
            return true;
        }
        return false;
    }

    public static SpringSecurityVersion getVersion(@NotNull DomElement element) {
        if (element == null) {
            SpringSecurityUtil.$$$reportNull$$$0(1);
        }
        Module module = element.getModule();
        Project project = element.getManager().getProject();
        SpringSecurityVersion version = module != null ? SpringSecurityUtil.getSpringSecurityVersion(module) : SpringSecurityUtil.getSpringSecurityVersion(project);
        return version != null ? version : SpringSecurityVersion.V_2_0;
    }

    @Nullable
    private static SpringSecurityVersion getSpringSecurityVersion(@NotNull Project project) {
        if (project == null) {
            SpringSecurityUtil.$$$reportNull$$$0(2);
        }
        EnumSet<SpringSecurityVersion> versions = EnumSet.noneOf(SpringSecurityVersion.class);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ContainerUtil.addIfNotNull(versions, (Object)((Object)SpringSecurityUtil.getSpringSecurityVersion(module)));
        }
        return versions.isEmpty() ? null : Collections.max(versions);
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringSecurityVersion version) {
        if (module == null) {
            return false;
        }
        SpringSecurityVersion cached = SpringSecurityUtil.getSpringSecurityVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    public static SpringSecurityVersion getSpringSecurityVersion(@NotNull Module module) {
        if (module == null) {
            SpringSecurityUtil.$$$reportNull$$$0(3);
        }
        if (module.isDisposed() || module.getProject().isDefault()) {
            return null;
        }
        return (SpringSecurityVersion)((Object)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            String libraryVersion = JavaLibraryUtil.getLibraryVersion((Module)module, (String)SPRING_SECURITY_MAVEN);
            SpringSecurityVersion detected = libraryVersion == null ? null : (SpringSecurityVersion)((Object)((Object)ContainerUtil.find((Object[])((SpringSecurityVersion[])ArrayUtil.reverseArray((Object[])SpringSecurityVersion.values())), version -> VersionComparatorUtil.compare((String)version.getVersion(), (String)libraryVersion) <= 0)));
            return CachedValueProvider.Result.create((Object)((Object)detected), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/security/util/SpringSecurityUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSpringLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpringSecurityVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

