/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.notifydialog;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class HNotificationManager {
    public static final Logger log = Logger.getInstance(HNotificationManager.class);
    private static final int CAPTION_LENGTH_LIMIT = 40;
    private final Project project;

    public HNotificationManager(Project project) {
        this.project = project;
    }

    public static HNotificationManager getInstance(@NotNull Project project) {
        if (project == null) {
            HNotificationManager.$$$reportNull$$$0(0);
        }
        return (HNotificationManager)project.getService(HNotificationManager.class);
    }

    public void showNotification(@NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(1);
        }
        this.showNotification(null, description, type);
    }

    public void showNotification(@NlsContexts.NotificationContent @Nullable String description) {
        this.showNotification(null, description);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(2);
        }
        this.showNotification(caption, description, type, true);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description) {
        this.showNotification(caption, description, NotificationType.INFORMATION);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type, boolean balloon) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(3);
        }
        this.showNotification(caption, description, type, null, balloon);
    }

    public void error(@NlsContexts.NotificationTitle @Nullable String caption, @NotNull Throwable th) {
        if (th == null) {
            HNotificationManager.$$$reportNull$$$0(4);
        }
        this.error(caption, "", th);
    }

    public void error(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description, @NotNull Throwable th) {
        if (th == null) {
            HNotificationManager.$$$reportNull$$$0(5);
        }
        this.showNotification(caption, description, NotificationType.ERROR, true);
        log.warn(caption, th);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String title, @NlsContexts.NotificationSubtitle @Nullable String subtitle, @NlsContexts.NotificationContent @Nullable String content, @NotNull NotificationType type, boolean balloon, NotificationAction ... actions) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(6);
        }
        if (actions == null) {
            HNotificationManager.$$$reportNull$$$0(7);
        }
        NotificationGroup notificationGroup = balloon ? HNotificationManager.getBalloonGroup() : HNotificationManager.getLogOnlyGroup();
        Notification notification = new Notification(notificationGroup.getDisplayId(), content == null ? "" : content, type).setTitle(title, subtitle);
        for (NotificationAction action2 : actions) {
            notification.addAction((AnAction)action2);
        }
        notification.notify(this.project);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type, @Nullable NotificationAction[] actions, boolean balloon) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(8);
        }
        NotificationGroup notificationGroup = balloon ? HNotificationManager.getBalloonGroup() : HNotificationManager.getLogOnlyGroup();
        this.showNotification(caption, description, type, actions, notificationGroup);
    }

    public void showNotification(@NlsContexts.NotificationTitle @Nullable String caption, @NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type, @Nullable NotificationAction[] actions, NotificationGroup notificationGroup) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(9);
        }
        if (HNotificationManager.isCaptionOverLimit(caption)) {
            description = HNotificationManager.getCaptionInDescription(caption, description);
            caption = null;
        }
        Notification notification = notificationGroup.createNotification(caption == null ? "" : caption, description == null ? "" : description, type);
        if (actions != null) {
            for (NotificationAction action2 : actions) {
                notification.addAction((AnAction)action2);
            }
        }
        notification.notify(this.project);
    }

    public static void showNotification_(@NlsContexts.NotificationContent @Nullable String description, @NotNull NotificationType type) {
        if (type == null) {
            HNotificationManager.$$$reportNull$$$0(10);
        }
        HNotificationManager.getCommonNotificationGroup().createNotification(description == null ? "" : description, type).notify(null);
    }

    private static NotificationGroup getLogOnlyGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("com.intellij.jpa.jpb.model.logs.notification");
    }

    private static NotificationGroup getBalloonGroup() {
        return HNotificationManager.getCommonNotificationGroup();
    }

    private static NotificationGroup getCommonNotificationGroup() {
        return NotificationGroupManager.getInstance().getNotificationGroup("com.intellij.jpa.jpb.model.common.notification");
    }

    @NlsContexts.NotificationContent
    public static String getCaptionInDescription(@NlsContexts.NotificationTitle @NotNull String caption, @NlsContexts.NotificationContent @Nullable String description) {
        if (caption == null) {
            HNotificationManager.$$$reportNull$$$0(11);
        }
        return description == null ? HNotificationManager.getCaptionInDescription(caption) : HNotificationManager.getCaptionInDescription(caption) + "<p>" + description;
    }

    public static String getCaptionInDescription(@NotNull String caption) {
        if (caption == null) {
            HNotificationManager.$$$reportNull$$$0(12);
        }
        return "<b>" + caption + "</b>";
    }

    @Contract(value="null -> false")
    public static boolean isCaptionOverLimit(@Nullable String caption) {
        return caption != null && caption.length() > 40;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/core/notifydialog/HNotificationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification_";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getCaptionInDescription";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

