/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.X11DisplayNameGetter;
import com.intellij.ssh.X11Forwarding;
import com.intellij.ssh.config.ApplyJschBasedOpenSshConfig;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.ConfigRepository;
import com.intellij.ssh.config.EnvironmentVariable;
import com.intellij.ssh.config.IdentityAgent;
import com.intellij.ssh.config.OpenSSHConfig;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshProxyConfig;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.util.SmartFMap;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0001H\u0007\u001a5\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002\u00a2\u0006\u0002\u0010\f\u001a*\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0002\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001b\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0012\u001a\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0002\u001a\f\u0010\u001a\u001a\u00020\u0004*\u00020\u0004H\u0002\"/\u0010\u0016\u001a#\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00140\u00140\u0017\u00a2\u0006\u0002\b\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"applyJschBasedOpenSshConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "source", "config", "", "addDefaultPrivateKeysIfNeeded", "V", "", "", "splitChar", "", "fallback", "([Ljava/lang/String;CLjava/util/List;)Ljava/util/List;", "V", "V", "", "Lcom/intellij/ssh/config/ConfigRepository$Config;", "key", "(Lcom/intellij/ssh/config/ConfigRepository$Config;Ljava/lang/String;)Ljava/lang/Boolean;", "V", "Lcom/intellij/remote/SshConnectionConfigPatch$HostKeyVerifier$StrictHostKeyChecking;", "strictHostKeyCheckingValue", "strictHostKeyCheckingMap", "Lcom/intellij/util/SmartFMap;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
@JvmName(name="ApplyJschBasedOpenSshConfig")
@SourceDebugExtension(value={"SMAP\nApplyJschBasedOpenSshConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,314:1\n1#2:315\n1#2:330\n1#2:348\n1#2:390\n19#3:316\n19#3:337\n774#4:317\n865#4,2:318\n1617#4,9:320\n1869#4:329\n1870#4:331\n1626#4:332\n1563#4:333\n1634#4,3:334\n1011#4,2:351\n1374#4:361\n1460#4,5:362\n1803#4,3:367\n1563#4:370\n1634#4,3:371\n1374#4:374\n1460#4,5:375\n1617#4,9:380\n1869#4:389\n1870#4:391\n1626#4:392\n1563#4:396\n1634#4,3:397\n774#4:400\n865#4,2:401\n11879#5,9:338\n13805#5:347\n13806#5:349\n11888#5:350\n11561#5:353\n11896#5,3:354\n11561#5:357\n11896#5,3:358\n13216#5,3:393\n13#6:403\n*S KotlinDebug\n*F\n+ 1 ApplyJschBasedOpenSshConfig.kt\ncom/intellij/ssh/config/ApplyJschBasedOpenSshConfig\n*L\n103#1:330\n131#1:348\n224#1:390\n92#1:316\n124#1:337\n102#1:317\n102#1:318,2\n103#1:320,9\n103#1:329\n103#1:331\n103#1:332\n105#1:333\n105#1:334,3\n189#1:351,2\n207#1:361\n207#1:362,5\n211#1:367,3\n218#1:370\n218#1:371,3\n220#1:374\n220#1:375,5\n224#1:380,9\n224#1:389\n224#1:391\n224#1:392\n282#1:396\n282#1:397,3\n282#1:400\n282#1:401,2\n131#1:338,9\n131#1:347\n131#1:349\n131#1:350\n199#1:353\n199#1:354,3\n203#1:357\n203#1:358,3\n265#1:393,3\n313#1:403\n*E\n"})
public final class ApplyJschBasedOpenSshConfig {
    @NotNull
    private static final SmartFMap<String, SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking> strictHostKeyCheckingMap;
    @NotNull
    private static final Logger LOG;

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @NotNull
    public static final SshConnectionConfig applyJschBasedOpenSshConfig(@NotNull SshConnectionConfig source, @NotNull String config) {
        block105: {
            block104: {
                block103: {
                    block102: {
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                        var3_2 = OpenSSHConfig.parse(config).getConfig(source.getHost());
                        Intrinsics.checkNotNullExpressionValue((Object)var3_2, (String)"getConfig(...)");
                        var2_3 = var3_2;
                        var4_4 = var2_3.getValue("HostName");
                        v0 = var4_4;
                        if (v0 == null) {
                            v0 = var3_2 = source.getHost();
                        }
                        if ((v1 = (var5_5 = var2_3.getValue("User"))) == null) {
                            v1 = source.getUser();
                        }
                        var4_4 = v1;
                        var6_7 = var2_3.getValue("Port");
                        v2 = var6_7;
                        var5_6 = v2 != null && (v2 = (var7_8 = StringsKt.toIntOrNull((String)v2))) != null ? v2.intValue() : source.getPort();
                        var8_10 = var7_8 = var2_3.getValue("ConnectTimeout");
                        var9_11 = false;
                        if (var8_10 == null) ** GOTO lbl-1000
                        switch (var8_10.hashCode()) {
                            case 3387192: {
                                if (var8_10.equals("none")) {
                                    v3 = null;
                                    break;
                                }
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                if ((v3 = var8_10) != null && (v3 = StringsKt.toLongOrNull((String)v3)) != null) {
                                    var10_13 = ((Number)v3).longValue();
                                    var12_15 = false;
                                    v4 = Duration.ofSeconds(var10_13);
                                    v3 = v4;
                                    if (v4 != null) break;
                                }
                                v3 = source.getConnectTimeout();
                            }
                        }
                        var6_7 = v3;
                        v5 = var8_10 = ApplyJschBasedOpenSshConfig.V(var2_3, "Compression");
                        var7_9 = v5 != null ? v5.booleanValue() : source.getCompression();
                        var8_10 = ApplyJschBasedOpenSshConfig.V(var2_3.getValues("KexAlgorithms"), ',', source.getKexAlgorithms());
                        var9_12 = ApplyJschBasedOpenSshConfig.V(var2_3.getValues("HostKeyAlgorithms"), ',', source.getHostKeyAlgorithms());
                        var10_14 = ApplyJschBasedOpenSshConfig.V(var2_3.getValues("Ciphers"), ',', source.getCiphers());
                        var11_17 = ApplyJschBasedOpenSshConfig.V(var2_3.getValues("MACs"), ',', source.getMacs());
                        var13_18 = false;
                        v6 = var2_3.getValue("ServerAliveInterval");
                        if (v6 == null || (v6 = StringsKt.toLongOrNull((String)v6)) == null) ** GOTO lbl-1000
                        var14_20 = v6;
                        var15_22 = ((Number)var14_20).longValue();
                        var17_29 = false;
                        v6 = var15_22 > 0L != false ? var14_20 : null;
                        if (v6 != null) {
                            var15_22 = ((Number)v6).longValue();
                            var17_29 = false;
                            v7 = Duration.ofSeconds(var15_22);
                        } else lbl-1000:
                        // 2 sources

                        {
                            v7 = var18_34 = null;
                        }
                        if ((v8 = var2_3.getValue("ServerAliveCountMax")) != null && (v8 = StringsKt.toIntOrNull((String)v8)) != null) {
                            var14_20 = v8;
                            var19_35 = ((Number)var14_20).intValue();
                            var20_37 = false;
                            v9 = var19_35 > 0 ? var14_20 : null;
                        } else {
                            v9 = null;
                        }
                        var21_40 = v9;
                        if (var18_34 != null && var21_40 != null) {
                            v10 = new ServerAlive((Duration)var18_34, var21_40.intValue());
                        } else if (var18_34 != null) {
                            v11 = source.getServerAlive();
                            v10 = new ServerAlive((Duration)var18_34, v11 != null ? v11.getCountMax() : 3);
                        } else if (var21_40 != null) {
                            v12 = source.getServerAlive();
                            v10 = v12 != null ? ServerAlive.copy$default(v12, null, var21_40.intValue(), 1, null) : null;
                        } else {
                            v10 = source.getServerAlive();
                        }
                        var12_16 = v10;
                        if (!Registry.Companion.is("ssh.x11.forwarding")) ** GOTO lbl-1000
                        v13 = var14_20 = var2_3.getValue("ForwardX11");
                        if (v13 != null) {
                            var15_23 = v13;
                            var16_43 = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)var16_43, (String)"getDefault(...)");
                            v14 = var15_23.toLowerCase((Locale)var16_43);
                            v15 = v14;
                            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"toLowerCase(...)");
                        } else {
                            v15 = null;
                        }
                        if (!Intrinsics.areEqual(v15, (Object)"yes")) lbl-1000:
                        // 2 sources

                        {
                            v16 = null;
                        } else {
                            v17 = var14_20 = ApplyJschBasedOpenSshConfig.V(var2_3, "ForwardX11Trusted");
                            if (v17 != null) {
                                v18 = v17.booleanValue();
                            } else {
                                v19 = var16_43 = source.getX11Forwarding();
                                v20 = var15_24 = v19 != null ? Boolean.valueOf(v19.getTrusted()) : null;
                                v18 = v20 != null ? v20 : false;
                            }
                            if ((v21 = (var14_20 = var2_3.getValue("XAuthLocation"))) == null) {
                                v22 = var16_43 = source.getX11Forwarding();
                                var15_25 = v22 != null ? v22.getXAuthLocation() : null;
                                v21 = var15_25;
                                if (v21 == null) {
                                    v21 = X11Forwarding.Companion.getDefaultXAuthLocation();
                                }
                            }
                            if ((v23 = (var14_20 = source.getX11Forwarding())) == null || (v23 = (var15_26 = v23.getDisplayName())) == null) {
                                v23 = X11DisplayNameGetter.Companion.getInstance().getDisplay();
                            }
                            v16 = var13_19 = new X11Forwarding(v18, (String)v21, (String)v23);
                        }
                        if (!Registry.Companion.is("ssh.agent.forwarding")) ** GOTO lbl-1000
                        v24 = var15_27 = var2_3.getValue("ForwardAgent");
                        if (v24 != null) {
                            var16_43 = v24;
                            var17_30 = Locale.getDefault();
                            Intrinsics.checkNotNullExpressionValue((Object)var17_30, (String)"getDefault(...)");
                            v25 = var16_43.toLowerCase(var17_30);
                            v26 = v25;
                            Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"toLowerCase(...)");
                        } else {
                            v26 = null;
                        }
                        if (Intrinsics.areEqual(v26, (Object)"yes")) {
                            v27 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v27 = false;
                        }
                        var14_21 = v27;
                        v28 = var16_43 = var2_3.getValue("IdentityAgent");
                        if (v28 != null) {
                            var18_34 = var17_31 = v28;
                            var19_35 = 0;
                            v29 = new IdentityAgent((String)var18_34);
                        } else {
                            v29 = null;
                        }
                        var15_28 = v29;
                        var17_32 = false;
                        var18_34 = source.getHostKeyVerifier();
                        var19_35 = 0;
                        v30 = var18_34;
                        if (!(v30 instanceof OpenSshLikeHostKeyVerifier)) {
                            v30 = null;
                        }
                        var20_38 = (OpenSshLikeHostKeyVerifier)v30;
                        v31 = var2_3.getValue("StrictHostKeyChecking");
                        if (v31 == null) break block102;
                        var21_40 = v31;
                        var22_44 = false;
                        v32 = ApplyJschBasedOpenSshConfig.V((String)var21_40);
                        v31 = v32;
                        if (v32 != null) break block103;
                    }
                    v33 = var20_38;
                    v31 = v33 != null ? v33.getStrictHostKeyChecking() : (var18_34 = SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK);
                }
                if ((var23_50 = var2_3.getValue("UserKnownHostsFile")) == null) ** GOTO lbl-1000
                var21_40 = new char[1];
                var21_40[0] = 32;
                var24_58 = StringsKt.split$default((CharSequence)var23_50, (char[])var21_40, (boolean)false, (int)0, (int)6, null);
                if (var24_58 != null) {
                    var22_45 = (Iterable)var24_58;
                    var25_59 = false;
                    var26_74 = var22_45;
                    var27_82 = new ArrayList<E>();
                    var28_87 = false;
                    for (Object var30_99 : var26_74) {
                        var31_108 = (String)var30_99;
                        var32_119 = false;
                        v34 = !StringsKt.isBlank((CharSequence)var31_108);
                        if (!v34) continue;
                        var27_82.add(var30_99);
                    }
                    var21_40 = (List)var27_82;
                    var25_60 = (Iterable)var21_40;
                    var26_75 = false;
                    var27_82 = var25_60;
                    var28_88 = new ArrayList<E>();
                    var29_97 = 0;
                    var30_99 = var27_82;
                    var31_109 = false;
                    var32_120 = var30_99.iterator();
                    while (var32_120.hasNext()) {
                        var34_132 /* !! */  = var33_126 = var32_120.next();
                        var35_135 = false;
                        var36_137 = (String)var34_132 /* !! */ ;
                        var37_139 = false;
                        try {
                            var38_143 = false;
                            var38_142 = Result.constructor-impl((Object)new File(OSAgnosticPathUtil.expandUserHome((String)StringsKt.trim((CharSequence)((CharSequence)var36_137)).toString())));
                        }
                        catch (Throwable var39_144) {
                            var38_142 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var39_144));
                        }
                        if ((File)(Result.isFailure-impl((Object)var38_142) != false ? null : var38_142) == null) continue;
                        var41_148 = false;
                        var28_88.add(var40_147);
                    }
                    var22_45 = (List)var28_88;
                    v35 /* !! */  = var22_45;
                } else lbl-1000:
                // 2 sources

                {
                    v36 = var20_38;
                    if (v36 != null) {
                        v35 /* !! */  = v36.getKnownHostsFiles();
                    } else {
                        var25_60 = (Object[])OpenSSHConfigUtil.getDefaultKnownHostsFiles();
                        var26_75 = false;
                        var27_82 = var25_60;
                        var28_88 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var25_60, (int)10));
                        var29_97 = 0;
                        for (T var31_110 : var27_82) {
                            var32_120 = (Path)var31_110;
                            var42_150 = var28_88;
                            var33_127 = false;
                            var42_150.add(var32_120.toFile());
                        }
                        v35 /* !! */  = (List)var28_88;
                    }
                }
                var19_36 = v35 /* !! */ ;
                v37 = ApplyJschBasedOpenSshConfig.V(var2_3, "HashKnownHosts");
                if (v37 != null) {
                    v38 = v37;
                } else {
                    v39 = var20_38;
                    v40 = v39 != null ? Boolean.valueOf(v39.getHashKnownHosts()) : null;
                    v38 = var23_51 = v40 != null ? v40 : false;
                }
                var16_43 = ((Collection)var19_36).isEmpty() == false ? (SshHostKeyVerifier)new OpenSshLikeHostKeyVerifier((List)var19_36, (SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking)var18_34, var23_51, false, 8, null) : source.getHostKeyVerifier();
                var18_34 = var2_3.getValue("ProxyCommand");
                v41 = var18_34;
                if (v41 == null || (v41 = (var19_36 = ApplyJschBasedOpenSshConfig.V((String)v41))) == null) break block104;
                var22_46 = var21_40 = v41;
                var23_51 = false;
                if (!(((CharSequence)var22_46).length() > 0)) ** GOTO lbl-1000
                var24_58 = var22_46;
                v42 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)v42, (String)"getDefault(...)");
                v43 = var24_58.toLowerCase(v42);
                Intrinsics.checkNotNullExpressionValue((Object)v43, (String)"toLowerCase(...)");
                if (!Intrinsics.areEqual((Object)v43, (Object)"none")) {
                    v44 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v44 = false;
                }
                if ((v41 = (var20_38 = v44 != false ? var21_40 : null)) != null) break block105;
            }
            if ((v45 = (var21_40 = var2_3.getValue("ProxyJump"))) == null) ** GOTO lbl-1000
            var24_58 = var23_52 = v45;
            var25_61 = false;
            var22_47 = OpenSSHConfigUtil.parseJump((String)var24_58);
            v45 = var22_47;
            if (v45 != null) {
                v41 = OpenSSHConfigUtil.toProxyCommand((ProxyJumpOptions)v45);
            } else lbl-1000:
            // 2 sources

            {
                var24_58 = source.getProxyConfig();
                var25_62 = false;
                v46 = var24_58;
                if (!(var24_58 instanceof SshProxyConfig.Command)) {
                    v46 = null;
                }
                v47 = var23_53 = (SshProxyConfig.Command)v46;
                v41 = v47 != null ? v47.getCommand() : null;
            }
        }
        v48 = var17_33 = v41;
        if (v48 != null) {
            var20_38 = var19_36 = v48;
            var21_41 = false;
            v49 = new SshProxyConfig.Command((String)var20_38);
        } else {
            v49 = null;
        }
        var18_34 = v49;
        var20_39 = false;
        var21_42 = var2_3.getValues("IdentityFile");
        if (var21_42 != null) {
            var22_48 = var21_42;
            var23_54 = false;
            var24_58 = var22_48;
            var25_63 = new ArrayList<E>();
            var26_75 = false;
            var27_82 = var24_58;
            var28_89 = false;
            var30_100 = var27_82.length;
            for (var29_97 = 0; var29_97 < var30_100; ++var29_97) {
                var31_111 = var27_82[var29_97];
                var32_120 = var31_111;
                var33_128 = false;
                var34_132 /* !! */  = var32_120;
                var35_135 = false;
                try {
                    Intrinsics.checkNotNull(var34_132 /* !! */ );
                    var36_137 = Paths.get(OSAgnosticPathUtil.expandUserHome((String)ApplyJschBasedOpenSshConfig.V(var34_132 /* !! */ )), new String[0]);
                }
                catch (InvalidPathException var37_140) {
                    ApplyJschBasedOpenSshConfig.LOG.warn("Wrong IdentityFile " + var34_132 /* !! */ );
                    var36_137 = null;
                }
                if (var36_137 == null) continue;
                var39_145 = false;
                var25_63.add(var38_142);
            }
            var40_147 = (List)var25_63;
            v50 /* !! */  = var40_147;
        } else {
            v50 /* !! */  = CollectionsKt.emptyList();
        }
        var41_149 /* !! */  = v50 /* !! */ ;
        var21_42 = ApplyJschBasedOpenSshConfig.V(var2_3, "IdentitiesOnly");
        var40_147 = SshConnectionConfigKt.findPublicKeyWithIndex(source.getAuthMethods());
        var22_49 /* !! */  = CollectionsKt.toMutableList((Collection)source.getAuthMethods());
        if (((Collection)var41_149 /* !! */ ).isEmpty() == false && var40_147 != null) {
            var22_49 /* !! */ .remove(((Number)var40_147.getFirst()).intValue());
        }
        v51 = var40_147;
        v52 = v51 != null ? ((Number)v51.getFirst()).intValue() : var22_49 /* !! */ .size();
        v53 = var40_147;
        v54 = v53 != null && (v53 = (AuthMethod.PublicKey)v53.getSecond()) != null ? v53.getAgent() : null;
        switch (v54 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[v54.ordinal()]) {
            case 1: {
                v55 = AuthMethod.PublicKey.Agent.NO;
                break;
            }
            case 2: 
            case 3: {
                var25_64 /* !! */  = var21_42;
                if (Intrinsics.areEqual((Object)var25_64 /* !! */ , (Object)true)) {
                    v55 = AuthMethod.PublicKey.Agent.ONLY_MENTIONED;
                    break;
                }
                if (Intrinsics.areEqual((Object)var25_64 /* !! */ , (Object)false)) {
                    v55 = AuthMethod.PublicKey.Agent.ALL;
                    break;
                }
                if (var25_64 /* !! */  == null) {
                    v55 = ((AuthMethod.PublicKey)var40_147.getSecond()).getAgent();
                    break;
                }
                throw new NoWhenBranchMatchedException();
            }
            case -1: {
                v55 = AuthMethod.PublicKey.Agent.ALL;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        var22_49 /* !! */ .add(v52, new AuthMethod.PublicKey((List<? extends Path>)var41_149 /* !! */ , v55));
        ((Collection)var22_49 /* !! */ ).add(AuthMethod.Password.INSTANCE);
        if (!Intrinsics.areEqual((Object)ApplyJschBasedOpenSshConfig.V(var2_3, "ChallengeResponseAuthentication"), (Object)false)) {
            ((Collection)var22_49 /* !! */ ).add(AuthMethod.KeyboardInteractive.INSTANCE);
        }
        v56 = ApplyJschBasedOpenSshConfig.V(var2_3, "GSSAPIAuthentication");
        if (v56 != null) {
            var25_65 = v56;
            var26_75 = false;
            if (var25_65) {
                var22_49 /* !! */ .add(0, AuthMethod.GssApi.INSTANCE);
                v57 = Unit.INSTANCE;
            } else {
                v57 = var22_49 /* !! */ .remove(AuthMethod.GssApi.INSTANCE);
            }
        } else {
            v57 = null;
        }
        if ((v58 = var2_3.getValue("PreferredAuthentications")) != null && (v58 = ApplyJschBasedOpenSshConfig.V((String)v58, ',')) != null) {
            var26_76 = v58;
            var27_83 = false;
            var28_90 = var22_49 /* !! */ ;
            var29_97 = 0;
            if (var28_90.size() > 1) {
                CollectionsKt.sortWith((List)var28_90, (Comparator)new Comparator((List)var26_76){
                    final /* synthetic */ List $preferredAuthentications$inlined;
                    {
                        this.$preferredAuthentications$inlined = list;
                    }

                    public final int compare(T a, T b) {
                        AuthMethod authMethod = (AuthMethod)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(authMethod)) + Integer.MAX_VALUE + 1);
                        authMethod = (AuthMethod)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(this.$preferredAuthentications$inlined.indexOf(SshConnectionConfigKt.getOpenSshLabel(authMethod)) + Integer.MAX_VALUE + 1));
                    }
                });
            }
            v59 = Unit.INSTANCE;
        } else {
            v59 = null;
        }
        var19_36 = AuthMethods.Companion.create((Iterable)var22_49 /* !! */ );
        v60 = var21_42 = ApplyJschBasedOpenSshConfig.V(var2_3, "ClearAllForwardings");
        v61 = var20_39 = v60 != null ? v60.booleanValue() : false;
        if (var20_39) {
            v62 = source.getInitialLocalTcpForwardings();
        } else {
            v63 = (Collection<Collection>)source.getInitialLocalTcpForwardings();
            if (var22_49 /* !! */  != null) {
                var24_58 = var22_49 /* !! */  = var2_3.getValues("LocalForward");
                var44_151 /* !! */  = v63;
                var25_66 = false;
                var26_77 = var24_58;
                var27_84 = new ArrayList<E>(((Object[])var24_58).length);
                var28_91 = false;
                var30_101 = var26_77.length;
                for (var29_97 = 0; var29_97 < var30_101; ++var29_97) {
                    var32_120 = var31_112 = var26_77[var29_97];
                    var45_152 = var27_84;
                    var33_129 = false;
                    var46_153 = OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)var32_120);
                    var45_152.add(var46_153);
                }
                var45_152 = (List)var27_84;
                v63 = var44_151 /* !! */ ;
                var23_55 = var45_152;
                v64 = var23_55;
            } else {
                v64 = CollectionsKt.emptyList();
            }
            v62 = var21_42 = CollectionsKt.plus((Collection)v63, (Iterable)v64);
        }
        if (var20_39) {
            v65 = source.getInitialRemoteTcpForwardings();
        } else {
            v66 = source.getInitialRemoteTcpForwardings();
            if (var23_56 != null) {
                var25_67 = var23_56 = var2_3.getValues("RemoteForward");
                var44_151 /* !! */  = v66;
                var26_78 = false;
                var27_85 = var25_67;
                var28_92 = new ArrayList<E>(var25_67.length);
                var29_97 = 0;
                var31_113 = var27_85.length;
                for (var30_102 = 0; var30_102 < var31_113; ++var30_102) {
                    var33_130 = var32_120 = var27_85[var30_102];
                    var45_152 = var28_92;
                    var34_133 = false;
                    var46_153 = OpenSSHConfigUtil.parseOpenSshConfigForwardInfo((String)var33_130);
                    var45_152.add(var46_153);
                }
                var45_152 = (List)var28_92;
                v66 = var44_151 /* !! */ ;
                var24_58 = var45_152;
                v67 = (Iterable)var24_58;
            } else {
                v67 = CollectionsKt.emptyList();
            }
            v65 = CollectionsKt.plus((Collection)v66, (Iterable)v67);
        }
        var22_49 /* !! */  = v65;
        var24_58 = var2_3.getValues("SendEnv");
        v68 /* !! */  = var24_58;
        if (var24_58 == null || (v68 /* !! */  = (var25_68 = ArraysKt.toList((Object[])v68 /* !! */ ))) == null) {
            v68 /* !! */  = CollectionsKt.emptyList();
        }
        var24_58 = (Iterable)v68 /* !! */ ;
        var25_69 = false;
        var26_79 = var24_58;
        var27_86 = (LinkedHashSet<E>)new ArrayList<E>();
        var28_93 = false;
        var29_98 = var26_79.iterator();
        while (var29_98.hasNext()) {
            var30_103 = var29_98.next();
            var31_114 = (String)var30_103;
            var32_121 = false;
            Intrinsics.checkNotNull((Object)var31_114);
            v69 = UtilKt.argvSplit((String)var31_114, true);
            if (v69 == null) {
                v69 = CollectionsKt.emptyList();
            }
            var31_114 = v69;
            CollectionsKt.addAll(var27_86, (Iterable)var31_114);
        }
        var24_58 = (List)var27_86;
        var25_70 = new LinkedHashSet<E>();
        var26_80 = false;
        var27_86 = var25_70;
        var28_94 = var24_58.iterator();
        while (var28_94.hasNext()) {
            var29_98 = var28_94.next();
            var30_104 = (String)var29_98;
            var31_115 = var27_86;
            var32_122 = false;
            if (StringsKt.startsWith$default((String)var30_104, (String)"-", (boolean)false, (int)2, null)) {
                v70 = var31_115;
                v71 = var30_104.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)v71, (String)"substring(...)");
                v70.remove(v71);
            } else {
                ((Collection)var31_115).add(var30_104);
            }
            var27_86 = var31_115;
        }
        var24_58 = var27_86;
        var25_71 = false;
        var26_81 = var24_58;
        var27_86 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var24_58, (int)10));
        var28_95 = false;
        var29_98 = var26_81.iterator();
        while (var29_98.hasNext()) {
            var30_105 = var29_98.next();
            var31_116 = (String)var30_105;
            var44_151 /* !! */  = var27_86;
            var32_123 = false;
            var45_152 = new EnvironmentVariable.Inherit(var31_116);
            var44_151 /* !! */ .add(var45_152);
        }
        v72 = (List)var27_86;
        var24_58 = var2_3.getValues("SetEnv");
        v73 = var24_58;
        if (v73 == null || (v73 = (var25_72 = ArraysKt.toList((Object[])v73))) == null) {
            v73 = CollectionsKt.emptyList();
        }
        var24_58 = (Iterable)v73;
        var44_151 /* !! */  = v72;
        var25_73 = false;
        var26_81 = var24_58;
        var27_86 = new ArrayList<E>();
        var28_95 = false;
        var29_98 = var26_81.iterator();
        while (var29_98.hasNext()) {
            var30_106 = var29_98.next();
            var31_117 = (String)var30_106;
            var32_124 = false;
            Intrinsics.checkNotNull((Object)var31_117);
            v74 = UtilKt.argvSplit((String)var31_117, true);
            if (v74 == null) {
                v74 = CollectionsKt.emptyList();
            }
            var31_117 = v74;
            CollectionsKt.addAll(var27_86, (Iterable)var31_117);
        }
        var45_152 = (List)var27_86;
        var24_58 = (Iterable)var45_152;
        var25_73 = false;
        var26_81 = var24_58;
        var27_86 = new ArrayList<E>();
        var28_95 = false;
        var29_98 = var26_81;
        var30_107 = false;
        var31_118 = var29_98.iterator();
        while (var31_118.hasNext()) {
            var33_131 = var32_125 = var31_118.next();
            var34_134 = false;
            var35_136 = (String)var33_131;
            var36_138 = false;
            var37_141 /* !! */  = new char[]{'='};
            var37_141 /* !! */  = (char[])StringsKt.split$default((CharSequence)var35_136, (char[])var37_141 /* !! */ , (boolean)false, (int)2, (int)2, null);
            var38_142 = var37_141 /* !! */ ;
            var39_146 = false;
            v75 /* !! */  = (char[])(var38_142.size() == 2 != false ? var37_141 /* !! */  : null);
            if (v75 /* !! */  == null) {
                v76 = null;
            } else {
                var40_147 = v75 /* !! */ ;
                var41_149 /* !! */  = (String)var40_147.get(0);
                var37_141 /* !! */  = (char[])((String)var40_147.get(1));
                v76 = new EnvironmentVariable.Certain((String)var41_149 /* !! */ , (String)var37_141 /* !! */ );
            }
            if (v76 == null) continue;
            var42_150 = v76;
            var43_154 = false;
            var27_86.add(var42_150);
        }
        var45_152 = (List)var27_86;
        var23_57 = CollectionsKt.plus(var44_151 /* !! */ , (Iterable)((Iterable)var45_152));
        var24_58 = AuthMethods.Companion.create((Iterable)var19_36);
        return new SshConnectionConfig((AuthMethods)var24_58, var10_14, var7_9, (Duration)var6_7, var14_21, var23_57, (String)var3_2, var9_12, (SshHostKeyVerifier)var16_43, var15_28, (List<OpenSshConfigForwardInfo>)var21_42, (List<OpenSshConfigForwardInfo>)var22_49 /* !! */ , var8_10, var11_17, var5_6, (SshProxyConfig)var18_34, var12_16, var4_4, var13_19);
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @NotNull
    public static final SshConnectionConfig addDefaultPrivateKeysIfNeeded(@NotNull SshConnectionConfig $this$addDefaultPrivateKeysIfNeeded) {
        SshConnectionConfig sshConnectionConfig;
        Intrinsics.checkNotNullParameter((Object)$this$addDefaultPrivateKeysIfNeeded, (String)"<this>");
        AuthMethod.PublicKey publicKey = SshConnectionConfigKt.findPublicKey($this$addDefaultPrivateKeysIfNeeded.getAuthMethods());
        if (publicKey != null) {
            AuthMethod.PublicKey publicKey2 = publicKey;
            boolean bl = false;
            Object[] objectArray = new String[]{"id_rsa", "id_dsa", "id_ecdsa", "id_ed25519", "id_xmss"};
            Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
            File file = Ssh.getHomeSshDirectory().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            List list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)sequence, (Function1)((Function1)new Function1<String, File>((Object)file){

                public final File invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return FilesKt.resolve((File)((File)this.receiver), (String)p0);
                }
            })), (Function1)addDefaultPrivateKeysIfNeeded.1.defaultPrivateKeys.2.INSTANCE));
            SshConnectionConfig sshConnectionConfig2 = SshConnectionConfig.copy$default($this$addDefaultPrivateKeysIfNeeded, $this$addDefaultPrivateKeysIfNeeded.getAuthMethods().plus(new AuthMethod.PublicKey(list, null, 2, null)), null, false, null, false, null, null, null, null, null, null, null, null, null, 0, null, null, null, null, 524286, null);
            if (sshConnectionConfig2 != null) {
                sshConnectionConfig = sshConnectionConfig2;
                return sshConnectionConfig;
            }
        }
        sshConnectionConfig = $this$addDefaultPrivateKeysIfNeeded;
        return sshConnectionConfig;
    }

    private static final List<String> V(String[] stringArray, char c, List<String> list) {
        String[] stringArray2 = stringArray;
        if (stringArray == null) {
            stringArray2 = new String[]{};
        }
        String[] stringArray3 = stringArray2;
        List<String> list2 = list;
        boolean bl = false;
        List<String> list3 = list2;
        int n = stringArray3.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray3[i];
            List<String> list4 = list3;
            boolean bl2 = false;
            list3 = ApplyJschBasedOpenSshConfig.V(string2, c, list4);
        }
        return list3;
    }

    private static final List<String> V(String string, char c, List<String> list) {
        List<String> list2;
        Object object = string;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            list2 = list;
        } else if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list2 = CollectionsKt.plus((Collection)list, (Iterable)ApplyJschBasedOpenSshConfig.V(StringsKt.trimStart((String)string, (char[])object), c, (List<String>)CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)string, (String)"-", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 43;
            list2 = CollectionsKt.minus((Iterable)list, (Iterable)ApplyJschBasedOpenSshConfig.V(StringsKt.trimStart((String)string, (char[])object), c, (List<String>)CollectionsKt.emptyList()));
        } else if (StringsKt.startsWith$default((String)string, (String)"^", (boolean)false, (int)2, null)) {
            object = new char[1];
            object[0] = 94;
            list2 = CollectionsKt.plus((Collection)ApplyJschBasedOpenSshConfig.V(StringsKt.trimStart((String)string, (char[])object), c, (List<String>)CollectionsKt.emptyList()), (Iterable)list);
        } else {
            List<String> list3;
            List<String> list4 = list3 = ApplyJschBasedOpenSshConfig.V(string, c);
            boolean bl = false;
            list2 = !((Collection)list4).isEmpty() ? list3 : null;
            if (list2 == null) {
                list2 = list;
            }
        }
        return list2;
    }

    private static final List<String> V(String string, char c) {
        boolean bl;
        String string2;
        Object t;
        Object object = new char[]{c};
        object = StringsKt.split$default((CharSequence)string, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl2 = false;
        Object object2 = object;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        boolean bl3 = false;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            string2 = (String)t;
            Collection collection2 = collection;
            bl = false;
            collection2.add(((Object)StringsKt.trim((CharSequence)string2)).toString());
        }
        object = (List)collection;
        bl2 = false;
        object2 = object;
        collection = new ArrayList();
        bl3 = false;
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            t = iterator.next();
            string2 = (String)t;
            bl = false;
            boolean bl4 = ((CharSequence)string2).length() > 0;
            if (!bl4) continue;
            collection.add(t);
        }
        return (List)collection;
    }

    private static final Boolean V(ConfigRepository.Config config, String string) {
        String string2;
        String string3 = config.getValue(string);
        if (string3 != null) {
            String string4 = string3;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string5 = string4.toLowerCase(locale);
            v3 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
        } else {
            v3 = string2 = null;
        }
        return Intrinsics.areEqual(string2, (Object)"yes") ? Boolean.valueOf(true) : (Intrinsics.areEqual((Object)string2, (Object)"no") ? Boolean.valueOf(false) : null);
    }

    private static final SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking V(String string) {
        CharSequence charSequence = string;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            CharSequence charSequence2 = charSequence = (SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking)strictHostKeyCheckingMap.get((Object)string3);
            if (charSequence2 != null) {
                return charSequence2;
            }
            Set set = strictHostKeyCheckingMap.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            LOG.warn("Unexpected StrictHostKeyChecking=" + string + ". Accepted values are: " + CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, null, (int)63, null) + ".");
        }
        return SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
    }

    private static final String V(String string) {
        String string2 = StringUtil.unquoteString((String)string, (char)'\"');
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unquoteString(...)");
        return string2;
    }

    static {
        SmartFMap smartFMap = SmartFMap.emptyMap().plus((Object)"yes", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES).plus((Object)"accept-new", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ACCEPT_NEW).plus((Object)"no", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO).plus((Object)"off", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO).plus((Object)"ask", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK).plus((Object)"true", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.YES).plus((Object)"false", (Object)SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.NO);
        Intrinsics.checkNotNullExpressionValue((Object)smartFMap, (String)"plus(...)");
        strictHostKeyCheckingMap = smartFMap;
        boolean bl = false;
        Logger logger = Logger.getInstance(SshConnectionConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthMethod.PublicKey.Agent.values().length];
            try {
                nArray[AuthMethod.PublicKey.Agent.NO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ONLY_MENTIONED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthMethod.PublicKey.Agent.ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

