/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.VtlPsiUtil;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlFileReferenceSet;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Util {
    @Nullable
    static VtlReferenceExpression findReferenceExpression(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            Util.$$$reportNull$$$0(0);
        }
        if (file == null) {
            Util.$$$reportNull$$$0(1);
        }
        return Util.findReferenceExpression(editor, file, VtlReferenceExpression.class);
    }

    @Nullable
    static <T> T findReferenceExpression(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Class<T> refClass) {
        PsiReference reference;
        if (editor == null) {
            Util.$$$reportNull$$$0(2);
        }
        if (file == null) {
            Util.$$$reportNull$$$0(3);
        }
        if (refClass == null) {
            Util.$$$reportNull$$$0(4);
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        if (charSequence.length() == offset || charSequence.length() > offset && !Character.isJavaIdentifierPart(charSequence.charAt(offset))) {
            --offset;
        }
        return (T)(refClass.isInstance(reference = file.findReferenceAt(offset)) ? reference : null);
    }

    @NotNull
    static <T> List<T> collectFilePaths(@NotNull PsiElement element, @NotNull Function<? super PsiFile, ? extends T> converter) {
        if (element == null) {
            Util.$$$reportNull$$$0(5);
        }
        if (converter == null) {
            Util.$$$reportNull$$$0(6);
        }
        SmartList allFiles = new SmartList();
        PsiManager psiManager = element.getManager();
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)element)).getFileIndex();
        fileIndex.iterateContent(arg_0 -> Util.lambda$collectFilePaths$0(psiManager, (List)allFiles, converter, arg_0));
        SmartList smartList = allFiles;
        if (smartList == null) {
            Util.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    static boolean canSetVelocityProperties(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        VtlFile vtlFile = (VtlFile)file.getViewProvider().getPsi((Language)VtlLanguage.INSTANCE);
        return vtlFile != null && vtlFile.getVelocityProperties() == null;
    }

    @Nullable
    static VtlFileReferenceSet findVtlFileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            Util.$$$reportNull$$$0(8);
        }
        for (PsiReference ref : element.getReferences()) {
            FileReferenceSet refSet;
            if (!(ref instanceof FileReference) || !((refSet = ((FileReference)ref).getFileReferenceSet()) instanceof VtlFileReferenceSet) || refSet.getLastReference() == null) continue;
            return (VtlFileReferenceSet)refSet;
        }
        return null;
    }

    static PsiFile @NotNull [] findReferencedFiles(final @Nullable Module module, @NotNull String nameFile) {
        if (nameFile == null) {
            Util.$$$reportNull$$$0(9);
        }
        if (module == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                Util.$$$reportNull$$$0(10);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)module.getProject(), (String)nameFile, (GlobalSearchScope)new GlobalSearchScope(module.getProject()){
            private final VirtualFile[] myContentRoots;
            {
                super(arg0);
                this.myContentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VirtualFile contentRoot : this.myContentRoots) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aModule == module;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/velocity/inspections/Util$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (psiFileArray == null) {
            Util.$$$reportNull$$$0(11);
        }
        return psiFileArray;
    }

    static String computeFilePath(VelocityPropertiesProvider velocityProperties, String referencedFilePath, String pathString, PsiFile fileToInsertComment) {
        for (String path : velocityProperties.getResourceLoaderPathList()) {
            String propFilePath;
            VirtualFile vFileToInsertCommentParent;
            String basePath;
            String vtlRootPath;
            String relativePath;
            String string = relativePath = ".".equals(path) ? pathString : path + "/" + pathString;
            if (!referencedFilePath.endsWith(relativePath)) continue;
            int len = referencedFilePath.length() - relativePath.length();
            VirtualFile vFileToInsertComment = fileToInsertComment.getVirtualFile();
            if (vFileToInsertComment == null || (vtlRootPath = VtlPsiUtil.getRelativePath(basePath = (vFileToInsertCommentParent = vFileToInsertComment.getParent()) == null ? null : vFileToInsertCommentParent.getPath(), referencedFilePath.substring(0, len))) == null || (propFilePath = VtlPsiUtil.getRelativePath(fileToInsertComment, velocityProperties.getPropertiesFile().getContainingFile())) == null) continue;
            return "\"" + propFilePath + "\" runtime_root=\"" + vtlRootPath + "\"";
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$collectFilePaths$0(PsiManager psiManager, List allFiles, Function converter, VirtualFile fileOrDir) {
        PsiFile psiFile = psiManager.findFile(fileOrDir);
        if (psiFile != null) {
            ContainerUtil.addIfNotNull((Collection)allFiles, (Object)converter.fun((Object)psiFile));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/inspections/Util";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/inspections/Util";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilePaths";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceExpression";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectFilePaths";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findVtlFileReferenceSet";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

