/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 123912947962539L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1153547070 - (char)-6384, -1153416000 + -((char)-3654), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1153547070 - (char)-6385, 1153416000 + (char)-7102, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 86674369454076L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.n();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 == 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1929481470 - -((char)-6535), -1929481470 - -((char)-6163), (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1929481470 - -((char)-6536), -1929481470 - -((char)-24425), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1929481470 - -((char)-6533), 1929481470 - (char)-21480, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 31227057854571L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    n2 = SshAgentIpcService.n();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1649384880 - 32453, -1649384880 - -((char)-27518), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1649384880 - 32456, 1649384880 - 29504, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1649384880 - 32455, 1649384880 - 28387, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 == 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1649384880 - 32458, 1649384880 - 32481, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1649384880 - 32457, -1649384880 - -((char)-29749), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1649384880 - 32460, 1649384880 - 30339, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1649384880 - 32458, 1649384880 - 32481, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1649384880 - 32459, -1649384880 - -((char)-27289), (int)l2));
            if (ActionTimestamp.V() == null) {
                SshAgentIpcService.V(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 134786792246501L;
                    n3 = SshAgentIpcService.V();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 != 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 != 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 60086704037070L;
                int n3 = SshAgentIpcService.n();
                this.assertConnectionThread();
                n2 = n3;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-111540570 + -27743, 111540570 + 23495, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27744, -111540570 + -9486, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27745, -111540570 + -2751, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-111540570 + -27743, 111540570 + 23495, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27746, -111540570 + -21328, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-111540570 + -27743, 111540570 + 23495, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27723, 111540570 + 21184, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27724, -111540570 + -((char)-32600), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27745, -111540570 + -2751, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-111540570 + -27743, 111540570 + 23495, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-111540570 + -27747, -111540570 + -27708, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-111540570 + -27725, 111540570 + 24552, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 117641544310680L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1904840310 + (char)-15933, -1904840310 + -((char)-9941), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 116236555934740L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1855951200 + -((char)-9492), 1855951200 + (char)-19454, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u008f\u00d6\u008c\u009a\u0085\u009e\u00da2\u00a7a\u007fPo\u0012c\u00d8\u00c6\u001e\u00f9\u00143\u00cf\u001b\u00bfl\u00f8\u009a{-N\u00eba?\u00cd\u00a8\u00a8R\u00d6l\u00c5";
                        var4_3 = "\u008f\u00d6\u008c\u009a\u0085\u009e\u00da2\u00a7a\u007fPo\u0012c\u00d8\u00c6\u001e\u00f9\u00143\u00cf\u001b\u00bfl\u00f8\u009a{-N\u00eba?\u00cd\u00a8\u00a8R\u00d6l\u00c5".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 63;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 83;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 65;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 27;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 48;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 88;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 3;
                                        break;
                                    }
                                    default: {
                                        v11 = 111;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xFFFFCFA1) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 6;
                            case 1 -> 45;
                            case 2 -> 101;
                            case 3 -> 224;
                            case 4 -> 26;
                            case 5 -> 109;
                            case 6 -> 254;
                            case 7 -> 30;
                            case 8 -> 72;
                            case 9 -> 114;
                            case 10 -> 38;
                            case 11 -> 132;
                            case 12 -> 116;
                            case 13 -> 19;
                            case 14 -> 250;
                            case 15 -> 163;
                            case 16 -> 242;
                            case 17 -> 21;
                            case 18 -> 209;
                            case 19 -> 57;
                            case 20 -> 129;
                            case 21 -> 228;
                            case 22 -> 65;
                            case 23 -> 226;
                            case 24 -> 131;
                            case 25 -> 94;
                            case 26 -> 158;
                            case 27 -> 22;
                            case 28 -> 172;
                            case 29 -> 117;
                            case 30 -> 159;
                            case 31 -> 108;
                            case 32 -> 95;
                            case 33 -> 252;
                            case 34 -> 182;
                            case 35 -> 91;
                            case 36 -> 202;
                            case 37 -> 135;
                            case 38 -> 156;
                            case 39 -> 34;
                            case 40 -> 183;
                            case 41 -> 77;
                            case 42 -> 15;
                            case 43 -> 160;
                            case 44 -> 227;
                            case 45 -> 214;
                            case 46 -> 106;
                            case 47 -> 125;
                            case 48 -> 176;
                            case 49 -> 245;
                            case 50 -> 31;
                            case 51 -> 104;
                            case 52 -> 246;
                            case 53 -> 190;
                            case 54 -> 13;
                            case 55 -> 171;
                            case 56 -> 37;
                            case 57 -> 71;
                            case 58 -> 84;
                            case 59 -> 43;
                            case 60 -> 170;
                            case 61 -> 237;
                            case 62 -> 86;
                            case 63 -> 103;
                            case 64 -> 92;
                            case 65 -> 4;
                            case 66 -> 35;
                            case 67 -> 147;
                            case 68 -> 102;
                            case 69 -> 220;
                            case 70 -> 16;
                            case 71 -> 50;
                            case 72 -> 54;
                            case 73 -> 3;
                            case 74 -> 99;
                            case 75 -> 61;
                            case 76 -> 145;
                            case 77 -> 204;
                            case 78 -> 221;
                            case 79 -> 100;
                            case 80 -> 126;
                            case 81 -> 251;
                            case 82 -> 188;
                            case 83 -> 253;
                            case 84 -> 181;
                            case 85 -> 97;
                            case 86 -> 243;
                            case 87 -> 70;
                            case 88 -> 152;
                            case 89 -> 32;
                            case 90 -> 217;
                            case 91 -> 74;
                            case 92 -> 192;
                            case 93 -> 193;
                            case 94 -> 33;
                            case 95 -> 69;
                            case 96 -> 165;
                            case 97 -> 111;
                            case 98 -> 150;
                            case 99 -> 186;
                            case 100 -> 223;
                            case 101 -> 185;
                            case 102 -> 211;
                            case 103 -> 40;
                            case 104 -> 67;
                            case 105 -> 11;
                            case 106 -> 178;
                            case 107 -> 118;
                            case 108 -> 153;
                            case 109 -> 7;
                            case 110 -> 66;
                            case 111 -> 166;
                            case 112 -> 1;
                            case 113 -> 29;
                            case 114 -> 173;
                            case 115 -> 195;
                            case 116 -> 155;
                            case 117 -> 232;
                            case 118 -> 20;
                            case 119 -> 124;
                            case 120 -> 189;
                            case 121 -> 46;
                            case 122 -> 9;
                            case 123 -> 55;
                            case 124 -> 201;
                            case 125 -> 179;
                            case 126 -> 215;
                            case 127 -> 10;
                            case 128 -> 98;
                            case 129 -> 197;
                            case 130 -> 137;
                            case 131 -> 207;
                            case 132 -> 184;
                            case 133 -> 210;
                            case 134 -> 12;
                            case 135 -> 89;
                            case 136 -> 239;
                            case 137 -> 169;
                            case 138 -> 175;
                            case 139 -> 127;
                            case 140 -> 105;
                            case 141 -> 148;
                            case 142 -> 196;
                            case 143 -> 167;
                            case 144 -> 64;
                            case 145 -> 88;
                            case 146 -> 78;
                            case 147 -> 0;
                            case 148 -> 62;
                            case 149 -> 177;
                            case 150 -> 231;
                            case 151 -> 180;
                            case 152 -> 238;
                            case 153 -> 218;
                            case 154 -> 76;
                            case 155 -> 119;
                            case 156 -> 168;
                            case 157 -> 23;
                            case 158 -> 151;
                            case 159 -> 63;
                            case 160 -> 96;
                            case 161 -> 249;
                            case 162 -> 164;
                            case 163 -> 49;
                            case 164 -> 187;
                            case 165 -> 90;
                            case 166 -> 110;
                            case 167 -> 121;
                            case 168 -> 144;
                            case 169 -> 83;
                            case 170 -> 47;
                            case 171 -> 134;
                            case 172 -> 233;
                            case 173 -> 112;
                            case 174 -> 113;
                            case 175 -> 87;
                            case 176 -> 82;
                            case 177 -> 81;
                            case 178 -> 154;
                            case 179 -> 140;
                            case 180 -> 27;
                            case 181 -> 208;
                            case 182 -> 107;
                            case 183 -> 240;
                            case 184 -> 142;
                            case 185 -> 241;
                            case 186 -> 80;
                            case 187 -> 235;
                            case 188 -> 93;
                            case 189 -> 161;
                            case 190 -> 48;
                            case 191 -> 198;
                            case 192 -> 200;
                            case 193 -> 51;
                            case 194 -> 205;
                            case 195 -> 8;
                            case 196 -> 133;
                            case 197 -> 60;
                            case 198 -> 162;
                            case 199 -> 36;
                            case 200 -> 157;
                            case 201 -> 68;
                            case 202 -> 41;
                            case 203 -> 244;
                            case 204 -> 44;
                            case 205 -> 141;
                            case 206 -> 138;
                            case 207 -> 18;
                            case 208 -> 28;
                            case 209 -> 247;
                            case 210 -> 248;
                            case 211 -> 115;
                            case 212 -> 130;
                            case 213 -> 225;
                            case 214 -> 146;
                            case 215 -> 123;
                            case 216 -> 199;
                            case 217 -> 59;
                            case 218 -> 75;
                            case 219 -> 52;
                            case 220 -> 229;
                            case 221 -> 39;
                            case 222 -> 236;
                            case 223 -> 24;
                            case 224 -> 216;
                            case 225 -> 219;
                            case 226 -> 194;
                            case 227 -> 58;
                            case 228 -> 222;
                            case 229 -> 149;
                            case 230 -> 128;
                            case 231 -> 213;
                            case 232 -> 79;
                            case 233 -> 191;
                            case 234 -> 5;
                            case 235 -> 56;
                            case 236 -> 17;
                            case 237 -> 53;
                            case 238 -> 212;
                            case 239 -> 230;
                            case 240 -> 14;
                            case 241 -> 206;
                            case 242 -> 122;
                            case 243 -> 73;
                            case 244 -> 234;
                            case 245 -> 139;
                            case 246 -> 2;
                            case 247 -> 255;
                            case 248 -> 143;
                            case 249 -> 25;
                            case 250 -> 136;
                            case 251 -> 42;
                            case 252 -> 174;
                            case 253 -> 85;
                            case 254 -> 120;
                            default -> 203;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.V(new int[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 65112129666097L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.n();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 == 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-425453220 - -8540, 425453220 + 3898, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-425453220 - -8544, -425453220 - -8505, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-425453220 - -8523, 425453220 - 15756, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-425453220 - -8540, 425453220 + 3898, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-425453220 - -8544, -425453220 - -8505, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-425453220 - -8516, 425453220 - 17407, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 113970837585305L;
                        int n3 = SshAgentIpcService.n();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(414574410 + 21439, -414574410 + -29734, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(414574410 + 21440, -414574410 + -((char)-29608), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 126590916208126L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = SshAgentIpcService.V();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 != 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 != 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1050132840 - -9439, 1050132840 - 5463, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1050132840 - -9435, -1050132840 - -9410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1050132840 - -9428, -1050132840 - -1239, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1050132840 - -9435, -1050132840 - -9410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1050132840 - -9437, -1050132840 + -15297, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1050132840 - -9439, 1050132840 - 5463, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1050132840 - -9435, -1050132840 - -9410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1050132840 - -9419, 1050132840 + 11132, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 != 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1050132840 - -9439, 1050132840 - 5463, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1050132840 - -9435, -1050132840 - -9410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1050132840 - -9418, 1050132840 + 14676, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 != 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1050132840 - -9439, 1050132840 - 5463, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-1050132840 - -9435, -1050132840 - -9410, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1050132840 - -9417, 1050132840 - 11578, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 75426498312751L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.n();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8964, -1717279140 + -((char)-3428), (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8960, 1717410210 - (char)-8937, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8975, 1717410210 - (char)-4000, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8980, 1717410210 - (char)-25887, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8964, -1717279140 + -((char)-3428), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8960, 1717410210 - (char)-8937, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8981, 1717410210 - (char)-829, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8964, -1717279140 + -((char)-3428), (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8960, 1717410210 - (char)-8937, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8978, -1717279140 + -((char)-242), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8964, -1717279140 + -((char)-3428), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8960, 1717410210 - (char)-8937, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8979, 1717279140 + (char)-6150, (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8964, -1717279140 + -((char)-3428), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8960, 1717410210 - (char)-8937, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8936, 1717279140 + (char)-171, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1717410210 - (char)-8937, -1717410210 - -((char)-11794), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "P\u00e0\u00a9)q\u00e4\u00f9\u001f\u0014\u0099\u0007\u00a82\u00af\u000f\u008dx\u00f8W\u0004\u00ad\"\u00c5x\u00ceW\u001d\u00bcJ\u0006\u00e1\u00b3\u009fC\u00dd\u00e8\u0018\u00bf\u0004\fb\u00b9\u00c0MA(\r\u0011\u0096\u00e6]\u00b2_\u00a7F\u008c\u00bc\u00d5[\u00e92\t\u00a2\u000e1\u0092uA\u00cc9$\u0005\u00af$V\u00b1\u00fe\baG\u008f\u00ac\u00e7r-/\u0014\u009c\u0018pJ\u00d9\bv\u000f\u00e9d\u008d\u007fY<\u00ac\u001c\u00df\u0094T9\u00050R\u00a5\u007f\u0080\u001e\u0090\u00c1\u00a4i=e\u007f\u008f\u00cb\u00c0&\u00a8L\u00baE\u00c7\u00b8\u00c4\u00bd\u0018_\u00e0\u00b4\u0088\u00da\u00f3\u00ad\u00d4]\u00e8\u0010\u001c\u00c0\u00d1\u008c\u00c4\u00eb\u00b6\u00a7\u008fw#\u00a3\u00ea\u008e>\u00de\t\u008efb\u008eL\u00e5\u00cd2\u00ea\u0010\u0096\u00b7\u0080b\u00ee6\u00f3\u001c'\u00006MHSje?\u00d4\u00ac$\u00c4 \u00d9Yt~n\u00d5\u0086\u008d\u0089@\u0098\u00ddJl\f\u00eb0Y\u00f4w\u0094\u0015\u008c}\u00b5\u0085\u00f4x\u00a8\u00be\u00d3\u0088<v\u00ce(\u008bi\u00f9\u00e1\b\u009a\u00bf\b\u00ca\u008b\u00da\u000fN5`\u00daY\u00a6C0)8\bD\u00c5+\u00fcsx\u00bfn\f\u008b}\u00c2\u00f0S\u009bU\u0015\u00dai\u00dbdF\u0000\u00db\u00b3$}\u0001\u0090Fb\u000f\u00c6ly\u00dc\u00c1\u0014\u0011\u00bc\u00f5}\u00caL~I\u00a5\b\u00bc\u0014\u00f7\u008f\u00ee\u008f)qV\u00c9O2%\u00cb\u00d1>\u00dd\u00b4\u00a9$\u00c7GD-d\u008c\u001d\u0012a\u00f0\u00cf?\u00923\u0085N\u00d2\u0085\u00bf\u00b9z\u00dc\fC\u001f\u00a2\u00d4\u00e2\u00cb\u00f51f\u0005\u00e8\u0091B\u0082\u00c0\u00e2\u00df}\u0090{\u00c5%\u009b\u00c7\u00fb\u00c7R\u00ca\u00ab?\u0080d\u0002\u000b\u0089\u001d\u0082\u00fc[\u001aT%\u00fac\u00d5\u0015Dw;\u00b2k\u00bb\u00bel\u0099\u00aaq.\u0018\u00db\u00d9\f\u00ab\u00c1\u007f\u000b\u00fa)\u00e3\u00ca\u00ca\b\u00f0I\u00c6\n\u00fcp\u00c0\u00be\u0094o\u00cb\u00c9Me\u00a5Ag3\u00a2A\u0016S\u00f4tD\u00f9\u0018\u007f\t\u00ca43\u001dp\u00e4*J\u0007\u00b9\u00ee\u008b\u0096\u00fc\u00c7\u00dc\u0007\u0087\\(\u00acoo\u00b8(\u0085\"J4P\u00a4$\u0090\u00d0\u00f4o\u0018B:S\u00e0Y\u00ed\u0089\u0013\u0083GQ\u0004\u00f8G\u009f\u008d\u001e\u00a6\u0088\u008d\u00e0\u00ff\u00978\u00d3l\u00aeZ\u000f\u00b0X\u00a2R\u00a5\u0004?G\u00c6\u0083\f\u00a7\u008e\u0099T\"\u00e2\u0098\u00eaB\u00f4\u0000F#\u00ecU\u00c2\u001a\u00d7\u00f7\u00c7\u0014'\u00f7bQu1@Q\u00d9\u0005\u00c0`\u00e6I\u00een\u00f9\u001b\u000e\u0097oF\u00b49\u00d8\u00ac\u00dc\u00b4\u00f0B\u00c9K^\u001b\u00ba\u001f\u00e4\u00bf\u0096\f\u00cc\u001a\u00ef\u00af\u00a4#\u00c75\u00e3Z\u000b\u0094Z\u00a1I\u001b\u00b4\u00b2\f\u0014/\n\u00a61\u00a3}j\u00b0\u0080\u00a7\u00cdz\u0018j\u007f\u00fe\u00be\u00d4\u0090\u00a5\u00d7\u00dc\u00df\u0000\u00b2\u00eaT\u00baWW4\u0006\u00cc\u00ba\u00fd\u0091=)q\u00aa\u0098\u0004\u00ba\u00c8\u008f:\u00d5v\u00e5~4~@\u0090B;\u009bO\u009a\u00e2Tw\u00bd\u0007\u001c\u0012\nij\u00fcbd\u008cr\u00d4|\u00dd\u00abm\tx=\u00bc\u00fb\u009d\u0084\u00a1E\u00da";
                var4_3 = "P\u00e0\u00a9)q\u00e4\u00f9\u001f\u0014\u0099\u0007\u00a82\u00af\u000f\u008dx\u00f8W\u0004\u00ad\"\u00c5x\u00ceW\u001d\u00bcJ\u0006\u00e1\u00b3\u009fC\u00dd\u00e8\u0018\u00bf\u0004\fb\u00b9\u00c0MA(\r\u0011\u0096\u00e6]\u00b2_\u00a7F\u008c\u00bc\u00d5[\u00e92\t\u00a2\u000e1\u0092uA\u00cc9$\u0005\u00af$V\u00b1\u00fe\baG\u008f\u00ac\u00e7r-/\u0014\u009c\u0018pJ\u00d9\bv\u000f\u00e9d\u008d\u007fY<\u00ac\u001c\u00df\u0094T9\u00050R\u00a5\u007f\u0080\u001e\u0090\u00c1\u00a4i=e\u007f\u008f\u00cb\u00c0&\u00a8L\u00baE\u00c7\u00b8\u00c4\u00bd\u0018_\u00e0\u00b4\u0088\u00da\u00f3\u00ad\u00d4]\u00e8\u0010\u001c\u00c0\u00d1\u008c\u00c4\u00eb\u00b6\u00a7\u008fw#\u00a3\u00ea\u008e>\u00de\t\u008efb\u008eL\u00e5\u00cd2\u00ea\u0010\u0096\u00b7\u0080b\u00ee6\u00f3\u001c'\u00006MHSje?\u00d4\u00ac$\u00c4 \u00d9Yt~n\u00d5\u0086\u008d\u0089@\u0098\u00ddJl\f\u00eb0Y\u00f4w\u0094\u0015\u008c}\u00b5\u0085\u00f4x\u00a8\u00be\u00d3\u0088<v\u00ce(\u008bi\u00f9\u00e1\b\u009a\u00bf\b\u00ca\u008b\u00da\u000fN5`\u00daY\u00a6C0)8\bD\u00c5+\u00fcsx\u00bfn\f\u008b}\u00c2\u00f0S\u009bU\u0015\u00dai\u00dbdF\u0000\u00db\u00b3$}\u0001\u0090Fb\u000f\u00c6ly\u00dc\u00c1\u0014\u0011\u00bc\u00f5}\u00caL~I\u00a5\b\u00bc\u0014\u00f7\u008f\u00ee\u008f)qV\u00c9O2%\u00cb\u00d1>\u00dd\u00b4\u00a9$\u00c7GD-d\u008c\u001d\u0012a\u00f0\u00cf?\u00923\u0085N\u00d2\u0085\u00bf\u00b9z\u00dc\fC\u001f\u00a2\u00d4\u00e2\u00cb\u00f51f\u0005\u00e8\u0091B\u0082\u00c0\u00e2\u00df}\u0090{\u00c5%\u009b\u00c7\u00fb\u00c7R\u00ca\u00ab?\u0080d\u0002\u000b\u0089\u001d\u0082\u00fc[\u001aT%\u00fac\u00d5\u0015Dw;\u00b2k\u00bb\u00bel\u0099\u00aaq.\u0018\u00db\u00d9\f\u00ab\u00c1\u007f\u000b\u00fa)\u00e3\u00ca\u00ca\b\u00f0I\u00c6\n\u00fcp\u00c0\u00be\u0094o\u00cb\u00c9Me\u00a5Ag3\u00a2A\u0016S\u00f4tD\u00f9\u0018\u007f\t\u00ca43\u001dp\u00e4*J\u0007\u00b9\u00ee\u008b\u0096\u00fc\u00c7\u00dc\u0007\u0087\\(\u00acoo\u00b8(\u0085\"J4P\u00a4$\u0090\u00d0\u00f4o\u0018B:S\u00e0Y\u00ed\u0089\u0013\u0083GQ\u0004\u00f8G\u009f\u008d\u001e\u00a6\u0088\u008d\u00e0\u00ff\u00978\u00d3l\u00aeZ\u000f\u00b0X\u00a2R\u00a5\u0004?G\u00c6\u0083\f\u00a7\u008e\u0099T\"\u00e2\u0098\u00eaB\u00f4\u0000F#\u00ecU\u00c2\u001a\u00d7\u00f7\u00c7\u0014'\u00f7bQu1@Q\u00d9\u0005\u00c0`\u00e6I\u00een\u00f9\u001b\u000e\u0097oF\u00b49\u00d8\u00ac\u00dc\u00b4\u00f0B\u00c9K^\u001b\u00ba\u001f\u00e4\u00bf\u0096\f\u00cc\u001a\u00ef\u00af\u00a4#\u00c75\u00e3Z\u000b\u0094Z\u00a1I\u001b\u00b4\u00b2\f\u0014/\n\u00a61\u00a3}j\u00b0\u0080\u00a7\u00cdz\u0018j\u007f\u00fe\u00be\u00d4\u0090\u00a5\u00d7\u00dc\u00df\u0000\u00b2\u00eaT\u00baWW4\u0006\u00cc\u00ba\u00fd\u0091=)q\u00aa\u0098\u0004\u00ba\u00c8\u008f:\u00d5v\u00e5~4~@\u0090B;\u009bO\u009a\u00e2Tw\u00bd\u0007\u001c\u0012\nij\u00fcbd\u008cr\u00d4|\u00dd\u00abm\tx=\u00bc\u00fb\u009d\u0084\u00a1E\u00da".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 104;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "J\u00a1\u00f0j\u00b8\n\u00c0m3\u00936\u00cdA\u0007\u00e1\u00b0y<\u00a3$\u00c7\u00bf\u0003\r\u00f3[K\u00d3\u007f\u0014\u00f3\u00d0\u00ea\u00c7\u00e8\u00bejA\u000b\u007fu\u00a7\u0003\u008bS\b=\u00ca\u00fe\u00bf";
                    var4_3 = "J\u00a1\u00f0j\u00b8\n\u00c0m3\u00936\u00cdA\u0007\u00e1\u00b0y<\u00a3$\u00c7\u00bf\u0003\r\u00f3[K\u00d3\u007f\u0014\u00f3\u00d0\u00ea\u00c7\u00e8\u00bejA\u000b\u007fu\u00a7\u0003\u008bS\b=\u00ca\u00fe\u00bf".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 11;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 6;
                            break;
                        }
                        case 1: {
                            v15 = 3;
                            break;
                        }
                        case 2: {
                            v15 = 8;
                            break;
                        }
                        case 3: {
                            v15 = 17;
                            break;
                        }
                        case 4: {
                            v15 = 14;
                            break;
                        }
                        case 5: {
                            v15 = 46;
                            break;
                        }
                        default: {
                            v15 = 93;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC685) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 43;
                case 1 -> 241;
                case 2 -> 201;
                case 3 -> 68;
                case 4 -> 178;
                case 5 -> 44;
                case 6 -> 3;
                case 7 -> 36;
                case 8 -> 124;
                case 9 -> 41;
                case 10 -> 78;
                case 11 -> 250;
                case 12 -> 166;
                case 13 -> 225;
                case 14 -> 205;
                case 15 -> 230;
                case 16 -> 232;
                case 17 -> 212;
                case 18 -> 28;
                case 19 -> 64;
                case 20 -> 254;
                case 21 -> 158;
                case 22 -> 133;
                case 23 -> 167;
                case 24 -> 12;
                case 25 -> 69;
                case 26 -> 48;
                case 27 -> 42;
                case 28 -> 147;
                case 29 -> 165;
                case 30 -> 190;
                case 31 -> 60;
                case 32 -> 37;
                case 33 -> 191;
                case 34 -> 196;
                case 35 -> 88;
                case 36 -> 234;
                case 37 -> 5;
                case 38 -> 236;
                case 39 -> 249;
                case 40 -> 99;
                case 41 -> 235;
                case 42 -> 25;
                case 43 -> 56;
                case 44 -> 231;
                case 45 -> 47;
                case 46 -> 173;
                case 47 -> 109;
                case 48 -> 27;
                case 49 -> 188;
                case 50 -> 187;
                case 51 -> 123;
                case 52 -> 91;
                case 53 -> 146;
                case 54 -> 170;
                case 55 -> 171;
                case 56 -> 9;
                case 57 -> 160;
                case 58 -> 162;
                case 59 -> 135;
                case 60 -> 34;
                case 61 -> 253;
                case 62 -> 95;
                case 63 -> 63;
                case 64 -> 211;
                case 65 -> 139;
                case 66 -> 200;
                case 67 -> 192;
                case 68 -> 202;
                case 69 -> 81;
                case 70 -> 7;
                case 71 -> 89;
                case 72 -> 208;
                case 73 -> 150;
                case 74 -> 67;
                case 75 -> 51;
                case 76 -> 82;
                case 77 -> 122;
                case 78 -> 149;
                case 79 -> 136;
                case 80 -> 97;
                case 81 -> 24;
                case 82 -> 252;
                case 83 -> 77;
                case 84 -> 143;
                case 85 -> 119;
                case 86 -> 39;
                case 87 -> 137;
                case 88 -> 227;
                case 89 -> 110;
                case 90 -> 52;
                case 91 -> 243;
                case 92 -> 114;
                case 93 -> 22;
                case 94 -> 118;
                case 95 -> 72;
                case 96 -> 223;
                case 97 -> 62;
                case 98 -> 177;
                case 99 -> 247;
                case 100 -> 155;
                case 101 -> 93;
                case 102 -> 86;
                case 103 -> 209;
                case 104 -> 204;
                case 105 -> 132;
                case 106 -> 87;
                case 107 -> 138;
                case 108 -> 206;
                case 109 -> 1;
                case 110 -> 128;
                case 111 -> 121;
                case 112 -> 85;
                case 113 -> 189;
                case 114 -> 49;
                case 115 -> 224;
                case 116 -> 220;
                case 117 -> 242;
                case 118 -> 83;
                case 119 -> 117;
                case 120 -> 30;
                case 121 -> 55;
                case 122 -> 96;
                case 123 -> 180;
                case 124 -> 216;
                case 125 -> 215;
                case 126 -> 73;
                case 127 -> 18;
                case 128 -> 84;
                case 129 -> 161;
                case 130 -> 94;
                case 131 -> 164;
                case 132 -> 176;
                case 133 -> 251;
                case 134 -> 229;
                case 135 -> 174;
                case 136 -> 144;
                case 137 -> 40;
                case 138 -> 182;
                case 139 -> 181;
                case 140 -> 140;
                case 141 -> 221;
                case 142 -> 74;
                case 143 -> 20;
                case 144 -> 15;
                case 145 -> 14;
                case 146 -> 105;
                case 147 -> 154;
                case 148 -> 35;
                case 149 -> 112;
                case 150 -> 92;
                case 151 -> 218;
                case 152 -> 131;
                case 153 -> 169;
                case 154 -> 0;
                case 155 -> 255;
                case 156 -> 226;
                case 157 -> 246;
                case 158 -> 153;
                case 159 -> 238;
                case 160 -> 100;
                case 161 -> 111;
                case 162 -> 134;
                case 163 -> 126;
                case 164 -> 207;
                case 165 -> 141;
                case 166 -> 104;
                case 167 -> 203;
                case 168 -> 199;
                case 169 -> 125;
                case 170 -> 240;
                case 171 -> 142;
                case 172 -> 61;
                case 173 -> 145;
                case 174 -> 237;
                case 175 -> 115;
                case 176 -> 222;
                case 177 -> 4;
                case 178 -> 193;
                case 179 -> 76;
                case 180 -> 233;
                case 181 -> 156;
                case 182 -> 184;
                case 183 -> 26;
                case 184 -> 103;
                case 185 -> 101;
                case 186 -> 214;
                case 187 -> 21;
                case 188 -> 151;
                case 189 -> 32;
                case 190 -> 210;
                case 191 -> 168;
                case 192 -> 148;
                case 193 -> 8;
                case 194 -> 71;
                case 195 -> 106;
                case 196 -> 186;
                case 197 -> 217;
                case 198 -> 120;
                case 199 -> 163;
                case 200 -> 10;
                case 201 -> 194;
                case 202 -> 59;
                case 203 -> 57;
                case 204 -> 58;
                case 205 -> 102;
                case 206 -> 79;
                case 207 -> 248;
                case 208 -> 213;
                case 209 -> 116;
                case 210 -> 29;
                case 211 -> 157;
                case 212 -> 127;
                case 213 -> 113;
                case 214 -> 19;
                case 215 -> 98;
                case 216 -> 50;
                case 217 -> 16;
                case 218 -> 23;
                case 219 -> 108;
                case 220 -> 130;
                case 221 -> 197;
                case 222 -> 54;
                case 223 -> 219;
                case 224 -> 2;
                case 225 -> 75;
                case 226 -> 53;
                case 227 -> 70;
                case 228 -> 159;
                case 229 -> 185;
                case 230 -> 90;
                case 231 -> 175;
                case 232 -> 33;
                case 233 -> 45;
                case 234 -> 46;
                case 235 -> 198;
                case 236 -> 6;
                case 237 -> 244;
                case 238 -> 66;
                case 239 -> 183;
                case 240 -> 152;
                case 241 -> 239;
                case 242 -> 245;
                case 243 -> 31;
                case 244 -> 38;
                case 245 -> 17;
                case 246 -> 129;
                case 247 -> 107;
                case 248 -> 80;
                case 249 -> 13;
                case 250 -> 65;
                case 251 -> 179;
                case 252 -> 195;
                case 253 -> 228;
                case 254 -> 172;
                default -> 11;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 48307017382937L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1520149860 + (char)-17007, 1520149860 + 25926, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 9845044931386L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.n();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(979879320 + 12351, 979879320 + 8104, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(979879320 + 12348, -979879320 - -2899, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(979879320 + 12349, 979879320 - 17219, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00ffx\u00c3AA;W.\u0010>\u00db\n\u0094\u00c2:\u00deW\u00d9\u00f6\u0092\u00ee\u000e\u008fh\u00a5";
                    var4_3 = "\u00ffx\u00c3AA;W.\u0010>\u00db\n\u0094\u00c2:\u00deW\u00d9\u00f6\u0092\u00ee\u000e\u008fh\u00a5".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 78;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ff\u00e8}\u00edX5\u00fb\u00b4\u00ea\nxn/\u00c8.\u0000@N\u001d\u00cf\u00b1\u0099\u00dcf\u0018to\u00ce\u0080^\u00e8\u00ad\u0095\u0097\u0089\u0003\u00eb\u00a0\u008a\u00f2\u00f2\u00ad!\u00f8\u00c2\u00feb\u00b4\u00c3\u0013\u00c0{\u008f/\bZ}\u00ccQ";
                        var4_3 = "\u00ff\u00e8}\u00edX5\u00fb\u00b4\u00ea\nxn/\u00c8.\u0000@N\u001d\u00cf\u00b1\u0099\u00dcf\u0018to\u00ce\u0080^\u00e8\u00ad\u0095\u0097\u0089\u0003\u00eb\u00a0\u008a\u00f2\u00f2\u00ad!\u00f8\u00c2\u00feb\u00b4\u00c3\u0013\u00c0{\u008f/\bZ}\u00ccQ".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 83;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 68;
                                break;
                            }
                            case 1: {
                                v15 = 23;
                                break;
                            }
                            case 2: {
                                v15 = 61;
                                break;
                            }
                            case 3: {
                                v15 = 10;
                                break;
                            }
                            case 4: {
                                v15 = 55;
                                break;
                            }
                            case 5: {
                                v15 = 125;
                                break;
                            }
                            default: {
                                v15 = 48;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x1EEC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 186;
                    case 1 -> 42;
                    case 2 -> 242;
                    case 3 -> 205;
                    case 4 -> 245;
                    case 5 -> 99;
                    case 6 -> 154;
                    case 7 -> 33;
                    case 8 -> 230;
                    case 9 -> 29;
                    case 10 -> 48;
                    case 11 -> 140;
                    case 12 -> 229;
                    case 13 -> 238;
                    case 14 -> 79;
                    case 15 -> 175;
                    case 16 -> 10;
                    case 17 -> 239;
                    case 18 -> 190;
                    case 19 -> 212;
                    case 20 -> 227;
                    case 21 -> 12;
                    case 22 -> 27;
                    case 23 -> 54;
                    case 24 -> 101;
                    case 25 -> 52;
                    case 26 -> 20;
                    case 27 -> 138;
                    case 28 -> 84;
                    case 29 -> 173;
                    case 30 -> 155;
                    case 31 -> 232;
                    case 32 -> 167;
                    case 33 -> 237;
                    case 34 -> 200;
                    case 35 -> 74;
                    case 36 -> 255;
                    case 37 -> 152;
                    case 38 -> 0;
                    case 39 -> 60;
                    case 40 -> 142;
                    case 41 -> 98;
                    case 42 -> 132;
                    case 43 -> 76;
                    case 44 -> 119;
                    case 45 -> 91;
                    case 46 -> 147;
                    case 47 -> 253;
                    case 48 -> 244;
                    case 49 -> 118;
                    case 50 -> 11;
                    case 51 -> 56;
                    case 52 -> 39;
                    case 53 -> 206;
                    case 54 -> 81;
                    case 55 -> 105;
                    case 56 -> 100;
                    case 57 -> 231;
                    case 58 -> 243;
                    case 59 -> 61;
                    case 60 -> 82;
                    case 61 -> 35;
                    case 62 -> 50;
                    case 63 -> 15;
                    case 64 -> 234;
                    case 65 -> 13;
                    case 66 -> 90;
                    case 67 -> 202;
                    case 68 -> 8;
                    case 69 -> 166;
                    case 70 -> 133;
                    case 71 -> 236;
                    case 72 -> 193;
                    case 73 -> 24;
                    case 74 -> 96;
                    case 75 -> 137;
                    case 76 -> 217;
                    case 77 -> 226;
                    case 78 -> 179;
                    case 79 -> 224;
                    case 80 -> 221;
                    case 81 -> 251;
                    case 82 -> 188;
                    case 83 -> 14;
                    case 84 -> 128;
                    case 85 -> 93;
                    case 86 -> 139;
                    case 87 -> 3;
                    case 88 -> 196;
                    case 89 -> 22;
                    case 90 -> 129;
                    case 91 -> 65;
                    case 92 -> 168;
                    case 93 -> 7;
                    case 94 -> 16;
                    case 95 -> 131;
                    case 96 -> 254;
                    case 97 -> 113;
                    case 98 -> 149;
                    case 99 -> 97;
                    case 100 -> 80;
                    case 101 -> 124;
                    case 102 -> 123;
                    case 103 -> 78;
                    case 104 -> 106;
                    case 105 -> 69;
                    case 106 -> 66;
                    case 107 -> 19;
                    case 108 -> 51;
                    case 109 -> 55;
                    case 110 -> 126;
                    case 111 -> 102;
                    case 112 -> 121;
                    case 113 -> 107;
                    case 114 -> 89;
                    case 115 -> 103;
                    case 116 -> 70;
                    case 117 -> 21;
                    case 118 -> 95;
                    case 119 -> 1;
                    case 120 -> 189;
                    case 121 -> 201;
                    case 122 -> 41;
                    case 123 -> 165;
                    case 124 -> 194;
                    case 125 -> 225;
                    case 126 -> 18;
                    case 127 -> 36;
                    case 128 -> 34;
                    case 129 -> 145;
                    case 130 -> 136;
                    case 131 -> 156;
                    case 132 -> 195;
                    case 133 -> 58;
                    case 134 -> 57;
                    case 135 -> 87;
                    case 136 -> 43;
                    case 137 -> 68;
                    case 138 -> 235;
                    case 139 -> 92;
                    case 140 -> 228;
                    case 141 -> 71;
                    case 142 -> 159;
                    case 143 -> 248;
                    case 144 -> 161;
                    case 145 -> 73;
                    case 146 -> 53;
                    case 147 -> 108;
                    case 148 -> 163;
                    case 149 -> 246;
                    case 150 -> 182;
                    case 151 -> 192;
                    case 152 -> 86;
                    case 153 -> 247;
                    case 154 -> 25;
                    case 155 -> 85;
                    case 156 -> 31;
                    case 157 -> 64;
                    case 158 -> 199;
                    case 159 -> 38;
                    case 160 -> 30;
                    case 161 -> 185;
                    case 162 -> 250;
                    case 163 -> 146;
                    case 164 -> 5;
                    case 165 -> 215;
                    case 166 -> 49;
                    case 167 -> 77;
                    case 168 -> 115;
                    case 169 -> 117;
                    case 170 -> 204;
                    case 171 -> 164;
                    case 172 -> 104;
                    case 173 -> 213;
                    case 174 -> 47;
                    case 175 -> 26;
                    case 176 -> 37;
                    case 177 -> 211;
                    case 178 -> 207;
                    case 179 -> 28;
                    case 180 -> 160;
                    case 181 -> 88;
                    case 182 -> 23;
                    case 183 -> 180;
                    case 184 -> 191;
                    case 185 -> 174;
                    case 186 -> 216;
                    case 187 -> 170;
                    case 188 -> 144;
                    case 189 -> 241;
                    case 190 -> 59;
                    case 191 -> 6;
                    case 192 -> 141;
                    case 193 -> 151;
                    case 194 -> 181;
                    case 195 -> 130;
                    case 196 -> 158;
                    case 197 -> 112;
                    case 198 -> 223;
                    case 199 -> 44;
                    case 200 -> 17;
                    case 201 -> 143;
                    case 202 -> 249;
                    case 203 -> 240;
                    case 204 -> 162;
                    case 205 -> 187;
                    case 206 -> 116;
                    case 207 -> 222;
                    case 208 -> 75;
                    case 209 -> 184;
                    case 210 -> 67;
                    case 211 -> 120;
                    case 212 -> 197;
                    case 213 -> 198;
                    case 214 -> 210;
                    case 215 -> 114;
                    case 216 -> 109;
                    case 217 -> 125;
                    case 218 -> 135;
                    case 219 -> 122;
                    case 220 -> 171;
                    case 221 -> 4;
                    case 222 -> 150;
                    case 223 -> 148;
                    case 224 -> 111;
                    case 225 -> 127;
                    case 226 -> 177;
                    case 227 -> 32;
                    case 228 -> 178;
                    case 229 -> 172;
                    case 230 -> 157;
                    case 231 -> 9;
                    case 232 -> 233;
                    case 233 -> 183;
                    case 234 -> 220;
                    case 235 -> 40;
                    case 236 -> 153;
                    case 237 -> 169;
                    case 238 -> 45;
                    case 239 -> 62;
                    case 240 -> 2;
                    case 241 -> 94;
                    case 242 -> 176;
                    case 243 -> 219;
                    case 244 -> 208;
                    case 245 -> 46;
                    case 246 -> 214;
                    case 247 -> 83;
                    case 248 -> 110;
                    case 249 -> 134;
                    case 250 -> 72;
                    case 251 -> 209;
                    case 252 -> 63;
                    case 253 -> 218;
                    case 254 -> 252;
                    default -> 203;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 39706623364300L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "o&\b.>\u000fc6\th,\u001b$sM~*j";
                    var5_4 = "o&\b.>\u000fc6\th,\u001b$sM~*j".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 50;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 54;
                                    break;
                                }
                                case 1: {
                                    v11 = 113;
                                    break;
                                }
                                case 2: {
                                    v11 = 72;
                                    break;
                                }
                                case 3: {
                                    v11 = 114;
                                    break;
                                }
                                case 4: {
                                    v11 = 105;
                                    break;
                                }
                                case 5: {
                                    v11 = 81;
                                    break;
                                }
                                default: {
                                    v11 = 98;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 42324960327363L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = ">\\\u007f.\u000bO\u0014\u00048Bs4\n4]x4\u0007M\f\u001e\\q\t4]x4\u0007M\f\u0012V\r3[e9\r@\u0016\u0012Qb3\fI";
                    var5_4 = ">\\\u007f.\u000bO\u0014\u00048Bs4\n4]x4\u0007M\f\u001e\\q\t4]x4\u0007M\f\u0012V\r3[e9\r@\u0016\u0012Qb3\fI".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 27;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "9St$\u0006M\u0012\u00069St$\nG";
                        var5_4 = "9St$\u0006M\u0012\u00069St$\nG".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 22;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 108;
                                break;
                            }
                            case 1: {
                                v15 = 41;
                                break;
                            }
                            case 2: {
                                v15 = 13;
                                break;
                            }
                            case 3: {
                                v15 = 65;
                                break;
                            }
                            case 4: {
                                v15 = 121;
                                break;
                            }
                            case 5: {
                                v15 = 53;
                                break;
                            }
                            default: {
                                v15 = 99;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 70664876727679L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(220197600 - 26012, -220197600 - -26865, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 76721785024025L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "BQ\u00a8$S\u0003\u0093~&\u0005B\u00c5\u008ert\rkF\u009dH\u00e3B\u0004\u00b8\u00b0u\u00d8?\u00d7\u0010yv\u0018\u00a5lj\u00de\u0080\"\u00f6i\u0002\u0007\u00c7\u0094W\u00059\u00dc\u00e1Q\u00993\u007f38\u00db\u00bd\u00e1\u00d4\u00e5\u001e\u00a7e\u0001@\u00f6Pn\u0094\u00b94G&\u00cd\u008a\u00f2X\u00f5\u00a2\u00a1\u00b24\u00f7!\u009a\u00ac{n\u00af\u0086\u0099i\\wv\u001cC\u00d2\u00c3\u00f8c\u00f3\u00a5";
                    var4_3 = "BQ\u00a8$S\u0003\u0093~&\u0005B\u00c5\u008ert\rkF\u009dH\u00e3B\u0004\u00b8\u00b0u\u00d8?\u00d7\u0010yv\u0018\u00a5lj\u00de\u0080\"\u00f6i\u0002\u0007\u00c7\u0094W\u00059\u00dc\u00e1Q\u00993\u007f38\u00db\u00bd\u00e1\u00d4\u00e5\u001e\u00a7e\u0001@\u00f6Pn\u0094\u00b94G&\u00cd\u008a\u00f2X\u00f5\u00a2\u00a1\u00b24\u00f7!\u009a\u00ac{n\u00af\u0086\u0099i\\wv\u001cC\u00d2\u00c3\u00f8c\u00f3\u00a5".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 39;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "H\u00f3hC4\u00e0\u0083\u0087\u00df@\u0080\u0082l\u0081\u00af\u00c9L\u00d4\u00f4\fi\u0092m9X\u0001(\u00f76\u008c\u0099 \u00b3\u00c9\u00856`X\u001b9\u00dc[\u008d\u00b1>|\u00d8\u0097\u0085\u00d0\u0080\u0015\u00a1\u0006\u00f7\u00c0w\u0017\u001f\u0086:\u001e\u009e\u00f5\u001f\u0001mW\u00ac\u0012\u009e\u009b\u00a3J\u0003H\u0098\u001e\u00d8~c\u00a9V\u00eb\u0087eTK\u00daK\u0097k\u00b5";
                        var4_3 = "H\u00f3hC4\u00e0\u0083\u0087\u00df@\u0080\u0082l\u0081\u00af\u00c9L\u00d4\u00f4\fi\u0092m9X\u0001(\u00f76\u008c\u0099 \u00b3\u00c9\u00856`X\u001b9\u00dc[\u008d\u00b1>|\u00d8\u0097\u0085\u00d0\u0080\u0015\u00a1\u0006\u00f7\u00c0w\u0017\u001f\u0086:\u001e\u009e\u00f5\u001f\u0001mW\u00ac\u0012\u009e\u009b\u00a3J\u0003H\u0098\u001e\u00d8~c\u00a9V\u00eb\u0087eTK\u00daK\u0097k\u00b5".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 94;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 18;
                                break;
                            }
                            case 1: {
                                v15 = 2;
                                break;
                            }
                            case 2: {
                                v15 = 73;
                                break;
                            }
                            case 3: {
                                v15 = 104;
                                break;
                            }
                            case 4: {
                                v15 = 17;
                                break;
                            }
                            case 5: {
                                v15 = 3;
                                break;
                            }
                            default: {
                                v15 = 101;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF903B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 92;
                    case 1 -> 83;
                    case 2 -> 170;
                    case 3 -> 210;
                    case 4 -> 33;
                    case 5 -> 135;
                    case 6 -> 243;
                    case 7 -> 157;
                    case 8 -> 49;
                    case 9 -> 228;
                    case 10 -> 230;
                    case 11 -> 41;
                    case 12 -> 193;
                    case 13 -> 105;
                    case 14 -> 172;
                    case 15 -> 37;
                    case 16 -> 121;
                    case 17 -> 240;
                    case 18 -> 201;
                    case 19 -> 187;
                    case 20 -> 103;
                    case 21 -> 32;
                    case 22 -> 219;
                    case 23 -> 189;
                    case 24 -> 60;
                    case 25 -> 38;
                    case 26 -> 51;
                    case 27 -> 208;
                    case 28 -> 31;
                    case 29 -> 162;
                    case 30 -> 171;
                    case 31 -> 3;
                    case 32 -> 124;
                    case 33 -> 156;
                    case 34 -> 139;
                    case 35 -> 126;
                    case 36 -> 52;
                    case 37 -> 211;
                    case 38 -> 140;
                    case 39 -> 21;
                    case 40 -> 129;
                    case 41 -> 30;
                    case 42 -> 229;
                    case 43 -> 5;
                    case 44 -> 221;
                    case 45 -> 13;
                    case 46 -> 161;
                    case 47 -> 81;
                    case 48 -> 242;
                    case 49 -> 249;
                    case 50 -> 145;
                    case 51 -> 231;
                    case 52 -> 244;
                    case 53 -> 43;
                    case 54 -> 2;
                    case 55 -> 180;
                    case 56 -> 152;
                    case 57 -> 93;
                    case 58 -> 100;
                    case 59 -> 110;
                    case 60 -> 253;
                    case 61 -> 197;
                    case 62 -> 0;
                    case 63 -> 158;
                    case 64 -> 178;
                    case 65 -> 202;
                    case 66 -> 246;
                    case 67 -> 39;
                    case 68 -> 102;
                    case 69 -> 213;
                    case 70 -> 143;
                    case 71 -> 225;
                    case 72 -> 196;
                    case 73 -> 134;
                    case 74 -> 23;
                    case 75 -> 176;
                    case 76 -> 9;
                    case 77 -> 204;
                    case 78 -> 34;
                    case 79 -> 4;
                    case 80 -> 169;
                    case 81 -> 86;
                    case 82 -> 141;
                    case 83 -> 198;
                    case 84 -> 80;
                    case 85 -> 136;
                    case 86 -> 120;
                    case 87 -> 127;
                    case 88 -> 148;
                    case 89 -> 247;
                    case 90 -> 184;
                    case 91 -> 69;
                    case 92 -> 137;
                    case 93 -> 20;
                    case 94 -> 67;
                    case 95 -> 111;
                    case 96 -> 232;
                    case 97 -> 66;
                    case 98 -> 25;
                    case 99 -> 96;
                    case 100 -> 241;
                    case 101 -> 85;
                    case 102 -> 45;
                    case 103 -> 234;
                    case 104 -> 192;
                    case 105 -> 97;
                    case 106 -> 132;
                    case 107 -> 91;
                    case 108 -> 6;
                    case 109 -> 89;
                    case 110 -> 35;
                    case 111 -> 113;
                    case 112 -> 8;
                    case 113 -> 142;
                    case 114 -> 144;
                    case 115 -> 248;
                    case 116 -> 182;
                    case 117 -> 251;
                    case 118 -> 153;
                    case 119 -> 88;
                    case 120 -> 29;
                    case 121 -> 199;
                    case 122 -> 82;
                    case 123 -> 138;
                    case 124 -> 71;
                    case 125 -> 78;
                    case 126 -> 205;
                    case 127 -> 181;
                    case 128 -> 147;
                    case 129 -> 183;
                    case 130 -> 146;
                    case 131 -> 128;
                    case 132 -> 79;
                    case 133 -> 112;
                    case 134 -> 108;
                    case 135 -> 119;
                    case 136 -> 76;
                    case 137 -> 11;
                    case 138 -> 7;
                    case 139 -> 130;
                    case 140 -> 99;
                    case 141 -> 56;
                    case 142 -> 109;
                    case 143 -> 117;
                    case 144 -> 163;
                    case 145 -> 116;
                    case 146 -> 84;
                    case 147 -> 54;
                    case 148 -> 173;
                    case 149 -> 200;
                    case 150 -> 59;
                    case 151 -> 149;
                    case 152 -> 236;
                    case 153 -> 28;
                    case 154 -> 1;
                    case 155 -> 168;
                    case 156 -> 19;
                    case 157 -> 87;
                    case 158 -> 15;
                    case 159 -> 151;
                    case 160 -> 77;
                    case 161 -> 166;
                    case 162 -> 95;
                    case 163 -> 133;
                    case 164 -> 179;
                    case 165 -> 220;
                    case 166 -> 72;
                    case 167 -> 65;
                    case 168 -> 118;
                    case 169 -> 94;
                    case 170 -> 22;
                    case 171 -> 12;
                    case 172 -> 48;
                    case 173 -> 212;
                    case 174 -> 98;
                    case 175 -> 167;
                    case 176 -> 74;
                    case 177 -> 90;
                    case 178 -> 164;
                    case 179 -> 73;
                    case 180 -> 42;
                    case 181 -> 233;
                    case 182 -> 215;
                    case 183 -> 26;
                    case 184 -> 61;
                    case 185 -> 154;
                    case 186 -> 209;
                    case 187 -> 106;
                    case 188 -> 123;
                    case 189 -> 224;
                    case 190 -> 57;
                    case 191 -> 250;
                    case 192 -> 44;
                    case 193 -> 46;
                    case 194 -> 185;
                    case 195 -> 125;
                    case 196 -> 223;
                    case 197 -> 155;
                    case 198 -> 190;
                    case 199 -> 239;
                    case 200 -> 16;
                    case 201 -> 252;
                    case 202 -> 63;
                    case 203 -> 188;
                    case 204 -> 53;
                    case 205 -> 68;
                    case 206 -> 70;
                    case 207 -> 47;
                    case 208 -> 36;
                    case 209 -> 17;
                    case 210 -> 216;
                    case 211 -> 217;
                    case 212 -> 235;
                    case 213 -> 165;
                    case 214 -> 159;
                    case 215 -> 62;
                    case 216 -> 191;
                    case 217 -> 150;
                    case 218 -> 194;
                    case 219 -> 203;
                    case 220 -> 227;
                    case 221 -> 254;
                    case 222 -> 218;
                    case 223 -> 55;
                    case 224 -> 174;
                    case 225 -> 175;
                    case 226 -> 207;
                    case 227 -> 114;
                    case 228 -> 206;
                    case 229 -> 237;
                    case 230 -> 104;
                    case 231 -> 245;
                    case 232 -> 18;
                    case 233 -> 186;
                    case 234 -> 24;
                    case 235 -> 238;
                    case 236 -> 115;
                    case 237 -> 58;
                    case 238 -> 64;
                    case 239 -> 10;
                    case 240 -> 27;
                    case 241 -> 131;
                    case 242 -> 107;
                    case 243 -> 160;
                    case 244 -> 177;
                    case 245 -> 255;
                    case 246 -> 122;
                    case 247 -> 50;
                    case 248 -> 101;
                    case 249 -> 14;
                    case 250 -> 195;
                    case 251 -> 40;
                    case 252 -> 222;
                    case 253 -> 226;
                    case 254 -> 75;
                    default -> 214;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 76351960724880L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(327150720 - 30733, 327150720 - (char)-14472, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 53404565909960L;
                    int n3 = SshAgentIpcService.n();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(942524370 + (char)-22440, 942524370 + 25053, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 124607595740138L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0082:\u00a1\u00fdu\u0003~\u0088h";
                var4_3 = "\u0082:\u00a1\u00fdu\u0003~\u0088h".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 6;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 49;
                                break;
                            }
                            case 1: {
                                v11 = 23;
                                break;
                            }
                            case 2: {
                                v11 = 57;
                                break;
                            }
                            case 3: {
                                v11 = 123;
                                break;
                            }
                            case 4: {
                                v11 = 29;
                                break;
                            }
                            case 5: {
                                v11 = 85;
                                break;
                            }
                            default: {
                                v11 = 50;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x41E3) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 11;
                    case 1 -> 172;
                    case 2 -> 100;
                    case 3 -> 102;
                    case 4 -> 121;
                    case 5 -> 90;
                    case 6 -> 39;
                    case 7 -> 131;
                    case 8 -> 162;
                    case 9 -> 14;
                    case 10 -> 185;
                    case 11 -> 236;
                    case 12 -> 69;
                    case 13 -> 103;
                    case 14 -> 169;
                    case 15 -> 111;
                    case 16 -> 87;
                    case 17 -> 227;
                    case 18 -> 75;
                    case 19 -> 0;
                    case 20 -> 53;
                    case 21 -> 129;
                    case 22 -> 86;
                    case 23 -> 125;
                    case 24 -> 66;
                    case 25 -> 130;
                    case 26 -> 117;
                    case 27 -> 60;
                    case 28 -> 202;
                    case 29 -> 254;
                    case 30 -> 235;
                    case 31 -> 33;
                    case 32 -> 120;
                    case 33 -> 203;
                    case 34 -> 104;
                    case 35 -> 134;
                    case 36 -> 139;
                    case 37 -> 55;
                    case 38 -> 160;
                    case 39 -> 183;
                    case 40 -> 240;
                    case 41 -> 132;
                    case 42 -> 27;
                    case 43 -> 246;
                    case 44 -> 67;
                    case 45 -> 168;
                    case 46 -> 188;
                    case 47 -> 37;
                    case 48 -> 25;
                    case 49 -> 181;
                    case 50 -> 250;
                    case 51 -> 29;
                    case 52 -> 105;
                    case 53 -> 159;
                    case 54 -> 51;
                    case 55 -> 41;
                    case 56 -> 44;
                    case 57 -> 248;
                    case 58 -> 77;
                    case 59 -> 247;
                    case 60 -> 205;
                    case 61 -> 47;
                    case 62 -> 156;
                    case 63 -> 158;
                    case 64 -> 145;
                    case 65 -> 79;
                    case 66 -> 195;
                    case 67 -> 36;
                    case 68 -> 74;
                    case 69 -> 76;
                    case 70 -> 62;
                    case 71 -> 126;
                    case 72 -> 146;
                    case 73 -> 45;
                    case 74 -> 40;
                    case 75 -> 245;
                    case 76 -> 174;
                    case 77 -> 21;
                    case 78 -> 38;
                    case 79 -> 15;
                    case 80 -> 226;
                    case 81 -> 233;
                    case 82 -> 108;
                    case 83 -> 96;
                    case 84 -> 1;
                    case 85 -> 107;
                    case 86 -> 52;
                    case 87 -> 56;
                    case 88 -> 209;
                    case 89 -> 214;
                    case 90 -> 28;
                    case 91 -> 115;
                    case 92 -> 151;
                    case 93 -> 155;
                    case 94 -> 252;
                    case 95 -> 167;
                    case 96 -> 64;
                    case 97 -> 9;
                    case 98 -> 26;
                    case 99 -> 65;
                    case 100 -> 234;
                    case 101 -> 99;
                    case 102 -> 8;
                    case 103 -> 242;
                    case 104 -> 161;
                    case 105 -> 222;
                    case 106 -> 48;
                    case 107 -> 198;
                    case 108 -> 12;
                    case 109 -> 112;
                    case 110 -> 59;
                    case 111 -> 10;
                    case 112 -> 35;
                    case 113 -> 92;
                    case 114 -> 191;
                    case 115 -> 4;
                    case 116 -> 150;
                    case 117 -> 218;
                    case 118 -> 208;
                    case 119 -> 119;
                    case 120 -> 171;
                    case 121 -> 229;
                    case 122 -> 136;
                    case 123 -> 122;
                    case 124 -> 93;
                    case 125 -> 114;
                    case 126 -> 24;
                    case 127 -> 193;
                    case 128 -> 249;
                    case 129 -> 82;
                    case 130 -> 153;
                    case 131 -> 165;
                    case 132 -> 253;
                    case 133 -> 110;
                    case 134 -> 187;
                    case 135 -> 212;
                    case 136 -> 78;
                    case 137 -> 2;
                    case 138 -> 166;
                    case 139 -> 50;
                    case 140 -> 219;
                    case 141 -> 237;
                    case 142 -> 17;
                    case 143 -> 3;
                    case 144 -> 175;
                    case 145 -> 95;
                    case 146 -> 106;
                    case 147 -> 5;
                    case 148 -> 13;
                    case 149 -> 241;
                    case 150 -> 239;
                    case 151 -> 83;
                    case 152 -> 163;
                    case 153 -> 231;
                    case 154 -> 184;
                    case 155 -> 97;
                    case 156 -> 20;
                    case 157 -> 157;
                    case 158 -> 61;
                    case 159 -> 228;
                    case 160 -> 72;
                    case 161 -> 63;
                    case 162 -> 58;
                    case 163 -> 179;
                    case 164 -> 68;
                    case 165 -> 94;
                    case 166 -> 81;
                    case 167 -> 70;
                    case 168 -> 230;
                    case 169 -> 141;
                    case 170 -> 211;
                    case 171 -> 143;
                    case 172 -> 118;
                    case 173 -> 244;
                    case 174 -> 144;
                    case 175 -> 54;
                    case 176 -> 221;
                    case 177 -> 147;
                    case 178 -> 220;
                    case 179 -> 23;
                    case 180 -> 57;
                    case 181 -> 196;
                    case 182 -> 85;
                    case 183 -> 128;
                    case 184 -> 16;
                    case 185 -> 223;
                    case 186 -> 176;
                    case 187 -> 190;
                    case 188 -> 154;
                    case 189 -> 243;
                    case 190 -> 84;
                    case 191 -> 46;
                    case 192 -> 142;
                    case 193 -> 123;
                    case 194 -> 149;
                    case 195 -> 224;
                    case 196 -> 32;
                    case 197 -> 232;
                    case 198 -> 251;
                    case 199 -> 30;
                    case 200 -> 152;
                    case 201 -> 101;
                    case 202 -> 182;
                    case 203 -> 127;
                    case 204 -> 192;
                    case 205 -> 225;
                    case 206 -> 199;
                    case 207 -> 207;
                    case 208 -> 116;
                    case 209 -> 204;
                    case 210 -> 49;
                    case 211 -> 216;
                    case 212 -> 173;
                    case 213 -> 98;
                    case 214 -> 238;
                    case 215 -> 201;
                    case 216 -> 19;
                    case 217 -> 89;
                    case 218 -> 177;
                    case 219 -> 255;
                    case 220 -> 91;
                    case 221 -> 6;
                    case 222 -> 140;
                    case 223 -> 200;
                    case 224 -> 194;
                    case 225 -> 43;
                    case 226 -> 197;
                    case 227 -> 109;
                    case 228 -> 88;
                    case 229 -> 34;
                    case 230 -> 138;
                    case 231 -> 217;
                    case 232 -> 133;
                    case 233 -> 73;
                    case 234 -> 80;
                    case 235 -> 189;
                    case 236 -> 206;
                    case 237 -> 180;
                    case 238 -> 178;
                    case 239 -> 137;
                    case 240 -> 18;
                    case 241 -> 135;
                    case 242 -> 7;
                    case 243 -> 164;
                    case 244 -> 186;
                    case 245 -> 22;
                    case 246 -> 170;
                    case 247 -> 124;
                    case 248 -> 215;
                    case 249 -> 113;
                    case 250 -> 31;
                    case 251 -> 71;
                    case 252 -> 213;
                    case 253 -> 42;
                    case 254 -> 210;
                    default -> 148;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

