/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class SpringLocalModelUtils {
    @NotNull
    public static Set<CommonSpringModel> getLocalAnnotationModels(@NotNull Module module, @NotNull Set<PsiClass> classes, @NotNull Set<String> activeProfiles) {
        if (module == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(0);
        }
        if (classes == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(2);
        }
        Set<CommonSpringModel> set = classes.stream().map(file -> SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel((PsiClass)file, module, activeProfiles)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public static Set<XmlFile> getXmlFiles(Project project, @NotNull Set<VirtualFile> files) {
        if (files == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(4);
        }
        HashSet<XmlFile> xmlConfigs = new HashSet<XmlFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (file == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof XmlFile)) continue;
            xmlConfigs.add((XmlFile)psiFile);
        }
        HashSet<XmlFile> hashSet = xmlConfigs;
        if (hashSet == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static Set<PsiClass> getConfigClasses(@NotNull Project project, @NotNull Set<VirtualFile> files) {
        if (project == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(6);
        }
        if (files == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(7);
        }
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        for (VirtualFile file : files) {
            PsiFile psiFile;
            if (file == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(file)) instanceof PsiClassOwner)) continue;
            configurations.addAll(SpringLocalModelUtils.getConfigurationPsiClasses((PsiClassOwner)psiFile));
        }
        return configurations;
    }

    public static void addConfigurations(@NotNull Set<PsiClass> configurations, @NotNull PsiClass psiClass) {
        if (configurations == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(8);
        }
        if (psiClass == null) {
            SpringLocalModelUtils.$$$reportNull$$$0(9);
        }
        if (configurations.contains(psiClass)) {
            return;
        }
        configurations.add(psiClass);
        for (PsiClass innerClass : psiClass.getInnerClasses()) {
            if (!SpringCommonUtils.isConfigurationOrMeta(innerClass)) continue;
            SpringLocalModelUtils.addConfigurations(configurations, innerClass);
        }
    }

    public static Set<PsiClass> getConfigurationPsiClasses(PsiClassOwner psiClassOwner) {
        LinkedHashSet<PsiClass> configurations = new LinkedHashSet<PsiClass>();
        PsiClass[] classes = psiClassOwner.getClasses();
        if (classes.length == 1) {
            SpringLocalModelUtils.addConfigurations(configurations, classes[0]);
        } else {
            for (PsiClass psiClass : classes) {
                if (!SpringCommonUtils.isConfigurationOrMeta(psiClass)) continue;
                SpringLocalModelUtils.addConfigurations(configurations, psiClass);
            }
        }
        return configurations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/SpringLocalModelUtils";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/SpringLocalModelUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalAnnotationModels";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalAnnotationModels";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXmlFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigClasses";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addConfigurations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

