/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.values.awt;

import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Bitmap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/jetbrains/letsPlot/commons/values/awt/BitmapUtil;", "", "()V", "fromBufferedImage", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "image", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "bitmap", "commons"})
public final class BitmapUtil {
    @NotNull
    public static final BitmapUtil INSTANCE = new BitmapUtil();

    private BitmapUtil() {
    }

    @NotNull
    public final Bitmap fromBufferedImage(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int[] argbArray = new int[image.getWidth() * image.getHeight()];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), argbArray, 0, image.getWidth());
        return new Bitmap(image.getWidth(), image.getHeight(), argbArray);
    }

    @NotNull
    public final BufferedImage toBufferedImage(@NotNull Bitmap bitmap2) {
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        BufferedImage image = new BufferedImage(bitmap2.getWidth(), bitmap2.getHeight(), 2);
        image.setRGB(0, 0, bitmap2.getWidth(), bitmap2.getHeight(), bitmap2.getArgbInts(), 0, bitmap2.getWidth());
        return image;
    }
}

