/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.util.sizing.SizingPolicy;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotExportCommon;", "", "()V", "MAX_INCHES", "", "computeExportParameters", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$ExportParameters;", "plotSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "dpi", "", "unit", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "scaleFactor", "ExportParameters", "SizeUnit", "plot-stem"})
public final class PlotExportCommon {
    @NotNull
    public static final PlotExportCommon INSTANCE = new PlotExportCommon();
    private static final double MAX_INCHES = 20.0;

    private PlotExportCommon() {
    }

    @NotNull
    public final ExportParameters computeExportParameters(@Nullable DoubleVector plotSize2, @Nullable Number dpi, @Nullable SizeUnit unit, @Nullable Number scaleFactor) {
        SizingPolicy sizingPolicy;
        double d;
        double exportScale = 0.0;
        SizeUnit exportUnit = null;
        if (plotSize2 == null && dpi == null && unit == null) {
            exportUnit = SizeUnit.PX;
            Number number = scaleFactor;
            exportScale = number != null ? number.doubleValue() : 2.0;
        } else if (plotSize2 == null && unit == null && dpi != null) {
            exportUnit = SizeUnit.PX;
            Number number = scaleFactor;
            exportScale = number != null ? number.doubleValue() : 1.0;
        } else if (plotSize2 != null && unit == null) {
            if (plotSize2.getX() >= 20.0 || plotSize2.getY() >= 20.0) {
                throw new IllegalArgumentException("The image size was interpreted as inches, but it seems unusually large. Please specify the size unit explicitly (px, cm, mm, in).");
            }
            exportUnit = SizeUnit.IN;
            Number number = scaleFactor;
            exportScale = number != null ? number.doubleValue() : 1.0;
        } else if (plotSize2 != null && unit != null) {
            exportUnit = unit;
            Number number = scaleFactor;
            exportScale = number != null ? number.doubleValue() : 1.0;
        } else {
            SizeUnit sizeUnit = unit;
            if (sizeUnit == null) {
                sizeUnit = SizeUnit.PX;
            }
            exportUnit = sizeUnit;
            Number number = scaleFactor;
            exportScale = number != null ? number.doubleValue() : 1.0;
        }
        Number number = dpi;
        if (number != null) {
            d = number.doubleValue();
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[exportUnit.ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    d = 300.0;
                    break;
                }
                case 4: {
                    d = 96.0;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        double exportDpi = d;
        if (plotSize2 == null) {
            sizingPolicy = SizingPolicy.Companion.keepFigureDefaultSize();
        } else {
            DoubleVector doubleVector;
            switch (WhenMappings.$EnumSwitchMapping$0[exportUnit.ordinal()]) {
                case 1: {
                    doubleVector = plotSize2.mul(96.0);
                    break;
                }
                case 2: {
                    doubleVector = plotSize2.mul(37.79527559055118);
                    break;
                }
                case 3: {
                    doubleVector = plotSize2.mul(3.7795275590551185);
                    break;
                }
                case 4: {
                    doubleVector = plotSize2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DoubleVector doubleVector2 = doubleVector;
            double logicalWidth = doubleVector2.component1();
            double logicalHeight = doubleVector2.component2();
            sizingPolicy = SizingPolicy.Companion.fixed(logicalWidth, logicalHeight);
        }
        SizingPolicy sizingPolicy2 = sizingPolicy;
        double finalScaleFactor = exportUnit == SizeUnit.PX && plotSize2 != null ? exportScale : exportDpi / 96.0 * exportScale;
        return new ExportParameters(sizingPolicy2, finalScaleFactor, exportUnit, exportDpi);
    }

    public static /* synthetic */ ExportParameters computeExportParameters$default(PlotExportCommon plotExportCommon, DoubleVector doubleVector, Number number, SizeUnit sizeUnit, Number number2, int n, Object object) {
        if ((n & 1) != 0) {
            doubleVector = null;
        }
        if ((n & 2) != 0) {
            number = null;
        }
        if ((n & 4) != 0) {
            sizeUnit = null;
        }
        if ((n & 8) != 0) {
            number2 = null;
        }
        return plotExportCommon.computeExportParameters(doubleVector, number, sizeUnit, number2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$ExportParameters;", "", "sizingPolicy", "Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "scaleFactor", "", "sizeUnit", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "dpi", "(Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;DLorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;D)V", "getDpi", "()D", "getScaleFactor", "getSizeUnit", "()Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "getSizingPolicy", "()Lorg/jetbrains/letsPlot/core/util/sizing/SizingPolicy;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "plot-stem"})
    public static final class ExportParameters {
        @NotNull
        private final SizingPolicy sizingPolicy;
        private final double scaleFactor;
        @NotNull
        private final SizeUnit sizeUnit;
        private final double dpi;

        public ExportParameters(@NotNull SizingPolicy sizingPolicy, double scaleFactor, @NotNull SizeUnit sizeUnit, double dpi) {
            Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
            Intrinsics.checkNotNullParameter((Object)((Object)sizeUnit), (String)"sizeUnit");
            this.sizingPolicy = sizingPolicy;
            this.scaleFactor = scaleFactor;
            this.sizeUnit = sizeUnit;
            this.dpi = dpi;
        }

        @NotNull
        public final SizingPolicy getSizingPolicy() {
            return this.sizingPolicy;
        }

        public final double getScaleFactor() {
            return this.scaleFactor;
        }

        @NotNull
        public final SizeUnit getSizeUnit() {
            return this.sizeUnit;
        }

        public final double getDpi() {
            return this.dpi;
        }

        @NotNull
        public final SizingPolicy component1() {
            return this.sizingPolicy;
        }

        public final double component2() {
            return this.scaleFactor;
        }

        @NotNull
        public final SizeUnit component3() {
            return this.sizeUnit;
        }

        public final double component4() {
            return this.dpi;
        }

        @NotNull
        public final ExportParameters copy(@NotNull SizingPolicy sizingPolicy, double scaleFactor, @NotNull SizeUnit sizeUnit, double dpi) {
            Intrinsics.checkNotNullParameter((Object)sizingPolicy, (String)"sizingPolicy");
            Intrinsics.checkNotNullParameter((Object)((Object)sizeUnit), (String)"sizeUnit");
            return new ExportParameters(sizingPolicy, scaleFactor, sizeUnit, dpi);
        }

        public static /* synthetic */ ExportParameters copy$default(ExportParameters exportParameters, SizingPolicy sizingPolicy, double d, SizeUnit sizeUnit, double d2, int n, Object object) {
            if ((n & 1) != 0) {
                sizingPolicy = exportParameters.sizingPolicy;
            }
            if ((n & 2) != 0) {
                d = exportParameters.scaleFactor;
            }
            if ((n & 4) != 0) {
                sizeUnit = exportParameters.sizeUnit;
            }
            if ((n & 8) != 0) {
                d2 = exportParameters.dpi;
            }
            return exportParameters.copy(sizingPolicy, d, sizeUnit, d2);
        }

        @NotNull
        public String toString() {
            return "ExportParameters(sizingPolicy=" + this.sizingPolicy + ", scaleFactor=" + this.scaleFactor + ", sizeUnit=" + (Object)((Object)this.sizeUnit) + ", dpi=" + this.dpi + ')';
        }

        public int hashCode() {
            int result2 = this.sizingPolicy.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.scaleFactor);
            result2 = result2 * 31 + this.sizeUnit.hashCode();
            result2 = result2 * 31 + Double.hashCode(this.dpi);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExportParameters)) {
                return false;
            }
            ExportParameters exportParameters = (ExportParameters)other;
            if (!Intrinsics.areEqual((Object)this.sizingPolicy, (Object)exportParameters.sizingPolicy)) {
                return false;
            }
            if (Double.compare(this.scaleFactor, exportParameters.scaleFactor) != 0) {
                return false;
            }
            if (this.sizeUnit != exportParameters.sizeUnit) {
                return false;
            }
            return Double.compare(this.dpi, exportParameters.dpi) == 0;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000fB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "", "value", "", "isPhysicalUnit", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "()Z", "getValue", "()Ljava/lang/String;", "toString", "PX", "MM", "CM", "IN", "Companion", "plot-stem"})
    public static final class SizeUnit
    extends Enum<SizeUnit> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String value;
        private final boolean isPhysicalUnit;
        public static final /* enum */ SizeUnit PX;
        public static final /* enum */ SizeUnit MM;
        public static final /* enum */ SizeUnit CM;
        public static final /* enum */ SizeUnit IN;
        private static final /* synthetic */ SizeUnit[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SizeUnit(String value, boolean isPhysicalUnit) {
            this.value = value;
            this.isPhysicalUnit = isPhysicalUnit;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        public final boolean isPhysicalUnit() {
            return this.isPhysicalUnit;
        }

        @NotNull
        public String toString() {
            return this.value;
        }

        public static SizeUnit[] values() {
            return (SizeUnit[])$VALUES.clone();
        }

        public static SizeUnit valueOf(String value) {
            return Enum.valueOf(SizeUnit.class, value);
        }

        @NotNull
        public static EnumEntries<SizeUnit> getEntries() {
            return $ENTRIES;
        }

        static {
            PX = new SizeUnit("px", false);
            MM = new SizeUnit("mm", true);
            CM = new SizeUnit("cm", true);
            IN = new SizeUnit("in", true);
            $VALUES = sizeUnitArray = new SizeUnit[]{SizeUnit.PX, SizeUnit.MM, SizeUnit.CM, SizeUnit.IN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit$Companion;", "", "()V", "fromName", "Lorg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit;", "name", "", "plot-stem"})
        @SourceDebugExtension(value={"SMAP\nPlotExportCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotExportCommon.kt\norg/jetbrains/letsPlot/core/util/PlotExportCommon$SizeUnit$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SizeUnit fromName(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Iterable iterable = (Iterable)SizeUnit.getEntries();
                    for (Object t : iterable) {
                        SizeUnit it = (SizeUnit)((Object)t);
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getValue(), (String)name, (boolean)true)) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SizeUnit.values().length];
            try {
                nArray[SizeUnit.IN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizeUnit.CM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizeUnit.MM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SizeUnit.PX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

