/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kubernetes.api.settings.KubernetesLogsGlobalSettings;
import com.intellij.kubernetes.api.settings.LogHighlightingPattern;
import com.intellij.kubernetes.logs.AnsiSegment;
import com.intellij.kubernetes.logs.KubernetesAnsiParsingException;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesLogAnsiSegmentKt;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import com.intellij.kubernetes.logs.LogEntry;
import com.intellij.kubernetes.logs.LogLineEntry;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import com.intellij.util.AnsiCsiUtil;
import java.awt.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001aB\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bj\u0002`\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a4\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0002\u001a\u001e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0010H\u0002\u001a\"\u0010(\u001a\u00020)2\u0018\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0010H\u0000\u001a\u001e\u0010+\u001a\u00020,*\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0010H\u0000\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001e\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000*0\b\u0000\u0010\u0007\"\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b2\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b\u00a8\u0006-"}, d2={"HYPERLINK_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getHYPERLINK_INFO_KEY", "()Lcom/intellij/openapi/util/Key;", "KubernetesLogLineEntry", "Lcom/intellij/kubernetes/logs/LogLineEntry;", "Ljava/time/Instant;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "buildLogEntriesList", "", "Lcom/intellij/kubernetes/logs/KubernetesLogLineEntry;", "logsList", "", "presentationSettings", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "hyperLinkRegistry", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "createLogEntry", "Lcom/intellij/kubernetes/logs/LogEntry;", "log", "highlighters", "Lcom/intellij/kubernetes/api/settings/LogHighlightingPattern;", "determineContentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "NORMAL_OUTPUT", "TIMESTAMP_CONTENT_TYPE", "SOURCE_CONTENT_TYPE", "getSOURCE_CONTENT_TYPE", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "LAZY_NORMAL", "Lkotlin/Lazy;", "LAZY_SOURCE", "LAZY_TIMESTAMP", "OPENING_BRACKET_ENTRY", "CLOSING_BRACKET_TAB_ENTRY", "LINE_BREAK_ENTRY", "disposeHighlighting", "", "logsToDispose", "joinToString", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogEntry.kt\ncom/intellij/kubernetes/logs/KubernetesLogEntryKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n13#2:157\n1374#3:158\n1460#3,5:159\n*S KotlinDebug\n*F\n+ 1 KubernetesLogEntry.kt\ncom/intellij/kubernetes/logs/KubernetesLogEntryKt\n*L\n63#1:157\n156#1:158\n156#1:159,5\n*E\n"})
public final class KubernetesLogEntryKt {
    @NotNull
    private static final Key<HyperlinkInfo> HYPERLINK_INFO_KEY;
    @NotNull
    private static final ConsoleViewContentType NORMAL_OUTPUT;
    @NotNull
    private static final ConsoleViewContentType TIMESTAMP_CONTENT_TYPE;
    @NotNull
    private static final ConsoleViewContentType SOURCE_CONTENT_TYPE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_NORMAL;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_SOURCE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_TIMESTAMP;
    @NotNull
    private static final LogEntry OPENING_BRACKET_ENTRY;
    @NotNull
    private static final LogEntry CLOSING_BRACKET_TAB_ENTRY;
    @NotNull
    private static final LogEntry LINE_BREAK_ENTRY;

    @NotNull
    public static final Key<HyperlinkInfo> getHYPERLINK_INFO_KEY() {
        return HYPERLINK_INFO_KEY;
    }

    @NotNull
    public static final List<LogLineEntry<Instant, KubernetesContainerObject, KubernetesContextLog>> buildLogEntriesList(@NotNull List<? extends KubernetesContextLog> logsList, @NotNull KubernetesLogPresentationSettings presentationSettings, @NotNull KubernetesLogStateManager.HyperLinkCachedCreator hyperLinkRegistry) {
        Intrinsics.checkNotNullParameter(logsList, (String)"logsList");
        Intrinsics.checkNotNullParameter((Object)presentationSettings, (String)"presentationSettings");
        Intrinsics.checkNotNullParameter((Object)hyperLinkRegistry, (String)"hyperLinkRegistry");
        List logEntries = new ArrayList();
        List highlighters = KubernetesLogsGlobalSettings.Companion.getInstance().getLogsHighlighters();
        for (KubernetesContextLog kubernetesContextLog : logsList) {
            LogLineEntry logLineEntry = new LogLineEntry(KubernetesLogEntryKt.createLogEntry(presentationSettings, kubernetesContextLog, hyperLinkRegistry, highlighters), kubernetesContextLog);
            logEntries.add(logLineEntry);
        }
        return logEntries;
    }

    private static final List<LogEntry> createLogEntry(KubernetesLogPresentationSettings presentationSettings, KubernetesContextLog log, KubernetesLogStateManager.HyperLinkCachedCreator hyperLinkRegistry, List<LogHighlightingPattern> highlighters) {
        List logLineEntries = new ArrayList();
        if (presentationSettings.getShowTimestamp()) {
            logLineEntries.add(new LogEntry("[" + log.getPrettyTimestamp() + "]\t", LAZY_TIMESTAMP, null, null, 12, null));
        }
        if (presentationSettings.getShowSource()) {
            logLineEntries.add(OPENING_BRACKET_ENTRY);
            logLineEntries.add(new LogEntry(log.getSource(), LAZY_SOURCE, hyperLinkRegistry.getHyperlinkInfoForLog$intellij_clouds_kubernetes_backend(log), null, 8, null));
            logLineEntries.add(CLOSING_BRACKET_TAB_ENTRY);
        }
        if (presentationSettings.getShowMessage()) {
            if (AnsiCsiUtil.containsAnsi((CharSequence)log.getMessage())) {
                boolean ansiSegments22;
                try {
                    List ansiSegments22 = KubernetesLogAnsiSegmentKt.parseStringWithAnsiCsi((String)log.getMessage());
                    for (AnsiSegment it : ansiSegments22) {
                        logLineEntries.add(it.toLogEntry());
                    }
                    ansiSegments22 = logLineEntries.add(new LogEntry("\n", LAZY_NORMAL, null, null, 12, null));
                }
                catch (KubernetesAnsiParsingException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(AnsiSegment.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warnWithDebug("Exception during log ANSI line parsing", (Throwable)e);
                    ansiSegments22 = logLineEntries.add(new LogEntry(AnsiCsiUtil.stripAnsi((CharSequence)log.getMessage()) + "\n", LAZY_NORMAL, null, null, 12, null));
                }
                v1 = ansiSegments22;
            } else {
                ConsoleViewContentType logEntryContentType = KubernetesLogEntryKt.determineContentType(log, highlighters);
                v1 = logLineEntries.add(new LogEntry(log.getMessage() + "\n", LazyKt.lazy(() -> KubernetesLogEntryKt.createLogEntry$lambda$0(logEntryContentType)), null, null, 12, null));
            }
        } else {
            v1 = logLineEntries.add(LINE_BREAK_ENTRY);
        }
        return logLineEntries;
    }

    private static final ConsoleViewContentType determineContentType(KubernetesContextLog log, List<LogHighlightingPattern> highlighters) {
        ConsoleViewContentType consoleViewContentType;
        String message = log.getMessage();
        LogHighlightingPattern matchedHighlighter = null;
        int earliestMatchIndex = Integer.MAX_VALUE;
        for (LogHighlightingPattern highlighter : highlighters) {
            int matchIndex;
            MatchResult matchResult;
            if (!highlighter.getEnabled() || (matchResult = Regex.find$default((Regex)new Regex(highlighter.getPattern()), (CharSequence)message, (int)0, (int)2, null)) == null || (matchIndex = matchResult.getRange().getFirst()) >= earliestMatchIndex) continue;
            earliestMatchIndex = matchIndex;
            matchedHighlighter = highlighter;
        }
        LogHighlightingPattern logHighlightingPattern = matchedHighlighter;
        if (logHighlightingPattern != null) {
            LogHighlightingPattern it = logHighlightingPattern;
            boolean bl = false;
            int fontStyle = it.getBold() && it.getItalic() ? 3 : (it.getBold() ? 1 : (it.getItalic() ? 2 : 0));
            consoleViewContentType = new ConsoleViewContentType("KUBERNETES_LOG_CVCT", new TextAttributes((Color)new JBColor(it.getFgRgb(), it.getFgRgbDark()), null, null, null, fontStyle));
        } else {
            consoleViewContentType = NORMAL_OUTPUT;
        }
        return consoleViewContentType;
    }

    @NotNull
    public static final ConsoleViewContentType getSOURCE_CONTENT_TYPE() {
        return SOURCE_CONTENT_TYPE;
    }

    public static final void disposeHighlighting(@NotNull List<? extends LogLineEntry<?, ?, ?>> logsToDispose) {
        Intrinsics.checkNotNullParameter(logsToDispose, (String)"logsToDispose");
        for (LogLineEntry<?, ?, ?> previousLogLine : logsToDispose) {
            for (LogEntry previousEntry : previousLogLine.getLogEntries()) {
                RangeHighlighter rangeHighlighter = previousEntry.getHighlighter();
                if (rangeHighlighter == null) continue;
                rangeHighlighter.dispose();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String joinToString(@NotNull List<? extends LogLineEntry<?, ?, ?>> $this$joinToString) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$joinToString, (String)"<this>");
        Iterable $this$flatMap$iv = $this$joinToString;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogLineEntry it = (LogLineEntry)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLogEntries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, KubernetesLogEntryKt::joinToString$lambda$1, (int)30, null);
    }

    private static final ConsoleViewContentType createLogEntry$lambda$0(ConsoleViewContentType $logEntryContentType) {
        return $logEntryContentType;
    }

    private static final ConsoleViewContentType LAZY_NORMAL$lambda$0() {
        return NORMAL_OUTPUT;
    }

    private static final ConsoleViewContentType LAZY_SOURCE$lambda$0() {
        return SOURCE_CONTENT_TYPE;
    }

    private static final ConsoleViewContentType LAZY_TIMESTAMP$lambda$0() {
        return TIMESTAMP_CONTENT_TYPE;
    }

    private static final CharSequence joinToString$lambda$1(LogEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    static {
        Key key = Key.create((String)"HYPERLINK_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HYPERLINK_INFO_KEY = key;
        NORMAL_OUTPUT = new ConsoleViewContentType("KUBERNETES_LOGS_DEFAULT", new TextAttributes((Color)new JBColor(526344, 12369604), null, null, null, 0));
        TIMESTAMP_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_TIMESTAMP", new TextAttributes((Color)JBColor.GRAY, null, null, null, 0));
        SOURCE_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_SOURCE", new TextAttributes((Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), null, (Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), EffectType.LINE_UNDERSCORE, 0));
        LAZY_NORMAL = LazyKt.lazy(KubernetesLogEntryKt::LAZY_NORMAL$lambda$0);
        LAZY_SOURCE = LazyKt.lazy(KubernetesLogEntryKt::LAZY_SOURCE$lambda$0);
        LAZY_TIMESTAMP = LazyKt.lazy(KubernetesLogEntryKt::LAZY_TIMESTAMP$lambda$0);
        OPENING_BRACKET_ENTRY = new LogEntry("(", LAZY_NORMAL, null, null, 12, null);
        CLOSING_BRACKET_TAB_ENTRY = new LogEntry(")\t", LAZY_NORMAL, null, null, 12, null);
        LINE_BREAK_ENTRY = new LogEntry("\n", LAZY_NORMAL, null, null, 12, null);
    }
}

