/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.dynatrace.hash4j.hashing.HashSink;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.hashing.Hashing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.ProjectStamps;

@ApiStatus.Internal
public final class FileHashUtil {
    public static void computePathHashCode(@Nullable String path, @NotNull HashSink hash) {
        int length;
        if (hash == null) {
            FileHashUtil.$$$reportNull$$$0(0);
        }
        int n = length = path == null ? 0 : path.length();
        if (length == 0) {
            hash.putInt(0);
        } else if (ProjectStamps.PORTABLE_CACHES || SystemInfoRt.isFileSystemCaseSensitive) {
            hash.putString(path);
        } else {
            for (int idx = 0; idx < length; ++idx) {
                hash.putChar(StringUtilRt.toLowerCase((char)path.charAt(idx)));
            }
            hash.putInt(length);
        }
    }

    public static long getFileHash(Path file) throws IOException {
        HashStream64 hash = Hashing.komihash5_0().hashStream();
        FileHashUtil.getFileHash(file, (HashSink)hash);
        return hash.getAsLong();
    }

    public static void getFileHash(Path file, HashSink hash) throws IOException {
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
            int readBytes;
            long fileSize = channel.size();
            ByteBuffer buffer = ByteBuffer.allocate(262144);
            for (long offset = 0L; offset < fileSize; offset += (long)readBytes) {
                buffer.clear();
                readBytes = channel.read(buffer, offset);
                if (readBytes <= 0) break;
                hash.putBytes(buffer.array(), 0, readBytes);
            }
            hash.putLong(fileSize);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "org/jetbrains/jps/incremental/FileHashUtil", "computePathHashCode"));
    }
}

