/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.util.Pair;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.LongIntegerSerializer;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class V8OverviewScalesReader {
    private final List<Long> myStepSizes = new ArrayList<Long>();
    private final List<SequentialRawReader<Pair<Long, Integer>>> myReaders = new ArrayList<SequentialRawReader<Pair<Long, Integer>>>();

    public V8OverviewScalesReader(List<File> overviewFiles, CompositeCloseable resources, long tickStep) throws FileNotFoundException {
        long step = tickStep;
        if (overviewFiles != null) {
            LongIntegerSerializer serializer = new LongIntegerSerializer();
            for (File file : overviewFiles) {
                this.myStepSizes.add(step);
                this.myReaders.add(resources.register(new SequentialRawReader<Pair<Long, Integer>>(file, serializer)));
                step *= 4L;
            }
        }
    }

    public List<Pair<Long, Integer>> getMostDetailedOverview(long from, long to) throws IOException {
        return this.myStepSizes.isEmpty() ? null : this.calculateWith(0, from, to);
    }

    public List<Pair<Long, Integer>> getStackOverview(long from, long to) throws IOException {
        long interval = to - from;
        for (int i = this.myStepSizes.size() - 1; i >= 0; --i) {
            if (interval / this.myStepSizes.get(i) < 500L) continue;
            if (i == this.myStepSizes.size() - 1) {
                return this.calculateWith(i, from, to);
            }
            return this.calculateWith(i + 1, from, to);
        }
        return null;
    }

    public List<Pair<Long, Integer>> calculateWith(int i, long from, long to) throws IOException {
        long stepSize = this.myStepSizes.get(i);
        final int fromIdx = (int)Math.floor(from / stepSize);
        final int toIdx = (int)Math.ceil((double)to / (double)stepSize);
        final ArrayList<Pair<Long, Integer>> result = new ArrayList<Pair<Long, Integer>>();
        SequentialRawReader<Pair<Long, Integer>> reader = this.myReaders.get(i);
        reader.reset();
        reader.skip(fromIdx);
        reader.iterate(new CloseableThrowableConsumer<Pair<Long, Integer>, IOException>(this){
            int cnt;
            {
                this.cnt = fromIdx;
            }

            @Override
            public void close() throws IOException {
            }

            public void consume(Pair<Long, Integer> pair) throws IOException {
                if (this.cnt <= toIdx) {
                    result.add(pair);
                }
                ++this.cnt;
            }
        });
        return result;
    }
}

