/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleBase;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.debugger.SqlDebugSessionRunner;
import com.intellij.database.debugger.SqlDebuggerFacade;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.util.DbeTierUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugQueryAction
extends QueryActionBase {
    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DebugQueryAction.$$$reportNull$$$0(0);
        }
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        JdbcConsole console = DebugQueryAction.getConsole(e);
        SqlDebugSessionRunner.SqlDebugAvailability availability = DebugQueryAction.checkAvailability(console, editor2, file);
        Presentation p = e.getPresentation();
        p.setVisible(availability.visible);
        p.setEnabled(availability.enabled);
        DbeTierUtil.adjustPaidTier(e);
    }

    private static SqlDebugSessionRunner.SqlDebugAvailability checkAvailability(@Nullable JdbcConsole console, @Nullable Editor editor2, @Nullable PsiFile file) {
        if (console == null) {
            return SqlDebugSessionRunner.SqlDebugAvailability.DEBUGGER_ABSENT;
        }
        LocalDataSource lds = ((DatabaseConnectionPoint)console.getTarget()).getDataSource();
        SqlDebuggerFacade facade = SqlDebugSessionRunner.Handler.obtainDebuggerFacadeWhenApplicable(lds);
        if (facade == null) {
            return SqlDebugSessionRunner.SqlDebugAvailability.DEBUGGER_ABSENT;
        }
        if (editor2 == null || file == null) {
            return SqlDebugSessionRunner.SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
        }
        PsiElement element = JdbcConsoleProvider.elementAt(file, null, editor2);
        if (element == null) {
            return SqlDebugSessionRunner.SqlDebugAvailability.DEBUGGER_INAPPLICABLE;
        }
        if (!console.isIdle()) {
            return SqlDebugSessionRunner.SqlDebugAvailability.DEBUGGER_CONSOLE_BUSY;
        }
        return SqlDebugSessionRunner.Handler.checkDebuggerAvailability(lds, facade, element);
    }

    @Override
    protected boolean isApplicable(@Nullable JdbcConsole console, @Nullable Editor editor2, @Nullable PsiFile file) {
        SqlDebugSessionRunner.SqlDebugAvailability availability = DebugQueryAction.checkAvailability(console, editor2, file);
        return availability.visible;
    }

    @Override
    protected boolean isEnabled(@Nullable JdbcConsole console, @Nullable Editor editor2, @Nullable PsiFile file) {
        SqlDebugSessionRunner.SqlDebugAvailability availability = DebugQueryAction.checkAvailability(console, editor2, file);
        return availability.enabled;
    }

    @Override
    protected void invokeImpl(@Nullable JdbcConsole console, @NotNull ScriptModel<?> scriptModel, @NotNull JdbcConsoleProvider.Info info2) {
        if (scriptModel == null) {
            DebugQueryAction.$$$reportNull$$$0(1);
        }
        if (info2 == null) {
            DebugQueryAction.$$$reportNull$$$0(2);
        }
        if (console == null) {
            return;
        }
        if (!console.beforeExecuteQueries(scriptModel)) {
            return;
        }
        Document document = console.getDocument();
        RangeMarker rangeMarker = document.createRangeMarker(scriptModel.getTextRange());
        Function1 requestFactory = sm -> ConsoleDataRequest.newConsoleRequest((JdbcConsoleBase)console, (Editor)info2.editor, (ScriptModel)sm, (boolean)true);
        SqlDebugSessionRunner.Handler.startDebugProcess((DatabaseSessionClient)console, true, scriptModel.getVirtualFile(), rangeMarker, console.getSearchPath(), console.getTitle(), requestFactory);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/actions/DebugQueryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

