/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.maven;

import com.intellij.java.workspace.entities.ArtifactEntity;
import com.intellij.java.workspace.entities.ArtifactId;
import com.intellij.javaee.maven.JavaeeArtifactInBuildService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.workspacemodel.BridgeUtilsKt;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010$\u001a\u00020\tJ\u0014\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010+\u001a\u00020'J\u001c\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'2\f\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001cJ\b\u00100\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001fR(\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010\u0013R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u00061"}, d2={"Lcom/intellij/javaee/maven/JavaeeImporterArtifact;", "", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "artifactType", "Lcom/intellij/packaging/artifacts/ArtifactType;", "outputUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "rootElement", "Lcom/intellij/packaging/elements/CompositePackagingElement;", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/packaging/artifacts/ArtifactType;Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/packaging/elements/CompositePackagingElement;Lcom/intellij/openapi/roots/ProjectModelExternalSource;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getArtifactType", "()Lcom/intellij/packaging/artifacts/ArtifactType;", "getRootElement", "()Lcom/intellij/packaging/elements/CompositePackagingElement;", "getExternalSource", "()Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "artifactProperties", "", "Lcom/intellij/packaging/artifacts/ArtifactProperties;", "isBuildOnMake", "", "()Z", "value", "outputPath", "getOutputPath", "setOutputPath", "getOutputUrl", "propertiesProviders", "", "Lcom/intellij/packaging/artifacts/ArtifactPropertiesProvider;", "getPropertiesProviders", "()Ljava/util/Collection;", "getProperties", "propertiesProvider", "setProperties", "", "provider", "properties", "toString", "intellij.javaee.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJavaeeFacetHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaeeFacetHelpers.kt\ncom/intellij/javaee/maven/JavaeeImporterArtifact\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n30#2,2:213\n1#3:215\n774#4:216\n865#4,2:217\n*S KotlinDebug\n*F\n+ 1 JavaeeFacetHelpers.kt\ncom/intellij/javaee/maven/JavaeeImporterArtifact\n*L\n72#1:213,2\n87#1:216\n87#1:217,2\n*E\n"})
public final class JavaeeImporterArtifact {
    @NotNull
    private final Project project;
    @NotNull
    private String name;
    @NotNull
    private final ArtifactType artifactType;
    @NotNull
    private VirtualFileUrl outputUrl;
    @NotNull
    private final CompositePackagingElement<?> rootElement;
    @Nullable
    private final ProjectModelExternalSource externalSource;
    @NotNull
    private final Map<String, ArtifactProperties<?>> artifactProperties;
    private final boolean isBuildOnMake;

    public JavaeeImporterArtifact(@NotNull Project project, @NotNull String name, @NotNull ArtifactType artifactType, @NotNull VirtualFileUrl outputUrl, @NotNull CompositePackagingElement<?> rootElement, @Nullable ProjectModelExternalSource externalSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)artifactType, (String)"artifactType");
        Intrinsics.checkNotNullParameter((Object)outputUrl, (String)"outputUrl");
        Intrinsics.checkNotNullParameter(rootElement, (String)"rootElement");
        this.project = project;
        this.name = name;
        this.artifactType = artifactType;
        this.outputUrl = outputUrl;
        this.rootElement = rootElement;
        this.externalSource = externalSource;
        this.artifactProperties = new LinkedHashMap();
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JavaeeArtifactInBuildService> serviceClass$iv = JavaeeArtifactInBuildService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.isBuildOnMake = ((JavaeeArtifactInBuildService)((Object)object)).isIncludedInProjectBuild(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @NotNull
    public final ArtifactType getArtifactType() {
        return this.artifactType;
    }

    @NotNull
    public final CompositePackagingElement<?> getRootElement() {
        return this.rootElement;
    }

    @Nullable
    public final ProjectModelExternalSource getExternalSource() {
        return this.externalSource;
    }

    public final boolean isBuildOnMake() {
        return this.isBuildOnMake;
    }

    @Nullable
    public final String getOutputPath() {
        String string;
        String string2 = this.outputUrl.getUrl();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = JpsPathUtil.urlToPath((String)it);
        } else {
            string = null;
        }
        return string;
    }

    public final void setOutputPath(@Nullable String value) {
        VirtualFileUrl outputUrl;
        VirtualFileUrl virtualFileUrl;
        String string = value;
        if (string != null) {
            String it = string;
            boolean bl = false;
            VirtualFileUrlManager virtualFileUrlManager = WorkspaceModel.Companion.getInstance(this.project).getVirtualFileUrlManager();
            String string2 = VfsUtilCore.pathToUrl((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pathToUrl(...)");
            virtualFileUrl = virtualFileUrlManager.getOrCreateFromUrl(string2);
        } else {
            virtualFileUrl = null;
        }
        VirtualFileUrl virtualFileUrl2 = outputUrl = virtualFileUrl;
        Intrinsics.checkNotNull(virtualFileUrl2);
        this.outputUrl = virtualFileUrl2;
    }

    @NotNull
    public final VirtualFileUrl getOutputUrl() {
        return this.outputUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ArtifactPropertiesProvider> getPropertiesProviders() {
        void $this$filterTo$iv$iv;
        List list = ArtifactPropertiesProvider.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProviders(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ArtifactPropertiesProvider it = (ArtifactPropertiesProvider)element$iv$iv;
            boolean bl = false;
            if (!it.isAvailableFor(this.artifactType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ArtifactProperties<?> getProperties(@NotNull ArtifactPropertiesProvider propertiesProvider) {
        Intrinsics.checkNotNullParameter((Object)propertiesProvider, (String)"propertiesProvider");
        String providerId = propertiesProvider.getId();
        if (!this.artifactProperties.containsKey(providerId) && propertiesProvider.isAvailableFor(this.artifactType)) {
            ArtifactEntity existingArtifact;
            ArtifactEntity artifactEntity = existingArtifact = (ArtifactEntity)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot().resolve((SymbolicEntityId)new ArtifactId(this.name));
            ArtifactProperties existingProperties = artifactEntity != null ? BridgeUtilsKt.getArtifactProperties((ArtifactEntity)artifactEntity, (ArtifactType)this.artifactType, (ArtifactPropertiesProvider)propertiesProvider) : null;
            ArtifactProperties artifactProperties = existingProperties;
            if (artifactProperties == null) {
                ArtifactProperties artifactProperties2 = propertiesProvider.createProperties(this.artifactType);
                artifactProperties = artifactProperties2;
                Intrinsics.checkNotNullExpressionValue((Object)artifactProperties2, (String)"createProperties(...)");
            }
            ArtifactProperties properties = artifactProperties;
            this.artifactProperties.put(providerId, properties);
        }
        return this.artifactProperties.get(providerId);
    }

    public final void setProperties(@NotNull ArtifactPropertiesProvider provider, @Nullable ArtifactProperties<?> properties) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        String string = provider.getId();
        ArtifactProperties<?> artifactProperties = properties;
        Intrinsics.checkNotNull(artifactProperties);
        this.artifactProperties.put(string, artifactProperties);
    }

    @NotNull
    public String toString() {
        return "JavaeeImporterArtifact(name='" + this.name + "')";
    }
}

