/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.TestProxyFilterProvider;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.karma.execution.KarmaRerunFailedTestAction;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaTestLocationProvider;
import com.intellij.javascript.karma.tree.KarmaTestProxyFilterProvider;
import com.intellij.javascript.testing.JsTestConsoleProperties;
import com.intellij.util.config.AbstractProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KarmaConsoleProperties
extends JsTestConsoleProperties {
    private static final String FRAMEWORK_NAME = "KarmaJavaScriptTestRunner";
    private final KarmaTestProxyFilterProvider myFilterProvider;

    public KarmaConsoleProperties(@NotNull KarmaRunConfiguration configuration, Executor executor, @NotNull KarmaTestProxyFilterProvider filterProvider) {
        if (configuration == null) {
            KarmaConsoleProperties.$$$reportNull$$$0(0);
        }
        if (filterProvider == null) {
            KarmaConsoleProperties.$$$reportNull$$$0(1);
        }
        super((RunConfiguration)configuration, FRAMEWORK_NAME, executor);
        this.myFilterProvider = filterProvider;
        this.setUsePredefinedMessageFilter(true);
        this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
        this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
        this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
        this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
        this.setIdBasedTestTree(true);
        this.setPrintTestingStartedTime(false);
        this.addStackTraceFilters(filterProvider);
    }

    private void addStackTraceFilters(@NotNull KarmaTestProxyFilterProvider filterProvider) {
        Filter phantomStacktraceFilter;
        Filter chromeStacktraceFilter;
        if (filterProvider == null) {
            KarmaConsoleProperties.$$$reportNull$$$0(2);
        }
        if ((chromeStacktraceFilter = filterProvider.getFilter("browser", "chrome", null)) != null) {
            this.addStackTraceFilter(chromeStacktraceFilter);
        }
        if ((phantomStacktraceFilter = filterProvider.getFilter("browser", "phantomjs", null)) != null) {
            this.addStackTraceFilter(phantomStacktraceFilter);
        }
    }

    public SMTestLocator getTestLocator() {
        return KarmaTestLocationProvider.INSTANCE;
    }

    public TestProxyFilterProvider getFilterProvider() {
        return this.myFilterProvider;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return new KarmaRerunFailedTestAction((SMTRunnerConsoleView)consoleView, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterProvider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/karma/execution/KarmaConsoleProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addStackTraceFilters";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

